<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use Directorist\Directorist_Single_Listing;
use Directorist_Job_Manager\Helper;

$listing = Directorist_Single_Listing::instance();
$quick_info = Helper::get_single_listing_quick_info_data( get_the_ID() );
if ( ! $quick_info || ! is_array( $quick_info ) ) {
	return;
} 
?>

<div class="directorist-card directorist-card-listing-description <?php echo esc_attr( $class ); ?>" <?php $listing->section_id( $id );?>>

	<div class="directorist-card__header">

		<h4 class="directorist-card__header--title"><?php directorist_icon( $icon );?><?php echo esc_html( $label ); ?></h4>

	</div>

	<div class="directorist-card__body">

	<?php
	echo "<ul class='directorist-job-quickinfo-list'>";

	// Output generated fields
	if ( $quick_info['dirjob_salary'] ) {
		printf( '<li>%s <strong class="directorist-job-quickinfo-label">%s:</strong> <span class="directorist-job-quickinfo-text"> %s</span></li>', Helper::get_svg_icon( 'money-bill-wave-solid' ), $quick_info['dirjob_salary_label'], $quick_info['dirjob_salary'] );
	}
	if ( $quick_info['dirjob_job_type'] ) {
		printf( '<li>%s <strong class="directorist-job-quickinfo-label">%s:</strong> <span class="directorist-job-quickinfo-text"> %s</span></li>', Helper::get_svg_icon( 'briefcase-solid' ), $quick_info['dirjob_job_type_label'], $quick_info['dirjob_job_type'] );
	}
	if ( $quick_info['dirjob_open_position'] ) {
		$label_placement = Helper::open_position_label_placement( get_the_ID() );

		if ( 'before' == $label_placement ) {
			printf( '<li>%s <strong class="directorist-job-quickinfo-label">%s:</strong> <span class="directorist-job-quickinfo-text"> %s %s</span></li>', Helper::get_svg_icon( 'user-check-solid' ), __( 'Position', 'directorist-job-manager' ), $quick_info['dirjob_open_position_label'], $quick_info['dirjob_open_position'] );
		} else {
			printf( '<li>%s <strong class="directorist-job-quickinfo-label">%s:</strong> <span class="directorist-job-quickinfo-text"> %s %s</span></li>', Helper::get_svg_icon( 'user-check-solid' ), __( 'Position', 'directorist-job-manager' ), $quick_info['dirjob_open_position'], $quick_info['dirjob_open_position_label'] );
		}
	}
	if ( $quick_info['address'] ) {
		printf( '<li>%s <strong class="directorist-job-quickinfo-label">%s:</strong> <span class="directorist-job-quickinfo-text"> %s</span></li>', Helper::get_svg_icon( 'map-marker-solid' ), $quick_info['address_label'], $quick_info['address'] );
	}
	if ( $quick_info['dirjob_deadline'] ) {
		printf( '<li>%s <strong class="directorist-job-quickinfo-label">%s:</strong> <span class="directorist-job-quickinfo-text"> %s</span></li>', Helper::get_svg_icon( 'clock' ), $quick_info['dirjob_deadline_label'], esc_html( Helper::get_date_by_wp_format( $quick_info['dirjob_deadline'] ) ) );
	}
	if ( $quick_info['website'] ) {
		printf( '<li>%s <strong class="directorist-job-quickinfo-label">%s:</strong> <a class="directorist-job-quickinfo-link" href="%s"> %s</a>', Helper::get_svg_icon( 'globe-solid' ), $quick_info['website_label'], $quick_info['website'], $quick_info['website'] );
	}
	echo "</ul>";	
	
	$dirjob_apply_form = get_post_meta( get_the_ID(), '_dirjob_apply_form', true );
	if ( $dirjob_apply_form ) : ?>
		<div class="directorist-info-item directorist-info-item-dirjob_apply_form">
			<?php echo Helper::get_apply_now_button_html( get_the_ID(), $args ); ?>
		</div>
	<?php endif;?>
	

	</div>

</div>