<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$value   = isset( $_GET['custom_field']['dirjob_date_posted'] ) && ! empty( $_GET['custom_field']['dirjob_date_posted'] ) ? $_GET['custom_field']['dirjob_date_posted'] : 0;
$options = array(
	'last_hour'      => __( 'Last Hour', 'directorist-job-manager' ),
	'last_24_hours'  => __( 'Last 24 Hours', 'directorist-job-manager' ),
	'last_7_days'    => __( 'Last 7 Days', 'directorist-job-manager' ),
	'last_30_days'   => __( 'Last 30 Days', 'directorist-job-manager' ),
	'last_month'     => __( 'Last Month', 'directorist-job-manager' ),
	'last_3_months'  => __( 'Last 3 Months', 'directorist-job-manager' ),
	'last_6_months'  => __( 'Last 6 Months', 'directorist-job-manager' ),
	'last_12_months' => __( 'Last 12 Months', 'directorist-job-manager' ),
);
?>

<div class="directorist-search-field">

	<?php if ( ! empty( $data['label'] ) ): ?>
		<label><?php echo esc_html( $data['label'] ); ?></label>
	<?php endif;?>

	<?php foreach ( $options as $name => $label ) {
	$uniqid = $name . '-' . wp_rand();
	?>

		<div class="directorist-radio directorist-radio-circle">
			<input <?php checked( $value === $name );?> type="radio" id="<?php echo esc_attr( $uniqid ); ?>" name="custom_field[<?php echo esc_attr( $data['widget_name'] ); ?>]" value="<?php echo esc_attr( $name ); ?>">
			<label class="directorist-radio__label" for="<?php echo esc_attr( $uniqid ); ?>"><?php echo esc_html( $label ); ?></label>
		</div>

	<?php }?>

</div>