<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

use Directorist_Job_Manager\Helper;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$mixed_value       = $data['value'] ? $data['value'] : '';
$mixed_array       = explode( '-000-', $mixed_value );
$dirjob_salary_1st = isset( $mixed_array[0] ) ? $mixed_array[0] : '';
$dirjob_salary_2nd = isset( $mixed_array[1] ) ? $mixed_array[1] : '';
?>

<div class="directorist-form-group directorist-custom-field-number">

	<?php Helper::field_label_template( $data );?>

	<div id="dirjob_salary">
		<input type="number" id="<?php echo esc_attr( $data['field_key'] ); ?>_1st" class="directorist-form-element" value="<?php echo esc_attr( $dirjob_salary_1st ); ?>" placeholder="min" step="any"  <?php $data['required'] ? 'required' : ''?>>
		<input type="number" id="<?php echo esc_attr( $data['field_key'] ); ?>_2nd" class="directorist-form-element" value="<?php echo esc_attr( $dirjob_salary_2nd ); ?>" placeholder="max" step="any"  <?php $data['required'] ? 'required' : ''?>>
		<input type="hidden" name="<?php echo esc_attr( $data['field_key'] ); ?>" id="<?php echo esc_attr( $data['field_key'] ); ?>_compact" value="<?php echo esc_attr( $data['value'] ); ?>">
	</div>

	<?php Helper::field_description_template( $data );?>

</div>