<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

use Directorist_Job_Manager\Helper;

if ( ! defined( 'ABSPATH' ) ) exit;

$max = !empty( $data['max'] ) ? 'max="'. esc_attr( $data['max'] ) .'"' : '';
?>

<div class="directorist-form-group directorist-custom-field-number">

	<?php Helper::field_label_template( $data );?>

	<input type="number" name="<?php echo esc_attr( $data['field_key'] ); ?>" id="<?php echo esc_attr( $data['field_key'] ); ?>" class="directorist-form-element" value="<?php echo esc_attr( $data['value'] ); ?>" placeholder="<?php echo esc_attr( $data['placeholder'] ); ?>" step="any" <?php $data['required'] ? 'required' : '' ?> <?php echo $max; ?>>

	<?php Helper::field_description_template( $data );?>

</div>