<?php

// Adds widget: Job Manager: Quick Info

use Directorist_Job_Manager\Helper;

class job_manager_quick_info_Widget extends WP_Widget {

	public function __construct() {
		parent::__construct(
			'job_manager_quick_info_widget',
			esc_html__( 'Directorist Job Manager - Info', 'directorist-job-manager' )
		);
	}

	private $widget_fields = array(
		array(
			'label'   => 'Salary',
			'id'      => 'salary',
			'default' => 'yes',
			'type'    => 'checkbox',
		),
		array(
			'label'   => 'Job Type',
			'id'      => 'job_type',
			'default' => 'yes',
			'type'    => 'checkbox',
		),
		array(
			'label'   => 'Open Positions',
			'id'      => 'open_position',
			'default' => 'yes',
			'type'    => 'checkbox',
		),
		array(
			'label'   => 'Location',
			'id'      => 'location',
			'default' => 'yes',
			'type'    => 'checkbox',
		),
		array(
			'label'   => 'Deadline',
			'id'      => 'deadline',
			'default' => 'yes',
			'type'    => 'checkbox',
		),
		array(
			'label'   => 'Website',
			'id'      => 'website',
			'default' => 'yes',
			'type'    => 'checkbox',
		),
	);

	public function widget( $args, $instance ) {
		Helper::get_template( 'widgets/quick-info', array( 'args' => $args, 'instance' => $instance ) );
	}

	public function field_generator( $instance ) {
		$output = '';

		foreach ( $this->widget_fields as $widget_field ) {
			$default = '';

			if ( isset( $widget_field['default'] ) ) {
				$default = $widget_field['default'];
			}

			$widget_value = ! empty( $instance[$widget_field['id']] ) ? $instance[$widget_field['id']] : esc_html__( $default, 'directorist-job-manager' );

			switch ( $widget_field['type'] ) {
				case 'checkbox':
					$output .= '<p>';
					$output .= '<input class="checkbox" type="checkbox" ' . checked( $widget_value, true, false ) . ' id="' . esc_attr( $this->get_field_id( $widget_field['id'] ) ) . '" name="' . esc_attr( $this->get_field_name( $widget_field['id'] ) ) . '" value="1">';
					$output .= '<label for="' . esc_attr( $this->get_field_id( $widget_field['id'] ) ) . '">' . esc_attr( $widget_field['label'], 'directorist-job-manager' ) . '</label>';
					$output .= '</p>';
					break;

				default:
					$output .= '<p>';
					$output .= '<label for="' . esc_attr( $this->get_field_id( $widget_field['id'] ) ) . '">' . esc_attr( $widget_field['label'], 'directorist-job-manager' ) . ':</label> ';
					$output .= '<input class="widefat" id="' . esc_attr( $this->get_field_id( $widget_field['id'] ) ) . '" name="' . esc_attr( $this->get_field_name( $widget_field['id'] ) ) . '" type="' . $widget_field['type'] . '" value="' . esc_attr( $widget_value ) . '">';
					$output .= '</p>';
			}
		}

		echo $output;
	}

	public function form( $instance ) {
		$title = ! empty( $instance['title'] ) ? $instance['title'] : esc_html__( '', 'directorist-job-manager' );
		?>

		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_attr_e( 'Title:', 'directorist-job-manager' );?></label>
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
		</p>

		<?php $this->field_generator( $instance );
	}

	public function update( $new_instance, $old_instance ) {
		$instance          = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		foreach ( $this->widget_fields as $widget_field ) {
			switch ( $widget_field['type'] ) {
				default:
					$instance[$widget_field['id']] = ( ! empty( $new_instance[$widget_field['id']] ) ) ? strip_tags( $new_instance[$widget_field['id']] ) : '';
			}
		}

		return $instance;
	}
}

function register_job_manager_quick_info_widget() {
	register_widget( 'job_manager_quick_info_Widget' );
}

add_action( 'widgets_init', 'register_job_manager_quick_info_widget' );