<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace Directorist_Job_Manager;

class Settings_Manager {

	public function __construct() {

		// Adding new Fields to Builder-> 'Add Listing/Submission Form'
		add_filter( 'atbdp_form_preset_widgets', array( $this, 'atbdp_form_preset_widgets' ) );

		// Adding new fields to Builder-> Search Form
		add_filter( 'directorist_search_form_widgets', array( $this, 'directorist_search_form_widgets' ) );
		// Modifying Search Listings Meta Queries for Date Posted Widget
		add_filter( 'atbdp_listing_search_query_argument', array( $this, 'atbdp_search_listings_meta_queries' ) );

		// Listing Archive
		add_filter( 'atbdp_listing_type_settings_field_list', array( $this, 'atbdp_listing_type_settings_field_list' ) );

		// Load Templates from this Plugin
		add_filter( 'directorist_template', array( $this, 'directorist_template' ), 10, 2 );

		// Single Listing
		add_filter( 'directorist_listing_header_layout', array( $this, 'directorist_listing_header_layout' ) );
		// Adds New Sections: Builder-> Single Page Layout-> Contents
		add_filter( 'atbdp_single_listing_other_fields_widget', array( $this, 'atbdp_single_listing_other_fields_widget' ) );

		// Adding new email template
		add_filter( 'atbdp_email_settings_submenu', array( $this, 'atbdp_email_settings_submenu' ) );

		// Adding page setup item
		add_filter( 'atbdp_pages_settings_fields', array( $this, 'atbdp_pages_settings_fields' ) );
	}

	public function atbdp_form_preset_widgets( $fields ) {

		$fields['dirjob_job_type'] = array(
			'label'   => esc_html__( 'Job Manager: Job Type', 'directorist-job-manager' ),
			'icon'    => 'las la-briefcase',
			'options' => array(
				'type'           => array(
					'type'  => 'hidden',
					'value' => 'radio',
				),
				'label'          => array(
					'type'  => 'text',
					'label' => esc_html__( 'Label', 'directorist-job-manager' ),
					'value' => 'Job Type',
				),
				'field_key'      => array(
					'value' => 'dirjob_job_type',
					'type'  => 'hidden',
					'rules' => array(
						'unique'   => true,
						'required' => true,
					),
				),

				'options'        => array(
					'type'                 => 'multi-fields',
					'label'                => esc_html__( 'Options', 'directorist-job-manager' ),
					'add-new-button-label' => esc_html__( 'Add Option', 'directorist-job-manager' ),
					'options'              => array(
						'option_value' => array(
							'type'  => 'text',
							'label' => esc_html__( 'Option Value', 'directorist-job-manager' ),
							'value' => '',
						),
						'option_label' => array(
							'type'  => 'text',
							'label' => esc_html__( 'Option Label', 'directorist-job-manager' ),
							'value' => '',
						),
					),
				),
				'description'    => array(
					'type'  => 'text',
					'label' => esc_html__( 'Description', 'directorist-job-manager' ),
					'value' => '',
				),
				'required'       => array(
					'type'  => 'toggle',
					'label' => esc_html__( 'Required', 'directorist-job-manager' ),
					'value' => false,
				),
				'only_for_admin' => array(
					'type'  => 'toggle',
					'label' => esc_html__( 'Only For Admin Use', 'directorist-job-manager' ),
					'value' => false,
				),
			),
		);

		$fields['dirjob_salary'] = array(
			'label'   => esc_html__( 'Job Manager: Salary', 'directorist-job-manager' ),
			'icon'    => 'uil uil-circle',
			'options' => array(
				'type'        => array(
					'type'  => 'hidden',
					'value' => 'radio',
				),
				'label'       => array(
					'type'  => 'text',
					'label' => esc_html__( 'Label', 'directorist-job-manager' ),
					'value' => 'Salary',
				),
				'field_key'   => array(
					'value' => 'dirjob_salary',
					'type'  => 'hidden',
					'rules' => array(
						'unique'   => true,
						'required' => true,
					),
				),
				'description' => array(
					'type'  => 'text',
					'label' => esc_html__( 'Description', 'directorist-job-manager' ),
					'value' => '',
				),
				'required'    => array(
					'type'  => 'toggle',
					'label' => esc_html__( 'Required', 'directorist-job-manager' ),
					'value' => false,
				),
			),
		);

		$fields['dirjob_open_position'] = array(
			'label'   => 'Job Manager: Open Positions',
			'icon'    => 'uil uil-0-plus',
			'options' => array(
				'label'           => array(
					'type'  => 'text',
					'label' => __( 'Label', 'directorist-job-manager' ),
					'value' => 'Open Positions',
				),
				'label_placement' => array(
					'type'    => 'select',
					'label'   => 'Label Placement',
					'value'   => 'after',
					'options' => array(
						array(
							'label' => __( 'Before', 'directorist-job-manager' ),
							'value' => 'before',
						),
						array(
							'label' => __( 'After', 'directorist-job-manager' ),
							'value' => 'after',
						),
					),
				),
				'field_key'       => array(
					'value' => 'dirjob_open_position',
					'type'  => 'hidden',
					'rules' => array(
						'unique'   => true,
						'required' => true,
					),
				),
				'placement'       => array(
					'type'  => 'dropdown',
					'label' => __( 'Placement', 'directorist-job-manager' ),
					'value' => 'after',
				),
				'placeholder'     => array(
					'type'  => 'text',
					'label' => __( 'Placeholder', 'directorist-job-manager' ),
					'value' => '',
				),
				'description'     => array(
					'type'  => 'text',
					'label' => __( 'Description', 'directorist-job-manager' ),
					'value' => '',
				),
				'required'        => array(
					'type'  => 'toggle',
					'label' => __( 'Required', 'directorist-job-manager' ),
					'value' => false,
				),
				'only_for_admin'  => array(
					'type'  => 'toggle',
					'label' => __( 'Only For Admin Use', 'directorist-job-manager' ),
					'value' => false,
				),
			),

		);

		$fields['dirjob_deadline'] = array(
			'label'   => 'Job Manager: Deadline',
			'icon'    => 'uil uil-calender',
			'options' => array(
				'type'           => array(
					'type'  => 'hidden',
					'value' => 'date',
				),
				'label'          => array(
					'type'  => 'text',
					'label' => __( 'Label', 'directorist-job-manager' ),
					'value' => 'Deadline',
				),
				'field_key'      => array(
					'value' => 'dirjob_deadline',
					'type'  => 'hidden',
					'rules' => array(
						'unique'   => true,
						'required' => true,
					),
				),
				'placeholder'    => array(
					'type'  => 'text',
					'label' => __( 'Placeholder', 'directorist-job-manager' ),
					'value' => '',
				),
				'description'    => array(
					'type'  => 'text',
					'label' => __( 'Description', 'directorist-job-manager' ),
					'value' => '',
				),
				'required'       => array(
					'type'  => 'toggle',
					'label' => __( 'Required', 'directorist-job-manager' ),
					'value' => false,
				),
				'only_for_admin' => array(
					'type'  => 'toggle',
					'label' => __( 'Only For Admin Use', 'directorist-job-manager' ),
					'value' => false,
				),

			),
		);

		$fields['dirjob_apply_form'] = array(
			'label'   => 'Job Manager: Application Form',
			'icon'    => 'la la-wpforms',
			'options' => array(
				'type'           => array(
					'type'  => 'hidden',
					'value' => 'date',
				),
				'label'          => array(
					'type'  => 'text',
					'label' => __( 'Label', 'directorist-job-manager' ),
					'value' => 'Application Form',
				),
				'field_key'      => array(
					'value' => 'dirjob_apply_form',
					'type'  => 'hidden',
					'rules' => array(
						'unique'   => true,
						'required' => true,
					),
				),
				'placeholder'    => array(
					'type'  => 'text',
					'label' => __( 'Placeholder', 'directorist-job-manager' ),
					'value' => '',
				),
				'description'    => array(
					'type'  => 'text',
					'label' => __( 'Description', 'directorist-job-manager' ),
					'value' => '',
				),
				'required'       => array(
					'type'  => 'toggle',
					'label' => __( 'Required', 'directorist-job-manager' ),
					'value' => false,
				),
				'only_for_admin' => array(
					'type'  => 'toggle',
					'label' => __( 'Only For Admin Use', 'directorist-job-manager' ),
					'value' => false,
				),

			),
		);

		return $fields;
	}

	public function directorist_search_form_widgets( $fields ) {

		$dirjob_job_type = array(
			'label'   => esc_html__( 'Job Manager: Job Types', 'directorist-job-manager' ),
			'icon'    => 'las la-briefcase',
			'options' => array(
				'label'    => array(
					'type'  => 'text',
					'label' => esc_html__( 'Label', 'directorist-job-manager' ),
					'value' => esc_html__( 'Job Type', 'directorist-job-manager' ),
				),
				'required' => array(
					'type'  => 'toggle',
					'label' => esc_html__( 'Required', 'directorist-job-manager' ),
					'value' => false,
				),
			),
		);

		$dirjob_date_posted = array(
			'label'   => esc_html__( 'Job Manager: Date Posted', 'directorist-job-manager' ),
			'icon'    => 'uil uil-calender',
			'options' => array(
				'label'    => array(
					'type'  => 'text',
					'label' => esc_html__( 'Label', 'directorist-job-manager' ),
					'value' => esc_html__( 'Date Posted', 'directorist-job-manager' ),
				),
				'required' => array(
					'type'  => 'toggle',
					'label' => esc_html__( 'Required', 'directorist-job-manager' ),
					'value' => false,
				),
			),
		);

		$fields['available_widgets']['widgets']['dirjob_job_type'] = $dirjob_job_type;
		$fields['other_widgets']['widgets']['dirjob_date_posted']  = $dirjob_date_posted;

		return $fields;
	}

	public function atbdp_search_listings_meta_queries( $query_data ) {

		if ( isset( $query_data['meta_query'] ) ) {

			foreach ( $query_data['meta_query'] as $key => $value ) {

				if ( isset( $query_data['meta_query'][$key]['key'] ) ) {

					if ( '_dirjob_date_posted' === $query_data['meta_query'][$key]['key'] && ! empty( $query_data['meta_query'][$key]['value'] ) ) {

						$column = '1 hour ago';
						switch ( $query_data['meta_query'][$key]['value'] ) {
							case 'last_hour':
								$column = '1 hour ago';
								break;
							case 'last_24_hours':
								$column = '24 hours ago';
								break;
							case 'last_7_days':
								$column = '7 days ago'; // perfect
								break;
							case 'last_30_days':
								$column = '30 days ago';
								break;
							case 'last_3_months':
								$column = '3 months ago';
								break;
							case 'last_6_months':
								$column = '6 months ago';
								break;
							case 'last_12_months':
								$column = '12 months ago';
								break;
						}

						if ( 'last_month' != $query_data['meta_query'][$key]['value'] ) {
							$query_data['date_query'] = array(
								array(
									'column' => 'post_date',
									'after'  => $column,
								),
							);
						} else {
							$query_data['date_query'] = array(
								array(
									'month'   => date( 'm' ) - 1,
									'year'    => date( 'Y' ),
									'compare' => '=',
								),
							);
						}

						unset( $query_data['meta_query'][$key] );
					}
				}
			}
		}

		return $query_data;
	}

	public function directorist_template( $template, $args ) {

		// Add Listing Form
		if ( 'listing-form/fields/dirjob_job_type' === $template ) {
			$template .= Helper::get_template( '/listing-form/fields/dirjob_job_type', $args );
		}
		if ( 'listing-form/fields/dirjob_salary' === $template ) {
			$template .= Helper::get_template( '/listing-form/fields/dirjob_salary', $args );
		}
		if ( 'listing-form/fields/dirjob_open_position' === $template ) {
			$template .= Helper::get_template( '/listing-form/fields/dirjob_open_position', $args );
		}
		if ( 'listing-form/fields/dirjob_deadline' === $template ) {
			$template .= Helper::get_template( '/listing-form/fields/dirjob_deadline', $args );
		}
		if ( 'listing-form/fields/dirjob_apply_form' === $template ) {
			$template .= Helper::get_template( '/listing-form/fields/dirjob_apply_form', $args );
		}

		// Search Form
		if ( 'search-form/fields/dirjob_job_type' === $template ) {
			$template = Helper::get_template( '/search-form/fields/dirjob_job_type', $args );
		}
		if ( 'search-form/fields/dirjob_date_posted' === $template ) {
			$template = Helper::get_template( '/search-form/fields/dirjob_date_posted', $args );
		}

		// Archive
		if ( 'archive/fields/dirjob_job_type' == $template ) {
			$template = Helper::get_template( '/archive/fields/dirjob_job_type', $args );
		}
		if ( 'archive/fields/dirjob_salary' == $template ) {
			$template = Helper::get_template( '/archive/fields/dirjob_salary', $args );
		}
		if ( 'archive/fields/dirjob_open_position' == $template ) {
			$template = Helper::get_template( '/archive/fields/dirjob_open_position', $args );
		}
		if ( 'archive/fields/dirjob_deadline' == $template ) {
			$template = Helper::get_template( '/archive/fields/dirjob_deadline', $args );
		}

		// Single Listing
		if ( 'single/fields/dirjob_job_type' == $template ) {
			$template = Helper::get_template( '/single/fields/dirjob_job_type', $args );
		}
		if ( 'single/fields/dirjob_open_position' == $template ) {
			$template = Helper::get_template( '/single/fields/dirjob_open_position', $args );
		}
		if ( 'single/fields/dirjob_salary' == $template ) {
			$template = Helper::get_template( '/single/fields/dirjob_salary', $args );
		}
		if ( 'single/fields/dirjob_deadline' == $template ) {
			$template = Helper::get_template( '/single/fields/dirjob_deadline', $args );
		}
		if ( 'single/fields/dirjob_apply_form' == $template ) {
			$template = Helper::get_template( '/single/fields/dirjob_apply_form', $args );
		}
		if ( 'single/section-dirjob_job_details' == $template ) {
			$template = Helper::get_template( '/single/section-dirjob_job_details', $args );
		}

		return $template;
	}

	public function atbdp_listing_type_settings_field_list( $fields ) {

		$dirjob_job_type = array(
			'type'    => "list-item",
			'label'   => __( "Job Type", "directorist-job-manager" ),
			'icon'    => 'las la-briefcase',
			'hook'    => "dirjob_job_type",
			'show_if' => array(
				'where'      => "submission_form_fields.value.fields",
				'conditions' => array(
					array( 'key' => '_any.widget_name', 'compare' => '=', 'value' => 'dirjob_job_type' ),
				),
			),
			'options' => array(
				'title'  => __( "Settings", "directorist-job-manager" ),
				'fields' => array(
					'icon'       => array(
						'type'  => "icon",
						'label' => __( "Icon", "directorist-job-manager" ),
						'value' => "las la-briefcase",
					),
					'show_label' => array(
						'type'  => "toggle",
						'label' => __( "Show Label", "directorist-job-manager" ),
						'value' => false,
					),
				),
			),
		);

		$dirjob_salary = array(
			'type'    => "list-item",
			'label'   => __( "Salary", "directorist-job-manager" ),
			'icon'    => 'las la-money-bill-wave',
			'hook'    => "dirjob_salary",
			'show_if' => array(
				'where'      => "submission_form_fields.value.fields",
				'conditions' => array(
					array( 'key' => '_any.widget_name', 'compare' => '=', 'value' => 'dirjob_salary' ),
				),
			),
			'options' => array(
				'title'  => __( "Settings", "directorist-job-manager" ),
				'fields' => array(
					'icon'       => array(
						'type'  => "icon",
						'label' => __( "Icon", "directorist-job-manager" ),
						'value' => "las la-money-bill-wave",
					),
					'show_label' => array(
						'type'  => "toggle",
						'label' => __( "Show Label", "directorist-job-manager" ),
						'value' => false,
					),
				),
			),
		);

		$dirjob_open_position = array(
			'type'    => "list-item",
			'label'   => __( "Open Positions", "directorist-job-manager" ),
			'icon'    => 'las la-user-check',
			'hook'    => "dirjob_open_position",
			'show_if' => array(
				'where'      => "submission_form_fields.value.fields",
				'conditions' => array(
					array( 'key' => '_any.widget_name', 'compare' => '=', 'value' => 'dirjob_open_position' ),
				),
			),
			'options' => array(
				'title'  => __( "Settings", "directorist-job-manager" ),
				'fields' => array(
					'icon'       => array(
						'type'  => "icon",
						'label' => __( "Icon", "directorist-job-manager" ),
						'value' => "las la-user-check",
					),
					'show_label' => array(
						'type'  => "toggle",
						'label' => __( "Show Label", "directorist-job-manager" ),
						'value' => true,
					),
					'label'      => array(
						'type'  => 'text',
						'label' => __( 'Label', 'directorist' ),
						'value' => 'Textarea',
					),
				),
			),
		);

		$dirjob_deadline = array(
			'type'    => "list-item",
			'label'   => __( "Deadline", "directorist-job-manager" ),
			'icon'    => 'las la-clock',
			'hook'    => "dirjob_deadline",
			'show_if' => array(
				'where'      => "submission_form_fields.value.fields",
				'conditions' => array(
					array( 'key' => '_any.widget_name', 'compare' => '=', 'value' => 'dirjob_deadline' ),
				),
			),
			'options' => array(
				'title'  => __( "Settings", "directorist-job-manager" ),
				'fields' => array(
					'icon'       => array(
						'type'  => "icon",
						'label' => __( "Icon", "directorist-job-manager" ),
						'value' => "las la-clock",
					),
					'show_label' => array(
						'type'  => "toggle",
						'label' => __( "Show Label", "directorist-job-manager" ),
						'value' => false,
					),
				),
			),
		);

		foreach ( $fields as $key => $value ) {

			if ( 'listings_card_grid_view' == $key ) {

				// Grid View with Thumbnail
				$fields[$key]['card_templates']['grid_view_with_thumbnail']['widgets']['dirjob_job_type']      = $dirjob_job_type;
				$fields[$key]['card_templates']['grid_view_with_thumbnail']['widgets']['dirjob_salary']        = $dirjob_salary;
				$fields[$key]['card_templates']['grid_view_with_thumbnail']['widgets']['dirjob_open_position'] = $dirjob_open_position;
				$fields[$key]['card_templates']['grid_view_with_thumbnail']['widgets']['dirjob_deadline']      = $dirjob_deadline;

				array_push( $fields[$key]['card_templates']['grid_view_with_thumbnail']['layout']['body']['bottom']['acceptedWidgets'],
					'dirjob_job_type', 'dirjob_salary', 'dirjob_open_position', 'dirjob_deadline' );
				array_push( $fields[$key]['card_templates']['grid_view_with_thumbnail']['layout']['footer']['left']['acceptedWidgets'],
					'dirjob_deadline' );

				// Grid View without Thumbnail
				$fields[$key]['card_templates']['grid_view_without_thumbnail']['widgets']['dirjob_job_type']      = $dirjob_job_type;
				$fields[$key]['card_templates']['grid_view_without_thumbnail']['widgets']['dirjob_salary']        = $dirjob_salary;
				$fields[$key]['card_templates']['grid_view_without_thumbnail']['widgets']['dirjob_open_position'] = $dirjob_open_position;
				$fields[$key]['card_templates']['grid_view_without_thumbnail']['widgets']['dirjob_deadline']      = $dirjob_deadline;

				array_push( $fields[$key]['card_templates']['grid_view_without_thumbnail']['layout']['body']['bottom']['acceptedWidgets'],
					'dirjob_job_type', 'dirjob_salary', 'dirjob_open_position', 'dirjob_deadline' );
				array_push( $fields[$key]['card_templates']['grid_view_without_thumbnail']['layout']['footer']['left']['acceptedWidgets'],
					'dirjob_deadline' );
			}

			if ( 'listings_card_list_view' === $key ) {

				// List View with Thumbnail
				$fields[$key]['card_templates']['list_view_with_thumbnail']['widgets']['dirjob_job_type']      = $dirjob_job_type;
				$fields[$key]['card_templates']['list_view_with_thumbnail']['widgets']['dirjob_salary']        = $dirjob_salary;
				$fields[$key]['card_templates']['list_view_with_thumbnail']['widgets']['dirjob_open_position'] = $dirjob_open_position;
				$fields[$key]['card_templates']['list_view_with_thumbnail']['widgets']['dirjob_deadline']      = $dirjob_deadline;

				array_push( $fields[$key]['card_templates']['list_view_with_thumbnail']['layout']['body']['bottom']['acceptedWidgets'],
					'dirjob_job_type', 'dirjob_salary', 'dirjob_open_position', 'dirjob_deadline' );
				array_push( $fields[$key]['card_templates']['list_view_with_thumbnail']['layout']['footer']['left']['acceptedWidgets'],
					'dirjob_deadline' );

				// List View without Thumbnail
				$fields[$key]['card_templates']['list_view_without_thumbnail']['widgets']['dirjob_job_type']      = $dirjob_job_type;
				$fields[$key]['card_templates']['list_view_without_thumbnail']['widgets']['dirjob_salary']        = $dirjob_salary;
				$fields[$key]['card_templates']['list_view_without_thumbnail']['widgets']['dirjob_open_position'] = $dirjob_open_position;
				$fields[$key]['card_templates']['list_view_without_thumbnail']['widgets']['dirjob_deadline']      = $dirjob_deadline;

				array_push( $fields[$key]['card_templates']['list_view_without_thumbnail']['layout']['body']['bottom']['acceptedWidgets'],
					'dirjob_job_type', 'dirjob_salary', 'dirjob_open_position', 'dirjob_deadline' );
				array_push( $fields[$key]['card_templates']['list_view_without_thumbnail']['layout']['footer']['left']['acceptedWidgets'],
					'dirjob_deadline' );
			}

			$fields['email_sub_job_submission_email'] = array(
				'type'        => 'text',
				'label'       => __( 'Email Subject', 'directorist-job-manager' ),
				'description' => __( 'Edit the Email subject you want the listing owner to see after a job seeker submits his or her application.', 'directorist-job-manager' ),
				'value'       => __( "New Job Application Submitted", 'directorist-job-manager' ),
			);
			$fields['email_tmpl_job_submission_email'] = array(
				'type'        => 'textarea',
				'label'       => __( 'Email Body', 'directorist-job-manager' ),
				'description' => __( 'Edit the Email template you want the listing owner to see after a job seeker submits his or her application. Please note that to receive the submission data you must use the placeholder “ ==SUBMISSION_DATA== ” in the template. ', 'directorist-job-manager' ),
				'value'       => __( "
				Dear ==NAME==,

				You have received an application from your listing at ==LISTING_URL==.

				Submission Data:
				==SUBMISSION_DATA==

				Time: ==NOW==

				Thanks,
				The Administrator of ==SITE_NAME==
				", 'directorist-job-manager' ),
			);

			$fields['job_manager_form_preview_page'] = array(
				'label'             => __( 'Form Preview Page', 'directorist-job-manager' ),
				'type'              => 'select',
				'description'       => sprintf( __( 'Following shortcode must be in the selected page %s', 'directorist-job-manager' ), '<div class="atbdp_shortcodes" style="color: #ff4500;">[directorist_job_manager_form_preview]</div>' ),
				'showDefaultOption' => true,
				'options'           => Helper::get_pages_vl_arrays(),
			);
		}

		return $fields;
	}

	public function directorist_listing_header_layout( $fields ) {

		$fields['widgets']['dirjob_job_type'] = array(
			'type'    => "badge",
			'label'   => __( "Job Type", "directorist-job-manager" ),
			'icon'    => 'las la-briefcase',
			'show_if' => array(
				'where'      => "submission_form_fields.value.fields",
				'conditions' => array(
					array( 'key' => '_any.widget_name', 'compare' => '=', 'value' => 'dirjob_job_type' ),
				),
			),
		);

		$fields['widgets']['dirjob_open_position'] = array(
			'type'    => "badge",
			'label'   => __( "Open Positions", "directorist-job-manager" ),
			'icon'    => 'las la-user-check',
			'show_if' => array(
				'where'      => "submission_form_fields.value.fields",
				'conditions' => array(
					array( 'key' => '_any.widget_name', 'compare' => '=', 'value' => 'dirjob_open_position' ),
				),
			),
			'options' => array(
				'title'  => __( "Open Position Settings", "directorist-job-manager" ),
				'fields' => array(
					'show_label' => array(
						'type'  => "toggle",
						'label' => __( "Show Label", "directorist-job-manager" ),
						'value' => true,
					),
				),
			),
		);

		$fields['widgets']['dirjob_salary'] = array(
			'type'    => "badge",
			'label'   => __( "Salary", "directorist-job-manager" ),
			'icon'    => 'las la-money-bill-wave',
			'show_if' => array(
				'where'      => "submission_form_fields.value.fields",
				'conditions' => array(
					array( 'key' => '_any.widget_name', 'compare' => '=', 'value' => 'dirjob_salary' ),
				),
			),
		);

		$fields['widgets']['dirjob_deadline'] = array(
			'type'    => "badge",
			'label'   => __( "Deadline", "directorist-job-manager" ),
			'icon'    => 'las la-clock',
			'show_if' => array(
				'where'      => "submission_form_fields.value.fields",
				'conditions' => array(
					array( 'key' => '_any.widget_name', 'compare' => '=', 'value' => 'dirjob_deadline' ),
				),
			),
		);

		$fields['widgets']['dirjob_apply_form'] = array(
			'type'    => "badge",
			'label'   => __( "Application Form", "directorist-job-manager" ),
			'icon'    => 'la la-wpforms',
			'show_if' => array(
				'where'      => "submission_form_fields.value.fields",
				'conditions' => array(
					array( 'key' => '_any.widget_name', 'compare' => '=', 'value' => 'dirjob_apply_form' ),
				),
			),
			'options' => array(
				'title'  => __( "Application Form Settings", "directorist-job-manager" ),
				'fields' => array(
					'target'      => array(
						'type'  => "toggle",
						'label' => __( "Target Blank?", "directorist-job-manager" ),
						'value' => true,
					),
					'button_text' => array(
						'type'  => "text",
						'label' => __( "Button Text", "directorist-job-manager" ),
						'value' => __( "Apply Now", "directorist-job-manager" ),
					),
				),
			),
		);

		array_push( $fields['layout']['listings_header']['quick_info']['acceptedWidgets'],
			'dirjob_job_type', 'dirjob_open_position', 'dirjob_salary', 'dirjob_deadline', 'dirjob_apply_form' );

		return $fields;
	}

	public function atbdp_single_listing_other_fields_widget( $fields ) {

		$fields['dirjob_job_details'] = array(
			'type'    => 'section',
			'label'   => esc_html__( 'dJobs: Job Details', 'djobs' ),
			'icon'    => 'uil uil-text-fields',
			'options' => array(
				'label'                => array(
					'type'  => 'text',
					'label' => esc_html__( 'Label', 'djobs' ),
					'value' => 'Job Details',
				),
				'custom_block_id'      => array(
					'type'  => 'text',
					'label' => esc_html__( 'Custom block ID', 'djobs' ),
					'value' => '',
				),
				'custom_block_classes' => array(
					'type'  => 'text',
					'label' => esc_html__( 'Custom block Classes', 'djobs' ),
					'value' => '',
				),
			),
		);

		return $fields;
	}

	public function atbdp_email_settings_submenu( $email_settings ) {
		if ( isset( $email_settings['email_templates']['sections'] ) ) {
			$email_settings['email_templates']['sections']['job_manager_email'] = array(
				'title'       => __( 'Job Manager Form Submission', 'directorist-job-manager' ),
				'description' => '',
				'fields'      => array(
					'email_sub_job_submission_email', 'email_tmpl_job_submission_email',
				),
			);
		}

		return $email_settings;
	}

	public function atbdp_pages_settings_fields( $fields ) {
		$fields[] = 'job_manager_form_preview_page';

		return $fields;
	}
}

new Settings_Manager;