<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace Directorist_Job_Manager;

class Scripts {

	public $version;
	protected static $instance = null;

	public function __construct() {
		$this->version = '1.0';
		add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ), 15 );
		add_action( 'wp_head', array( $this, 'conditional_scripts' ) );

		add_action( 'wp_enqueue_scripts', array( $this, 'register_scripts' ), 12 );
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ), 15 );
	}

	public static function instance() {

		if ( null == self::$instance ) {
			self::$instance = new self;
		}

		return self::$instance;
	}

	public function register_scripts() {

		// repeater
		// wp_register_script( 'repeater', ( DIRJOB_BASE_URL . 'assets/js/jquery.repeater.js' ), array( 'jquery' ), $this->version, true );

		// Main js
		wp_register_style( 'dirjob-main', ( DIRJOB_BASE_URL . 'assets/css/main.css' ), array(), $this->version );
		wp_register_script( 'dirjob-main', ( DIRJOB_BASE_URL . 'assets/js/main.js' ), array( 'jquery', 'jquery-ui-draggable' ), $this->version );

		$data = array(
			'ajaxurl'                 => admin_url( 'admin-ajax.php' ),
			'confirmation_text'       => __( 'Are you sure', 'job-manager' ),
			'ask_conf_sl_lnk_del_txt' => __( 'Do you really want to remove this Form Item!', 'job-manager' ),
			'confirm_delete'          => __( 'Yes, Delete it!', 'job-manager' ),
		);

		wp_localize_script( 'dirjob-main', 'dirjob_main_localize_data', $data );
	}

	public function enqueue_scripts() {

		wp_enqueue_style( 'dirjob-main' );
		wp_enqueue_script( 'dirjob-main' );
	}

	// Admin scripts.
	public function admin_scripts() {
		wp_enqueue_style( 'directorist-job-manager-admin', ( DIRJOB_BASE_URL . 'assets/css/admin.css' ), array(), $this->version );
		wp_enqueue_script( 'directorist-job-manager-admin', ( DIRJOB_BASE_URL . 'assets/js/admin.js' ), array(), $this->version );

		$data = array(
			'ajaxurl'                 => admin_url( 'admin-ajax.php' ),
			'confirmation_text'       => __( 'Are you sure', 'job-manager' ),
			'ask_conf_sl_lnk_del_txt' => __( 'Do you really want to remove this Form Item!', 'job-manager' ),
			'confirm_delete'          => __( 'Yes, Delete it!', 'job-manager' ),
		);

		wp_localize_script( 'directorist-job-manager-admin', 'dirjob_admin_localize_data', $data );
	}

	public function conditional_scripts() {

		// Styles for Sidebar: Quick Info
		// if ( get_post_type() === 'at_biz_dir' && is_single() ): ?>

			<style>
				.djm-apply-here {
					max-width: 850px;
					margin: 0 auto;
					background: #fff;
					padding: 50px 100px;
					border-radius: 10px;
					box-shadow: 0 10px 50px rgba(143, 142, 159, 0.2);
				}
				.djm-apply-here .form-field-field {
					margin: 0 0 30px;
				}
				.djm-apply-here .form-field-field label {
					width: 100%;
					font-size: 15px;
    				font-weight: 500;
					margin: 0 0 10px;
				}
				.djm-apply-here .form-field-field .widefat {
					width: 100%;
					height: 50px;
					padding: 12px 20px;
					border-radius: 5px;
					border: 1px solid #E1E4EC;
				}
				.djm-apply-here .form-field-field .widefat:focus {
					border: 2px solid #1A1B29;
					outline: none;
				}
				.djm-apply-here .form-field-field textarea {
					height: 130px !important;
					resize: none;
				}
				.djm-apply-here .form-field-field .widefat::placeholder { /* Chrome, Firefox, Opera, Safari 10.1+ */
					font-size: 14px;
					font-weight: 400;
					color: #8F8E9F; /* Firefox */
				}

				.djm-apply-here .form-field-field .widefat:-ms-input-placeholder { /* Internet Explorer 10-11 */
					font-size: 14px;
					font-weight: 400;
					color: #8F8E9F;
				}

				.djm-apply-here .form-field-field .widefat::-ms-input-placeholder { /* Microsoft Edge */
					font-size: 14px;
					font-weight: 400;
					color: #8F8E9F;
				}
				.djm-apply-here .form-field-field .file-upload {
					position: relative;
					padding: 10px;
					font-size: 0;
					height: 65px;
					line-height: 65px;
					border: 3px dashed #EFF1F6;
				}
				.djm-apply-here .form-field-field .file-upload::before {
					content: 'Browse';
					display: inline-block;
					color: #1A1B29;
					background: rgba(26, 27, 41, 0.1);
					border-radius: 5px;
					height: 36px;
					line-height: 1.3;
					padding: 10px 15px 10px 35px;
					outline: none;
					white-space: nowrap;
					-webkit-user-select: none;
					cursor: pointer;
					font-weight: 400;
					font-size: 13px;
					position: absolute;
					top: 10px;
					z-index: 1;
					transition: all ease 0.3s;
				}
				.djm-apply-here .form-field-field .file-upload::after {
					content: '';
					background-image: url(<?php echo Helper::get_svg_icon( 'paperclip-icon-vector-03', true ); ?>);
            		background-size: cover;
					width: 13px;
					height: 13px;
					position: absolute;
					top: 22px;
					left: 25px;
					z-index: 1;
				}
				.djm-apply-here .form-field-field .file-upload input[type="file"] {
					position: absolute;
					left: 10px;
					width: auto;
					max-height: 36px;
					line-height: 1;
					font-size: 14px;
    				font-weight: 400;
					padding: 12px 12px 12px 115px;
					border: none;
					z-index: 9;
					cursor: pointer;
				}
				.djm-apply-here .form-field-field .file-upload input[type="file"]::file-selector-button,
				.djm-apply-here .form-field-field .file-upload input[type="file"]::-webkit-file-upload-button {
					display: none;
				}
				.djm-apply-here .djm-btn {
					background: #17B978 !important;
					min-height: 50px;
					line-height: 1;
					padding: 10px 25px;
					border-radius: 7px;
					margin: 20px 0 0;
					text-transform: capitalize;
					text-decoration: none;
				}

				.djm-apply-here .djm-btn:hover {
					background: #222 !important;
				}


				.directorist-add-listing-form .directorist-content-module .repeater .directorist-apply-form-draggable .directorist-apply-form-item {
					background: #f9f9f9;
					padding: 25px 20px 15px;
					border-radius: 5px;
					display: -webkit-box;
					display: -ms-flexbox;
					display: flex;
					-webkit-box-align: center;
						-ms-flex-align: center;
							align-items: center;
				}

				.directorist-add-listing-form .directorist-content-module .repeater .directorist-apply-form-draggable .directorist-apply-form-item .directorist-form-group:not(:last-child) {
					margin-bottom: 5px;
				}

				.directorist-add-listing-form .directorist-content-module .directorist-form-group .directorist-form-element {
					padding: 10px 20px;
				}

				@media only screen and (max-width: 991px) {
					.djm-apply-here {
						max-width: unset;
						padding: 40px 30px;
					}
				}

				@media only screen and (max-width: 767px) {
					.djm-apply-here .form-field-field .file-upload input[type="file"] {
						width: 100%;
					}
				}

				@media only screen and (max-width: 480px) {
					.djm-apply-here {
						padding: 40px 15px;
					}
					.directorist-add-listing-form .directorist-content-module .repeater .directorist-apply-form-draggable .directorist-apply-form-item {
						display: block;
					}
					.directorist-apply-form-action {
						flex-direction: unset;
						margin: 15px 0 0;
					}
					.directorist-apply-form-drag {
						margin: 0 10px;
					}
					.directorist-apply-form-action .removeFormFieldField {
						width: auto;
						height: 35px;
						margin: 0 !important;
						padding: 5px 10px !important;
					}
				}

			</style>

		<?php //endif;

		// Add Listing: Salary Range
		if ( is_page() && get_the_ID() == get_directorist_option( 'add_listing_page' ) ): ?>

			<script>
				"use strict";

				(function ($) {
					$(document).ready(function () {

						if ($('#dirjob_salary') !== null) {

							$('#dirjob_salary').css({
								'display': 'grid',
								'grid-template-columns': '1fr 1fr',
								'grid-gap': '15px',
							});

							$('body').on('submit', '#directorist-add-listing-form', function () {
								const dirjob_salary_1st = $('#dirjob_salary_1st').val();
								const dirjob_salary_2nd = $('#dirjob_salary_2nd').val();
								const mixValue = dirjob_salary_1st + '-000-' + dirjob_salary_2nd;
								$('#dirjob_salary_compact').val(mixValue);
							});
						}

					});

				})(jQuery);

			</script>

		<?php endif;
	}
}

Scripts::instance();