<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace Directorist_Job_Manager;

class Mail_Processor {

	protected static $instance = null;
	public $to;
	public $subject;
	public $body;
	public $headers;
	public $attachment;

	public function __construct() {}

	public static function instance() {
		if ( null == self::$instance ) {
			self::$instance = new self;
		}

		include_once ABSPATH . "wp-includes/pluggable.php";

		return self::$instance;
	}

	public function send() {
		return wp_mail( $this->to, $this->subject, $this->body, $this->headers, $this->attachments );
	}

	public function setup( $submission_data ) {
		$this->submission_data = $submission_data;
		$this->to();
		$this->subject();
		$this->body();
		$this->headers();
		$this->attachments();

		return $this;
	}

	public function to() {
		$listing_id = isset( $this->submission_data['listing_id'] ) ? sanitize_text_field( $this->submission_data['listing_id'] ) : 0;
		$author_id  = get_post_field( 'post_author', $listing_id );
		$this->to   = get_the_author_meta( 'user_email', $author_id );
	}

	public function subject() {
		$this->subject = Helper::get_directorist_option( 'email_sub_job_submission_email', __( "New Job Application Submitted", 'directorist-job-manager' ) );
	}

	public function body() {
		$html       = '';
		$listing_id = isset( $this->submission_data['listing_id'] ) ? sanitize_text_field( $this->submission_data['listing_id'] ) : 0;

		foreach ( $this->extract_submission_keys() as $value ) {
			$html .= sprintf( '<p><strong>%s</strong>: %s</p>', esc_html( $value[0] ), esc_html( $value[1] ) );
		}

		$this->body = $this->beautify_message( $html, $listing_id );
	}

	private function extract_submission_keys() {
		$final_arr = array();
		unset( $this->submission_data['listing_id'] );
		unset( $this->submission_data['action'] );

		foreach ( $this->submission_data as $key => $value ) {
			$replaced_space         = str_replace( 'SPACE', ' ', $key );
			$removed_number_and_sep = explode( 'SEPARATOR', $replaced_space );
			$final_arr[]            = array( $removed_number_and_sep[0], $value );
		}

		return $final_arr;
	}

	public function headers() {
		$form_name     = Helper::get_directorist_option( 'email_from_name', get_option( 'blogname' ) );
		$form_email    = Helper::get_directorist_option( 'email_from_email', get_option( 'admin_email' ) );
		$content_type  = 'Content-Type: text/html; charset=UTF-8';
		$from          = "From: {$form_name} <{$form_email}>";
		$this->headers = array( $content_type, $from );
	}

	public function attachments() {
		$attachments       = File_Handler::instance()->upload_files();
		$this->attachments = $attachments;
	}

	public function beautify_message( $submission_fields_html, $listing_id ) {

		$post_author_id = get_post_field( 'post_author', $listing_id );
		$user           = get_userdata( $post_author_id );
		$site_name      = get_bloginfo( 'name' );
		$site_url       = get_bloginfo( 'url' );
		$listing_title  = get_the_title( $listing_id );
		$listing_url    = get_permalink( $listing_id );
		$date_format    = get_option( 'date_format' );
		$time_format    = get_option( 'time_format' );
		$current_time   = current_time( 'timestamp' );

		$placeholders = array(
			'==NAME=='            => $user->display_name,
			'==USERNAME=='        => $user->user_login,
			'==SITE_NAME=='       => $site_name,
			'==SITE_LINK=='       => sprintf( '<a href="%s">%s</a>', $site_url, $site_name ),
			'==SITE_URL=='        => sprintf( '<a href="%s">%s</a>', $site_url, $site_url ),
			'==LISTING_TITLE=='   => $listing_title,
			'==LISTING_LINK=='    => sprintf( '<a href="%s">%s</a>', $listing_url, $listing_title ),
			'==LISTING_URL=='     => sprintf( '<a href="%s">%s</a>', $listing_url, $listing_url ),
			'==SUBMISSION_DATA==' => $submission_fields_html,
			'==TODAY=='           => date_i18n( $date_format, $current_time ),
			'==NOW=='             => date_i18n( $date_format . ' ' . $time_format, $current_time ),
		);

		$job_submission_subject = get_directorist_option( 'email_sub_job_submission_email' );
		$job_submission_body    = get_directorist_option( 'email_tmpl_job_submission_email' );

		$subject = strtr( $job_submission_subject, $placeholders );
		$message = strtr( $job_submission_body, $placeholders );
		$message = nl2br( $message );

		return atbdp_email_html( $subject, $message );
	}
}