<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace Directorist_Job_Manager;

class Helper {

	public static function field_label_template( $data, $label_id = '', $type = "listing-form" ) {
		$key  = ! empty( $data['field_key'] ) ? $data['field_key'] : 'random-' . rand();
		$args = array(
			'data'     => $data,
			'label_id' => $label_id ? $label_id : $key,
		);

		Helper::get_template( "{$type}/field-label", $args );
	}

	public static function field_description_template( $data, $type = "listing-form" ) {
		$args = array(
			'data' => $data,
		);

		Helper::get_template( "{$type}/field-description", $args );
	}

	public static function get_template( $template_file, $args = array() ) {
		if ( is_array( $args ) ) {
			extract( $args );
		}

		$theme_template  = '/directorist-job-manager/' . $template_file . '.php';
		$plugin_template = DIRJOB_BASE_DIR . '/templates/' . $template_file . '.php';

		if ( file_exists( get_stylesheet_directory() . $theme_template ) ) {
			$file = get_stylesheet_directory() . $theme_template;
		} elseif ( file_exists( get_template_directory() . $theme_template ) ) {
			$file = get_template_directory() . $theme_template;
		} else {
			$file = $plugin_template;
		}

		if ( file_exists( $file ) ) {
			include $file;
		}
	}

	public static function get_directorist_option( $name, $default = false, $force_default = false ) {
		// at first get the group of options from the database.
		// then check if the data exists in the array and if it exists then return it
		// if not, then return false
		if ( empty( $name ) ) {
			return $default;
		}
		// get the option from the database and return it if it is not a null value. Otherwise, return the default value
		$options = (array) get_option( 'atbdp_option' );
		$v       = ( array_key_exists( $name, $options ) )
			? $v     = $options[sanitize_key( $name )]
			: null;

		$newvalue = apply_filters( 'directorist_option', $v, $name );

		if ( $newvalue != $v ) {
			return $newvalue;
		}

		// use default only when the value of the $v is NULL
		if ( is_null( $v ) ) {
			return $default;
		}
		if ( $force_default ) {
			// use the default value even if the value of $v is falsy value returned from the database
			if ( empty( $v ) ) {
				return $default;
			}
		}

		return ( isset( $v ) ) ? $v : $default; // return the data if it is anything but NULL.
	}

	public static function get_salary_range( $dirjob_salary ) {
		$mixed_array       = explode( '-000-', $dirjob_salary );
		$dirjob_salary_1st = isset( $mixed_array[0] ) ? $mixed_array[0] : '';
		$dirjob_salary_2nd = isset( $mixed_array[1] ) ? $mixed_array[1] : '';
		$salary            = '';
		$c_position        = self::get_directorist_option( 'g_currency_position' );
		$c_symbol          = self::get_currency_symbol();

		if ( ! $dirjob_salary_1st && ! $dirjob_salary_2nd ) {
			return '';
		} else if ( ! $dirjob_salary_1st ) {
			$salary = $dirjob_salary_2nd;
		} else if ( ! $dirjob_salary_2nd ) {
			$salary = $dirjob_salary_1st;
		} else {
			$salary = sprintf( '%s-%s', $dirjob_salary_1st, $dirjob_salary_2nd );
		}

		if ( 'before' == $c_position ) {
			$salary = sprintf( '%s%s', $c_symbol, $salary );
		} else {
			$salary = sprintf( '%s%s', $salary, $c_symbol );
		}

		return $salary;
	}

	public static function get_single_listing_quick_info_data( $listing_id = null ) {

		if ( ! $listing_id ) {
			$listing_id = get_the_ID();
		}

		// Submission Form
		$listing_type           = get_post_meta( $listing_id, '_directory_type', true );
		$submission_form_fields = get_term_meta( $listing_type, 'submission_form_fields', true );

		// Labels
		$dirjob_deadline_label      = isset( $submission_form_fields['fields']['dirjob_deadline']['label'] ) ? $submission_form_fields['fields']['dirjob_deadline']['label'] : __( 'Deadline', 'directorist-job-manager' );
		$dirjob_job_type_label      = isset( $submission_form_fields['fields']['dirjob_job_type']['label'] ) ? $submission_form_fields['fields']['dirjob_job_type']['label'] : __( 'Iob Type', 'directorist-job-manager' );
		$dirjob_open_position_label = isset( $submission_form_fields['fields']['dirjob_open_position']['label'] ) ? $submission_form_fields['fields']['dirjob_open_position']['label'] : __( 'Position', 'directorist-job-manager' );
		$dirjob_salary_label        = isset( $submission_form_fields['fields']['dirjob_salary']['label'] ) ? $submission_form_fields['fields']['dirjob_salary']['label'] : __( 'Salary', 'directorist-job-manager' );
		$address_label              = isset( $submission_form_fields['fields']['address']['label'] ) ? $submission_form_fields['fields']['address']['label'] : __( 'Location', 'directorist-job-manager' );
		$website_label              = isset( $submission_form_fields['fields']['website']['label'] ) ? $submission_form_fields['fields']['website']['label'] : __( 'Website', 'directorist-job-manager' );

		// Values
		$dirjob_deadline      = get_post_meta( $listing_id, '_dirjob_deadline', true );
		$dirjob_job_type      = get_post_meta( $listing_id, '_dirjob_job_type', true );
		$dirjob_open_position = get_post_meta( $listing_id, '_dirjob_open_position', true );
		$address              = get_post_meta( $listing_id, '_address', true );
		$website              = get_post_meta( $listing_id, '_website', true );
		$dirjob_salary        = self::get_salary_range( get_post_meta( $listing_id, '_dirjob_salary', true ) );

		return array(
			'dirjob_deadline_label'      => $dirjob_deadline_label,
			'dirjob_job_type_label'      => $dirjob_job_type_label,
			'dirjob_open_position_label' => $dirjob_open_position_label,
			'dirjob_salary_label'        => $dirjob_salary_label,
			'address_label'              => $address_label,
			'website_label'              => $website_label,

			'dirjob_deadline'            => isset( $submission_form_fields['fields']['dirjob_job_type'] ) ? $dirjob_deadline : null,
			'dirjob_job_type'            => isset( $submission_form_fields['fields']['dirjob_job_type'] ) ? $dirjob_job_type : null,
			'dirjob_open_position'       => isset( $submission_form_fields['fields']['dirjob_open_position'] ) ? $dirjob_open_position : null,
			'dirjob_salary'              => isset( $submission_form_fields['fields']['dirjob_salary'] ) ? $dirjob_salary : null,
			'address'                    => isset( $submission_form_fields['fields']['address'] ) ? $address : null,
			'website'                    => isset( $submission_form_fields['fields']['address'] ) ? $website : null,
		);
	}

	public static function open_position_label_placement( $listing_id = null ) {
		if ( ! $listing_id ) {
			$listing_id = get_the_ID();
		}

		// Submission Form
		$listing_type           = get_post_meta( $listing_id, '_directory_type', true );
		$submission_form_fields = get_term_meta( $listing_type, 'submission_form_fields', true );

		return isset( $submission_form_fields['fields']['dirjob_open_position']['label_placement'] ) ? $submission_form_fields['fields']['dirjob_open_position']['label_placement'] : 'after';
	}

	public static function get_svg_icon( $filename, $url = false ) {
		$file = DIRJOB_BASE_DIR . '/assets/icons/' . $filename . '.svg';

		if ( ! file_exists( $file ) ) {
			return;
		}

		if ( $url ) {
			return DIRJOB_BASE_URL . '/assets/icons/' . $filename . '.svg';
		}

		$svg = file_get_contents( $file );
		$svg = trim( $svg );

		return $svg;
	}

	public static function get_currency_symbol() {
		$currency = atbdp_get_payment_currency();

		return atbdp_currency_symbol( $currency );
	}

	public static function get_date_by_wp_format( $date ) {
		return date_i18n( get_option( 'date_format' ), strtotime( $date ) );
	}

	public static function get_apply_now_button_html( $listing_id, $args ) {

		$widgets     = $args['listing']->header_data['listings_header']['quick_info'];
		$target      = 'target="__blank"';
		$button_text = __( "Apply Form", "directorist-job-manager" );

		$preview_page_id   = self::get_directorist_option( 'job_manager_form_preview_page' );
		$preview_page_url  = get_permalink( $preview_page_id );
		$apply_form_fields = get_post_meta( $listing_id, '_dirjob_apply_form', true );
		$html              = '';

		foreach ( $widgets as $widget ) {
			if ( 'dirjob_apply_form' == $widget['widget_name'] ) {
				$target      = $widget['target'] ? $target : '';
				$button_text = $widget['button_text'] ? $widget['button_text'] : $button_text;
			}
		}

		if ( $button_text && is_array( $apply_form_fields ) && ! empty( $apply_form_fields ) && $preview_page_id ) {
			$html .= sprintf( '<a href="%s?apply_now=%s" %s>%s</a>', $preview_page_url, get_the_ID(), $target, $button_text );
		}

		echo $html;
	}

	/**
	 * Get all the pages in an array where each page is an array of key:value:id and key:label:name
	 *
	 * Example : array(
	 *                  array('value'=> 1, 'label'=> 'page_name'),
	 *                  array('value'=> 50, 'label'=> 'page_name'),
	 *          )
	 * @return array page names with key value pairs in a multi-dimensional array
	 * @since 3.0.0
	 */
	public static function get_pages_vl_arrays() {
		$pages         = get_pages();
		$pages_options = array();
		if ( $pages ) {
			foreach ( $pages as $page ) {
				$pages_options[] = array( 'value' => $page->ID, 'label' => $page->post_title );
			}
		}

		return $pages_options;
	}
}