<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace Directorist_Job_Manager;

class Generate_Pages {

	protected static $instance = null;

	public function __construct() {
		if ( get_option( 'atbdp_pages_version' ) < 1 ) {
			add_action( 'wp_loaded', array( self::instance(), 'add_custom_page' ) );
		}
	}

	public static function instance() {
		if ( null == self::$instance ) {
			self::$instance = new self;
		}

		return self::$instance;
	}

	public function add_custom_page( $array ) {
		$options      = get_option( 'atbdp_option' ); // we are retrieving all of our custom options because it contains all the page options too. and we can filter this array instead of calling get_directorist_option() over and over.
		$new_settings = 0; // lets keep track of new settings so that we do not update option unnecessarily.

		$directorist_pages = array( 'job_manager_form_preview_page' => array(
			'title'   => __( 'Job Apply Form', 'directorist-job-manager' ),
			'content' => '[directorist_job_manager_form_preview]',
		) );

		foreach ( $directorist_pages as $op_name => $page_settings ) {
			// $op_name is the page option name in the database.
			// if we do not have the page id assigned in the settings with the given page option name, then create an page
			// and update the option.

			if ( empty( $options[$op_name] ) || ! get_post( $options[$op_name] ) ) {

				$id = wp_insert_post(
					array(
						'post_title'     => $page_settings['title'],
						'post_content'   => $page_settings['content'],
						'post_status'    => 'publish',
						'post_type'      => 'page',
						'comment_status' => 'closed',
					)
				);
				// if we have added the page successfully, lets add the page id to the options array to save the page settings in the database after the loop.
				if ( $id ) {
					$options[$op_name] = (int) $id;

					/*TRYING TO SET THE DEFAULT PAGE TEMPLATE FOR THIS PAGE WHERE OUR SHORTCODE IS USED */
					// get the template list of the theme and if it has any full width template then assign it.
					$page_templates  = wp_get_theme()->get_page_templates();
					$custom_template = ''; // place holder for full width template
					$temp_type       = ( 'search_listing' == $op_name ) ? 'home-page.php' : 'full'; // look for home template for search_listing page
					// lets see if we can find any full width template, then use it for the page where our shortcode is used.
					foreach ( $page_templates as $slug => $name ) {
						// checkout page and payment receipt page looks better on non full-width template, so skip them.
						if ( in_array( $op_name, array( 'checkout_page', 'payment_receipt_page' ) ) ) {
							break;
						}

						if ( strpos( $slug, $temp_type ) ) {
							$custom_template = $slug;
							break;
						}
					}
					if ( ! empty( $custom_template ) ) {
						update_post_meta( $id, '_wp_page_template', sanitize_text_field( $custom_template ) );
					}

				}

				$new_settings++;
			} else {
				$replace_shortcode = wp_update_post(
					array(
						'ID'             => $options[$op_name],
						'post_title'     => $page_settings['title'],
						'post_content'   => $page_settings['content'],
						'post_status'    => 'publish',
						'post_type'      => 'page',
						'comment_status' => 'closed',
					), true
				);
			}
			// if we have new options then lets update the options with new option values.
			if ( $new_settings ) {
				update_option( 'atbdp_option', $options );
			}
			update_option( 'atbdp_pages_version', 1 );
		}
	}
}

Generate_Pages::instance();