<?php
/**
 * @author  HeyMehedi
 * @since   1.0
 * @version 1.0
 */

namespace Directorist_Job_Manager;

class General {

	protected static $instance = null;

	public function __construct() {
		add_shortcode( 'directorist_job_manager_form_preview', array( $this, 'directorist_job_manager_form_preview' ) );
	}

	public static function instance() {
		if ( null == self::$instance ) {
			self::$instance = new self;
		}

		return self::$instance;
	}

	public function directorist_job_manager_form_preview() {
		$listing_id        = isset( $_REQUEST['apply_now'] ) ? sanitize_text_field( $_REQUEST['apply_now'] ) : 0;
		$apply_form_fields = get_post_meta( $listing_id, '_dirjob_apply_form', true );

		if ( $apply_form_fields || is_array( $apply_form_fields ) && $listing_id && is_single( $listing_id ) ):
			return Form_Generator::display( $apply_form_fields );
		elseif ( $apply_form_fields || is_array( $apply_form_fields ) && $listing_id ):
			return sprintf( '<div class="wrong-form"><p>%s</p></div>', __( "Something wen't wrong" ) );
		endif;
	}
}

General::instance();