<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace Directorist_Job_Manager;

class Form_Generator {

	protected static $instance = null;

	public function __construct() {
	}

	public static function instance() {
		if ( null == self::$instance ) {
			self::$instance = new self;
		}

		return self::$instance;
	}

	public static function display( $fields ) {

		ob_start();

		if ( is_array( $fields ) && ! empty( $fields ) ):

			echo '<div class="djm-apply-here"><form action="" method="POST" id="form-job-application">';

			foreach ( $fields as $key => $field ):
				$label       = isset( $field['text-label'] ) ? $field['text-label'] : '';
				$placeholder = isset( $field['text-placeholder'] ) ? $field['text-placeholder'] : '';
				$required    = isset( $field['required'] ) ? $field['required'] : false;
				$desc        = isset( $field['desc'] ) && ! empty( $field['desc'] ) ? $field['desc'] : false;
				$id          = rand();
				$value       = '';
				$name        = str_replace( ' ', 'SPACE', $field['text-label'] );
				$name        = $name . "SEPARATOR{$key}";
				$options     = isset( $field['options'] ) && ! empty( $field['options'] ) ? $field['options'] : false;

				if ( method_exists( __CLASS__, $field['selectfield-type'] ) ) {

					echo '<div class="form-field-field">';
					call_user_func( array( __CLASS__, $field['selectfield-type'] ), $id, $name, $value, $label, $options, $field, $placeholder );

					if ( $desc ) {
						echo '<div class="desc">' . $desc . '</div>';
					}

					echo '</div>';
				}

			endforeach;
			printf( '<input type="hidden" value="%s" name="listing_id" />', isset( $_GET['apply_now'] ) ? $_GET['apply_now'] : '' );
			echo '<button type="submit" id="submit-job-application" class="directorist-btn directorist-btn-lg directorist-btn-dark directorist-btn-search djm-btn"> Submit Application </button>';
			echo '<div class="dirjob_message"></div>';
			echo '</div></form>';

		endif;

		return ob_get_clean();
	}

	public static function text( $id, $name, $value, $label, $options, $field, $placeholder ) {
		?>
		<label for="<?php echo esc_attr( $id ); ?>"><?php echo esc_html( $label ); ?></label>
		<input <?php self::placeholder( $placeholder );?> class="widefat" type="text" id="<?php echo esc_attr( $id ); ?>" name="<?php echo esc_attr( $name ); ?>" value="<?php echo esc_attr( $value ); ?>" />
	<?php }

	public static function email( $id, $name, $value, $label, $options, $field, $placeholder ) {
		?>
		<label for="<?php echo esc_attr( $id ); ?>"><?php echo esc_html( $label ); ?></label>
		<input <?php self::placeholder( $placeholder );?> class="widefat" type="email" id="<?php echo esc_attr( $id ); ?>" name="<?php echo esc_attr( $name ); ?>" value="<?php echo esc_attr( $value ); ?>" />
	<?php }

	public static function url( $id, $name, $value, $label, $options, $field, $placeholder ) {
		?>
		<label for="<?php echo esc_attr( $id ); ?>"><?php echo esc_html( $label ); ?></label>
		<input <?php self::placeholder( $placeholder );?> class="widefat" type="text" id="<?php echo esc_attr( $id ); ?>" name="<?php echo esc_attr( $name ); ?>" value="<?php echo esc_url( $value ); ?>" />
	<?php }

	public static function number( $id, $name, $value, $label, $options, $field, $placeholder ) {
		$min  = isset( $field['min'] ) ? $field['min'] : 1;
		$max  = isset( $field['max'] ) ? $field['max'] : '';
		$step = isset( $field['step'] ) ? $field['step'] : 1;
		?>
		<label for="<?php echo esc_attr( $id ); ?>"><?php echo esc_html( $label ); ?></label>
		<input <?php self::placeholder( $placeholder );?> class="widefat" type="number" min="<?php echo esc_attr( $min ); ?>" max="<?php echo esc_attr( $max ); ?>" step="<?php echo esc_attr( $step ); ?>" id="<?php echo esc_attr( $id ); ?>" name="<?php echo esc_attr( $name ); ?>" value="<?php echo esc_attr( $value ); ?>" />
	<?php }

	public static function textarea( $id, $name, $value, $label, $options, $field, $placeholder ) {
		?>
		<label for="<?php echo esc_attr( $id ); ?>"><?php echo esc_html( $label ); ?></label>
		<textarea <?php self::placeholder( $placeholder );?> class="widefat" rows="3" id="<?php echo esc_attr( $id ); ?>" name="<?php echo esc_attr( $name ); ?>"><?php echo esc_textarea( $value ); ?></textarea>
	<?php }

	public static function select( $id, $name, $value, $label, $options, $field ) {
		?>
		<label for="<?php echo esc_attr( $id ); ?>"><?php echo esc_html( $label ); ?></label>
		<select name="<?php echo esc_attr( $name ); ?>" id="<?php echo esc_attr( $id ); ?>">
			<?php foreach ( $options as $key => $option ): ?>
				<?php $selected = ( $key == $value ) ? ' selected="selected"' : '';?>
				<option value="<?php echo esc_attr( $key ); ?>"<?php echo $selected; ?>><?php echo esc_html( $option ) ?></option>
			<?php endforeach;?>
		</select>
	<?php }

	public static function file( $id, $name, $value, $label, $options, $field, $placeholder ) {
		?>
		<label for="<?php echo esc_attr( $id ); ?>"><?php echo esc_html( $label ); ?></label>
		<div class="file-upload">
			<input class="widefat" type="file" id="<?php echo esc_attr( $id ); ?>" name="<?php echo esc_attr( $name ); ?>" />
		</div>

	<?php }

	public static function placeholder( $placeholder ) {
		echo $placeholder ? "placeholder='{$placeholder}'" : '';
	}
}

Form_Generator::instance();