<?php
/**
 * @author  wpWax
 * @since   1.0
 * @version 1.0
 */

namespace Directorist_Job_Manager;

class Ajax_Handler {

	protected static $instance = null;

	public function __construct() {
		add_action( 'wp_ajax_job_manager_form_field_handler', array( $this, 'job_manager_form_field_handler' ) );
		add_action( 'wp_ajax_nopriv_job_manager_form_field_handler', array( $this, 'job_manager_form_field_handler' ) );

		add_action( 'wp_ajax_dirjob_form_submission', array( $this, 'dirjob_form_submission' ) );
		add_action( 'wp_ajax_nopriv_dirjob_form_submission', array( $this, 'dirjob_form_submission' ) );
	}

	public static function instance() {
		if ( null == self::$instance ) {
			self::$instance = new self;
		}

		return self::$instance;
	}

	/**
	 *  Add new Social Item in the member page in response to Ajax request
	 */
	public function job_manager_form_field_handler() {
		$id = ( ! empty( $_POST['id'] ) ) ? absint( $_POST['id'] ) : 0;
		echo Helper::get_template( 'listing-form/fields/dirjob_apply_form_fields', array( 'id' => $id ) );
		die();
	}

	public function dirjob_form_submission() {
		Form_Handler::instance()->submit_data_process();
		die();
	}
}

Ajax_Handler::instance();