<?php
/**
 * Plugin Name: Directorist - Job Manager
 * Plugin URI: https://directorist.com/product/directorist-job-manager
 * Description: This is an extension for Directorist plugin. It allows you to create job listing using directorist.
 * Version: 1.0.1
 * Author: wpWax
 * Author URI: https://wpwax.com
 * License: GPLv2 or later
 * Text Domain: directorist-job-manager
 * Domain Path: /languages
 */

use Directorist_Job_Manager\Generate_Pages;

// Prevent direct access to the file
defined( 'ABSPATH' ) || die( 'No direct script access allowed!' );

if ( ! defined( 'DIRJOB_BASE_DIR' ) ) {
	define( 'DIRJOB_BASE_DIR', plugin_dir_path( __FILE__ ) );
}

if ( ! defined( 'DIRJOB_BASE_URL' ) ) {
	define( 'DIRJOB_BASE_URL', plugin_dir_url( __FILE__ ) );
}

if ( ! class_exists( 'Directorist_Job_Manager' ) ) {

	final class Directorist_Job_Manager {

		private static $instance;

		public static function instance() {

			if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Directorist_Job_Manager ) ) {
				self::$instance = new Directorist_Job_Manager();
				self::$instance->init();
			}

			return self::$instance;
		}

		private function __construct() {}

		private function init() {
			add_action( 'plugins_loaded', array( $this, 'load_textdomain' ), 20 );
			$this->includes();
			register_activation_hook( __FILE__, array( Generate_Pages::instance(), 'add_custom_page' ) );
		}

		public function load_textdomain() {
			load_plugin_textdomain( 'directorist-job-manager', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
		}

		public function includes() {
			require_once DIRJOB_BASE_DIR . '/includes/class-helper.php';
			require_once DIRJOB_BASE_DIR . '/includes/class-general.php';
			require_once DIRJOB_BASE_DIR . '/includes/class-scripts.php';
			require_once DIRJOB_BASE_DIR . '/includes/class-settings-manager.php';
			require_once DIRJOB_BASE_DIR . '/includes/class-form-generator.php';

			require_once DIRJOB_BASE_DIR . '/includes/class-file-handler.php';
			require_once DIRJOB_BASE_DIR . '/includes/class-mail-processor.php';
			require_once DIRJOB_BASE_DIR . '/includes/class-form-handler.php';
			require_once DIRJOB_BASE_DIR . '/includes/class-ajax-handler.php';
			require_once DIRJOB_BASE_DIR . '/includes/class-generate-pages.php';

			require_once DIRJOB_BASE_DIR . '/includes/class-widget-quick-info.php';
		}
	}

	add_action( 'plugins_loaded', function () {
		require_once ( ABSPATH . '/wp-admin/includes/plugin.php' );
		
		if ( ! is_plugin_active( 'directorist/directorist-base.php' ) ) {
			deactivate_plugins( 'directorist-job-manager/directorist-job-manager.php' );
			require_once DIRJOB_BASE_DIR . '/includes/class-warning-notice.php';
		}
	} );

	Directorist_Job_Manager::instance();
}