"use strict";

(function ($) {

	function addNewElement() {
		const FormField_Wrap = $('#dirjob_apply_form_sortable_container'); // cache it
		const currentItems = $('.dirjob_apply_form_field_wrapper').length;
		const ID = `id=${currentItems}`; // eg. 'id=3'
		const iconBindingElement = jQuery('#addNewFormField');

		// arrange names ID in order before adding new elements
		$('.dirjob_apply_form_field_wrapper').each(function (index, element) {
			const e = $(element);
			e.attr('id', `FormField-${index}`);
			let wrapId = $(this).attr('id');

			$(wrapId + " [name='selectfield-type']").attr('name', `dirjob_apply_form[${index}][selectfield-type]`);
			$(wrapId + " [name='text-label']").attr('name', `dirjob_apply_form[${index}][text-label]`);
			$(wrapId + " [name='text-placeholder']").attr('name', `dirjob_apply_form[${index}][text-placeholder]`);
			$(wrapId + " [name='required']").attr('name', `dirjob_apply_form[${index}][required]`);
		});

		// now add the new elements. we could do it here without using ajax but it would require more markup here.
		atbdp_do_ajax(iconBindingElement, 'job_manager_form_field_handler', ID, function (data) {
			FormField_Wrap.append(data);
		});
	}

	/* This function handles all ajax request */
	function atbdp_do_ajax(ElementToShowLoadingIconAfter, ActionName, arg, CallBackHandler) {
		let data;
		if (ActionName) data = `action=${ActionName}`;
		if (arg) data = `${arg}&action=${ActionName}`;
		if (arg && !ActionName) data = arg;
		// data = data ;

		const n = data.search(dirjob_admin_localize_data.nonceName);
		if (n < 0) {
			data = `${data}&${dirjob_admin_localize_data.nonceName}=${dirjob_admin_localize_data.nonce}`;
		}

		jQuery.ajax({
			type: 'post',
			url: dirjob_admin_localize_data.ajaxurl,
			data,
			beforeSend() {
				jQuery("<span class='atbdp_ajax_loading'></span>").insertAfter(
					ElementToShowLoadingIconAfter
				);
			},
			success(data) {
				jQuery('.atbdp_ajax_loading').remove();
				CallBackHandler(data);
			},
		});
	}

	$(document).ready(function () {

		{
			// Rearrange the IDS and Add new FormField field
			$('body').on('click', '#addNewFormField', function () {
				addNewElement();
			});

			//remove the FormField field and then reset the ids while maintaining position
			$(document).on('click', '.removeFormFieldField', function (e) {
				const id = $(this).data('id');
				const elementToRemove = $(`div#FormField-${id}`);
				e.preventDefault();

				/* Act on the event */
				swal(
					{
						title: dirjob_admin_localize_data.confirmation_text,
						text: dirjob_admin_localize_data.ask_conf_sl_lnk_del_txt,
						type: 'warning',
						showCancelButton: true,
						confirmButtonColor: '#DD6B55',
						confirmButtonText: dirjob_admin_localize_data.confirm_delete,
						closeOnConfirm: false,
					},
					function (isConfirm) {
						if (isConfirm) {
							// user has confirmed, no remove the item and reset the ids
							elementToRemove.slideUp('fast', function () {
								elementToRemove.remove();
								let newIndex = 0;

								// arrange names ID in order before adding new elements
								$('.dirjob_apply_form_field_wrapper').each(function (index, element) {
									const e = $(element);
									e.attr('id', `FormField-${index}`);
									$(`div#FormField-${index} .selectfield-type`).attr('name', `dirjob_apply_form[${index}][selectfield-type]`);
									$(`div#FormField-${index} .text-label`).attr('name', `dirjob_apply_form[${index}][text-label]`);
									$(`div#FormField-${index} .text-placeholder`).attr('name', `dirjob_apply_form[${index}][text-placeholder]`);
									$(`div#FormField-${index} .required`).attr('name', index);
									$(`div#FormField-${index} .removeFormFieldField`).attr('data-id', index);
								});
							});

							// show success message
							swal({
								title: 'Deleted',
								type: 'success',
								timer: 200,
								showConfirmButton: false,
							});
						}
					}
				);
			});
			var $draggableContainer = $(".directorist-apply-form-draggable"); // cache it

			if ($draggableContainer.length) {
				$draggableContainer.sortable({
					axis: 'y',
					opacity: '0.7'
				});
			}
		}

		// Form Submission
		{
			$(document).on('click', '#submit-job-application', function (e) {
				e.preventDefault();
				let myForm = document.getElementById('form-job-application');
				let formData = new FormData(myForm);

				formData.append('action', 'dirjob_form_submission');
				$.ajax({
					method: 'POST',
					processData: false,
					contentType: false,
					url: dirjob_admin_localize_data.ajaxurl,
					data: formData,
					success: function success(response) {
						$('.dirjob_message').html(`<p class="success">${response.data.message}</p>`);
					},
					error: function error(_error) {
						$('.dirjob_message').html(`<p class="failed">${_error.data.message}</p>`);
					}
				});

				console.log(formData);
			});
		}

		if ($('#dirjob_salary') !== null) {

			$('#dirjob_salary').css({
				'display': 'grid',
				'grid-template-columns': '1fr 1fr',
				'grid-gap': '15px',
			});

			$('#post').on('submit', function () {
				const dirjob_salary_1st = $('#dirjob_salary_1st').val();
				const dirjob_salary_2nd = $('#dirjob_salary_2nd').val();
				const mixValue = dirjob_salary_1st + '-000-' + dirjob_salary_2nd;
				$('#dirjob_salary_compact').val(mixValue);
			});
		}
	});

})(jQuery);