<?php
/**
 * @package  Directorist - Ads Manager
 */

/**
 * Plugin Name:       Directorist - Ads Manager
 * Plugin URI:        https://directorist.com/product/directorist-adverts-manager/
 * Description:       Directorist Ads Manager allows you to insert advertisements on specific Directorist pages such as All listings, Single Listings, All Location, All Category, etc
 * Version:           1.1.5
 * Requires at least: 5.2
 * Author:            wpWax
 * Author URI:        https://wpwax.com
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       directorist-adverts-manager
 * Domain Path:       /languages
 */



/**
 * If this file is called directly, abrot!!!
 */ 
if( ! defined( 'ABSPATH' ) ) {
    exit;                      // Exit if accessed
}



if( ! class_exists( 'SWBDPAdsManager' ) ){
    /**
     * Plugin's main class
     */
    final class SWBDPAdsManager
    {   
        /**
        * Created plugin Singleton instance
        *
        * @var string
        */
        private static $instance;    


        /**
         * Class constructor
         * 
         * @return object ATDAdsManager 
         */
        public static function instance()
        {
            
            // Authenticate, is instance created or not
            if( ! isset( self::$instance ) && !( self::$instance instanceof SWBDPAdsManager ) ){
                self::$instance = new SWBDPAdsManager();
                self::$instance->define_constant();
                self::$instance->instance_plugin_classes();     
            }

            return self::$instance;
        } 

        public static function get_version_from_file_content( $file_path = '' ) {
            $version = '';
    
            if ( ! file_exists( $file_path ) ) {
                return $version;
            }
    
            $content = file_get_contents( $file_path );
            $version = self::get_version_from_content( $content );
            
            return $version;
        }

        public static function get_version_from_content( $content = '' ) {
            $version = '';
    
            if ( preg_match('/\*[\s\t]+?version:[\s\t]+?([0-9.]+)/i', $content, $v) ) {
                $version = $v[1];
            }
    
            return $version;
        }
        
        
        /**
        * Define the required plugin constant
        *
        * @return void
        */
        public function define_constant()
        {
            $version = self::get_version_from_file_content( __FILE__ );
            define( 'SWBDPAM_PLUGIN_VERSION', $version );
            define( 'SWBDPAM_POST_TYPE', 'swbdp-ad-manager' );
            if ( !defined('ATBDP_POST_TYPE') ) { define('ATBDP_POST_TYPE', 'at_biz_dir'); } ;
            // plugin author url
            if (!defined('ATBDP_AUTHOR_URL')) { define('ATBDP_AUTHOR_URL', 'https://directorist.com');}
            // post id from download post type (edd)
            if (!defined('ATBDP_ADS_POST_ID')) { define('ATBDP_ADS_POST_ID', 32342);}
            define( 'SWBDPAM_BASE_FILE', __FILE__ );
            define( 'SWBDPAM_PLUGIN_DIR_PATH', dirname( __FILE__ ) ."/" );
            define( 'SWBDPAM_PLUGIN_DIR_URL', plugin_dir_url( __FILE__ ) );
            define( 'SWBDPAM_PLUGIN_DIRNAME', dirname( plugin_basename( __FILE__ ) ) );            
            define( 'SWBDPAM_PLUGIN_TEMPLATES_DIR', dirname( __FILE__ ) ."/Inc/View/" );            
            define( 'SWBDPAM_ADMIN_CSS', SWBDPAM_PLUGIN_DIR_URL ."assets/admin/css/" );
            define( 'SWBDPAM_ADMIN_JS', SWBDPAM_PLUGIN_DIR_URL ."assets/admin/js/" );
            define( 'SWBDPAM_FRONTEND_CSS', SWBDPAM_PLUGIN_DIR_URL ."assets/frontend/css/" );
            define( 'SWBDPAM_FRONTEND_JS', SWBDPAM_PLUGIN_DIR_URL ."assets/frontend/js/" );
            define( 'SWBDPAM_ADMIN_IMAGE_URL', SWBDPAM_PLUGIN_DIR_URL ."assets/admin/img/" );
        }
        
 

        /**
         * Iintialize all other classes of this plugin
         *
         * @return void
         */
        public function instance_plugin_classes()
        { 
            if (!class_exists('EDD_SL_Plugin_Updater')) {
                // load our custom updater if it doesn't already exist
                include(dirname(__FILE__) . '/Inc/Controller/Admin/EDD_SL_Plugin_Updater.php');
            }
            // setup the updater
            $license_key = trim(get_option('directorist_ads_license'));
            new EDD_SL_Plugin_Updater(ATBDP_AUTHOR_URL, __FILE__, array(
                'version'   => SWBDPAM_PLUGIN_VERSION,        // current version number
                'license'   => $license_key,    // license key (used get_option above to retrieve from DB)
                'item_id'   => ATBDP_ADS_POST_ID,    // id of this plugin
                'author'    => 'AazzTech',    // author of this plugin
                'url'       => home_url(),
                'beta'      => false // set to true if you wish customers to receive update notifications of beta releases
            ));

            require_once( SWBDPAM_PLUGIN_DIR_PATH .'includes.php' );
            SWBDPAMIncludeClasses::includes();

            $class_names = array(
                'SWBDPAMEnqueue',
                'SWBDPAMActivate',
                'SWBDPAMPDashboard',
                'SWBDPAdsManagerCPT', 
                'SWBDPAMExtnSettings',  
                'SWBDPAMWidgetsHandler',
                'SWBDPAMAdminCallbacks',                
                'SWBDPWidgetAdsManager',
                'SWBDPAMHelperFunctions',
                'SWBDPAMShortcodeHandler',
                'SWBDPAMCustomWpListTable',
                'SWBDPAMPAddListing',
                'SWBDPAMPAllListings',
                'SWBDPAMPAllLocations',
                'SWBDPAMPSearchHome',
                'SWBDPAMPSearchResult',
                'SWBDPAMPAllCategories',
                'SWBDPAMPAuthorListing',
                'SWBDPAMPSingleListing',
                'SWBDPAMPSingleCategory',
                'SWBDPAMPSingleLocation',                                    
            );

            foreach( $class_names as $class_name ){
                if( method_exists( $class_name, 'register' ) ){
                    $object = new $class_name;                    
                    $object->register();
                }                
            }
        }

    }// End class

    if (!function_exists('get_directorist_option')) {

        /**
         * It retrieves an option from the database if it exists and returns false if it is not exist.
         * It is a custom function to get the data of custom setting page
         * @param string $name The name of the option we would like to get. Eg. map_api_key
         * @param mixed $default Default value for the option key if the option does not have value then default will be returned
         * @param bool $force_default Whether to use default value when database return anything other than NULL such as '', false etc
         * @return mixed    It returns the value of the $name option if it exists in the option $group in the database, false otherwise.
         */
        function get_directorist_option($name, $default = false, $force_default = false)
        {
            // at first get the group of options from the database.
            // then check if the data exists in the array and if it exists then return it
            // if not, then return false
            if (empty($name)) {
                return $default;
            }
            // get the option from the database and return it if it is not a null value. Otherwise, return the default value
            $options = (array)get_option('atbdp_option');
            $v = (array_key_exists($name, $options))
                ? $v = $options[sanitize_key($name)]
                : null;

            $newvalue = apply_filters( 'directorist_option', $v, $name );

            if ( $newvalue != $v ) {
            return $newvalue;
            }

            // use default only when the value of the $v is NULL
            if (is_null($v)) {
                return $default;
            }
            if ($force_default) {
                // use the default value even if the value of $v is falsy value returned from the database
                if (empty($v)) {
                    return $default;
                }
            }
            return (isset($v)) ? $v : $default; // return the data if it is anything but NULL.
        }
    }

    /**
     * Initializes the main plugin
     *
     * @return \SWBDPAdsManager class
     */
    function SWBDPAdsManager()
    {
        return SWBDPAdsManager::instance();        
    }


    /**
     * Handle plugin activation
     *
     * @return void
     */
    function swbdp_ads_manager_plugin_activate()
    {
        // Get the Directorist plugin is active or deactive
        if( in_array( 'directorist/directorist-base.php', ( array )get_option( 'active_plugins' ) ) ) {

            // Get Directorist - Ads Manager plugin activation time
            $installed = get_option( 'swbdp_ads_manager_installed' );
            if( ! $installed ){
                update_option( 'swbdp_ads_manager_installed', time() );
            }
            // Store current version of this plugin.
            update_option( 'swbdp_ads_manager_version', SWBDPAM_PLUGIN_VERSION );            
        }

    }
    register_activation_hook( __FILE__, 'swbdp_ads_manager_plugin_activate' );



    /**
    * Handle plugin deactivation
    *
    * @return void
    */
    function swbdp_ads_manager_plugin_deactivate()
    {
        //flush_rewrite_rules();
    }
    register_deactivation_hook( __FILE__, 'swbdp_ads_manager_plugin_deactivate' );


    if ( ! function_exists( 'directorist_is_plugin_active' ) ) {
        function directorist_is_plugin_active( $plugin ) {
            return in_array( $plugin, (array) get_option( 'active_plugins', array() ), true ) || directorist_is_plugin_active_for_network( $plugin );
        }
    }

    if ( ! function_exists( 'directorist_is_plugin_active_for_network' ) ) {
        function directorist_is_plugin_active_for_network( $plugin ) {
            if ( ! is_multisite() ) {
                return false;
            }
                    
            $plugins = get_site_option( 'active_sitewide_plugins' );
            if ( isset( $plugins[ $plugin ] ) ) {
                    return true;
            }

            return false;
        }
    }


    /**
     * If the Directorist plugin is activate then Directorist - Ads Manager plugin is run otherwise don't run.
     */
    if (  directorist_is_plugin_active( 'directorist/directorist-base.php' ) ) {

        /**
         * If called this method then Directorist - Ads Manager plugin is run otherwise don't run
         * 
         * Kick-off the plugin
         */
        SWBDPAdsManager(); // get the plugin running
    }     

}