/**
 * @package  Directorist - Ads Manager
 */


jQuery( document ).ready( function($){

    $('#ads-activated input[name="ads-activated"]').on('change', function (event) {
        event.preventDefault();
        var form_data = new FormData();
        var ads_license = $('#ads_license input[name="ads_license"]').val();
        form_data.append('action', 'atbdp_ads_license_activation');
        form_data.append('ads_license', ads_license);
        $.ajax({
            method: 'POST',
            processData: false,
            contentType: false,
            url: sendVarible.ajaxurl,
            data: form_data,
            success: function (response) {
                if (response.status === true) {
                    $('#success_msg').remove();
                    $('#ads-activated').after('<p id="success_msg">' + response.msg + '</p>');
                    location.reload();
                } else {
                    $('#error_msg').remove();
                    $('#ads-activated').after('<p id="error_msg">' + response.msg + '</p>');
                }
            },
            error: function (error) {
                // console.log(error);
            }
        });
    });
    // deactivate license
    $('#ads-deactivated input[name="ads-deactivated"]').on('change', function (event) {
        event.preventDefault();
        var form_data = new FormData();
        var ads_license = $('#ads_license input[name="ads_license"]').val();
        form_data.append('action', 'atbdp_ads_license_deactivation');
        form_data.append('ads_license', ads_license);
        $.ajax({
            method: 'POST',
            processData: false,
            contentType: false,
            url: sendVarible.ajaxurl,
            data: form_data,
            success: function (response) {
                if (response.status === true) {
                    $('#success_msg').remove();
                    $('#ads-deactivated').after('<p id="success_msg">' + response.msg + '</p>');
                    location.reload();
                } else {
                    $('#error_msg').remove();
                    $('#ads-deactivated').after('<p id="error_msg">' + response.msg + '</p>');
                }
            },
            error: function (error) {
                // console.log(error);
            }
        });
    });
    
    /**************  START Image ad uploader START  ****************/
    var frame;
    var ad_image_url = $( "#swbdpam__image-ad-image-url" ).val();

    if( ad_image_url ) {
        $( "#swbdpam__image-ad-image-container" ).html( `<img src='${ad_image_url}' />` );
    }

    $( "#swbdpam__image-ad-image-uploader" ).on( "click", function(){
        if( frame ){
            frame.open();
            return false;
        }

        frame = wp.media( {
            title: "Select Image",
            button: {
                text: "Insert Image"
            },
            multiple: false
        } );

        frame.on( 'select', function() {
            var attachment = frame.state().get( 'selection' ).first().toJSON();

            $( "#swbdpam__image-ad-image-id" ).val( attachment.id );
            $( "#swbdpam__image-ad-image-url" ).val( attachment.sizes.thumbnail.url );
            $( "#swbdpam__image-ad-image-container" ).html( `<img src='${attachment.sizes.thumbnail.url}' />` );
        });
        frame.open();

        return false;
    });
    /**************  END Image ad uploader END  ****************/


    /**************  START Contact for ad image uploader START  ****************/
    var contactImageFrame;
    var contact_image_url = $( "#swbdpam__contact-image-url" ).val();

    if( contact_image_url ) {
        $( "#swbdpam__contact-image-container" ).html( `<img src='${contact_image_url}' />` );
    }

    $( "#swbdpam__contact-image-uploader" ).on( "click", function(){
        if( contactImageFrame ){
            contactImageFrame.open();
            return false;
        }

        contactImageFrame = wp.media( {
            title: "Select Image",
            button: {
                text: "Insert Image"
            },
            multiple: false
        } );

        contactImageFrame.on( 'select', function() {
            var attachment = contactImageFrame.state().get( 'selection' ).first().toJSON();
            console.log( attachment );
            $( "#swbdpam__contact-image-id" ).val( attachment.id );
            $( "#swbdpam__contact-image-url" ).val( attachment.sizes.thumbnail.url );
            $( "#swbdpam__contact-image-container" ).html( `<img src='${attachment.sizes.thumbnail.url}' />` );
        });

        contactImageFrame.open();
        return false;
    });
    /**************  END Contact for ad image uploader END  ****************/

    

    // Defult ad types input field are hide
    if( $( '#swbdpam__ad-type-image, #swbdpam__ad-type-custom_code' ).is( ':checked' ) ){
        $( '#swbdpam__image-ad-row, #swbdpam__terget-url-row, #swbdpam__rel-attribute-row, #swbdpam__open-link-row' ).show();
    }else{
        $( '#swbdpam__image-ad-row, #swbdpam__terget-url-row, #swbdpam__rel-attribute-row, #swbdpam__open-link-row' ).hide();
    }

    if( $( '#swbdpam__ad-type-image' ).is( ':checked' ) ){
        $( '#directorist-img-ad-size-row' ).show();
    }else{
        $( '#directorist-img-ad-size-row' ).hide();
    }

    if( $( '#swbdpam__ad-type-google_adsense, #swbdpam__ad-type-facebook_pixel, #swbdpam__ad-type-custom_code' ).is( ':checked' ) ){
        $( '#swbdpam__custom-code-row' ).show();
    }else{     
        $( '#swbdpam__custom-code-row' ).hide( 1 );
    }
   
    if( $( '#swbdpam__ad-type-google_adsense' ).is( ':checked' ) ){
        $( '#swbdpam__code-editor-label' ).html( sendVarible.adsense_ad_label );
    }

    if( $( '#swbdpam__ad-type-facebook_pixel' ).is( ':checked' ) ){
        $( '#swbdpam__code-editor-label' ).html( sendVarible.facebook_ad_label );
    }

    if( $( '#swbdpam__ad-type-custom_code' ).is( ':checked' ) ){
        $( '#swbdpam__code-editor-label' ).html( sendVarible.custom_code_ad_label );
        $( '#swbdpam__image-ad-row' ).hide();
    }
    



    /**************   START image type ad   ****************/
    // When click on 'Image button' for image ad then show the image type ad for image uploader
    $( "body" ).on( "click", "#swbdpam__ad-type-image", function (){
        $( '#swbdpam__image-ad-row, #swbdpam__terget-url-row, #swbdpam__rel-attribute-row, #swbdpam__open-link-row, #directorist-img-ad-size-row' ).show();
        $( '#swbdpam__custom-code-row' ).hide();

        $( '#swbdpam__custom-code-row' ).hide();

    });
    /**************   END image type ad   ****************/


    /**************   START Google Adsense type ad   ****************/
    // When click on 'Google Adsense button' for Google Adsense ad then show the Google Adsense type ad input field
    $( "body" ).on( "click", "#swbdpam__ad-type-google_adsense", function (){
        $( '#swbdpam__code-editor-label' ).html( sendVarible.adsense_ad_label );

        $( '#swbdpam__custom-code-row' ).show();
        $( '#swbdpam__image-ad-row, #swbdpam__terget-url-row, #swbdpam__rel-attribute-row, #swbdpam__open-link-row, #directorist-img-ad-size-row' ).hide();

        $( '#swbdpam__image-ad-image-id' ).val( '' );
        $( '#swbdpam__image-ad-image-url' ).val( '' );

    });
    /**************   END Google Adsense type ad   ****************/

    
    /**************   START facebook pixel type ad   ****************/
    // When click on 'Facebook Pixel button' for facebook pixel ad then show the facebook pixel type ad input field
    $( "body" ).on( "click", "#swbdpam__ad-type-facebook_pixel", function (){
        $( '#swbdpam__code-editor-label' ).html( sendVarible.facebook_ad_label );

        $( '#swbdpam__custom-code-row' ).show();
        $( '#swbdpam__image-ad-row, #swbdpam__terget-url-row, #swbdpam__rel-attribute-row, #swbdpam__open-link-row, #directorist-img-ad-size-row' ).hide();

        $( '#swbdpam__image-ad-image-id' ).val( '' );
        $( '#swbdpam__image-ad-image-url' ).val( '' );
    });
    /**************   END facebook pixel type ad   ****************/
    
    
    /**************   START custom code type ad   ****************/
    // When click on 'custom html/js button' for custom code ad then show the custom code type ad input field
    $( "body" ).on( "click", "#swbdpam__ad-type-custom_code", function () {
        $( '#swbdpam__code-editor-label' ).html( sendVarible.custom_code_ad_label );

        $( '#swbdpam__custom-code-row, #swbdpam__terget-url-row, #swbdpam__rel-attribute-row, #swbdpam__open-link-row' ).show();
        $( '#swbdpam__image-ad-row, #directorist-img-ad-size-row' ).hide();

        $( '#swbdpam__image-ad-image-id' ).val( '' );
        $( '#swbdpam__image-ad-image-url' ).val( '' );       
    });
    
    /**************   END custom code type ad   ****************/


 
    /**************************   START Show ad placements in a page   ************************ */
    // Defult all ad placement are hide
    // Which page checked then display that page ad placements
    if( $( '#swbdpam__page-select-all_listings' ).is( ':checked' ) ){
        $( '#swbdpam__all-listing-page-ad-places' ).show();
    }else{
        $( '#swbdpam__all-listing-page-ad-places' ).hide();
    }

    if( $( '#swbdpam__page-select-single_listing' ).is( ':checked' ) ){
        $( '#swbdpam__single-listing-page-ad-places' ).show();
    }else{ 
        $( '#swbdpam__single-listing-page-ad-places' ).hide();
    }

    if( $( '#swbdpam__page-select-all_categories' ).is( ':checked' ) ){
        $( '#swbdpam__all-cat-page-ad-places' ).show();
    }else{
        $( '#swbdpam__all-cat-page-ad-places' ).hide();
    }

    if( $( '#swbdpam__page-select-single_category' ).is( ':checked' ) ){
        $( '#swbdpam__single-category-page-ad-places' ).show();
    }else{
        $( '#swbdpam__single-category-page-ad-places' ).hide();
    }

    if( $( '#swbdpam__page-select-all_location' ).is( ':checked' ) ){
        $( '#swbdpam__all-loc-page-ad-places' ).show();
    }else{
        $( '#swbdpam__all-loc-page-ad-places' ).hide();
    }

    if( $( '#swbdpam__page-select-single_location' ).is( ':checked' ) ){
        $( '#swbdpam__single-location-page-ad-places' ).show();
    }else{
        $( '#swbdpam__single-location-page-ad-places' ).hide();
    }

    if( $( '#swbdpam__page-select-add_listing' ).is( ':checked' ) ){
        $( '#swbdpam__add-listing-page-ad-places' ).show();
    }else{
        $( '#swbdpam__add-listing-page-ad-places' ).hide();
    }

    if( $( '#swbdpam__page-select-dashboard' ).is( ':checked' ) ){
        $( '#swbdpam__dashboard-page-ad-places' ).show();
    }else{
        $( '#swbdpam__dashboard-page-ad-places' ).hide();
    }

    if( $( '#swbdpam__page-select-author_profile' ).is( ':checked' ) ){
        $( '#swbdpam__author-profile-page-ad-places' ).show();
    }else{
        $( '#swbdpam__author-profile-page-ad-places' ).hide();
    }

    if( $( '#swbdpam__page-select-search_home' ).is( ':checked' ) ){
        $( '#swbdpam__search-home-page-ad-places' ).show();
    }else{
        $( '#swbdpam__search-home-page-ad-places' ).hide();
    }

    if( $( '#swbdpam__page-select-search_result' ).is( ':checked' ) ){
        $( '#swbdpam__search-result-page-ad-places' ).show();
    }else{
        $( '#swbdpam__search-result-page-ad-places' ).hide();
    }



    // Show all listings page ad placements
    $( 'body' ).on( 'click', '#swbdpam__page-select-all_listings', function(){
        $( '#swbdpam__all-listing-page-ad-places' ).toggle();

        if( !$( '#swbdpam__page-select-all_listings' ).is( ':checked' ) ){
            $( '#swbdpam__all-lis-ad-place-before-filter' ).val( '' );
            $( '#swbdpam__all-lis-ad-place-after-filter' ).val( '' );
            $( '#swbdpam__all-lis-ad-place-as-card-in-loop' ).val( '' );
            $( '#swbdpam__all-lis-ad-place-full-row-in-loop' ).val( '' );
            $( '#swbdpam__all-lis-ad-place-before-pagination' ).val( '' );
            $( '#swbdpam__all-lis-ad-place-after-pagination' ).val( '' );
        }
    } );

    // Show single listing page ad placements
    $( 'body' ).on( 'click', '#swbdpam__page-select-single_listing', function(){
        $( '#swbdpam__single-listing-page-ad-places' ).toggle();

        if( !$( '#swbdpam__page-select-single_listing' ).is( ':checked' ) ){
            $( '#swbdpam__single-lis-ad-place-before-filter' ).val( '' );
            $( '#swbdpam__single-lis-ad-place-after-filter' ).val( '' );
            $( '#swbdpam__single-lis-ad-place-as-card-in-loop' ).val( '' );
            $( '#swbdpam__single-lis-ad-place-full-row-in-loop' ).val( '' );
            $( '#swbdpam__single-lis-ad-place-before-pagination' ).val( '' );
            $( '#swbdpam__single-lis-ad-place-after-pagination' ).val( '' );
        }
    } );

    // Show All-Categories page ad placements
    $( 'body' ).on( 'click', '#swbdpam__page-select-all_categories', function(){
        $( '#swbdpam__all-cat-page-ad-places' ).toggle();

        if( !$( '#swbdpam__page-select-all_categories' ).is( ':checked' ) ){
            $( '#swbdpam__all-cat-ad-place-before-header' ).val( '' );
            $( '#swbdpam__all-cat-ad-place-before-loop' ).val( '' );
            $( '#swbdpam__all-cat-ad-place-after-loop' ).val( '' );
            $( '#swbdpam__all-cat-ad-place-after-footer' ).val( '' );
        }
    } );

    // Show single category page ad placements
    $( 'body' ).on( 'click', '#swbdpam__page-select-single_category', function(){
        $( '#swbdpam__single-category-page-ad-places' ).toggle();

        if( !$( '#swbdpam__page-select-single_category' ).is( ':checked' ) ){
            $( '#swbdpam__single-cat-ad-place-before-filter' ).val( '' );
            $( '#swbdpam__single-cat-ad-place-after-filter' ).val( '' );
            $( '#swbdpam__single-cat-ad-place-as-card-in-loop' ).val( '' );
            $( '#swbdpam__single-cat-ad-place-full-row-in-loop' ).val( '' );
            $( '#swbdpam__single-cat-ad-place-after-loop' ).val( '' );
        }
    } );

    // Show All-locations page ad placements
    $( 'body' ).on( 'click', '#swbdpam__page-select-all_location', function(){
        $( '#swbdpam__all-loc-page-ad-places' ).toggle();

        if( !$( '#swbdpam__page-select-all_location' ).is( ':checked' ) ){
            $( '#swbdpam__all-loc-ad-place-before-header' ).val( '' );
            $( '#swbdpam__all-loc-ad-place-before-loop' ).val( '' );
            $( '#swbdpam__all-loc-ad-place-after-loop' ).val( '' );
            $( '#swbdpam__all-loc-ad-place-after-footer' ).val( '' );
        }
    } );

    // Show single location page ad placements
    $( 'body' ).on( 'click', '#swbdpam__page-select-single_location', function(){
        $( '#swbdpam__single-location-page-ad-places' ).toggle();

        if( !$( '#swbdpam__page-select-single_location' ).is( ':checked' ) ){
            $( '#swbdpam__single-loc-ad-place-before-filter' ).val( '' );
            $( '#swbdpam__single-loc-ad-place-after-filter' ).val( '' );
            $( '#swbdpam__single-loc-ad-place-as-card-in-loop' ).val( '' );
            $( '#swbdpam__single-loc-ad-place-full-row-in-loop' ).val( '' );
            $( '#swbdpam__single-loc-ad-place-after-loop' ).val( '' );
        }
    } );

    // Show add listing page ad placements
    $( 'body' ).on( 'click', '#swbdpam__page-select-add_listing', function(){
        $( '#swbdpam__add-listing-page-ad-places' ).toggle();

        if( !$( '#swbdpam__page-select-add_listing' ).is( ':checked' ) ){
            $( '#swbdpam__add-lis-ad-place-before-filter' ).val( '' );
            $( '#swbdpam__add-lis-ad-place-after-filter' ).val( '' );
            $( '#swbdpam__add-lis-ad-place-as-card-in-loop' ).val( '' );
            $( '#swbdpam__add-lis-ad-place-full-row-in-loop' ).val( '' );
            $( '#swbdpam__add-lis-ad-place-before-pagination' ).val( '' );
            $( '#swbdpam__add-lis-ad-place-after-pagination' ).val( '' );
        }
    } );

    // Show dashboard page ad placements
    $( 'body' ).on( 'click', '#swbdpam__page-select-dashboard', function(){
        $( '#swbdpam__dashboard-page-ad-places' ).toggle();

        if( !$( '#swbdpam__page-select-dashboard' ).is( ':checked' ) ){
            $( '#swbdpam__dashboard-ad-place-before-dashboard-menu' ).val( '' );
            $( '#swbdpam__dashboard-ad-place-after-dashboard-menu' ).val( '' );
            $( '#swbdpam__dashboard-ad-place-as-card-in-loop' ).val( '' );
            $( '#swbdpam__dashboard-ad-place-full-row-in-loop' ).val( '' );
            $( '#swbdpam__dashboard-ad-place-before-pagination' ).val( '' );
            $( '#swbdpam__dashboard-ad-place-after-pagination' ).val( '' );
        }
    } );

    // Show author profile page ad placements
    $( 'body' ).on( 'click', '#swbdpam__page-select-author_profile', function(){
        $( '#swbdpam__author-profile-page-ad-places' ).toggle();

        if( !$( '#swbdpam__page-select-author_profile' ).is( ':checked' ) ){
            $( '#swbdpam__auth-lis-ad-place-before-author-image' ).val( '' );
            $( '#swbdpam__auth-lis-ad-place-after-author-image' ).val( '' );
            $( '#swbdpam__auth-lis-ad-place-after-author-about' ).val( '' );
            $( '#swbdpam__auth-lis-ad-place-before-loop' ).val( '' );
            $( '#swbdpam__auth-lis-ad-place-as-card-in-loop' ).val( '' );
            $( '#swbdpam__auth-lis-ad-place-full-row-in-loop' ).val( '' );
            $( '#swbdpam__auth-lis-ad-place-before-pagination' ).val( '' );
            $( '#swbdpam__auth-lis-ad-place-after-pagination' ).val( '' );
        }
    } );

    // Show search home page ad placements
    $( 'body' ).on( 'click', '#swbdpam__page-select-search_home', function(){
        $( '#swbdpam__search-home-page-ad-places' ).toggle();

        if( !$( '#swbdpam__page-select-search_home' ).is( ':checked' ) ){
            $( '#swbdpam__search-home-ad-place-before-search-bar' ).val( '' );
            $( '#swbdpam__search-home-ad-place-after-search-bar' ).val( '' );
        }
    } );

    // Show search result page ad placements
    $( 'body' ).on( 'click', '#swbdpam__page-select-search_result', function(){
        $( '#swbdpam__search-result-page-ad-places' ).toggle();

        if( !$( '#swbdpam__page-select-search_result' ).is( ':checked' ) ){
            $( '#swbdpam__search-result-ad-place-before-filter' ).val( '' );
            $( '#swbdpam__search-result-ad-place-after-filter' ).val( '' );
            $( '#swbdpam__search-result-ad-place-as-card-in-loop' ).val( '' );
            $( '#swbdpam__search-result-ad-place-full-row-in-loop' ).val( '' );
            $( '#swbdpam__search-result-ad-place-after-loop' ).val( '' );
        }
    } );
    /***************************   END Show ad placements in a page   ***************************/


    /************************   Disable ad places which selected ago   ***************************/

    // Disable All Listing page all selected places
    $.each( sendVarible.disableAllLisPlaces, function( i, val ){
        $( "#swbdpam__all-lis-ad-place-" + val ).attr( 'disabled', true );
        $( "#swbdpam__all-lis-ad-place-" + val ).parent().addClass( 'swbdpam__selected_placement' );
    } );

    // Disable single listging page all selected places
    $.each( sendVarible.disableSingleLisPlaces, function( i, val ){
        $( "#swbdpam__single-lis-ad-place-" + val ).attr( 'disabled', true );
        $( "#swbdpam__single-lis-ad-place-" + val ).parent().addClass( 'swbdpam__selected_placement' );
    } );

    // Disable All-Categories page all selected places
    $.each( sendVarible.disableAllCatPlaces, function( i, val ){
        $( "#swbdpam__all-cat-ad-place-" + val ).attr( 'disabled', true );
        $( "#swbdpam__all-cat-ad-place-" + val ).parent().addClass( 'swbdpam__selected_placement' );
    } );

    // Disable single category page all selected places
    $.each( sendVarible.disableSingleCatPlaces, function( i, val ){
        $( "#swbdpam__single-cat-ad-place-" + val ).attr( 'disabled', true );
        $( "#swbdpam__single-cat-ad-place-" + val ).parent().addClass( 'swbdpam__selected_placement' );
    } );

    // Disable All loctions page all selected places
    $.each( sendVarible.disableAllLocPlaces, function( i, val ){
        $( "#swbdpam__all-loc-ad-place-" + val ).attr( 'disabled', true );
        $( "#swbdpam__all-loc-ad-place-" + val ).parent().addClass( 'swbdpam__selected_placement' );
    } );

    // Disable single loction page all selected places
    $.each( sendVarible.disableSingleLocPlaces, function( i, val ){
        $( "#swbdpam__single-loc-ad-place-" + val ).attr( 'disabled', true );
        $( "#swbdpam__single-loc-ad-place-" + val ).parent().addClass( 'swbdpam__selected_placement' );
    } );

    // Disable add listing page all selected places
    $.each( sendVarible.disableAddLisPlaces, function( i, val ){
        $( "#swbdpam__add-lis-ad-place-" + val ).attr( 'disabled', true );
        $( "#swbdpam__add-lis-ad-place-" + val ).parent().addClass( 'swbdpam__selected_placement' );
    } );

    // Disable user dashboard page all selected places
    $.each( sendVarible.disableDashboardPlaces, function( i, val ){
        $( "#swbdpam__dashboard-ad-place-" + val ).attr( 'disabled', true );
        $( "#swbdpam__dashboard-ad-place-" + val ).parent().addClass( 'swbdpam__selected_placement' );
    } );

    // Disable Author listings all selected places
    $.each( sendVarible.disableAuthLisPlaces, function( i, val ){
        $( "#swbdpam__auth-lis-ad-place-" + val ).attr( 'disabled', true );
        $( "#swbdpam__auth-lis-ad-place-" + val ).parent().addClass( 'swbdpam__selected_placement' );
    } );

    // Disable Search Home page all selected places
    $.each( sendVarible.disableSearchHomePlaces, function( i, val ){
        $( "#swbdpam__search-home-ad-place-" + val ).attr( 'disabled', true );
        $( "#swbdpam__search-home-ad-place-" + val ).parent().addClass( 'swbdpam__selected_placement' );
    } );

    // Disable Search Result page all selected places
    $.each( sendVarible.disableSearchResultPlaces, function( i, val ){
        $( "#swbdpam__search-result-ad-place-" + val ).attr( 'disabled', true );
        $( "#swbdpam__search-result-ad-place-" + val ).parent().addClass( 'swbdpam__selected_placement' );
    } );

    /*************************   END Disable ad places which selected ago  ***********************/


    /*************************   START Enable ad places which selected ago  **********************/
    // Enable current post's selected ad places
    $.each( sendVarible.enableAllLisPlaces, function( i, val ){
        $( "#swbdpam__all-lis-ad-place-" + val ).attr( 'disabled', false );
        $( "#swbdpam__all-lis-ad-place-" + val ).parent().removeClass( 'swbdpam__selected_placement' );
    } );

    $.each( sendVarible.enableSingleLisPlaces, function( i, val ){
        $( "#swbdpam__single-lis-ad-place-" + val ).attr( 'disabled', false );
        $( "#swbdpam__single-lis-ad-place-" + val ).parent().removeClass( 'swbdpam__selected_placement' );
    } );

    $.each( sendVarible.enableAllCatPlaces, function( i, val ){
        $( "#swbdpam__all-cat-ad-place-" + val ).attr( 'disabled', false );
        $( "#swbdpam__all-cat-ad-place-" + val ).parent().removeClass( 'swbdpam__selected_placement' );
    } );

    $.each( sendVarible.enableSingleCatPlaces, function( i, val ){
        $( "#swbdpam__single-cat-ad-place-" + val ).attr( 'disabled', false );
        $( "#swbdpam__single-cat-ad-place-" + val ).parent().removeClass( 'swbdpam__selected_placement' );
    } );

    $.each( sendVarible.enableAllLocPlaces, function( i, val ){
        $( "#swbdpam__all-loc-ad-place-" + val ).attr( 'disabled', false );
        $( "#swbdpam__all-loc-ad-place-" + val ).parent().removeClass( 'swbdpam__selected_placement' );
    } );

    $.each( sendVarible.enableSingleLocPlaces, function( i, val ){
        $( "#swbdpam__single-loc-ad-place-" + val ).attr( 'disabled', false );
        $( "#swbdpam__single-loc-ad-place-" + val ).parent().removeClass( 'swbdpam__selected_placement' );
    } );

    $.each( sendVarible.enableAddLisPlaces, function( i, val ){
        $( "#swbdpam__add-lis-ad-place-" + val ).attr( 'disabled', false );
        $( "#swbdpam__add-lis-ad-place-" + val ).parent().removeClass( 'swbdpam__selected_placement' );
    } );

    $.each( sendVarible.enableDashboardPlaces, function( i, val ){
        $( "#swbdpam__dashboard-ad-place-" + val ).attr( 'disabled', false );
        $( "#swbdpam__dashboard-ad-place-" + val ).parent().removeClass( 'swbdpam__selected_placement' );
    } );

    $.each( sendVarible.enableAuthLisPlaces, function( i, val ){
        $( "#swbdpam__auth-lis-ad-place-" + val ).attr( 'disabled', false );
        $( "#swbdpam__auth-lis-ad-place-" + val ).parent().removeClass( 'swbdpam__selected_placement' );
    } );

    $.each( sendVarible.enableSearchHomePlaces, function( i, val ){
        $( "#swbdpam__search-home-ad-place-" + val ).attr( 'disabled', false );
        $( "#swbdpam__search-home-ad-place-" + val ).parent().removeClass( 'swbdpam__selected_placement' );
    } );

    $.each( sendVarible.enableSearchResultPlaces, function( i, val ){
        $( "#swbdpam__search-result-ad-place-" + val ).attr( 'disabled', false );
        $( "#swbdpam__search-result-ad-place-" + val ).parent().removeClass( 'swbdpam__selected_placement' );
    } );

    /*******************   END enable ad places which selected ago  ********************/


    /**************   START show and hide the Ad layout options depend on Ad placements  ****************/
    // Default all these Ad layout or width, height, ad's repeat etc options row are hide
    $( "#swbdpam__bhaf-ad-size-row, #swbdpam__card-ad-show-after-row, #swbdpam__card-ad-repeat-row, #swbdpam__card-ad-size-row, #swbdpam__row-ad-show-after-row, #swbdpam__row-ad-repeat-row, #swbdpam__row-ad-size-row" ).hide();

    // Before header and after footer Ad placements ID
    var headerFooterPlacements = [        
        '#swbdpam__all-lis-ad-place-before-header',
        '#swbdpam__single-cat-ad-place-before-header',
        '#swbdpam__single-lis-ad-place-before-header',
        '#swbdpam__single-loc-ad-place-before-header',
        '#swbdpam__add-lis-ad-place-before-header',
        '#swbdpam__dashboard-ad-place-before-header',
        '#swbdpam__auth-lis-ad-place-before-header',
        '#swbdpam__search-home-ad-place-before-header',
        '#swbdpam__search-result-ad-place-before-header',
        '#swbdpam__all-lis-ad-place-after-footer',
        '#swbdpam__single-cat-ad-place-after-footer',
        '#swbdpam__single-lis-ad-place-after-footer',
        '#swbdpam__single-loc-ad-place-after-footer',
        '#swbdpam__add-lis-ad-place-after-footer',
        '#swbdpam__dashboard-ad-place-after-footer',
        '#swbdpam__auth-lis-ad-place-after-footer',
        '#swbdpam__search-home-ad-place-after-footer',
        '#swbdpam__search-result-ad-place-after-footer',
    ];

    // This trigger when click on the before header and after footer Ad placements
    $.each( headerFooterPlacements, function( i, val ){
        $( "body" ).on( "click", val, function(){
            // This variable or ID is, which options row we wanna show and hide that's rows ID
            var optionsRow = '#swbdpam__bhaf-ad-size-row';

            // For show Ad layout options row
            ShowLayoutOptions( val, optionsRow );

            // For hide Ad layout options row
            hideLayoutOptions( headerFooterPlacements, val, optionsRow );        
        });
    } );

    // This trigger after save the before header and after footer Ad placements
    $.each( headerFooterPlacements, function( i, val ){   
        // This variable or ID is, which options row we wanna show and hide that's rows ID
        var optionsRow = '#swbdpam__bhaf-ad-size-row';

        // For show Ad layout options row
        ShowLayoutOptions( val, optionsRow );
        
        // For hide Ad layout options row
        hideLayoutOptions( headerFooterPlacements, val, optionsRow );        
    } );
    

    // As card in loop Ad placements ID
    var asCardInLoopPlacements = [
        '#swbdpam__all-lis-ad-place-as-card-in-loop',
        '#swbdpam__single-cat-ad-place-as-card-in-loop',
        '#swbdpam__single-loc-ad-place-as-card-in-loop',
        '#swbdpam__dashboard-ad-place-as-card-in-loop',
        '#swbdpam__auth-lis-ad-place-as-card-in-loop',
        '#swbdpam__search-result-ad-place-as-card-in-loop',
    ];

    // This trigger when click on the as card in loop Ad placements
    $.each( asCardInLoopPlacements, function( i, val ){
        $( "body" ).on( "click", val, function(){
            // This variable or ID is, which options row we wanna show and hide that's rows ID
            var optionsRow = "#swbdpam__card-ad-show-after-row, #swbdpam__card-ad-repeat-row, #swbdpam__card-ad-size-row";

            // For show Ad layout options row
            ShowLayoutOptions( val, optionsRow );
        
            // For hide Ad layout options row
            hideLayoutOptions( asCardInLoopPlacements, val, optionsRow );  
        } );
    } );

    // This trigger after save the as card in loop Ad placements
    $.each( asCardInLoopPlacements, function( i, val ){        
        // This variable or ID is, which options row we wanna show and hide that's rows ID
        var optionsRow = "#swbdpam__card-ad-show-after-row, #swbdpam__card-ad-repeat-row, #swbdpam__card-ad-size-row";

        // For show Ad layout options row
        ShowLayoutOptions( val, optionsRow );
    
        // For hide Ad layout options row
        hideLayoutOptions( asCardInLoopPlacements, val, optionsRow );  
    } );

    // Full row Ad placements ID
    var fullRowPlacements = [        
        '#swbdpam__all-lis-ad-place-before-filter',
        '#swbdpam__all-lis-ad-place-after-filter',
        '#swbdpam__all-lis-ad-place-before-pagination',
        '#swbdpam__all-lis-ad-place-after-pagination',
        '#swbdpam__single-lis-ad-place-after-title',
        '#swbdpam__single-lis-ad-place-after-related-listing',
        '#swbdpam__single-cat-ad-place-before-filter',        
        '#swbdpam__single-cat-ad-place-after-filter',        
        '#swbdpam__single-cat-ad-place-after-loop',
        '#swbdpam__single-loc-ad-place-before-filter',
        '#swbdpam__single-loc-ad-place-after-filter',
        '#swbdpam__single-loc-ad-place-after-loop',
        '#swbdpam__add-lis-ad-place-before-add-new-title',
        '#swbdpam__add-lis-ad-place-after-add-new-title',
        '#swbdpam__dashboard-ad-place-before-dashboard-menu',
        '#swbdpam__dashboard-ad-place-before-loop',
        '#swbdpam__dashboard-ad-place-before-pagination',
        '#swbdpam__auth-lis-ad-place-before-author-image',
        '#swbdpam__auth-lis-ad-place-after-author-image',
        '#swbdpam__auth-lis-ad-place-after-author-about',
        '#swbdpam__auth-lis-ad-place-before-loop',
        '#swbdpam__auth-lis-ad-place-before-pagination',
        '#swbdpam__search-home-ad-place-before-search-bar',
        '#swbdpam__search-home-ad-place-after-search-bar',
        '#swbdpam__search-result-ad-place-before-filter',
        '#swbdpam__search-result-ad-place-after-filter',
        '#swbdpam__search-result-ad-place-after-loop',
    ];

    // Full row in loop Ad placements ID
    var fullRowInLoopPlacements = [
        '#swbdpam__all-lis-ad-place-full-row-in-loop',
        '#swbdpam__single-cat-ad-place-full-row-in-loop',
        '#swbdpam__single-loc-ad-place-full-row-in-loop',
        '#swbdpam__dashboard-ad-place-full-row-in-loop',
        '#swbdpam__auth-lis-ad-place-full-row-in-loop',
        '#swbdpam__search-result-ad-place-full-row-in-loop',
    ];

    // This trigger when click on the full row in loop Ad placements
    $.each( fullRowInLoopPlacements, function( i, val ){
        $( "body" ).on( "click", val, function(){
            // For show Ad layout options
            if( $( val ).is( ':checked' ) ){
                var fullRowInLoopPlaces = [];
                var getFullRowInLoopPlaces = $( val ).attr( 'id' );    
                fullRowInLoopPlaces.push( getFullRowInLoopPlaces );
                if( 1 <= fullRowInLoopPlaces.length ){
                    $( "#swbdpam__row-ad-show-after-row, #swbdpam__row-ad-repeat-row, #swbdpam__row-ad-size-row" ).show();   
                }
            }
        
            // For hide Ad layout options
            if( !$( val ).is( ':checked' ) ){
                let checked = true;
                let checkedSize = true;
                for( let i = 0 ; i <= fullRowInLoopPlacements.length; i++ ){
                    if( $( fullRowInLoopPlacements[i] ).is( ':checked' ) ){
                        checked = true;
                        break;
                    }else{
                        checked = false;
                    }
                }

                for( let i = 0 ; i <= fullRowPlacements.length; i++ ){
                    if( $( fullRowPlacements[i] ).is( ':checked' ) ){
                        checkedSize = true;
                        break;
                    }else{
                        checkedSize = false;
                    }
                }

                if( checked === true ){
                    $( "#swbdpam__row-ad-show-after-row, #swbdpam__row-ad-repeat-row" ).show(); 
                }else{
                    $( "#swbdpam__row-ad-show-after-row, #swbdpam__row-ad-repeat-row" ).hide();  
                }

                if( checkedSize === true ){
                    $( "#swbdpam__row-ad-size-row" ).show();
                }else{
                    $( "#swbdpam__row-ad-size-row" ).hide();
                }
            }    
        } );
    } );   

    // This trigger after save the full row in loop Ad placements
    $.each( fullRowInLoopPlacements, function( i, val ){
        // For show Ad layout options
        if( $( val ).is( ':checked' ) ){
            var fullRowInLoopPlaces = [];
            var getFullRowInLoopPlaces = $( val ).attr( 'id' );    
            fullRowInLoopPlaces.push( getFullRowInLoopPlaces );
            if( 1 <= fullRowInLoopPlaces.length ){
                $( "#swbdpam__row-ad-show-after-row, #swbdpam__row-ad-repeat-row, #swbdpam__row-ad-size-row" ).show();   
            }
        }
    
        // For hide Ad layout options
        if( !$( val ).is( ':checked' ) ){
            let checked = true;
            let checkedSize = true;
            for( let i = 0 ; i <= fullRowInLoopPlacements.length; i++ ){
                if( $( fullRowInLoopPlacements[i] ).is( ':checked' ) ){
                    checked = true;
                    break;
                }else{
                    checked = false;
                }
            }

            for( let i = 0 ; i <= fullRowPlacements.length; i++ ){
                if( $( fullRowPlacements[i] ).is( ':checked' ) ){
                    checkedSize = true;
                    break;
                }else{
                    checkedSize = false;
                }
            }

            if( checked === true ){
                $( "#swbdpam__row-ad-show-after-row, #swbdpam__row-ad-repeat-row" ).show(); 
            }else{
                $( "#swbdpam__row-ad-show-after-row, #swbdpam__row-ad-repeat-row" ).hide();  
            }

            if( checkedSize === true ){
                $( "#swbdpam__row-ad-size-row" ).show();
            }else{
                $( "#swbdpam__row-ad-size-row" ).hide();
            }
        }    
    } );   


    // This trigger when click on the full row Ad placements
    $.each( fullRowPlacements, function( i, val ){
        $( "body" ).on( "click", val, function(){
            // This variable or ID is, which options row we wanna show and hide that's rows ID
            var optionsRow = "#swbdpam__row-ad-size-row";

            // For show Ad layout options
            ShowLayoutOptions( val, optionsRow );

            // For hide Ad layout options
            if( !$( val ).is( ':checked' ) ){
                let checked = true;
                for( let i = 0 ; i <= fullRowPlacements.length; i++ ){
                    if( ( $( fullRowPlacements[i] ).is( ':checked' ) ) || ( $( fullRowInLoopPlacements[i] ).is( ':checked' ) ) ){
                        checked = true;
                        break;
                    }else{
                        checked = false;
                    }
                }

                if( checked === true ){
                    $( optionsRow ).show(); 
                }else{
                    $( optionsRow ).hide();  
                }
            }    
        } );
    } );


    // This trigger after save the full row Ad placements
    $.each( fullRowPlacements, function( i, val ){
        var optionsRow = "#swbdpam__row-ad-size-row";

        // For show Ad layout options
        ShowLayoutOptions( val, optionsRow );

        // For hide Ad layout options
        if( !$( val ).is( ':checked' ) ){
            let checked = true;
            for( let i = 0 ; i <= fullRowPlacements.length; i++ ){
                if( ( $( fullRowPlacements[i] ).is( ':checked' ) ) || ( $( fullRowInLoopPlacements[i] ).is( ':checked' ) ) ){
                    checked = true;
                    break;
                }else{
                    checked = false;
                }
            }

            if( checked === true ){
                $( optionsRow ).show(); 
            }else{
                $( optionsRow ).hide();  
            }
        }    
    } );


    
    /**
     * This function show the Ad layout options row like width, height, ad's repeat etc when check the option Ad placement
     * 
     * @param place is placement ID and optionsRow is option row's ID
     * 
     * @return void
     */
    function ShowLayoutOptions( place, optionsRow ){
        if( $( place ).is( ':checked' ) ){
            var places = [];
            var getPlacesId = $( place ).attr( 'id' );
            places.push( getPlacesId );

            if( 1 <= places.length ){
                $( optionsRow ).show(); 
            }
        }
    }


    /**
     * This function hide the Ad layout options row like width, height, ad's repeat etc when check the option Ad placement
     * 
     * @param placementsArray is array, place is placement ID and optionsRow is option row's ID
     * 
     * @return void
     */
    function hideLayoutOptions( placementsArray, place, optionsRow ){
        if( !$( place ).is( ':checked' ) ){
            let checked = true;
            for( let i = 0 ; i <= placementsArray.length; i++ ){
                if( $( placementsArray[i] ).is( ':checked' ) ){
                    checked = true;
                    break;
                }else{
                    checked = false;
                }
            }

            if( checked === true ){
                $( optionsRow ).show(); 
            }else{
                $( optionsRow ).hide();  
            }
        }    
    }

    /************** END show and hide the Ad layout options depend on Ad placements **************/
 


    /****************************   START ad expiry code  ********************************/
/** Roq Comment  **/
    // When checked 'Mark As Forever' other ad expiry in days & in hours be empty
    $( "body" ).on( "click", "#swbdpam__ad-mark-as-forever", function () {
        if( $( '#swbdpam__ad-mark-as-forever' ).is( ':checked' ) ){
            $( '#swbdpam__ad-expire-day' ).val( '' );
            $( '#swbdpam__ad-expire-hour' ).val( '' );
        }
    });

    // If don't check Ad expire by Day or Hour then auto select Mark as Forever
    var AdExpireHoure   = $( '#swbdpam__ad-expire-hour' ).val();
    var AdExpireDay     = $( '#swbdpam__ad-expire-day' ).val();

    if(AdExpireHoure && AdExpireDay){
        if( ( AdExpireHoure.length === 0 ) && ( AdExpireDay.length === 0) ){
            $( '#swbdpam__ad-mark-as-forever' ).prop( "checked", true );
        }
    }
    /**************************   END ad expiry code  ****************************/

 
    /**********************   START Contact for ad image uploader   ********************/
    // Defult contact for ad image uploder is hide
    if( $( '#swbdpam__contact-image-show' ).is( ':checked' ) ){
        $( '#swbdpam__contact-image-raw' ).show();
    }else{
        $( '#swbdpam__contact-image-raw' ).hide();
    }

    // When click on 'Show Contact For Ad Image' then show the contact for ad image uploader
    $( "body" ).on( "click", "#swbdpam__contact-image-show", function () {
        $( '#swbdpam__contact-image-raw' ).show();
    });

    // When click on 'Leave ad place' then hide contact for ad image uploader
    $( "body" ).on( "click", "#swbdpam__leave-place", function () {
        $( '#swbdpam__contact-image-raw' ).hide();
        $( '#swbdpam__contact-image-id' ).val( '' );
        $( '#swbdpam__contact-image-url' ).val( '' );
    });
    /************************   END Contact for ad image uploader   ************************/

});



