<?php
/**
 * @package  Directorist - Ads Manager
 */


if( ! class_exists( 'SWBDPAMAdminCallbacks' ) ){
    /**
     * Ads Manager custom post type handler class
     */
    class SWBDPAMAdminCallbacks
    {
        /**
         * SWBDPAM_POST_TYPE CPT's select Ad type CMB's callback
         *
         * @param Current post
         *
         * @return void
         */
        public static function cmb_ads_manager_ad_types_callback( $post )
        {
            $ad_types  = array(
                'image'             => __( 'Image', 'directorist-adverts-manager' ),
                'google_adsense'    => __( 'Google Adsense', 'directorist-adverts-manager' ),
                'facebook_pixel'    => __( 'Facebook Pixel', 'directorist-adverts-manager' ),
                'custom_code'       => __( 'Custom HTML/JS', 'directorist-adverts-manager' ),
            );

            $rel_attr_opts      = array( 
                'sponsored' => __( 'Sponsored', 'directorist-adverts-manager' ),
                'ugc'       => __( 'Ugc', 'directorist-adverts-manager' ),
                'dofollow'  => __( 'Do Follow', 'directorist-adverts-manager' ),
                'nofollow'  => __( 'No Follow', 'directorist-adverts-manager' )  
            );
 
            $ad_types_description = array(
                'image'             => __( 'Something about Image type ad.', 'directorist-adverts-manager' ),
                'google_adsense'    => __( 'Something about Google Adsense type ad.', 'directorist-adverts-manager' ),
                'facebook_pixel'    => __( 'Something about Facebook Pixel type ad.', 'directorist-adverts-manager' ),
                'custom_code'       => __( 'Something about Custom HTML/JS type ad.', 'directorist-adverts-manager' ),
            );

            $l_img              = __( 'Upload Ad Image', 'directorist-adverts-manager' );
            $l_img_up_btn       = __( 'Upload Ad Image', 'directorist-adverts-manager' );
            $l_url              = __( 'Target URL', 'directorist-adverts-manager' );
            $l_url_placeholder  = __( 'Enter URL', 'directorist-adverts-manager' );
            $l_rel_attr         = __( 'rel Attribute', 'directorist-adverts-manager' );
            $l_open_link        = __( 'Open Link', 'directorist-adverts-manager' );
            $l_new_tab          = __( 'In New Tab', 'directorist-adverts-manager' );
            $l_same_tab         = __( 'Same Tab', 'directorist-adverts-manager' );
            $l_input_suggestion = __( "Add code snippets using script and style tags such as <code>&lt;script&gt;</code>", 'directorist-adverts-manager' );

            $saved_ad_type = get_post_meta( $post->ID, 'swbdpam_ad_type', true );
            $saved_ad_type = ! empty( $saved_ad_type ) ? $saved_ad_type : 'custom_code';

            $saved_image_ad_image_id    = get_post_meta( $post->ID, 'swbdpam_image_ad_image_id', true );
            $saved_image_ad_image_url   = get_post_meta( $post->ID, 'swbdpam_image_ad_image_url', true );
            $saved_custom_ad            = get_post_meta( $post->ID, 'swbdpam_custom_code_ad', true );    

            $saved_terget_url   = get_post_meta( $post->ID, 'swbdpam_ad_terget_url', true );
            $saved_rel_attr     = get_post_meta( $post->ID, 'swbdpam_rel_attr', true );

            $saved_open_link    = get_post_meta( $post->ID, 'swbdpam_open_link', true );
            $checked_new_tab    = ( 'new_tab' == $saved_open_link ) ? "checked = 'checked'" : '';
            $checked_same_tab   = ( 'same_tab' == $saved_open_link ) ? "checked = 'checked'" : '';
            

            wp_nonce_field( 'swbdpam_ad_types_cmb_action', 'swbdpam_ad_types_cmb_field' );
            ?>
            <div class="atdam-ad-types-list">
            <?php
            $icon = '';
            foreach( $ad_types as $key => $ad_type ){
                if( 'image' === $key ) {
                    $icon = 'far fa-images';
                }
                if( 'google_adsense' === $key ) {
                    $icon = 'fab fa-google';
                }
                if( 'facebook_pixel' === $key ) {
                    $icon = 'fab fa-facebook-f';
                }
                if( 'custom_code' === $key ) {
                    $icon = 'fas fa-code';
                }
                $ad_type = ucwords( $ad_type );
                $checked_ad_type = ( $key == $saved_ad_type ) ? "checked = 'checked'" : '';
                ?>
                <!-- START Ad type select input field -->
                <div class="swbdpam-ad-type-wrapper">
                    <label for='swbdpam__ad-type-<?php echo $key; ?>'>
                        <input type='radio' name='swbdpam_ad_type' id='swbdpam__ad-type-<?php echo $key; ?>' value='<?php echo $key; ?>' <?php echo $checked_ad_type; ?>>
                        <span class="swbdpam-custom-radio"></span>
                        <div class="swbdpam-ad-desc-box">
                            <i class="<?php echo $icon ?>" style="font-size: 22px;"></i>
                            <span><?php echo $ad_type; ?></span>
                        </div>
                    </label>
                    <!-- <p id=""><?php echo $ad_types_description[$key]; ?></p> -->
                </div>
                <!-- START Ad type select input field -->
                <?php
            }
            ?>
                <div class="swbdpam-ad-type-content-wrapper" id='swbdpam__custom-code-row'>
                    <div class="swbdpam-ad-type-image swbdpam-ad-code-google">
                        <div class="swbdpam-form-group">
                            <div class="swbdpam-form-group__label">
                                <label id="swbdpam__code-editor-label"></label>
                            </div>
                            <div class="swbdpam-form-group__elm w-100">
                                <p class="description"><?php echo $l_input_suggestion; ?></p>
                                <textarea id="swbdpam__custom-code" rows="5" name="swbdpam_custom_code_ad" class="widefat textarea"><?php echo $saved_custom_ad; ?></textarea>
                            </div>
                        </div><!-- ends: .swbdpam-form-group -->
                    </div><!-- ends: .swbdpam-ad-type-image -->
                </div><!-- ends: .swbdpam-ad-type-content-wrapper -->

                <div class="swbdpam-ad-type-content-wrapper">
                    <div class="swbdpam-ad-type-image">

                        <div class="swbdpam-form-group" id='swbdpam__image-ad-row'>
                            <div class="swbdpam-form-group__label">
                                <span><?php echo $l_img; ?></span>
                            </div>
                            <div class="swbdpam-form-group__elm">
                                <button class='button swbdpam-upload-img-btn' id='swbdpam__image-ad-image-uploader'>
                                    <img src="<?php echo SWBDPAM_ADMIN_IMAGE_URL .'image-upload.png'; ?>"><?php echo $l_img_up_btn; ?>
                                </button>
                                <input type='hidden' name='swbdpam_image_ad_image_id' id='swbdpam__image-ad-image-id' value='<?php echo $saved_image_ad_image_id; ?>'>
                                <input type='hidden' name='swbdpam_image_ad_image_url' id='swbdpam__image-ad-image-url' value='<?php echo $saved_image_ad_image_url; ?>'>
                                <div class="swbdpam__up_img_container" id='swbdpam__image-ad-image-container'></div>
                            </div>
                        </div><!-- ends: .swbdpam-form-group -->

                        <div class="swbdpam-form-group" id="swbdpam__terget-url-row">
                            <div class="swbdpam-form-group__label">
                                <label><?php echo $l_url; ?></label>
                            </div>
                            <div class="swbdpam-form-group__elm">
                                <input type="url" id='swbdpam__ad-terget-url' name='swbdpam_ad_terget_url' placeholder="<?php echo $l_url_placeholder; ?>" value='<?php echo $saved_terget_url; ?>'>
                            </div>
                        </div><!-- ends: .swbdpam-form-group -->

                        <div class="swbdpam-form-group" id="swbdpam__rel-attribute-row">
                            <div class="swbdpam-form-group__label">
                                <label><?php echo $l_rel_attr; ?></label>
                            </div>
                            <div class="swbdpam-form-group__elm">
                                <?php 
                                $dropdown_rel_attr = '<option value="0">'.__( 'Select a Attribute', 'directorist-adverts-manager' ).'</option>';
                                foreach( $rel_attr_opts as $attr_opt_key => $rel_attr_opt ){
                                    $selected_rel_attr = '';
                                    if( $attr_opt_key == $saved_rel_attr ){
                                    	$selected_rel_attr = "selected";
                                    }
                                    $dropdown_rel_attr .= sprintf( "<option %s value='%s'>%s</option>", $selected_rel_attr, $attr_opt_key, $rel_attr_opt );
                                }
                                ?>
                                <select name="swbdpam_rel_attr"><?php echo $dropdown_rel_attr; ?></select>
                            </div>
                        </div><!-- ends: .swbdpam-form-group -->

                        <div class="swbdpam-form-group" id="swbdpam__open-link-row">
                            <div class="swbdpam-form-group__label">
                                <label><?php echo $l_open_link; ?></label>
                            </div>
                            <div class="swbdpam-form-group__elm">
                                <div class="radio-group">
                                    <div class="radio-elm swbdpam-custom-radio-cont">
                                        <input type="radio" name='swbdpam_open_link' id='swbdpam__open-link-new-tab' value='new_tab' <?php echo $checked_new_tab; ?>>
                                        <label for="swbdpam__open-link-new-tab"><span class="swbdpam-custom-radio"></span><?php echo $l_new_tab; ?></label>
                                    </div>
                                    <div class="radio-elm swbdpam-custom-radio-cont">
                                        <input type="radio" name="swbdpam_open_link" id="swbdpam_open-link-same-tab" value='same_tab' <?php echo $checked_same_tab; ?>>
                                        <label for="swbdpam_open-link-same-tab"><span class="swbdpam-custom-radio"></span><?php echo $l_same_tab; ?></label>
                                    </div>
                                </div>
                            </div>  
                        </div><!-- ends: .swbdpam-form-group -->

                    </div><!-- ends: .swbdpam-ad-type-image -->
                </div><!-- ends: .swbdpam-ad-type-content-wrapper -->
            </div>
            <?php
        }



        /**
         * SWBDPAM_POST_TYPE CPT's select page & placement CMB's callback
         *
         * @param Current post
         *
         * @return void
         */
        public function cmb_ads_manager_select_pages_and_placement_callback( $post )
        {
            $l_select_pages     = __( 'Select Pages', 'directorist-adverts-manager' );
            $l_all_listing      = __( 'All Listing Ad Placements', 'directorist-adverts-manager' );
            $l_single_listing   = __( 'Single Listing Ad Placements', 'directorist-adverts-manager' );
            $l_all_cat          = __( 'All Category Page Ad Placements', 'directorist-adverts-manager' );
            $l_single_category  = __( 'Single Category Page Ad Placements', 'directorist-adverts-manager' );
            $l_all_loc          = __( 'All Location Page Ad Placements', 'directorist-adverts-manager' );
            $l_single_location  = __( 'Single Location Page Ad Placements', 'directorist-adverts-manager' );
            $l_add_listing      = __( 'Add Listing Page Ad Placements', 'directorist-adverts-manager' );
            $l_dashboard        = __( 'Dashboard Ad Placements', 'directorist-adverts-manager' );
            $l_author_profile   = __( 'Author Profile Ad Placements', 'directorist-adverts-manager' );
            $l_search_home      = __( 'Search Home Page Ad Placements', 'directorist-adverts-manager' );
            $l_search_result    = __( 'Search Result Page Ad Placements', 'directorist-adverts-manager' );

            $l_card_ad_show_after   = __( 'As Card Ad Show After Number of Listings', 'directorist-adverts-manager' );
            $l_row_ad_show_after    = __( 'Display Full Row Ad After Row Number', 'directorist-adverts-manager' );
            $l_card_ad_repeat       = __( 'Is Card Ad Repeat', 'directorist-adverts-manager' );
            $l_row_ad_repeat        = __( 'Repeat Full Row Ad', 'directorist-adverts-manager' );
            $l_yes                  = __( 'Yes', 'directorist-adverts-manager' );
            $l_no                   = __( 'No', 'directorist-adverts-manager' );
            $l_bhaf_ad_size         = __( 'Before Header - After Footer Ad Size', 'directorist-adverts-manager' );
            $l_card_ad_size         = __( 'As Card Ad Size', 'directorist-adverts-manager' );
            $l_row_ad_size          = __( 'Full Row Ad Size', 'directorist-adverts-manager' );
            $l_width                = __( 'Width', 'directorist-adverts-manager' );
            $l_height               = __( 'Height', 'directorist-adverts-manager' );
            $l_px                   = __( 'px', 'directorist-adverts-manager' );

            $ad_display_pages           = SWBDPAMHelperFunctions::ad_display_pages();
            $all_lis_ad_places          = SWBDPAMHelperFunctions::all_lis_ad_places();
            $single_lis_ad_places       = SWBDPAMHelperFunctions::single_lis_ad_places();
            $all_cat_ad_places          = SWBDPAMHelperFunctions::all_cat_ad_places();
            $single_cat_ad_places       = SWBDPAMHelperFunctions::single_cat_ad_places();
            $all_loc_ad_places          = SWBDPAMHelperFunctions::all_loc_ad_places();
            $single_loc_ad_places       = SWBDPAMHelperFunctions::single_loc_ad_places();
            $add_lis_ad_places          = SWBDPAMHelperFunctions::add_lis_ad_places();
            $dashboard_ad_places        = SWBDPAMHelperFunctions::dashboard_ad_places();
            $auth_lis_ad_places         = SWBDPAMHelperFunctions::auth_lis_ad_places();
            $search_home_ad_places      = SWBDPAMHelperFunctions::search_home_ad_places();
            $search_result_ad_places    = SWBDPAMHelperFunctions::search_result_ad_places();

            $saved_pages                = get_post_meta( $post->ID, 'swbdpam_pages_select', true );
            $saved_all_lis_plc          = get_post_meta( $post->ID, 'swbdpam_all_listings_ad_places', true );
            $saved_single_lis_plc       = get_post_meta( $post->ID, 'swbdpam_single_listing_ad_places', true );
            $saved_all_cat_plc          = get_post_meta( $post->ID, 'swbdpam_all_cat_ad_places', true );
            $saved_single_cat_plc       = get_post_meta( $post->ID, 'swbdpam_single_category_ad_places', true );
            $saved_all_loc_plc          = get_post_meta( $post->ID, 'swbdpam_all_loc_ad_places', true );
            $saved_single_loc_plc       = get_post_meta( $post->ID, 'swbdpam_single_location_ad_places', true );
            $saved_add_lis_plc          = get_post_meta( $post->ID, 'swbdpam_add_listing_ad_places', true );
            $saved_dashboard_plc        = get_post_meta( $post->ID, 'swbdpam_dashboard_ad_places', true );
            $saved_auth_lis_plc         = get_post_meta( $post->ID, 'swbdpam_author_listings_ad_places', true );
            $saved_search_home_plc      = get_post_meta( $post->ID, 'swbdpam_search_home_ad_places', true );
            $saved_search_result_plc    = get_post_meta( $post->ID, 'swbdpam_search_result_ad_places', true );

            $saved_bhaf_ad_width        = get_post_meta( $post->ID, 'swbdpam_bhaf_ad_width', true );
            $saved_bhaf_ad_height       = get_post_meta( $post->ID, 'swbdpam_bhaf_ad_height', true );

            $saved_card_ad_show_after   = get_post_meta( $post->ID, 'swbdpam_card_ad_show_after_lis', true );
            $saved_card_ad_repeat       = get_post_meta( $post->ID, 'swbdpam_card_ad_repeat', true );
            $checked_card_ad_repeat     = ( 'yes' == $saved_card_ad_repeat ) ? "checked = 'checked'" : '';
            $checked_card_ad_not_repeat = ( 'no' == $saved_card_ad_repeat ) ? "checked = 'checked'" : '';
            $saved_card_ad_width        = get_post_meta( $post->ID, 'swbdpam_card_ad_width', true );
            $saved_card_ad_height       = get_post_meta( $post->ID, 'swbdpam_card_ad_height', true );

            $saved_row_ad_show_after    = get_post_meta( $post->ID, 'swbdpam_row_ad_show_after_row', true );
            $saved_row_ad_repeat        = get_post_meta( $post->ID, 'swbdpam_row_ad_repeat', true );
            $checked_row_ad_repeat      = ( 'yes' == $saved_row_ad_repeat ) ? "checked = 'checked'" : '';
            $checked_row_ad_not_repeat  = ( 'no' == $saved_row_ad_repeat ) ? "checked = 'checked'" : '';
            $saved_row_ad_width         = get_post_meta( $post->ID, 'swbdpam_row_ad_width', true );
            $saved_row_ad_height        = get_post_meta( $post->ID, 'swbdpam_row_ad_height', true );

            $saved_bhaf_ad_width    = isset( $saved_bhaf_ad_width ) ? $saved_bhaf_ad_width : '';
            $saved_bhaf_ad_height   = isset( $saved_bhaf_ad_height ) ? $saved_bhaf_ad_height : '';
            $saved_card_ad_width    = isset( $saved_card_ad_width ) ? $saved_card_ad_width : '';
            $saved_card_ad_height   = isset( $saved_card_ad_height ) ? $saved_card_ad_height : '';
            $saved_row_ad_width     = isset( $saved_row_ad_width ) ? $saved_row_ad_width : '';
            $saved_row_ad_height    = isset( $saved_row_ad_height ) ? $saved_row_ad_height : '';

            $saved_bhaf_ad_width    = !empty( $saved_bhaf_ad_width ) ? $saved_bhaf_ad_width : 1000;
            $saved_bhaf_ad_height   = !empty( $saved_bhaf_ad_height ) ? $saved_bhaf_ad_height : 200;
            $saved_card_ad_width    = !empty( $saved_card_ad_width ) ? $saved_card_ad_width : 180;
            $saved_card_ad_height   = !empty( $saved_card_ad_height ) ? $saved_card_ad_height : 400;
            $saved_row_ad_width     = !empty( $saved_row_ad_width ) ? $saved_row_ad_width : 800;
            $saved_row_ad_height    = !empty( $saved_row_ad_height ) ? $saved_row_ad_height : 150;            
 
            wp_nonce_field( 'swbdpam_select_pages_cmb_action', 'swbdpam_select_pages_cmb_field' );

            ?>
            <div class="page-placement-content">
                <table class='form-table'>
                    <tbody>
                        <tr>      <!-- START Page select input field row -->
                            <th><?php echo $l_select_pages; ?></th>
                            <td>
                            <?php
                            foreach( $ad_display_pages as $key => $ad_display_page ){
                                $ad_display_page = ucwords( $ad_display_page );

                                $checked_pages = '';
                                if( is_array( $saved_pages ) ){
                                    $checked_pages = in_array( $key, $saved_pages ) ? 'checked' : '';
                                }
                                ?>
                                <div class="swbd-table-selection">
                                    <input type='checkbox' name='swbdpam_pages_select[]' id='swbdpam__page-select-<?php echo $key; ?>' value='<?php echo $key; ?>' <?php echo $checked_pages; ?>>
                                    <label for='swbdpam__page-select-<?php echo $key; ?>'><?php echo $ad_display_page; ?></label>
                                </div>
                                <?php
                            }
                            ?>
                            </td>
                        </tr>       <!-- END Page select input field row -->

                        <tr id='swbdpam__all-listing-page-ad-places'> <!-- START All-listings Page placement select input field row -->
                            <th><?php echo $l_all_listing; ?></th>
                            <td>
                                <div class="placement-wrap">
                                    <?php
                                    foreach( $all_lis_ad_places as $all_lis_ad_place ){
                                        $checked_all_lis_plc = '';
                                        if( is_array( $saved_all_lis_plc ) ){
                                            $checked_all_lis_plc = in_array( $all_lis_ad_place, $saved_all_lis_plc ) ? 'checked' : '';
                                        }

                                        $str_replace_all = str_replace( '-', ' ', $all_lis_ad_place );
                                        $l_all_placement = ucwords( $str_replace_all );
                                        ?>
                                        <div class="swbd__placement-single">
                                            <input type="checkbox" name="swbdpam_all_listings_ad_places[]" id="swbdpam__all-lis-ad-place-<?php echo $all_lis_ad_place; ?>" value="<?php echo $all_lis_ad_place; ?>" <?php echo $checked_all_lis_plc; ?>>
                                            <label for="swbdpam__all-lis-ad-place-<?php echo $all_lis_ad_place; ?>" class="swbdpam__ad-place-label">
                                                <img src="<?php echo SWBDPAM_ADMIN_IMAGE_URL .'all-lis-img/'. $all_lis_ad_place .'.png';?>" alt="">
                                            </label>
                                            <p><?php _e( $l_all_placement, 'directorist-adverts-manager' ); ?></p>
                                        </div>
                                        <?php
                                    }
                                    ?>
                                </div>
                            </td>
                        </tr>   <!-- END All-listings Page placement select input field row -->

                        <tr id='swbdpam__single-listing-page-ad-places'>  <!-- START Single Listing Page placement select input field row -->
                            <th><?php echo $l_single_listing; ?></th>
                            <td>
                                <div class="placement-wrap">
                                    <?php
                                    foreach( $single_lis_ad_places as $single_lis_ad_place ){
                                        $checked_sing_lis_plc = '';
                                        if( is_array( $saved_single_lis_plc ) ){
                                            $checked_sing_lis_plc = in_array( $single_lis_ad_place, $saved_single_lis_plc ) ? 'checked' : '';
                                        }

                                        $str_replace_single = str_replace( '-', ' ', $single_lis_ad_place );
                                        $l_single_placement = ucwords( $str_replace_single );
                                        ?>
                                        <div class="swbd__placement-single">
                                            <input type="checkbox" name="swbdpam_single_listing_ad_places[]" id="swbdpam__single-lis-ad-place-<?php echo $single_lis_ad_place; ?>" value="<?php echo $single_lis_ad_place; ?>" <?php echo $checked_sing_lis_plc; ?>>
                                            <label for="swbdpam__single-lis-ad-place-<?php echo $single_lis_ad_place; ?>" class="swbdpam__ad-place-label">
                                                <img src="<?php echo SWBDPAM_ADMIN_IMAGE_URL .'single-lis-img/'. $single_lis_ad_place .'.png';?>" alt="">
                                            </label>
                                            <p><?php _e( $l_single_placement, 'directorist-adverts-manager' ); ?></p>
                                        </div>
                                    <?php
                                    }
                                    ?>
                                </div>
                            </td>
                        </tr>   <!-- END Single Listing Page placement select input field row -->

                        <tr id='swbdpam__all-cat-page-ad-places'> <!-- START All Categories Page placement select input field row -->
                            <th><?php echo $l_all_cat; ?></th>
                            <td>
                                <div class="placement-wrap">
                                    <?php
                                    foreach( $all_cat_ad_places as $all_cat_ad_place ){
                                        $checked_all_cat_plc = '';
                                        if( is_array( $saved_all_cat_plc ) ){
                                            $checked_all_cat_plc = in_array( $all_cat_ad_place, $saved_all_cat_plc ) ? 'checked' : '';
                                        }
                                        $str_replace_all_cat = str_replace( '-', ' ', $all_cat_ad_place );
                                        $l_all_cat_placement = ucwords( $str_replace_all_cat );
                                        ?>
                                        <div class="swbd__placement-single">
                                        <input type="checkbox" name="swbdpam_all_cat_ad_places[]" id="swbdpam__all-cat-ad-place-<?php echo $all_cat_ad_place; ?>" value="<?php echo $all_cat_ad_place; ?>" <?php echo $checked_all_cat_plc; ?>>
                                            <label for="swbdpam__all-cat-ad-place-<?php echo $all_cat_ad_place; ?>" class="swbdpam__ad-place-label">
                                                <img src="<?php echo SWBDPAM_ADMIN_IMAGE_URL .'all-cat-img/'. $all_cat_ad_place .'.png';?>" alt="">
                                            </label>
                                            <p><?php _e( $l_all_cat_placement, 'directorist-adverts-manager' ); ?></p>
                                        </div>
                                        <?php
                                    }
                                    ?>
                                </div>
                            </td>
                        </tr>   <!-- END All Categories Page placement select input field row -->

                        <tr id='swbdpam__single-category-page-ad-places'> <!-- START Single Category Page placement select input field row -->
                            <th><?php echo $l_single_category; ?></th>
                            <td>
                                <div class="placement-wrap">
                                    <?php
                                    foreach( $single_cat_ad_places as $single_cat_ad_place ){
                                        $checked_sing_cat_plc = '';
                                        if( is_array( $saved_single_cat_plc ) ){
                                            $checked_sing_cat_plc = in_array( $single_cat_ad_place, $saved_single_cat_plc ) ? 'checked' : '';
                                        }

                                        $str_replace_sc = str_replace( '-', ' ', $single_cat_ad_place );
                                        $l_sc_placement = ucwords( $str_replace_sc );
                                        ?>
                                        <div class="swbd__placement-single">
                                            <input type="checkbox" name="swbdpam_single_category_ad_places[]" id="swbdpam__single-cat-ad-place-<?php echo $single_cat_ad_place; ?>" value="<?php echo $single_cat_ad_place; ?>" <?php echo $checked_sing_cat_plc; ?>>
                                            <label for="swbdpam__single-cat-ad-place-<?php echo $single_cat_ad_place; ?>" class="swbdpam__ad-place-label">
                                                <img src="<?php echo SWBDPAM_ADMIN_IMAGE_URL .'single-cat-img/'. $single_cat_ad_place .'.png'; ?>" alt="">
                                            </label>
                                            <p><?php _e( $l_sc_placement, 'directorist-adverts-manager' ); ?></p>
                                        </div>
                                    <?php
                                    }
                                    ?>
                                </div>
                            </td>
                        </tr>   <!-- END Single Category Page placement select input field row -->

                        <tr id='swbdpam__all-loc-page-ad-places'> <!-- START All locations Page placement select input field row -->
                            <th><?php echo $l_all_loc; ?></th>
                            <td>
                                <div class="placement-wrap">
                                    <?php
                                    foreach( $all_loc_ad_places as $all_loc_ad_place ){
                                        $checked_all_loc_plc = '';
                                        if( is_array( $saved_all_loc_plc ) ){
                                            $checked_all_loc_plc = in_array( $all_loc_ad_place, $saved_all_loc_plc ) ? 'checked' : '';
                                        }
                                        $str_replace_all_loc = str_replace( '-', ' ', $all_loc_ad_place );
                                        $l_all_loc_placement = ucwords( $str_replace_all_loc );
                                        ?>
                                        <div class="swbd__placement-single">
                                            <input type="checkbox" name="swbdpam_all_loc_ad_places[]" id="swbdpam__all-loc-ad-place-<?php echo $all_loc_ad_place; ?>" value="<?php echo $all_loc_ad_place; ?>" <?php echo $checked_all_loc_plc; ?>>
                                            <label for="swbdpam__all-loc-ad-place-<?php echo $all_loc_ad_place; ?>" class="swbdpam__ad-place-label">
                                                <img src="<?php echo SWBDPAM_ADMIN_IMAGE_URL .'all-loc-img/'. $all_loc_ad_place .'.png';?>" alt="">
                                            </label>
                                            <p><?php _e( $l_all_loc_placement, 'directorist-adverts-manager' ); ?></p>
                                        </div>
                                    <?php
                                    }
                                    ?>
                                </div>
                            </td>
                        </tr>   <!-- END Search Home Page placement select input field row -->

                        <tr id='swbdpam__single-location-page-ad-places'> <!-- START Single Location Page placement select input field row -->
                            <th><?php echo $l_single_location; ?></th>
                            <td>
                                <div class="placement-wrap">
                                    <?php
                                    foreach( $single_loc_ad_places as $single_loc_ad_place ){
                                        $checked_sing_loc_plc = '';
                                        if( is_array( $saved_single_loc_plc ) ){
                                            $checked_sing_loc_plc = in_array( $single_loc_ad_place, $saved_single_loc_plc ) ? 'checked' : '';
                                        }

                                        $str_replace_single_loc = str_replace( '-', ' ', $single_loc_ad_place );
                                        $l_single_loc_placement = ucwords( $str_replace_single_loc );
                                        ?>
                                        <div class="swbd__placement-single">
                                            <input type="checkbox" name="swbdpam_single_location_ad_places[]" id="swbdpam__single-loc-ad-place-<?php echo $single_loc_ad_place; ?>" value="<?php echo $single_loc_ad_place; ?>" <?php echo $checked_sing_loc_plc; ?>>
                                            <label for="swbdpam__single-loc-ad-place-<?php echo $single_loc_ad_place; ?>" class="swbdpam__ad-place-label">
                                                <img src="<?php echo SWBDPAM_ADMIN_IMAGE_URL .'single-loc-img/'. $single_loc_ad_place .'.png';?>" alt="">
                                            </label>
                                            <p><?php _e( $l_single_loc_placement, 'directorist-adverts-manager' ); ?></p>
                                        </div>
                                    <?php
                                    }
                                    ?>
                                </div>
                            </td>
                        </tr>   <!-- END Single Location Page placement select input field row -->

                        <tr id='swbdpam__add-listing-page-ad-places'> <!-- START Add-listing Page placement select input field row -->
                            <th><?php echo $l_add_listing; ?></th>
                            <td>
                                <div class="placement-wrap">
                                    <?php
                                    foreach( $add_lis_ad_places as $add_lis_ad_place ){
                                        $checked_add_lis_plc = '';
                                        if( is_array( $saved_add_lis_plc ) ){
                                            $checked_add_lis_plc = in_array( $add_lis_ad_place, $saved_add_lis_plc ) ? 'checked' : '';
                                        }

                                        $str_replace_add = str_replace( '-', ' ', $add_lis_ad_place );
                                        $l_add_placement = ucwords( $str_replace_add );
                                        ?>
                                        <div class="swbd__placement-single">
                                            <input type="checkbox" name="swbdpam_add_listing_ad_places[]" id="swbdpam__add-lis-ad-place-<?php echo $add_lis_ad_place; ?>" value="<?php echo $add_lis_ad_place; ?>" <?php echo $checked_add_lis_plc; ?>>
                                            <label for="swbdpam__add-lis-ad-place-<?php echo $add_lis_ad_place; ?>" class="swbdpam__ad-place-label">
                                                <img src="<?php echo SWBDPAM_ADMIN_IMAGE_URL .'add-lis-img/'. $add_lis_ad_place .'.png';?>" alt="">
                                            </label>
                                            <p><?php _e( $l_add_placement, 'directorist-adverts-manager' ); ?></p>
                                        </div>
                                    <?php
                                    }
                                    ?>
                                </div>
                            </td>
                        </tr>   <!-- END Add-listing Page placement select input field row -->

                        <tr id='swbdpam__dashboard-page-ad-places'>   <!-- START Dashboard Page placement select input field row -->
                            <th><?php echo $l_dashboard; ?></th>
                            <td>
                                <div class="placement-wrap">
                                    <?php
                                    foreach( $dashboard_ad_places as $dashboard_ad_place ){
                                        $checked_dashboard_plc = '';
                                        if( is_array( $saved_dashboard_plc ) ){
                                            $checked_dashboard_plc = in_array( $dashboard_ad_place, $saved_dashboard_plc ) ? 'checked' : '';
                                        }

                                        $str_replace_dash = str_replace( '-', ' ', $dashboard_ad_place );
                                        $l_dash_placement = ucwords( $str_replace_dash );
                                        ?>
                                        <div class="swbd__placement-single">
                                            <input type="checkbox" name="swbdpam_dashboard_ad_places[]" id="swbdpam__dashboard-ad-place-<?php echo $dashboard_ad_place; ?>" value="<?php echo $dashboard_ad_place; ?>" <?php echo $checked_dashboard_plc; ?>>
                                            <label for="swbdpam__dashboard-ad-place-<?php echo $dashboard_ad_place; ?>" class="swbdpam__ad-place-label">
                                                <img src="<?php echo SWBDPAM_ADMIN_IMAGE_URL .'dashboard-img/'. $dashboard_ad_place .'.png';?>" alt="">
                                            </label>
                                            <p><?php _e( $l_dash_placement, 'directorist-adverts-manager' ); ?></p>
                                        </div>
                                    <?php
                                    }
                                    ?>
                                </div>
                            </td>
                        </tr>   <!-- END Dashboard Page placement select input field row -->

                        <tr id='swbdpam__author-profile-page-ad-places'>  <!-- START Author Listings Page placement select input field row -->
                            <th><?php echo $l_author_profile; ?></th>
                            <td>
                                <div class="placement-wrap">
                                    <?php
                                    foreach( $auth_lis_ad_places as $auth_lis_ad_place ){
                                        $checked_auth_lis_plc = '';
                                        if( is_array( $saved_auth_lis_plc ) ){
                                            $checked_auth_lis_plc = in_array( $auth_lis_ad_place, $saved_auth_lis_plc ) ? 'checked' : '';
                                        }

                                        $str_replace_auth = str_replace( '-', ' ', $auth_lis_ad_place );
                                        $l_auth_placement = ucwords( $str_replace_auth );
                                        ?>
                                        <div class="swbd__placement-single">
                                            <input type="checkbox" name="swbdpam_author_listings_ad_places[]" id="swbdpam__auth-lis-ad-place-<?php echo $auth_lis_ad_place; ?>" value="<?php echo $auth_lis_ad_place; ?>" <?php echo $checked_auth_lis_plc; ?>>
                                            <label for="swbdpam__auth-lis-ad-place-<?php echo $auth_lis_ad_place; ?>" class="swbdpam__ad-place-label">
                                                <img src="<?php echo SWBDPAM_ADMIN_IMAGE_URL .'auth-profile-img/'. $auth_lis_ad_place .'.png';?>" alt="">
                                            </label>
                                            <p><?php _e( $l_auth_placement, 'directorist-adverts-manager' ); ?></p>
                                        </div>
                                    <?php
                                    }
                                    ?>
                                </div>
                            </td>
                        </tr>   <!-- END Author Listings Page placement select input field row -->


                        <tr id='swbdpam__search-home-page-ad-places'> <!-- START Search Home Page placement select input field row -->
                            <th><?php echo $l_search_home; ?></th>
                            <td>
                                <div class="placement-wrap">
                                    <?php
                                    foreach( $search_home_ad_places as $search_home_ad_place ){
                                        $checked_search_home_plc = '';
                                        if( is_array( $saved_search_home_plc ) ){
                                            $checked_search_home_plc = in_array( $search_home_ad_place, $saved_search_home_plc ) ? 'checked' : '';
                                        }

                                        $str_replace_sh = str_replace( '-', ' ', $search_home_ad_place );
                                        $l_sh_placement = ucwords( $str_replace_sh );
                                        ?>
                                        <div class="swbd__placement-single">
                                            <input type="checkbox" name="swbdpam_search_home_ad_places[]" id="swbdpam__search-home-ad-place-<?php echo $search_home_ad_place; ?>" value="<?php echo $search_home_ad_place; ?>" <?php echo $checked_search_home_plc; ?>>
                                            <label for="swbdpam__search-home-ad-place-<?php echo $search_home_ad_place; ?>" class="swbdpam__ad-place-label">
                                                <img src="<?php echo SWBDPAM_ADMIN_IMAGE_URL .'search-home-img/'. $search_home_ad_place .'.png';?>" alt="">
                                            </label>
                                            <p><?php _e( $l_sh_placement, 'directorist-adverts-manager' ); ?></p>
                                        </div>
                                    <?php
                                    }
                                    ?>
                                </div>
                            </td>
                        </tr>   <!-- END Search Home Page placement select input field row -->

                        <tr id='swbdpam__search-result-page-ad-places'> <!-- START Search Result Page placement select input field row -->
                            <th><?php echo $l_search_result; ?></th>
                            <td>
                                <div class="placement-wrap">
                                    <?php
                                        foreach( $search_result_ad_places as $search_result_ad_place ){
                                            $checked_search_result_plc = '';
                                            if( is_array( $saved_search_result_plc ) ){
                                                $checked_search_result_plc = in_array( $search_result_ad_place, $saved_search_result_plc ) ? 'checked' : '';
                                            }

                                            $str_replace_sr = str_replace( '-', ' ', $search_result_ad_place );
                                            $l_sr_placement = ucwords( $str_replace_sr );
                                            ?>
                                            <div class="swbd__placement-single">
                                                <input type="checkbox" name="swbdpam_search_result_ad_places[]" id="swbdpam__search-result-ad-place-<?php echo $search_result_ad_place; ?>" value="<?php echo $search_result_ad_place; ?>" <?php echo $checked_search_result_plc; ?>>
                                                <label for="swbdpam__search-result-ad-place-<?php echo $search_result_ad_place; ?>" class="swbdpam__ad-place-label">
                                                    <img src="<?php echo SWBDPAM_ADMIN_IMAGE_URL .'search-result-img/'. $search_result_ad_place .'.png';?>" alt="">
                                                </label>
                                                <p><?php _e( $l_sr_placement, 'directorist-adverts-manager' ); ?></p>
                                            </div>
                                        <?php
                                        }
                                    ?>
                                </div>
                            </td>
                        </tr>   <!-- END Search Result Page placement select input field row -->

                    </tbody>
                </table>
            </div>
            
            <!-- Start ad-layout-wrapper -->
            <div class="ad-layout-wrapper">
                <!-- START Before header & footer ads options -->
                <table class='form-table'>
                    <tbody>
                        <tr id="swbdpam__bhaf-ad-size-row">    <!-- START ad's width & height row -->
                            <th><?php echo $l_bhaf_ad_size; ?></th>
                            <td>
                                <div class="swbd-input-wrap mr-10">
                                    <label for='swbdpam__bhaf-ad-width'><?php echo $l_width; ?> :</label>
                                    <input type='number' min="0" name='swbdpam_bhaf_ad_width' id='swbdpam__bhaf-ad-width' value='<?php echo $saved_bhaf_ad_width; ?>'>
                                    <span><?php echo $l_px; ?></span>
                                </div>
                            </td>
                            <td>
                                <div class="swbd-input-wrap mr-10">
                                    <label for='swbdpam__bhaf-ad-height'><?php echo $l_height; ?> :</label>
                                    <input type='number' min="0" name='swbdpam_bhaf_ad_height' id='swbdpam__bhaf-ad-height' value='<?php echo $saved_bhaf_ad_height; ?>'>
                                    <span><?php echo $l_px; ?></span>
                                </div>
                            </td>
                        </tr>   <!-- END ad's width & height row -->
                    </tbody>
                </table>
                <!-- START As card in loop ads options -->

                <table class='form-table'>
                    <tbody>

                        <!--***************  START As card ad layout    *****************-->
                        <tr id="swbdpam__card-ad-show-after-row">    <!-- START ad show after number of listing field row -->
                            <th><?php echo $l_card_ad_show_after; ?></th>
                            <td>
                                <p>
                                    <input type='number' min="0" name='swbdpam_card_ad_show_after_lis' id='swbdpam__card-ad-show-after-lis' value="<?php echo $saved_card_ad_show_after; ?>">
                                </p>
                            </td>
                        </tr>   <!-- END ad show after number of listing field row -->

                        <tr id="swbdpam__card-ad-repeat-row">    <!-- START ad repeat field row -->
                            <th><?php echo $l_card_ad_repeat; ?></th>
                            <td>
                                <div class="radio-group">
                                    <div class="swbdpam-custom-radio-cont">
                                        <input type='radio' name='swbdpam_card_ad_repeat' id='swbdpam__card-ad-repeat' value='yes' <?php echo $checked_card_ad_repeat; ?>>
                                        <label for='swbdpam__card-ad-repeat'><span class="swbdpam-custom-radio"></span><?php echo $l_yes; ?></label>
                                    </div>
                                    <div class="swbdpam-custom-radio-cont">
                                        <input type='radio' name='swbdpam_card_ad_repeat' id='swbdpam__card-ad-not-repeat' value='no' <?php echo $checked_card_ad_not_repeat; ?>>
                                        <label for='swbdpam__card-ad-not-repeat'><span class="swbdpam-custom-radio"></span><?php echo $l_no; ?></label>
                                    </div>
                                </div>
                            </td>
                        </tr>   <!-- END ad repeat field row -->

                        <tr id="swbdpam__card-ad-size-row">   <!-- START ad's width & height row -->
                            <th><?php echo $l_card_ad_size; ?></th>
                            <td>
                                <div class="swbd-input-wrap mr-10">
                                    <label for='swbdpam__card-ad-width'><?php echo $l_width; ?> :</label>
                                    <input type='number' min="0" name='swbdpam_card_ad_width' id='swbdpam__card-ad-width' value='<?php echo $saved_card_ad_width; ?>'>
                                    <span><?php echo $l_px; ?></span>
                                </div>
                            </td>
                            <td>
                                <div class="swbd-input-wrap mr-10">
                                    <label for='swbdpam__card-ad-height'><?php echo $l_height; ?> :</label>
                                    <input type='number' min="0" name='swbdpam_card_ad_height' id='swbdpam__card-ad-height' value='<?php echo $saved_card_ad_height; ?>'>
                                    <span><?php echo $l_px; ?></span>
                                </div>
                            </td>
                        </tr>   <!-- END ad's width & height row -->

                        <!--***************  END As card ad layout    *****************-->


                        <!--***************  START Full row ad layout    *****************-->
                        <tr id="swbdpam__row-ad-show-after-row">  <!-- START ad show after number of listing field row -->
                            <th><?php echo $l_row_ad_show_after; ?></th>
                            <td>
                                <p>
                                    <input type='number' min="0" name='swbdpam_row_ad_show_after_row' id='swbdpam__ad-show-after-row' value="<?php echo $saved_row_ad_show_after; ?>">
                                </p>
                            </td>
                        </tr>   <!-- END ad show after number of listing field row -->

                        <tr id="swbdpam__row-ad-repeat-row">    <!-- START ad repeat field row -->
                            <th><?php echo $l_row_ad_repeat; ?></th>
                            <td>
                                <div class="radio-group">
                                    <div class="swbdpam-custom-radio-cont">
                                        <input type='radio' name='swbdpam_row_ad_repeat' id='swbdpam__row-ad-repeat' value='yes' <?php echo $checked_row_ad_repeat; ?>>
                                        <label for='swbdpam__row-ad-repeat'><span class="swbdpam-custom-radio"></span><?php echo $l_yes; ?></label>
                                    </div>
                                    
                                    <div class="swbdpam-custom-radio-cont">
                                        <input type='radio' name='swbdpam_row_ad_repeat' id='swbdpam__row-ad-not-repeat' value='no' <?php echo $checked_row_ad_not_repeat; ?>>
                                        <label for='swbdpam__row-ad-not-repeat'><span class="swbdpam-custom-radio"></span><?php echo $l_no; ?></label>
                                    </div>
                                </div>
                            </td>
                        </tr>   <!-- END ad repeat field row -->

                        <tr id="swbdpam__row-ad-size-row">    <!-- START ad's width & height row -->
                            <th><?php echo $l_row_ad_size; ?></th>
                            <td>
                                <div class="swbd-input-wrap mr-10">
                                    <label for='swbdpam__row-ad-width'><?php echo $l_width; ?> :</label>
                                    <input type='number' min="0" name='swbdpam_row_ad_width' id='swbdpam__row-ad-width' value='<?php echo $saved_row_ad_width; ?>'>
                                    <span><?php echo $l_px; ?></span>
                                </div>
                            </td>
                            <td>
                                <div class="swbd-input-wrap">
                                    <label for='swbdpam__row-ad-height'><?php echo $l_height; ?> :</label>
                                    <input type='number' min="0" name='swbdpam_row_ad_height' id='swbdpam__row-ad-height' value="<?php echo $saved_row_ad_height; ?>">
                                    <span><?php echo $l_px; ?></span>
                                </div>
                            </td>
                        </tr>   <!-- END ad's width & height row -->
                        <!--*************** END Full row ad layout    *****************-->

                    </tbody>
                </table>
            </div>
            <!-- End of ad-layout-wrapper -->
        <?php

        }



        /**
         * SWBDPAM_POST_TYPE CPT's Ad's additional settings CMB's callback
         *
         * @param Current post
         *
         * @return void
         */
        public function cmb_ads_manager_additional_settings_callback( $post )
        {
            $l_display_for      = __( 'Only For Logged In Users', 'directorist-adverts-manager' );
            $l_yes              = __( 'Yes', 'directorist-adverts-manager' );
            $l_no               = __( 'No', 'directorist-adverts-manager' );

            $l_ad_expiry        = __( 'Ad Expiry', 'directorist-adverts-manager' );
            $l_in_days          = __( 'In Days', 'directorist-adverts-manager' );
            $l_in_hours         = __( 'In Hours', 'directorist-adverts-manager' );
            $l_mark_as_forever  = __( 'Never Expires', 'directorist-adverts-manager' );
            $l_days_placeholder = __( 'e.g. 30', 'directorist-adverts-manager' );

            $l_after_expire     = __( 'After expiration', 'directorist-adverts-manager' );
            $l_leave_ad         = __( 'Leave The Ad As It Is', 'directorist-adverts-manager' );
            $l_ad_contact_image = __( 'Show Contact For Ad Image', 'directorist-adverts-manager' );

            $l_img              = __( 'Upload Contact Image', 'directorist-adverts-manager' );
            $l_img_up_btn       = __( 'Upload Image', 'directorist-adverts-manager' );

            $saved_logged_in_user   = get_post_meta( $post->ID, 'swbdpam_logged_in_user', true );
            $saved_logged_in_user   = ! empty( $saved_logged_in_user ) ? $saved_logged_in_user : 'no';
            $checked_yes            = ( 'yes' == $saved_logged_in_user ) ? "checked = 'checked'" : '';
            $checked_no             = ( 'no' == $saved_logged_in_user ) ? "checked = 'checked'" : '';

            $saved_ad_expire_day        = get_post_meta( $post->ID, 'swbdpam_ad_expire_day', true );
            $saved_ad_expire_hour       = get_post_meta( $post->ID, 'swbdpam_ad_expire_hour', true );
            $saved_mark_as_forever      = get_post_meta( $post->ID, 'swbdpam_ad_mark_as_forever', true );
            $checked_mark_as_forever    = ( 'mark-as-forever' == $saved_mark_as_forever ) ? 'checked' : '';

            $saved_after_expire     = get_post_meta( $post->ID, 'swbdpam_after_expire', true );
            $saved_after_expire     = ! empty( $saved_after_expire ) ? $saved_after_expire : 'leave_place';
            $checked_leave_place    = ( 'leave_place' == $saved_after_expire ) ? "checked = 'checked'" : '';
            $checked_contact_image  = ( 'contact_image' == $saved_after_expire ) ? "checked = 'checked'" : '';

            $saved_contact_image_id     = get_post_meta( $post->ID, 'swbdpam_contact_image_id', true );
            $saved_contact_image_url    = get_post_meta( $post->ID, 'swbdpam_contact_image_url', true );

            wp_nonce_field( 'swbdpam_additional_settings_cmb_action', 'swbdpam_additional_settings_cmb_field' );

            ?>
            <table class='form-table swbdam_ad-setting-form'>
                <tbody>
                    <tr>    <!-- START logged in user row -->
                        <th><?php echo $l_display_for; ?></th>
                        <td>
                            <label class="swbd-custom-switch">
                                <input type='checkbox' name='swbdpam_logged_in_user' id='swbdpam__logged-in-user-yes' value='yes' <?php echo $checked_yes; ?>>
                                <span class="switch_yes"><?php echo $l_yes; ?></span>
                                <span class="switch_no"><?php echo $l_no; ?></span>
                            </label>
                        </td>
                    </tr>   <!-- END logged in user row -->

                    <tr>    <!-- START ad expore row -->
                        <th><?php echo $l_ad_expiry; ?></th>
                        <td>
                            <div class="swbd-input-wrap">
                                <label for='swbdpam__ad-expire-day'><?php echo $l_in_days; ?></label>
                                <input type="number" class='swbdpam__ad_expiry_input' name='swbdpam_ad_expire_day' id='swbdpam__ad-expire-day' placeholder="<?php echo $l_days_placeholder; ?>" value="<?php echo $saved_ad_expire_day; ?>">
                            </div>
                            <div class="swbd-input-wrap mt-20">
                                <input type='checkbox' name='swbdpam_ad_mark_as_forever' id='swbdpam__ad-mark-as-forever' value='mark-as-forever' <?php echo $checked_mark_as_forever; ?>>
                                <label for='swbdpam__ad-mark-as-forever'><?php echo $l_mark_as_forever; ?></label>
                            </div>
                        </td>
                    </tr>   <!-- END ad expore row -->

                    <tr>    <!-- START after expire row -->
                        <th><?php echo $l_after_expire; ?></th>
                        <td>
                            <div class="swbdpam-custom-radio-cont">
                                <input type='radio' name='swbdpam_after_expire' id='swbdpam__leave-place' value='leave_place' <?php echo $checked_leave_place; ?>>
                                <label for='swbdpam__leave-place'><div class="swbdpam-custom-radio"></div><?php echo $l_leave_ad; ?></label>
                            </div>
                            <div class="swbdpam-custom-radio-cont">
                                <input type='radio' name='swbdpam_after_expire' id='swbdpam__contact-image-show' value='contact_image' <?php echo $checked_contact_image; ?>>
                                <label for='swbdpam__contact-image-show'><div class="swbdpam-custom-radio"></div><?php echo $l_ad_contact_image; ?></label>
                            </div>
                        </td>
                    </tr>   <!-- END after expire row -->
 
                    <tr id='swbdpam__contact-image-raw'>    <!-- START contact image ad button row -->
                        <th></th>
                        <td>
                            <div class="swbdpam_img-uploader">
                                <span class="swbdpam-form-group__label"><?php echo $l_img; ?></span>
                                <button class='button swbdpam-upload-img-btn' id='swbdpam__contact-image-uploader'><img src="<?php echo SWBDPAM_ADMIN_IMAGE_URL . 'image-upload.png'; ?>"><?php echo $l_img_up_btn; ?></button>
                                <input type='hidden' name='swbdpam_contact_image_id' id='swbdpam__contact-image-id' value='<?php echo $saved_contact_image_id; ?>'>
                                <input type='hidden' name='swbdpam_contact_image_url' id='swbdpam__contact-image-url' value='<?php echo $saved_contact_image_url; ?>'>
                                <div class="swbdpam__up_img_container" id='swbdpam__contact-image-container'></div>
                            </div>
                        </td>
                    </tr>   <!-- END contact image ad button row -->
                </tbody>
            </table>

            <div class="swbdpam_shortcode"> <!-- Start ad's shortcode creator row -->
                <div class="swbdpam_shortcode__inner">
                    <h2><?php esc_html_e( 'Shortcode', 'directorist-adverts-manager' ); ?></h2>
                    <div class="swbdpam_shortcode__form">
                        <p><?php esc_html_e( 'Use following shortcode to display anywhere:', 'directorist-adverts-manager' ); ?></p>
                        <textarea cols="50" rows="1" onClick="this.select();">[directorist_ads_manager id=<?php echo $post->ID; ?>]</textarea>
                        <br/>

                        <p><?php esc_html_e( 'If you need to put the shortcode inside php code/template file, use this:', 'directorist-adverts-manager' ); ?></p>
                        <textarea cols="63" rows="1" onClick="this.select();"><?php echo '<?php echo do_shortcode( "[directorist_ads_manager id='; echo $post->ID . "]"; echo '" ); ?>'; ?></textarea>
                    </div>
                </div>
            </div>  <!-- END ad's shortcode creator row -->
            <?php
        }

    } // Class closer
} // If statement closer