<?php
/**
 * @package  Directorist - Ads Manager
 */


if( ! class_exists( 'SWBDPWidgetAdsManager' ) ){
    /**
     * Directorist Ads Manager widget class
     */
    class SWBDPWidgetAdsManager extends WP_Widget
    {
        /**
        * Class constructor
        */
        public function __construct()
        {
            /**
             * Parent class function or WP_Widget class's function
             */
            parent::__construct(            
                // Registered widget's ID 
                'SWBDPWidgetAdsManager',
                
                // Widget name will appear in Wedgits menu page in admin
                __( 'Directorist - Ads Manager', 'directorist-adverts-manager' ), 
                
                // Widget description
                array(
                    'description' => __( 'Let to you to display ads on the sidebar by this widget', 'directorist-adverts-manager' ) 
                )
            );
        }



        /**
         * Creating widget output show in frontend, where we want to display the widget outpur
         * 
         * @param $args and $instance are defined in parent class
         */
        public function widget( $args, $instance )
        {
            // Widget output & display in frontend
            include SWBDPAM_PLUGIN_TEMPLATES_DIR. 'swbdpam-widget-output.php';

            // After widget arguments
            echo $args['after_widget'];
        }


        /**
         * Display in Widgets menu page
         * 
         * @param This parameter is defined in parent class
         */
        public function form( $instance )
        {
            $saved_ad = ! empty( $instance['select_ad'] ) ? $instance['select_ad'] : '';
            $args = array(
                'post_type'       => SWBDPAM_POST_TYPE,
                'post_status'     => 'publish',
                'posts_per_page'  => -1,
				'fields'		  => 'ids',
				
            );
            $ads = new WP_Query( $args );

            $ads_array = array();
            if ( $ads->have_posts() ) { ?>
			<p>
				<select class="widefat" id="<?php echo $this->get_field_id( 'select_ad' ); ?>" name="<?php echo $this->get_field_name( 'select_ad' ); ?>">
					<option value="0"><?php echo __( 'Select Ad', 'directorist-adverts-manager' ); ?></option>
					
					<?php 
					foreach( $ads->posts as $ad ) { ?>
						<option <?php echo $ad == $saved_ad ? esc_html('selected') : ''; ?> value="<?php echo esc_attr( $ad ); ?>"><?php echo esc_attr( get_the_title( $ad ) ); ?></option>
					<?php } ?>
					
				</select>
			</p>
			<?php
            }			
        }



        /**
         * Updating widget replacing old instances with new
         * 
         * @param Both parameters are defined in parent class
         * 
         * @return Widget
         */
        public function update( $new_instance, $old_instance )
        {
            $instance               = $old_instance;
            $instance['title']      = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
            $instance['select_ad']  = ( ! empty( $new_instance['select_ad'] ) ) ? strip_tags( $new_instance['select_ad'] ) : '';

            return $instance;
        }

    }// End class
} // End if_class_exists block