<?php
/**
 * @package  Directorist - Ads Manager
 */

if( ! class_exists( 'SWBDPAMShortcodeHandler' ) ){
    /**
     * Ads shortcode handler class
     */
    class SWBDPAMShortcodeHandler
    {
        /**
        * Class constructor
        * Call all hooks which we wanna triger
        */ 
        public function register()
        {
            //  shortcode
            add_shortcode( 'directorist_ads_manager', array( $this, 'directorist_ads_manager_ad_shortcode' ) );

            // Hook remover
            add_action( 'plugins_loaded', array( $this, 'remove_directorist_listing_compare_shortcode' ) );
        }


        /**
         * Create shortcode output
         * 
         * @param shortcode content
         * @return shortcode content
         */
        public function directorist_ads_manager_ad_shortcode( $atts, $content )
        {
            ob_start();

            // set up default parameters
            extract( shortcode_atts( array( 'id' => '' ), $atts) );
           
            $ad_type            = get_post_meta( $id, 'swbdpam_ad_type', true );
            $image_ad_image_id  = get_post_meta( $id, 'swbdpam_image_ad_image_id', true );
            $image_quality      = get_directorist_option('preview_image_quality', 'large');  // medium | large | full
            $image_ad_image_url = atbdp_get_image_source( $image_ad_image_id, $image_quality );;
            $ad_code            = get_post_meta( $id, 'swbdpam_custom_code_ad', true );
            $is_user_logged_in  = get_post_meta( $id, 'swbdpam_logged_in_user', true );
            $ad_expire_in_day   = get_post_meta( $id, 'swbdpam_ad_expire_day', true );
            $ad_expire_in_hour  = get_post_meta( $id, 'swbdpam_ad_expire_hour', true );
            $mark_as_forever    = get_post_meta( $id, 'swbdpam_ad_mark_as_forever', true );
            $after_expire       = get_post_meta( $id, 'swbdpam_after_expire', true );
            $contact_image_url  = get_post_meta( $id, 'swbdpam_contact_image_url', true );
            $terget_url         = get_post_meta( $id, 'swbdpam_ad_terget_url', true );
            $rel                = get_post_meta( $id, 'swbdpam_rel_attr', true );
            $open_link_in       = get_post_meta( $id, 'swbdpam_open_link', true );
            
            $ad_type            = isset( $ad_type ) ? $ad_type : '' ;
            $image_ad_image_url = isset( $image_ad_image_url ) ? esc_url( $image_ad_image_url ) : '' ;
            $ad_code            = isset( $ad_code ) ? $ad_code : '' ;
            $is_user_logged_in  = isset( $is_user_logged_in ) ? $is_user_logged_in : '' ;
            $ad_expire_in_day   = isset( $ad_expire_in_day ) ? (int)( $ad_expire_in_day ) : 0 ;
            $ad_expire_in_hour  = isset( $ad_expire_in_hour ) ? $ad_expire_in_hour : '' ;
            $mark_as_forever    = isset( $mark_as_forever ) ? $mark_as_forever : '' ;
            $after_expire       = isset( $after_expire ) ? $after_expire : '' ;
            $after_expire       = !empty( $after_expire ) ? $after_expire : 'leave_place' ;
            $contact_image_url  = isset( $contact_image_url ) ? esc_url( $contact_image_url ) : '' ;
            $terget_url         = isset( $terget_url ) ? esc_url( $terget_url ) : '' ;
            $rel                = isset( $rel ) ? $rel : '' ;
            
            // Set open link in a new tab or not
            if( isset( $open_link_in ) && ( 'new_tab' == $open_link_in ) ){
                $open_link = '_blank';
            }else{
                $open_link = '';
            }

            // Authenticate, Isn't mark as forever
            if( isset( $mark_as_forever ) && ( 'mark-as-forever' != $mark_as_forever ) ){
                // Authenticate, is only logged in user see the Ads? 
                if( ( 'yes' == $is_user_logged_in ) && ( ! is_user_logged_in() ) ){
                    return false;
                }

                // Authenticate, is Ad expire by date?
                if( ( ! empty( $ad_expire_in_day ) ) && ( 0 !== $ad_expire_in_day ) ){
                    $ad_published   = get_the_date( "d-m-Y", $id );                    
                    $date           = date_create( $ad_published );
                    date_add( $date, date_interval_create_from_date_string( $ad_expire_in_day .' day' ) );
                    $expire_date    = date_format( $date, "d-m-Y" );

                    $expire         = strtotime( $expire_date );
                    $current_date   = strtotime( date( "d-m-Y" ) );

                    if( $current_date > $expire ){
                        // After ad expire ad place is hide
                        if( ! empty( $after_expire ) && ( 'leave_place' == $after_expire ) ){
                            return false;
                        }

                        // After ad expire show image for contact
                        if( ! empty( $after_expire ) && ( 'contact_image' == $after_expire ) ){
                            ?>
                            <img class="swbdpam__contact_img_shortcode_ad" src="<?php echo $contact_image_url;?>" alt="">
                            <?php
                        }                       
                    }else{
                        // Ad render statement                 
                        // Authenticate, Is ad type image and have image url
                        if( ( 'image' == $ad_type ) && ( ! empty( $image_ad_image_url ) ) ){
                            // Image type ad
                            ?>
                            <a href="<?php echo $terget_url; ?>" target="<?php echo $open_link; ?>" rel="<?php echo $rel; ?>">
                                <img class="directorist-img_shortcode_ad" src="<?php echo $image_ad_image_url; ?>" alt="">
                            </a>
                            <?php
                        }
                        
                        // Authenticate, Is ad type custom code
                        if( ( 'custom_code' == $ad_type ) && ( ! empty( $terget_url ) ) ){
                            // Code type ad
                            return <<<EOD
<a href="{$terget_url}" target="{$open_link}" rel="{$rel}">
    <div class="swbdpam__custom_shortcode_ad">{$ad_code}</div>
</a>
EOD;
                        }
                        
                        // Authenticate, Is ad type google or facebook ad
                        if( ( 'google_adsense' == $ad_type ) || ( 'facebook_pixel' == $ad_type ) ){             
                            return <<<EOD
<div class="swbdpam__google_shortcode_ad">{$ad_code}</div>
EOD;
                        }
                    }
                }// Expire by day closer
                
                // Authenticate, is Ad expire by time?
                if( ! empty( $ad_expire_in_hour ) ){
                    $time = new DateTime( $ad_expire_in_hour );
                    $expire_time    = $time->format( 'g:i A' );
                    $current_time   = date( 'h:i A', time() );
                
                    $expire_strtotime   = strtotime( $expire_time );
                    $current_strtotime  = strtotime( $current_time );

                    if ( $current_strtotime > $expire_strtotime ){
                        // After ad expire ad place is hide
                        if( ! empty( $after_expire ) && ( 'leave_place' == $after_expire ) ){
                            return false;
                        }

                        // After ad expire show image for contact
                        if( ! empty( $after_expire ) && ( 'contact_image' == $after_expire ) ){
                            ?>
                            <img class="swbdpam__contact_img_shortcode_ad" src="<?php echo $contact_image_url;?>" alt="">
                            <?php
                        }
                    }else{
                        // Ad render statement
                        // Authenticate, Is ad type image and have image url
                        if( ( 'image' == $ad_type ) && ( ! empty( $image_ad_image_url ) ) ){
                            ?>
                            <a href="<?php echo $terget_url; ?>" target="<?php echo $open_link; ?>" rel="<?php echo $rel; ?>">
                                <img class="directorist-img_shortcode_ad" src="<?php echo $image_ad_image_url; ?>" alt="">
                            </a>
                            <?php
                        }

                        // Authenticate, Is ad type custom code
                        if( ( 'custom_code' == $ad_type ) && ( ! empty( $terget_url ) ) ){
                            return <<<EOD
<a href="{$terget_url}" target="{$open_link}" rel="{$rel}">
    <div class="swbdpam__custom_shortcode_ad">{$ad_code}</div>
</a>
EOD;
                        }
                        
                        // Authenticate, Is ad type google or facebook ad
                        if( ( 'google_adsense' == $ad_type ) || ( 'facebook_pixel' == $ad_type ) ){             
                            return <<<EOD
<div class="swbdpam__google_shortcode_ad">{$ad_code}</div>
EOD;
                        }
                    }
                }// Expire by hours closer

            }else{
                // Mark as foraver
                // Authenticate, is only logged in user see the Ads? 
                if( ( 'yes' == $is_user_logged_in ) && ( ! is_user_logged_in() ) ){
                    return false;
                }

                // Ad render statement
                if( ( 'image' == $ad_type ) && ( ! empty( $image_ad_image_url ) ) ){
                    // Image type ad
                    ?>
                    <a href="<?php echo $terget_url; ?>" target="<?php echo $open_link; ?>" rel="<?php echo $rel; ?>">
                        <img class="directorist-img_shortcode_ad" src="<?php echo $image_ad_image_url; ?>" alt="">
                    </a>
                    <?php
                }
                
                // Authenticate, Is ad type custom code
                if( ( 'custom_code' == $ad_type ) && ( ! empty( $terget_url ) ) ){          
                    // Code type ad           
                    return  <<<EOD
<a href="<?php echo $terget_url; ?>" target="{$open_link}" rel="{$rel}">
    <div class="swbdpam__custom_shortcode_ad">{$ad_code}</div>
</a>
EOD;
                }

                // Authenticate, Is ad type google or facebook ad
                if( ( 'google_adsense' == $ad_type ) || ( 'facebook_pixel' == $ad_type ) ){
                    return <<<EOD
<div class="swbdpam__google_shortcode_ad">{$ad_code}</div>
EOD;
                }

            }// Mark as forever closer

            $content = ob_get_contents();
            ob_get_clean();
            
            return $content;
        }


        /**
         * Remove hooks when Ads Manager is disable
         */
        public function remove_directorist_listing_compare_shortcode()
        {
            // Get Ads Manager enable option
            $is_ads_manager_enable = get_directorist_option( 'swbdp_ads_manager_is_enable', 1 );

            // Authenticate, is Ads Manager enable or not
            if( 1 !== ( int )$is_ads_manager_enable ){
                remove_shortcode( 'directorist_ads_manager' );
            }
        }

    }// End class
}