<?php
/**
 * @package  Directorist - Ads Manager
 */


if( ! class_exists( 'SWBDPAMHelperFunctions' ) ){
    /**
     * All helper functions handler class
     */
    class SWBDPAMHelperFunctions
    {
        /**
         * Which pages we wanna display the ads
         *
         * @return array
         */
        public static function ad_display_pages()
        {
            $ad_display_pages = array(
                'all_listings'      => __( 'all listings', 'directorist-adverts-manager' ),
                'single_listing'    => __( 'single listing', 'directorist-adverts-manager' ),
                'all_categories'    => __( 'all category', 'directorist-adverts-manager' ),
                'single_category'   => __( 'single category', 'directorist-adverts-manager' ),
                'all_location'      => __( 'all location', 'directorist-adverts-manager' ),
                'single_location'   => __( 'single location', 'directorist-adverts-manager' ),
                'add_listing'       => __( 'add listing', 'directorist-adverts-manager' ),
                'dashboard'         => __( 'dashboard', 'directorist-adverts-manager' ),
                'author_profile'    => __( 'author Profile', 'directorist-adverts-manager' ),
                'search_home'       => __( 'search home', 'directorist-adverts-manager' ),
                'search_result'     => __( 'search result', 'directorist-adverts-manager' ),
            );
            return $ad_display_pages;
        }



        /**
         * All-listings page ad places ID
         *
         * @return array
         */
        public static function all_lis_ad_places()
        {
            $all_lis_ad_places = array(
                'before-header',
                'before-filter',
                'after-filter',
                //'as-card-in-loop',
                //'full-row-in-loop',
                'before-pagination',
                'after-pagination',
                'after-footer'
            );
            return $all_lis_ad_places;
        }



        /**
         * Single Listing page ad places ID
         *
         * @return array
         */
        public static function single_lis_ad_places()
        {
            $single_lis_ad_places = array(
                'before-header',
                'after-title',
                //'',
                //'after-related-listing',
                'after-footer'
            );
            return $single_lis_ad_places;
        }



        /**
         * All-Categories page ad places ID
         *
         * @return array
         */
        public static function all_cat_ad_places()
        {
            $all_cat_ad_places = array(
                'before-header',
                'before-loop',
                'after-loop',
                'after-footer'
            );
            return $all_cat_ad_places;
        }




        /**
         * Single Category page ad places ID
         *
         * @return array
         */
        public static function single_cat_ad_places()
        {
            $single_cat_ad_places = array(
                'before-header',
                'before-filter',
                'after-filter',
                //'as-card-in-loop',
                //'full-row-in-loop',
                'after-loop',
                'after-footer'
            );
            return $single_cat_ad_places;
        }



        /**
         * All-listings page ad places ID
         *
         * @return array
         */
        public static function all_loc_ad_places()
        {
            $all_loc_ad_places = array(
                'before-header',
                'before-loop',
                'after-loop',
                'after-footer'
            );
            return $all_loc_ad_places;
        }



        /**
         * Single Location page ad places ID
         *
         * @return array
         */
        public static function single_loc_ad_places()
        {
            $single_loc_ad_places = array(
                'before-header',
                'before-filter',
                'after-filter',
                //'as-card-in-loop',
                //'full-row-in-loop',
                'after-loop',
                'after-footer'
            );
            return $single_loc_ad_places;
        }



        /**
         * Add-listing page ad places ID
         *
         * @return array
         */
        public static function add_lis_ad_places()
        {
            $add_lis_ad_places = array(
                'before-header',
                'before-add-new-title',
                //'after-add-new-title',
                //'before-contact-info',
                //'after-contact-info',
                //'before-save-preview-btn',
                'after-save-preview-btn',
                'after-footer'
            );
            return $add_lis_ad_places;
        }



        /**
         * User Dashboard page ad places ID
         *
         * @return array
         */
        public static function dashboard_ad_places()
        {
            $dashboard_ad_places = array(
                'before-header',
                //'before-dashboard-menu',
                //'before-loop',
                //'as-card-in-loop',
                //'full-row-in-loop',
                'before-pagination',
                'after-footer'
            );
            return $dashboard_ad_places;
        }



        /**
         * Aauthor Listings page ad places ID
         *
         * @return array
         */
        public static function auth_lis_ad_places()
        {
            $auth_lis_ad_places = array(
                'before-header',
                'before-author-image',
                'after-author-image',
                'after-author-about',
                'before-loop',
                //'as-card-in-loop',
                //'full-row-in-loop',
                //'before-pagination',
                'after-footer'
            );
            return $auth_lis_ad_places;
        }



        /**
         * Search Home page ad places ID
         *
         * @return array
         */
        public static function search_home_ad_places()
        {
            $search_home_ad_places = array(
                'before-header',
                'before-search-bar',
                'after-search-bar',
                'after-footer'
            );
            return $search_home_ad_places;
        }



        /**
         * Search Result page ad places ID
         *
         * @return array
         */
        public static function search_result_ad_places()
        {
            $search_result_ad_places = array(
                'before-header',
                'before-filter',
                'after-filter',
                //'as-card-in-loop',
                //'full-row-in-loop',
                'after-loop',
                'after-footer'
            );
            return $search_result_ad_places;
        }

        /**
         * Verify valid input fields or not
         * 
         * @return array
         */
        public static function is_secured( $nonce_field, $nonce_action, $post_id )
        {
            $nonce = isset( $_POST[$nonce_field] ) ? $_POST[$nonce_field] : '';

            if( '' == $nonce ){
                return false;
            }

            if( ! wp_verify_nonce( $nonce, $nonce_action ) ){
                return false;
            }

            if( ! current_user_can( 'edit_post', $post_id ) ){
                return false;
            }

            if( wp_is_post_autosave( $post_id ) ){
                return false;
            }

            if( wp_is_post_revision( $post_id ) ){
                return false;
            }

            return true;
        }
        
        
        
        /**
         * This function get the Ads ID
         * 
         * @return Ad id
         */
        public static function get_ad_id( $select_page_meta_value, $select_place_meta_key, $select_place_meta_value )
        {
            $args = array(
                'post_type'       => SWBDPAM_POST_TYPE,
                'post_status'     => 'publish',
                'posts_per_page'  => 1,
                'meta_query' => array(
                    'relation' => 'AND',
                    array(
                        'key'    => 'swbdpam_pages_select',
                        'value'  => $select_page_meta_value,    //'all_listings',
                        'compare' => 'LIKE',
                    ),
                    array(
                        'key'    => $select_place_meta_key,     //'atdam_all_listings_ad_places',
                        'value'  => $select_place_meta_value,   //'before-header',
                        'compare' => 'LIKE',
                    )
                )
            );

            $ads = get_posts( $args );
            foreach( $ads as $ad ){
                $is_user_logged_in  = get_post_meta( $ad->ID, 'swbdpam_logged_in_user', true );
                $is_user_logged_in  = isset( $is_user_logged_in ) ? $is_user_logged_in : '' ;

                // Authenticate, is only logged in user see the Ads?
                if( ( 'yes' == $is_user_logged_in ) && ( ! is_user_logged_in() ) ){
                    return false;
                }           
                return $ad->ID;
            }
        }



        /**
         * This function return an array which contain the selected places in a page
         * 
         * @param string, array
         * 
         * @return array
         */
        public static function get_selected_places_in_a_page( $select_page_meta_value, $select_place_meta_key, $all_places_in_a_page )
        {
            $args = array(
                'post_type'       => SWBDPAM_POST_TYPE,
                'post_status'     => 'publish',
                'posts_per_page'  => -1,
                'meta_query' => array(
                    array(
                        'key'       => 'swbdpam_pages_select',
                        'value'     => $select_page_meta_value,    //'all_listings',
                        'compare'   => 'LIKE',
                    ),
                )
            );            
            $ads = get_posts( $args );
            
            $selected_places = array();
            foreach( $ads as $ad ){
                $places             = get_post_meta( $ad->ID, $select_place_meta_key/*'atdam_all_listings_ad_places'*/, true );
                $places             = ! empty( $places ) ? $places : array();
                $selected_places    = array_merge( $selected_places, $places );
            }
            
            // In a page selected Places
            $total_selected_places = array_intersect( $all_places_in_a_page, $selected_places );
            return $total_selected_places;
        }



        /**
         * This return, whic place are selected for this post
         * 
         * @return array
         */
        public static function get_current_post_selected_ad_places( $select_place_meta_key )
        {
            global $pagenow;
            $screen = get_current_screen();

            if( ( SWBDPAM_POST_TYPE == $screen->post_type ) && ( 'post.php' == $pagenow ) ){
                $ad_id              = get_the_ID();
                $selected_places    = get_post_meta( $ad_id, $select_place_meta_key /*'atdam_all_listings_ad_places'*/, true );
                $selected_places    = ! empty( $selected_places ) ? $selected_places : array();

                return $selected_places;
            }
        }



        /**
         * This function return the Ad with expire or not
         * 
         * @return Ads
         */
        public static function display_ad( $ad_id, $page, $ad_place )
        {
            $ad_type            = get_post_meta( $ad_id, 'swbdpam_ad_type', true );
            $image_ad_image_id  = get_post_meta( $ad_id, 'swbdpam_image_ad_image_id', true );
            $image_quality      = get_directorist_option('preview_image_quality', 'large');  // medium | large | full
            $image_ad_image_url = atbdp_get_image_source( $image_ad_image_id, 'full' );
            $ad_code            = get_post_meta( $ad_id, 'swbdpam_custom_code_ad', true );            
            $ad_expire_in_day   = get_post_meta( $ad_id, 'swbdpam_ad_expire_day', true );
            $ad_expire_in_hour  = get_post_meta( $ad_id, 'swbdpam_ad_expire_hour', true );
            $mark_as_forever    = get_post_meta( $ad_id, 'swbdpam_ad_mark_as_forever', true );
            $after_expire       = get_post_meta( $ad_id, 'swbdpam_after_expire', true );
            $contact_image_id   = get_post_meta( $ad_id, 'swbdpam_contact_image_id', true );
            $contact_image_url  = atbdp_get_image_source( $contact_image_id, $image_quality );
            $terget_url         = get_post_meta( $ad_id, 'swbdpam_ad_terget_url', true );
            $rel                = get_post_meta( $ad_id, 'swbdpam_rel_attr', true );
            $open_link_in       = get_post_meta( $ad_id, 'swbdpam_open_link', true );
            
            $ad_type            = isset( $ad_type ) ? $ad_type : '' ;
            $image_ad_image_url = isset( $image_ad_image_url ) ? esc_url( $image_ad_image_url ) : '' ;
            $ad_code            = isset( $ad_code ) ? $ad_code : '' ;
            $ad_expire_in_day   = isset( $ad_expire_in_day ) ? (int)( $ad_expire_in_day ) : 0 ;
            $ad_expire_in_hour  = isset( $ad_expire_in_hour ) ? $ad_expire_in_hour : '' ;
            $mark_as_forever    = isset( $mark_as_forever ) ? $mark_as_forever : '' ;
            $after_expire       = isset( $after_expire ) ? $after_expire : '' ;
            $after_expire       = !empty( $after_expire ) ? $after_expire : 'leave_place' ;
            $contact_image_url  = isset( $contact_image_url ) ? esc_url( $contact_image_url ) : '' ;
            $terget_url         = isset( $terget_url ) ? esc_url( $terget_url ) : '' ;
            $rel                = isset( $rel ) ? $rel : '' ;
            $expire             = false;

            // Set open link in a new tab or not
            if( isset( $open_link_in ) && ( 'new_tab' == $open_link_in ) ){
                $open_link = '_blank';
            }else{
                $open_link = '';
            }
            
            // Mark as foraver
            if( isset( $mark_as_forever ) && ( 'mark-as-forever' == $mark_as_forever ) ){
                $expire = false;
            }

            // Authenticate, is Ad expire by date?
            if( ( ! empty( $ad_expire_in_day ) ) && ( 0 !== (int)$ad_expire_in_day ) ){
                $ad_published   = get_the_date( "d-m-Y", $ad_id );                    
                $date           = date_create( $ad_published );
                date_add( $date, date_interval_create_from_date_string( $ad_expire_in_day .' days' ) );
                $expire_date    = date_format( $date, "d-m-Y" );

                $expire_date         = strtotime( $expire_date );
                $current_date   = strtotime( date( "d-m-Y" ) );

                if( $current_date > $expire_date ){
                    $expire = true;
                }
            }// Expire by day closer
            
            // Authenticate, is Ad expire by time?
            if( ! empty( $ad_expire_in_hour ) && ( 0 !== (int)$ad_expire_in_hour ) ){
                $ad_published       = get_the_date( "d-m-Y", $ad_id );                    
                $date               = date_create( $ad_published );
                date_add( $date, date_interval_create_from_date_string( $ad_expire_in_hour .' hours' ) );
                $expire_time        = date_format( $date, "d-m-Y g:i A" );
                $expire_strtotime   = strtotime( $expire_time );
                $current_strtotime  = strtotime( date( 'h:i A', time() ) );

                if ( $current_strtotime > $expire_strtotime ){
                    $expire = true;
                }
            }// Expire by hours closer
            
            // If Ad expire
            if ( true == $expire ){
                // After ad expire ad place is hide
                if( ! empty( $after_expire ) && ( 'leave_place' == $after_expire ) ){
                    $data = array(
                        'ID'            => $ad_id,
                        'post_status'   => 'pending'
                    );                               
                    wp_update_post( $data );
                }

                // After ad expire show image for contact
                if( ! empty( $after_expire ) && ( 'contact_image' == $after_expire ) ){
                    ?>
                    <img class="directorist-img_ad_<?php echo $page.'_'.$ad_place; ?>" src="<?php echo $contact_image_url;?>" alt="">
                    <?php
                }
                
            }


            // If Ad isn't expire 
            if( false == $expire ){
                // Authenticate, Is ad type image and have image url
                if( ( 'image' == $ad_type ) && ( ! empty( $image_ad_image_url ) ) ){
                    ?>
                    <a href="<?php echo $terget_url; ?>" target="<?php echo $open_link; ?>" rel="<?php echo $rel; ?>">
                        <img class="directorist-img_ad_<?php echo $page.'_'.$ad_place; ?>" src="<?php echo $image_ad_image_url; ?>" alt="">
                    </a>
                    <?php
                }

                // Authenticate, Is ad type custom code
                if( ( 'custom_code' == $ad_type ) ){
                    return <<<EOD
<a href="{$terget_url}" target="{$open_link}" rel="{$rel}">
<div>{$ad_code}</div>
</a>
EOD;
                }
                
                // Authenticate, Is ad type google or facebook ad
                if( ( 'google_adsense' == $ad_type ) || ( 'facebook_pixel' == $ad_type ) ){             
                    return <<<EOD
<div class="">{$ad_code}</div>
EOD;
                }
            }
            
        }// Function closer




        /**
         * This function get & return the transferable data PHP file to JS file
         * 
         * @return array
         */
        public static function data_transfer_php_to_js_file()
        {
            // All pages ad places            
            $all_lis_ad_places          = self::all_lis_ad_places();
            $single_lis_ad_places       = self::single_lis_ad_places();
            $all_cat_ad_places          = self::all_cat_ad_places();
            $single_cat_ad_places       = self::single_cat_ad_places();
            $all_loc_ad_places          = self::all_loc_ad_places();
            $single_loc_ad_places       = self::single_loc_ad_places();
            $add_lis_ad_places          = self::add_lis_ad_places();
            $dashboard_ad_places        = self::dashboard_ad_places();
            $auth_lis_ad_places         = self::auth_lis_ad_places();
            $search_home_ad_places      = self::search_home_ad_places();
            $search_result_ad_places    = self::search_result_ad_places();

            /**************************   START Disabled places  ***************************/
            // Which palces are selected for other Ad, thats places are disable current post
            $disable_all_lis_places         = self::get_selected_places_in_a_page( 'all_listings', 'swbdpam_all_listings_ad_places', $all_lis_ad_places );

            $disable_single_lis_places      = self::get_selected_places_in_a_page( 'single_listing', 'swbdpam_single_listing_ad_places', $single_lis_ad_places );

            $disable_all_cat_places         = self::get_selected_places_in_a_page( 'all_categories', 'swbdpam_all_cat_ad_places',$all_cat_ad_places );

            $disable_single_cat_places      = self::get_selected_places_in_a_page( 'single_category', 'swbdpam_single_category_ad_places',$single_cat_ad_places );

            $disable_all_loc_places         = self::get_selected_places_in_a_page( 'all_location', 'swbdpam_all_loc_ad_places', $all_loc_ad_places );
            
            $disable_single_loc_places      = self::get_selected_places_in_a_page( 'single_location', 'swbdpam_single_location_ad_places', $single_loc_ad_places );

            $disable_add_lis_places         = self::get_selected_places_in_a_page( 'add_listing', 'swbdpam_add_listing_ad_places', $add_lis_ad_places );

            $disable_dashboard_places       = self::get_selected_places_in_a_page( 'dashboard', 'swbdpam_dashboard_ad_places', $dashboard_ad_places );

            $disable_auth_lis_places        = self::get_selected_places_in_a_page( 'author_profile', 'swbdpam_author_listings_ad_places', $auth_lis_ad_places );

            $disable_search_home_places     = self::get_selected_places_in_a_page( 'search_home', 'swbdpam_search_home_ad_places', $search_home_ad_places );

            $disable_search_result_places   = self::get_selected_places_in_a_page( 'search_result', 'swbdpam_search_result_ad_places', $search_result_ad_places );
            /**************************   END Disabled places  ***************************/
            

            /**************************   START Enable places  ***************************/
            // Current Post All-Listing page Selected ad Places
            $enable_all_lis_places          = self::get_current_post_selected_ad_places( 'swbdpam_all_listings_ad_places' );
            
            // Current Post Single Listing page Selected ad Places
            $enable_single_lis_places       = self::get_current_post_selected_ad_places( 'swbdpam_single_listing_ad_places' );
            
            // Current Post All-Categories page Selected ad Places
            $enable_all_cat_places          = self::get_current_post_selected_ad_places( 'swbdpam_all_cat_ad_places' );

            // Current Post Single Category page Selected ad Places
            $enable_single_cat_places       = self::get_current_post_selected_ad_places( 'swbdpam_single_category_ad_places' );
            
            // Current Post All-Locations page Selected ad Places
            $enable_all_loc_places          = self::get_current_post_selected_ad_places( 'swbdpam_all_loc_ad_places' );

            // Current Post Single Location page Selected ad Places
            $enable_single_loc_places       = self::get_current_post_selected_ad_places( 'swbdpam_single_location_ad_places' );
            
            // Current Post Add Listing page Selected ad Places
            $enable_add_lis_places          = self::get_current_post_selected_ad_places( 'swbdpam_add_listing_ad_places' );
            
            // Current Post Dashboard page Selected ad Places
            $enable_dashboard_places        = self::get_current_post_selected_ad_places( 'swbdpam_dashboard_ad_places' );
            
            // Current Post Author Profile page Selected ad Places
            $enable_auth_lis_places         = self::get_current_post_selected_ad_places( 'swbdpam_author_listings_ad_places' );
            
            // Current Post Search Home page Selected ad Places
            $enable_search_home_places      = self::get_current_post_selected_ad_places( 'swbdpam_search_home_ad_places' );
            
            // Current Post Search Result page Selected ad Places
            $enable_search_result_places    = self::get_current_post_selected_ad_places( 'swbdpam_search_result_ad_places' );
            /**************************   START Enable places  ***************************/


            // This array variable transfer PHP file to js file
            $transmission_data = array(
                'ajaxurl'                   => admin_url('admin-ajax.php'),
                'adsense_ad_label'          => __( 'Insert Google AdSense Code', 'directorist-adverts-manager' ),
                'facebook_ad_label'         => __( 'Insert Facebook Pixel Code', 'directorist-adverts-manager' ),
                'custom_code_ad_label'      => __( 'Insert Custom HTML/JS Code', 'directorist-adverts-manager' ),
 
                //
                'disableAllLisPlaces'       => $disable_all_lis_places,
                'disableSingleLisPlaces'    => $disable_single_lis_places,
                'disableAllCatPlaces'       => $disable_all_cat_places,
                'disableSingleCatPlaces'    => $disable_single_cat_places,
                'disableAllLocPlaces'       => $disable_all_loc_places,
                'disableSingleLocPlaces'    => $disable_single_loc_places,
                'disableAddLisPlaces'       => $disable_add_lis_places,
                'disableDashboardPlaces'    => $disable_dashboard_places,
                'disableAuthLisPlaces'      => $disable_auth_lis_places,
                'disableSearchHomePlaces'   => $disable_search_home_places,
                'disableSearchResultPlaces' => $disable_search_result_places,
                //
                'enableAllLisPlaces'        => $enable_all_lis_places,
                'enableSingleLisPlaces'     => $enable_single_lis_places,
                'enableAllCatPlaces'        => $enable_all_cat_places,
                'enableSingleCatPlaces'     => $enable_single_cat_places,
                'enableAllLocPlaces'        => $enable_all_loc_places,
                'enableSingleLocPlaces'     => $enable_single_loc_places,
                'enableAddLisPlaces'        => $enable_add_lis_places,
                'enableDashboardPlaces'     => $enable_dashboard_places,
                'enableAuthLisPlaces'       => $enable_auth_lis_places,
                'enableSearchHomePlaces'    => $enable_search_home_places,
                'enableSearchResultPlaces'  => $enable_search_result_places,
            );

            return $transmission_data;

        } // Function closer

    }// End class
}