<?php
/**
 * @package  Directorist - Ads Manager
 */
 

if( ! class_exists( 'SWBDPAMExtnSettings' ) ){
    /**
     * Plugin's Settings handler class
     */
    class SWBDPAMExtnSettings
    {
        /**
        * Class constructor
        * Call all hooks which we wanna triger
        */
        public function register()
        {   
            // Ads Manager plugin's enable option hook
            add_filter( 'atbdp_listing_type_settings_field_list', array( $this, 'atbdp_listing_type_settings_field_list' ) );
            add_filter( 'atbdp_extension_fields', array( $this, 'atbdp_extension_fields' ) );
            // push license settings
            add_filter('atbdp_license_settings_controls', array( $this, 'ads_license_settings_controls'), 10, 1);

             // licence activation
             add_action('wp_ajax_atbdp_ads_license_activation', array( $this, 'atbdp_ads_license_activation'));
             // license deactivation
             add_action('wp_ajax_atbdp_ads_license_deactivation', array( $this, 'atbdp_ads_license_deactivation'));
            // Hook remover
            add_action( 'plugins_loaded', array( $this, 'swbdpam_hook_remove' ) );
        }

        public function atbdp_extension_fields(  $fields ) {
            $fields[] = ['swbdp_ads_manager_is_enable'];
            return $fields;
        }
    
        public function atbdp_listing_type_settings_field_list( $ads_fields ) {
            $ads_fields['swbdp_ads_manager_is_enable'] = [
                'label'             => __( 'Enable Ads Manager', 'directorist-adverts-manager'),  // In extn general section
                'description'       => __( 'Process and manage ads which display on your site.', 'directorist-adverts-manager' ),
                'type'              => 'toggle',
                'value'             => true,
            ];
            
            return $ads_fields;
        }

        public function atbdp_ads_license_deactivation()
        {
            $license = !empty($_POST['ads_license']) ? trim($_POST['ads_license']) : '';
            $options = get_option('atbdp_option');
            $options['ads_license'] = $license;
            update_option('atbdp_option', $options);
            update_option('directorist_ads_license', $license);
            $data = array();
            if (!empty($license)) {
                // data to send in our API request
                $api_params = array(
                    'edd_action' => 'deactivate_license',
                    'license' => $license,
                    'item_id' => ATBDP_ADS_POST_ID, // The ID of the item in EDD
                    'url' => home_url()
                );
                // Call the custom API.
                $response = wp_remote_post(ATBDP_AUTHOR_URL, array('timeout' => 15, 'sslverify' => false, 'body' => $api_params));
                
                // make sure the response came back okay
                if (is_wp_error($response) || 200 !== wp_remote_retrieve_response_code($response)) {

                    $data['msg'] = (is_wp_error($response) && !empty($response->get_error_message())) ? $response->get_error_message() : __('An error occurred, please try again.', 'directorist-adverts-manager');
                    $data['status'] = false;

                } else {
                    $license_data = json_decode(wp_remote_retrieve_body($response));
                    if (!$license_data) {
                        $data['status'] = false;
                        $data['msg'] = __('Response not found!', 'directorist-adverts-manager');
                        wp_send_json($data);
                        die();
                    }
                    update_option('directorist_ads_license_status', $license_data->license);
                    if (false === $license_data->success) {
                        switch ($license_data->error) {
                            case 'expired' :
                                $data['msg'] = sprintf(
                                    __('Your license key expired on %s.', 'directorist-adverts-manager'),
                                    date_i18n(get_option('date_format'), strtotime($license_data->expires, current_time('timestamp')))
                                );
                                $data['status'] = false;
                                break;

                            case 'revoked' :
                                $data['status'] = false;
                                $data['msg'] = __('Your license key has been disabled.', 'directorist-adverts-manager');
                                break;

                            case 'missing' :

                                $data['msg'] = __('Invalid license.', 'directorist-adverts-manager');
                                $data['status'] = false;
                                break;

                            case 'invalid' :
                            case 'site_inactive' :

                                $data['msg'] = __('Your license is not active for this URL.', 'directorist-adverts-manager');
                                $data['status'] = false;
                                break;

                            case 'item_name_mismatch' :

                                $data['msg'] = sprintf(__('This appears to be an invalid license key for %s.', 'directorist-adverts-manager'), 'Directorist - Ads Manager');
                                $data['status'] = false;
                                break;

                            case 'no_activations_left':

                                $data['msg'] = __('Your license key has reached its activation limit.', 'directorist-adverts-manager');
                                $data['status'] = false;
                                break;

                            default :
                                $data['msg'] = __('An error occurred, please try again.', 'directorist-adverts-manager');
                                $data['status'] = false;
                                break;
                        }

                    } else {
                        $data['status'] = true;
                        $data['msg'] = __('License deactivated successfully!', 'directorist-adverts-manager');
                    }

                }
            } else {
                $data['status'] = false;
                $data['msg'] = __('License not found!', 'directorist-adverts-manager');
            }
            wp_send_json($data);
            die();
        }


        public function atbdp_ads_license_activation()
        {
            $license = !empty($_POST['ads_license']) ? trim($_POST['ads_license']) : '';
            $options = get_option('atbdp_option');
            $options['ads_license'] = $license;
            update_option('atbdp_option', $options);
            update_option('directorist_ads_license', $license);
            $data = array();
            if (!empty($license)) {
                // data to send in our API request
                $api_params = array(
                    'edd_action' => 'activate_license',
                    'license' => $license,
                    'item_id' => ATBDP_ADS_POST_ID, // The ID of the item in EDD
                    'url' => home_url()
                );
                // Call the custom API.
                $response = wp_remote_post(ATBDP_AUTHOR_URL, array('timeout' => 15, 'sslverify' => false, 'body' => $api_params));
               
                // make sure the response came back okay
                if (is_wp_error($response) || 200 !== wp_remote_retrieve_response_code($response)) {

                    $data['msg'] = (is_wp_error($response) && !empty($response->get_error_message())) ? $response->get_error_message() : __('An error occurred, please try again.', 'directorist-adverts-manager');
                    $data['status'] = false;

                } else {

                    $license_data = json_decode(wp_remote_retrieve_body($response));
                    if (!$license_data) {
                        $data['status'] = false;
                        $data['msg'] = __('Response not found!', 'directorist-adverts-manager');
                        wp_send_json($data);
                        die();
                    }
                    update_option('directorist_ads_license_status', $license_data->license);
                    if (false === $license_data->success) {
                        switch ($license_data->error) {
                            case 'expired' :
                                $data['msg'] = sprintf(
                                    __('Your license key expired on %s.', 'directorist-adverts-manager'),
                                    date_i18n(get_option('date_format'), strtotime($license_data->expires, current_time('timestamp')))
                                );
                                $data['status'] = false;
                                break;

                            case 'revoked' :
                                $data['status'] = false;
                                $data['msg'] = __('Your license key has been disabled.', 'directorist-adverts-manager');
                                break;

                            case 'missing' :

                                $data['msg'] = __('Invalid license.', 'directorist-adverts-manager');
                                $data['status'] = false;
                                break;

                            case 'invalid' :
                            case 'site_inactive' :

                                $data['msg'] = __('Your license is not active for this URL.', 'directorist-adverts-manager');
                                $data['status'] = false;
                                break;

                            case 'item_name_mismatch' :

                                $data['msg'] = sprintf(__('This appears to be an invalid license key for %s.', 'directorist-adverts-manager'), 'Directorist - Ads Manager');
                                $data['status'] = false;
                                break;

                            case 'no_activations_left':

                                $data['msg'] = __('Your license key has reached its activation limit.', 'directorist-adverts-manager');
                                $data['status'] = false;
                                break;

                            default :
                                $data['msg'] = __('An error occurred, please try again.', 'directorist-adverts-manager');
                                $data['status'] = false;
                                break;
                        }

                    } else {
                        $data['status'] = true;
                        $data['msg'] = __('License activated successfully!', 'directorist-adverts-manager');
                    }

                }
            } else {
                $data['status'] = false;
                $data['msg'] = __('License not found!', 'directorist-adverts-manager');
            }
            wp_send_json($data);
            die();
        }


        public function ads_license_settings_controls($default)
        {
            
            $status = get_option('directorist_ads_license_status');
            if (!empty($status) && ($status !== false && $status == 'valid')) {
                $action = array(
                    'type' => 'toggle',
                    'name' => 'ads-deactivated',
                    'label' => __('Action', 'directorist-adverts-manager'),
                    'validation' => 'numeric',
                );
            } else {
                $action = array(
                    'type' => 'toggle',
                    'name' => 'ads-activated',
                    'label' => __('Action', 'directorist-adverts-manager'),
                    'validation' => 'numeric',
                );
            }
            $new = apply_filters('atbdp_ads_extension_controls', array(
                'type' => 'section',
                'title' => __('Ads Manager', 'directorist-adverts-manager'),
                'description' => __('You can active your Ads Manager extension license
                 here.', 'directorist-adverts-manager'),
                'fields' => apply_filters('atbdp_ads_license_settings_field', array(
                    array(
                        'type' => 'textbox',
                        'name' => 'ads_license',
                        'label' => __('License', 'directorist-adverts-manager'),
                        'description' => __('Enter your Ads Manager extension license', 'directorist-adverts-manager'),
                        'default' => '',
                    ),
                    $action
                )),

            ));
            $settings = apply_filters('atbdp_licence_menu_for_ads', true);
            if($settings){
                array_push($default, $new);
            }
            return $default;
        }

        /**
         * Settings hook remover function
         */
        public function swbdpam_hook_remove()
        {
            // Get Ads Manager enable option
            $is_ads_manager_enable = get_directorist_option( 'swbdp_ads_manager_is_enable', 1 );

            // Authenticate, is Ads Manager enable or not
            if( 1 !== (int)$is_ads_manager_enable ){
                remove_filter( 'atbdp_extension_settings_submenus', array( $this, 'add_ads_manager_settings_submenu' ) );

            }
        }

    }// End class
}