<?php
/**
 * @package  Directorist - Ads Manager
 */


if( ! class_exists( 'SWBDPAMEnqueue' ) ){
    /**
    * All style & script files enqueue handler class
    */
    class SWBDPAMEnqueue
    {
        /**
         * Class constructor
         * Call all hooks which we wanna triger
         */
        public function register()
        {
            // Admin enqueue hook
            add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_script' ) );
            // Frontend enqueue hook
            add_action( 'wp_enqueue_scripts', array( $this, 'frontend_enqueue_script' ) );

            // Hook remover
            add_action( 'plugins_loaded', array( $this, 'swbdpam_hook_remover' ) );
        }



        /**
         * Register & enqueue all admin scripts & styles
         *
         * @return void
         */
        public function admin_enqueue_script( $page )
        {
            // Register admin style
            wp_register_style( 'swbdpam-admin-css', SWBDPAM_ADMIN_CSS.'swbdpam-admin.css', time() );
            // Register admin ajax script
            wp_register_script( 'swbdpam-admin-js', SWBDPAM_ADMIN_JS.'swbdpam-admin.js', true );            
            // Register WP custom code editor JS
            wp_register_script( 'swbdpam-custom-code-editor-js', SWBDPAM_ADMIN_JS.'swbdpam-custom-code-editor.js', array( 'jquery' ), '', true );
            
            $screen = get_current_screen();
            if( ( SWBDPAM_POST_TYPE == $screen->post_type ) || ( 'at_biz_dir_page_aazztech_settings' === $page ) ) {
                // Enqueue admin style
                wp_enqueue_style( 'swbdpam-admin-css' );
                // Enqueue admin ajax script
                wp_enqueue_script( 'swbdpam-admin-js' );
                // Enque WP custom code editor
                wp_enqueue_code_editor( array( 'type' => 'text/html' ) );
                // Register WP custom code editor JS
                wp_enqueue_script( 'swbdpam-custom-code-editor-js' );
                
                $get_transmission_data = SWBDPAMHelperFunctions::data_transfer_php_to_js_file();

                // Send data PHP file to js file
                wp_localize_script(
                    // Which file we wanna send the value or variable thats file enqueue handle
                    'swbdpam-admin-js',           // File handle
                    // This object name, we can use anything
                    'sendVarible',              // Object name
                    $get_transmission_data      // It's a variable                    
                );

            }
        }


        
        /**
         * Register & enqueue all frontend scripts & styles
         *
         * @return void
         */
        public function frontend_enqueue_script()
        {
            // Register frontend style
            wp_register_style( 'swbdpam-frontend-css', SWBDPAM_FRONTEND_CSS.'swbdpam-frontend.css', time() );

            // Enqueue frontend style
            wp_enqueue_style( 'swbdpam-frontend-css' );
            // By this method link the dynamic css
            wp_add_inline_style( 'swbdpam-frontend-css', SWBDPAMDynamicStyle::swbdpam_dynamic_css() );
        }



        /**
         * Remove hooks when Ads Manager is disable
         */
        public function swbdpam_hook_remover()
        {
            // Get Ads Manager enable option
            $is_ads_manager_enable = get_directorist_option( 'swbdp_ads_manager_is_enable', 1 );

            // Authenticate, is Ads Manager enable or not
            if( 1 !== ( int )$is_ads_manager_enable ){
                remove_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_script' ) );
                remove_action( 'wp_enqueue_scripts', array( $this, 'frontend_enqueue_script' ) );
            }
        }
        
    }// End class
}