<?php
/**
 * @package  Directorist - Ads Manager
 */

if( ! class_exists( 'SWBDPAMDynamicStyle' ) ){
    /**
     * Custom CSS handler class
     */
    class SWBDPAMDynamicStyle
    {
        /**
         * Ads size handler function
         * 
         * @return Ads size
         */
        public static function swbdpam_dynamic_css()
        {            
            // Add listing page ad's IDs
            $add_lis_be_hed_id  = SWBDPAMHelperFunctions::get_ad_id( 'add_listing', 'swbdpam_add_listing_ad_places', 'before-header' );
            $add_lis_bant_id    = SWBDPAMHelperFunctions::get_ad_id( 'add_listing', 'swbdpam_add_listing_ad_places', 'before-add-new-title' );
            $add_lis_aspb_id    = SWBDPAMHelperFunctions::get_ad_id( 'add_listing', 'swbdpam_add_listing_ad_places', 'after-save-preview-btn' );
            $add_lis_aft_fot_id = SWBDPAMHelperFunctions::get_ad_id( 'add_listing', 'swbdpam_add_listing_ad_places', 'after-footer' );

            // All listing page ad's IDs
            $all_lis_be_hed_id      = SWBDPAMHelperFunctions::get_ad_id( 'all_listings', 'swbdpam_all_listings_ad_places', 'before-header' );
            $all_lis_be_fil_id      = SWBDPAMHelperFunctions::get_ad_id( 'all_listings', 'swbdpam_all_listings_ad_places', 'before-filter' );
            $all_lis_aft_fil_id     = SWBDPAMHelperFunctions::get_ad_id( 'all_listings', 'swbdpam_all_listings_ad_places', 'after-filter' );
            $all_lis_as_card_id     = SWBDPAMHelperFunctions::get_ad_id( 'all_listings', 'swbdpam_all_listings_ad_places', 'as-card-in-loop' );
            $all_lis_full_row_id    = SWBDPAMHelperFunctions::get_ad_id( 'all_listings', 'swbdpam_all_listings_ad_places', 'full-row-in-loop' );
            $all_lis_be_pagi_id     = SWBDPAMHelperFunctions::get_ad_id( 'all_listings', 'swbdpam_all_listings_ad_places', 'before-pagination' );
            $all_lis_aft_pagi_id    = SWBDPAMHelperFunctions::get_ad_id( 'all_listings', 'swbdpam_all_listings_ad_places', 'after-pagination' );
            $all_lis_aft_fot_id     = SWBDPAMHelperFunctions::get_ad_id( 'all_listings', 'swbdpam_all_listings_ad_places', 'after-footer' );

            // Single listing page ad's IDs
            $sing_lis_be_hed_id     = SWBDPAMHelperFunctions::get_ad_id( 'single_listing', 'swbdpam_single_listing_ad_places', 'before-header' );
            $sing_lis_ati_id        = SWBDPAMHelperFunctions::get_ad_id( 'single_listing', 'swbdpam_single_listing_ad_places', 'after-title' );
            $sing_lis_arl_id        = SWBDPAMHelperFunctions::get_ad_id( 'single_listing', 'swbdpam_single_listing_ad_places', 'after-related-listing' );
            $sing_lis_aft_fot_id    = SWBDPAMHelperFunctions::get_ad_id( 'single_listing', 'swbdpam_single_listing_ad_places', 'after-footer' );

            // All-Categories page ad's IDs
            $all_cat_be_hed_id  = SWBDPAMHelperFunctions::get_ad_id( 'all_categories', 'swbdpam_all_cat_ad_places', 'before-header' );
            $all_cat_be_lp_id   = SWBDPAMHelperFunctions::get_ad_id( 'all_categories', 'swbdpam_all_cat_ad_places', 'before-loop' );
            $all_cat_aft_lp_id  = SWBDPAMHelperFunctions::get_ad_id( 'all_categories', 'swbdpam_all_cat_ad_places', 'after-loop' );
            $all_cat_aft_fot_id = SWBDPAMHelperFunctions::get_ad_id( 'all_categories', 'swbdpam_all_cat_ad_places', 'after-footer' );

            // Single Category page ad's IDs
            $sing_cat_be_hed_id     = SWBDPAMHelperFunctions::get_ad_id( 'single_category', 'swbdpam_single_category_ad_places', 'before-header' );
            $sing_cat_be_fil_id     = SWBDPAMHelperFunctions::get_ad_id( 'single_category', 'swbdpam_single_category_ad_places', 'before-filter' );
            $sing_cat_aft_fil_id    = SWBDPAMHelperFunctions::get_ad_id( 'single_category', 'swbdpam_single_category_ad_places', 'after-filter' );
            $sing_cat_as_card_id    = SWBDPAMHelperFunctions::get_ad_id( 'single_category', 'swbdpam_single_category_ad_places', 'as-card-in-loop' );
            $sing_cat_full_row_id   = SWBDPAMHelperFunctions::get_ad_id( 'single_category', 'swbdpam_single_category_ad_places', 'full-row-in-loop' );
            $sing_cat_aft_lop_id    = SWBDPAMHelperFunctions::get_ad_id( 'single_category', 'swbdpam_single_category_ad_places', 'after-loop' );
            $sing_cat_aft_fot_id    = SWBDPAMHelperFunctions::get_ad_id( 'single_category', 'swbdpam_single_category_ad_places', 'after-footer' );

            // All-Categories page ad's IDs
            $all_loc_be_hed_id  = SWBDPAMHelperFunctions::get_ad_id( 'all_locations', 'swbdpam_all_loc_ad_places', 'before-header' );
            $all_loc_be_lp_id   = SWBDPAMHelperFunctions::get_ad_id( 'all_locations', 'swbdpam_all_loc_ad_places', 'before-loop' );
            $all_loc_aft_lp_id  = SWBDPAMHelperFunctions::get_ad_id( 'all_locations', 'swbdpam_all_loc_ad_places', 'after-loop' );
            $all_loc_aft_fot_id = SWBDPAMHelperFunctions::get_ad_id( 'all_locations', 'swbdpam_all_loc_ad_places', 'after-footer' );

            // Single Location page ad's IDs
            $sing_loc_be_hed_id     = SWBDPAMHelperFunctions::get_ad_id( 'single_location', 'swbdpam_single_location_ad_places', 'before-header' );
            $sing_loc_be_fil_id     = SWBDPAMHelperFunctions::get_ad_id( 'single_location', 'swbdpam_single_location_ad_places', 'before-filter' );
            $sing_loc_aft_fil_id    = SWBDPAMHelperFunctions::get_ad_id( 'single_location', 'swbdpam_single_location_ad_places', 'after-filter' );
            $sing_loc_as_card_id    = SWBDPAMHelperFunctions::get_ad_id( 'single_location', 'swbdpam_single_location_ad_places', 'as-card-in-loop' );
            $sing_loc_full_row_id   = SWBDPAMHelperFunctions::get_ad_id( 'single_location', 'swbdpam_single_location_ad_places', 'full-row-in-loop' );
            $sing_loc_aft_lop_id    = SWBDPAMHelperFunctions::get_ad_id( 'single_location', 'swbdpam_single_location_ad_places', 'after-loop' );
            $sing_loc_aft_fot_id    = SWBDPAMHelperFunctions::get_ad_id( 'single_location', 'swbdpam_single_location_ad_places', 'after-footer' );

            // Author listings page ad's IDs
            $auth_lis_be_hed_id     = SWBDPAMHelperFunctions::get_ad_id( 'author_profile', 'swbdpam_author_listings_ad_places', 'before-header' );
            $auth_lis_be_ai_id      = SWBDPAMHelperFunctions::get_ad_id( 'author_profile', 'swbdpam_author_listings_ad_places', 'before-author-image' );
            $auth_lis_aft_ai_id     = SWBDPAMHelperFunctions::get_ad_id( 'author_profile', 'swbdpam_author_listings_ad_places', 'after-author-image' );
            $auth_lis_aft_aa_id     = SWBDPAMHelperFunctions::get_ad_id( 'author_profile', 'swbdpam_author_listings_ad_places', 'after-author-about' );
            $auth_lis_be_lop_id     = SWBDPAMHelperFunctions::get_ad_id( 'author_profile', 'swbdpam_author_listings_ad_places', 'before-loop' );
            $auth_lis_as_card_id    = SWBDPAMHelperFunctions::get_ad_id( 'author_profile', 'swbdpam_author_listings_ad_places', 'as-card-in-loop' );
            $auth_lis_full_row_id   = SWBDPAMHelperFunctions::get_ad_id( 'author_profile', 'swbdpam_author_listings_ad_places', 'full-row-in-loop' );
            $auth_lis_be_pagi_id    = SWBDPAMHelperFunctions::get_ad_id( 'author_profile', 'swbdpam_author_listings_ad_places', 'before-pagination' );
            $auth_lis_aft_fot_id    = SWBDPAMHelperFunctions::get_ad_id( 'author_profile', 'swbdpam_author_listings_ad_places', 'after-footer' );

            // User Dashboard page ad's IDs
            $user_dash_be_hed_id    = SWBDPAMHelperFunctions::get_ad_id( 'dashboard', 'swbdpam_dashboard_ad_places', 'before-header' );
            $user_dash_be_dm_id     = SWBDPAMHelperFunctions::get_ad_id( 'dashboard', 'swbdpam_dashboard_ad_places', 'before-dashboard-menu' );
            $user_dash_be_lop_id    = SWBDPAMHelperFunctions::get_ad_id( 'dashboard', 'swbdpam_dashboard_ad_places', 'before-loop' );
            $user_dash_as_card_id   = SWBDPAMHelperFunctions::get_ad_id( 'dashboard', 'swbdpam_dashboard_ad_places', 'as-card-in-loop' );
            $user_dash_full_row_id  = SWBDPAMHelperFunctions::get_ad_id( 'dashboard', 'swbdpam_dashboard_ad_places', 'full-row-in-loop' );
            $user_dash_be_pagi_id   = SWBDPAMHelperFunctions::get_ad_id( 'dashboard', 'swbdpam_dashboard_ad_places', 'before-pagination' );
            $user_dash_aft_fot_id   = SWBDPAMHelperFunctions::get_ad_id( 'dashboard', 'swbdpam_dashboard_ad_places', 'after-footer' );

            // Search Home page ad's IDs
            $sea_hom_be_hed_id  = SWBDPAMHelperFunctions::get_ad_id( 'search_home', 'swbdpam_search_home_ad_places', 'before-header' );
            $sea_hom_be_sb_id   = SWBDPAMHelperFunctions::get_ad_id( 'search_home', 'swbdpam_search_home_ad_places', 'before-search-bar' );
            $sea_hom_aft_sb_id  = SWBDPAMHelperFunctions::get_ad_id( 'search_home', 'swbdpam_search_home_ad_places', 'after-search-bar' );
            $sea_hom_aft_fot_id = SWBDPAMHelperFunctions::get_ad_id( 'search_home', 'swbdpam_search_home_ad_places', 'after-footer' );

            // Search Result page ad's IDs
            $sea_res_be_hed_id      = SWBDPAMHelperFunctions::get_ad_id( 'search_result', 'swbdpam_search_result_ad_places', 'before-header' );
            $sea_res_be_fil_id      = SWBDPAMHelperFunctions::get_ad_id( 'search_result', 'swbdpam_search_result_ad_places', 'before-filter' );
            $sea_res_aft_fil_id     = SWBDPAMHelperFunctions::get_ad_id( 'search_result', 'swbdpam_search_result_ad_places', 'after-filter' );
            $sea_res_as_card_id     = SWBDPAMHelperFunctions::get_ad_id( 'search_result', 'swbdpam_search_result_ad_places', 'as-card-in-loop' );
            $sea_res_full_row_id    = SWBDPAMHelperFunctions::get_ad_id( 'search_result', 'swbdpam_search_result_ad_places', 'full-row-in-loop' );
            $sea_res_aft_lop_id     = SWBDPAMHelperFunctions::get_ad_id( 'search_result', 'swbdpam_search_result_ad_places', 'after-loop' );
            $sea_res_aft_fot_id     = SWBDPAMHelperFunctions::get_ad_id( 'search_result', 'swbdpam_search_result_ad_places', 'after-footer' );
  
            // Add listing page ad's custom size
            $add_bh_width       = get_post_meta( $add_lis_be_hed_id, 'swbdpam_bhaf_ad_width', true );
            $add_bh_height      = get_post_meta( $add_lis_be_hed_id, 'swbdpam_bhaf_ad_height', true );
            $add_bant_width     = get_post_meta( $add_lis_bant_id, 'swbdpam_row_ad_width', true );
            $add_bant_height    = get_post_meta( $add_lis_bant_id, 'swbdpam_row_ad_height', true );  
            $add_aspb_width     = get_post_meta( $add_lis_aspb_id, 'swbdpam_row_ad_width', true );
            $add_aspb_height    = get_post_meta( $add_lis_aspb_id, 'swbdpam_row_ad_height', true );
            $add_afo_width      = get_post_meta( $add_lis_aft_fot_id, 'swbdpam_bhaf_ad_width', true );
            $add_afo_height     = get_post_meta( $add_lis_aft_fot_id, 'swbdpam_bhaf_ad_height', true );

            // All listings page ad's custom size
            $all_bh_width   = get_post_meta( $all_lis_be_hed_id, 'swbdpam_bhaf_ad_width', true );
            $all_bh_height  = get_post_meta( $all_lis_be_hed_id, 'swbdpam_bhaf_ad_height', true );
            $all_bf_width   = get_post_meta( $all_lis_be_fil_id, 'swbdpam_row_ad_width', true );
            $all_bf_height  = get_post_meta( $all_lis_be_fil_id, 'swbdpam_row_ad_height', true );            
            $all_af_width   = get_post_meta( $all_lis_aft_fil_id, 'swbdpam_row_ad_width', true );
            $all_af_height  = get_post_meta( $all_lis_aft_fil_id, 'swbdpam_row_ad_height', true );            
            $all_ac_width   = get_post_meta( $all_lis_as_card_id, 'swbdpam_card_ad_width', true );
            $all_ac_height  = get_post_meta( $all_lis_as_card_id, 'swbdpam_card_ad_height', true );            
            $all_fr_width   = get_post_meta( $all_lis_full_row_id, 'swbdpam_row_ad_width', true );
            $all_fr_height  = get_post_meta( $all_lis_full_row_id, 'swbdpam_row_ad_height', true );            
            $all_bp_width   = get_post_meta( $all_lis_be_pagi_id, 'swbdpam_row_ad_width', true );
            $all_bp_height  = get_post_meta( $all_lis_be_pagi_id, 'swbdpam_row_ad_height', true );
            $all_ap_width   = get_post_meta( $all_lis_aft_pagi_id, 'swbdpam_row_ad_width', true );
            $all_ap_height  = get_post_meta( $all_lis_aft_pagi_id, 'swbdpam_row_ad_height', true );            
            $all_afo_width  = get_post_meta( $all_lis_aft_fot_id, 'swbdpam_bhaf_ad_width', true );
            $all_afo_height = get_post_meta( $all_lis_aft_fot_id, 'swbdpam_bhaf_ad_height', true );

            // Add listing page ad's custom size
            $sing_bh_width      = get_post_meta( $sing_lis_be_hed_id, 'swbdpam_bhaf_ad_width', true );
            $sing_bh_height     = get_post_meta( $sing_lis_be_hed_id, 'swbdpam_bhaf_ad_height', true );
            $sing_ati_width     = get_post_meta( $sing_lis_ati_id, 'swbdpam_row_ad_width', true );
            $sing_ati_height    = get_post_meta( $sing_lis_ati_id, 'swbdpam_row_ad_height', true );  
            $sing_arl_width     = get_post_meta( $sing_lis_arl_id, 'swbdpam_row_ad_width', true );
            $sing_arl_height    = get_post_meta( $sing_lis_arl_id, 'swbdpam_row_ad_height', true );
            $sing_afo_width     = get_post_meta( $sing_lis_aft_fot_id, 'swbdpam_bhaf_ad_width', true );
            $sing_afo_height    = get_post_meta( $sing_lis_aft_fot_id, 'swbdpam_bhaf_ad_height', true );

            // All-Categories page ad's custom size
            $all_cat_bh_width   = get_post_meta( $all_cat_be_hed_id, 'swbdpam_bhaf_ad_width', true );
            $all_cat_bh_height  = get_post_meta( $all_cat_be_hed_id, 'swbdpam_bhaf_ad_height', true );
            $all_cat_blp_width   = get_post_meta( $all_cat_be_lp_id, 'swbdpam_row_ad_width', true );
            $all_cat_blp_height  = get_post_meta( $all_cat_be_lp_id, 'swbdpam_row_ad_height', true );  
            $all_cat_alp_width   = get_post_meta( $all_cat_aft_lp_id, 'swbdpam_row_ad_width', true );
            $all_cat_alp_height  = get_post_meta( $all_cat_aft_lp_id, 'swbdpam_row_ad_height', true );
            $all_cat_afo_width  = get_post_meta( $all_cat_aft_fot_id, 'swbdpam_bhaf_ad_width', true );
            $all_cat_afo_height = get_post_meta( $all_cat_aft_fot_id, 'swbdpam_bhaf_ad_height', true );

            // Single Category page ad's custom size
            $sing_cat_bh_width      = get_post_meta( $sing_cat_be_hed_id, 'swbdpam_bhaf_ad_width', true );
            $sing_cat_bh_height     = get_post_meta( $sing_cat_be_hed_id, 'swbdpam_bhaf_ad_height', true );
            $sing_cat_bf_width      = get_post_meta( $sing_cat_be_fil_id, 'swbdpam_row_ad_width', true );
            $sing_cat_bf_height     = get_post_meta( $sing_cat_be_fil_id, 'swbdpam_row_ad_height', true );  
            $sing_cat_af_width      = get_post_meta( $sing_cat_aft_fil_id, 'swbdpam_row_ad_width', true );
            $sing_cat_af_height     = get_post_meta( $sing_cat_aft_fil_id, 'swbdpam_row_ad_height', true ); 
            $sing_cat_ac_width      = get_post_meta( $sing_cat_as_card_id, 'swbdpam_card_ad_width', true );
            $sing_cat_ac_height     = get_post_meta( $sing_cat_as_card_id, 'swbdpam_card_ad_height', true ); 
            $sing_cat_fr_width      = get_post_meta( $sing_cat_full_row_id, 'swbdpam_row_ad_width', true );
            $sing_cat_fr_height     = get_post_meta( $sing_cat_full_row_id, 'swbdpam_row_ad_height', true );
            $sing_cat_al_width      = get_post_meta( $sing_cat_aft_lop_id, 'swbdpam_row_ad_width', true );
            $sing_cat_al_height     = get_post_meta( $sing_cat_aft_lop_id, 'swbdpam_row_ad_height', true );
            $sing_cat_afo_width     = get_post_meta( $sing_cat_aft_fot_id, 'swbdpam_bhaf_ad_width', true );
            $sing_cat_afo_height    = get_post_meta( $sing_cat_aft_fot_id, 'swbdpam_bhaf_ad_height', true );

            // All-Locations page ad's custom size
            $all_loc_bh_width   = get_post_meta( $all_loc_be_hed_id, 'swbdpam_bhaf_ad_width', true );
            $all_loc_bh_height  = get_post_meta( $all_loc_be_hed_id, 'swbdpam_bhaf_ad_height', true );
            $all_loc_alp_width   = get_post_meta( $all_loc_be_lp_id, 'swbdpam_row_ad_width', true );
            $all_loc_alp_height  = get_post_meta( $all_loc_be_lp_id, 'swbdpam_row_ad_height', true );  
            $all_loc_alp_width   = get_post_meta( $all_loc_aft_lp_id, 'swbdpam_row_ad_width', true );
            $all_loc_alp_height  = get_post_meta( $all_loc_aft_lp_id, 'swbdpam_row_ad_height', true );
            $all_loc_afo_width  = get_post_meta( $all_loc_aft_fot_id, 'swbdpam_bhaf_ad_width', true );
            $all_loc_afo_height = get_post_meta( $all_loc_aft_fot_id, 'swbdpam_bhaf_ad_height', true );

            // Single Location page ad's custom size
            $sing_loc_bh_width      = get_post_meta( $sing_loc_be_hed_id, 'swbdpam_bhaf_ad_width', true );
            $sing_loc_bh_height     = get_post_meta( $sing_loc_be_hed_id, 'swbdpam_bhaf_ad_height', true );
            $sing_loc_bf_width      = get_post_meta( $sing_loc_be_fil_id, 'swbdpam_row_ad_width', true );
            $sing_loc_bf_height     = get_post_meta( $sing_loc_be_fil_id, 'swbdpam_row_ad_height', true );  
            $sing_loc_af_width      = get_post_meta( $sing_loc_aft_fil_id, 'swbdpam_row_ad_width', true );
            $sing_loc_af_height     = get_post_meta( $sing_loc_aft_fil_id, 'swbdpam_row_ad_height', true ); 
            $sing_loc_ac_width      = get_post_meta( $sing_loc_as_card_id, 'swbdpam_card_ad_width', true );
            $sing_loc_ac_height     = get_post_meta( $sing_loc_as_card_id, 'swbdpam_card_ad_height', true ); 
            $sing_loc_fr_width      = get_post_meta( $sing_loc_full_row_id, 'swbdpam _row_ad_width', true );
            $sing_loc_fr_height     = get_post_meta( $sing_loc_full_row_id, 'swbdpam _row_ad_height', true );
            $sing_loc_al_width      = get_post_meta( $sing_loc_aft_lop_id, 'swbdpam_row_ad_width', true );
            $sing_loc_al_height     = get_post_meta( $sing_loc_aft_lop_id, 'swbdpam_row_ad_height', true );
            $sing_loc_afo_width     = get_post_meta( $sing_loc_aft_fot_id, 'swbdpam_bhaf_ad_width', true );
            $sing_loc_afo_height    = get_post_meta( $sing_loc_aft_fot_id, 'swbdpam_bhaf_ad_height', true );

            // Author listings page ad's custom size
            $auth_lis_bh_width      = get_post_meta( $auth_lis_be_hed_id, 'swbdpam_bhaf_ad_width', true );
            $auth_lis_bh_height     = get_post_meta( $auth_lis_be_hed_id, 'swbdpam_bhaf_ad_height', true );
            $auth_lis_bai_width     = get_post_meta( $auth_lis_be_ai_id, 'swbdpam_row_ad_width', true );
            $auth_lis_bai_height    = get_post_meta( $auth_lis_be_ai_id, 'swbdpam_row_ad_height', true );  
            $auth_lis_aai_width     = get_post_meta( $auth_lis_aft_ai_id, 'swbdpam_row_ad_width', true );
            $auth_lis_aai_height    = get_post_meta( $auth_lis_aft_ai_id, 'swbdpam_row_ad_height', true ); 
            $auth_lis_aaa_width     = get_post_meta( $auth_lis_aft_aa_id, 'swbdpam_row_ad_width', true );
            $auth_lis_aaa_height    = get_post_meta( $auth_lis_aft_aa_id, 'swbdpam_row_ad_height', true );
            $auth_lis_bl_width      = get_post_meta( $auth_lis_be_lop_id, 'swbdpam_row_ad_width', true );
            $auth_lis_bl_height     = get_post_meta( $auth_lis_be_lop_id, 'swbdpam_row_ad_height', true );
            $auth_lis_ac_width      = get_post_meta( $auth_lis_as_card_id, 'swbdpam_card_ad_width', true );
            $auth_lis_ac_height     = get_post_meta( $auth_lis_as_card_id, 'swbdpam_card_ad_height', true ); 
            $auth_lis_fr_width      = get_post_meta( $auth_lis_full_row_id, 'swbdpam_row_ad_width', true );
            $auth_lis_fr_height     = get_post_meta( $auth_lis_full_row_id, 'swbdpam_row_ad_height', true );
            $auth_lis_bp_width      = get_post_meta( $auth_lis_be_pagi_id, 'swbdpam_row_ad_width', true );
            $auth_lis_bp_height     = get_post_meta( $auth_lis_be_pagi_id, 'swbdpam_row_ad_height', true );
            $auth_lis_afo_width     = get_post_meta( $auth_lis_aft_fot_id, 'swbdpam_bhaf_ad_width', true );
            $auth_lis_afo_height    = get_post_meta( $auth_lis_aft_fot_id, 'swbdpam_bhaf_ad_height', true );

            // User Dashboard page ad's custom size
            $user_dash_bh_width     = get_post_meta( $user_dash_be_hed_id, 'swbdpam_bhaf_ad_width', true );
            $user_dash_bh_height    = get_post_meta( $user_dash_be_hed_id, 'swbdpam_bhaf_ad_height', true );
            $user_dash_bdm_width    = get_post_meta( $user_dash_be_dm_id, 'swbdpam_row_ad_width', true );
            $user_dash_bdm_height   = get_post_meta( $user_dash_be_dm_id, 'swbdpam_row_ad_height', true );  
            $user_dash_bl_width     = get_post_meta( $user_dash_be_lop_id, 'swbdpam_row_ad_width', true );
            $user_dash_bl_height    = get_post_meta( $user_dash_be_lop_id, 'swbdpam_row_ad_height', true );
            $user_dash_ac_width     = get_post_meta( $user_dash_as_card_id, 'swbdpam_card_ad_width', true );
            $user_dash_ac_height    = get_post_meta( $user_dash_as_card_id, 'swbdpam_card_ad_height', true ); 
            $user_dash_fr_width     = get_post_meta( $user_dash_full_row_id, 'swbdpam_row_ad_width', true );
            $user_dash_fr_height    = get_post_meta( $user_dash_full_row_id, 'swbdpam_row_ad_height', true );
            $user_dash_bp_width     = get_post_meta( $user_dash_be_pagi_id, 'swbdpam_row_ad_width', true );
            $user_dash_bp_height    = get_post_meta( $user_dash_be_pagi_id, 'swbdpam_row_ad_height', true );
            $user_dash_afo_width    = get_post_meta( $user_dash_aft_fot_id, 'swbdpam_bhaf_ad_width', true );
            $user_dash_afo_height   = get_post_meta( $user_dash_aft_fot_id, 'swbdpam_bhaf_ad_height', true );

            // Search Home page ad's custom size
            $sea_hom_bh_width   = get_post_meta( $sea_hom_be_hed_id, 'swbdpam_bhaf_ad_width', true );
            $sea_hom_bh_height  = get_post_meta( $sea_hom_be_hed_id, 'swbdpam_bhaf_ad_height', true );
            $sea_hom_bsb_width  = get_post_meta( $sea_hom_be_sb_id, 'swbdpam_row_ad_width', true );
            $sea_hom_bsb_height = get_post_meta( $sea_hom_be_sb_id, 'swbdpam_row_ad_height', true );  
            $sea_hom_asb_width  = get_post_meta( $sea_hom_aft_sb_id, 'swbdpam_row_ad_width', true );
            $sea_hom_asb_height = get_post_meta( $sea_hom_aft_sb_id, 'swbdpam_row_ad_height', true );
            $sea_hom_afo_width  = get_post_meta( $sea_hom_aft_fot_id, 'swbdpam_bhaf_ad_width', true );
            $sea_hom_afo_height = get_post_meta( $sea_hom_aft_fot_id, 'swbdpam_bhaf_ad_height', true );

            // Search Result page ad's custom size
            $sea_res_bh_width   = get_post_meta( $sea_res_be_hed_id, 'swbdpam_bhaf_ad_width', true );
            $sea_res_bh_height  = get_post_meta( $sea_res_be_hed_id, 'swbdpam_bhaf_ad_height', true );
            $sea_res_bf_width   = get_post_meta( $sea_res_be_fil_id, 'swbdpam_row_ad_width', true );
            $sea_res_bf_height  = get_post_meta( $sea_res_be_fil_id, 'swbdpam_row_ad_height', true );  
            $sea_res_af_width   = get_post_meta( $sea_res_aft_fil_id, 'swbdpam_row_ad_width', true );
            $sea_res_af_height  = get_post_meta( $sea_res_aft_fil_id, 'swbdpam_row_ad_height', true ); 
            $sea_res_ac_width   = get_post_meta( $sea_res_as_card_id, 'swbdpam_card_ad_width', true );
            $sea_res_ac_height  = get_post_meta( $sea_res_as_card_id, 'swbdpam_card_ad_height', true ); 
            $sea_res_fr_width   = get_post_meta( $sea_res_full_row_id, 'swbdpam_row_ad_width', true );
            $sea_res_fr_height  = get_post_meta( $sea_res_full_row_id, 'swbdpam_row_ad_height', true );
            $sea_res_al_width   = get_post_meta( $sea_res_aft_lop_id, 'swbdpam_row_ad_width', true );
            $sea_res_al_height  = get_post_meta( $sea_res_aft_lop_id, 'swbdpam_row_ad_height', true );
            $sea_res_afo_width  = get_post_meta( $sea_res_aft_fot_id, 'swbdpam_bhaf_ad_width', true );
            $sea_res_afo_height = get_post_meta( $sea_res_aft_fot_id, 'swbdpam_bhaf_ad_height', true );

            ob_start();
            ?>

            /**********************   START Add-listing Page ads size   ***********************/
            div.directorist-add-ad-before-header {
                width: <?php echo ! empty( $add_bh_width ) ? $add_bh_width : '1000'; ?>px;
                height: <?php echo ! empty( $add_bh_height ) ? $add_bh_height : '200'; ?>px;
            }

            div.directorist-add-ad-before-add-new-title {
                width: <?php echo ! empty( $add_bant_width ) ? $add_bant_width : '800'; ?>px;
                height: <?php echo ! empty( $add_bant_height ) ? $add_bant_height : '150'; ?>px;
            }

            div.directorist-add-ad-after-save-preview-btn {
                width: <?php echo ! empty( $add_aspb_width ) ? $add_aspb_width : '800'; ?>px;
                height: <?php echo ! empty( $add_aspb_height ) ? $add_aspb_height : '150'; ?>px;
            }

            div.directorist-add-ad-after-footer {
                width: <?php echo ! empty( $add_afo_width ) ? $add_afo_width : '1000'; ?>px;
                height: <?php echo ! empty( $add_afo_height ) ? $add_afo_height : '200'; ?>px;
            }
            /**********************   END Add-listing Page ads size   ***********************/
 

            /**********************   START All-listings Page ads size   ***********************/
            div.directorist-all-ad-before-header {
                width: <?php echo ! empty( $all_bh_width ) ? $all_bh_width : '1000'; ?>px;
                height: <?php echo ! empty( $all_bh_height ) ? $all_bh_height : '200'; ?>px;
            }

            div.directorist-all-ad-before-filter {
                width: <?php echo ! empty( $all_bf_width ) ? $all_bf_width : '800'; ?>px;
                height: <?php echo ! empty( $all_bf_height ) ? $all_bf_height : '150'; ?>px;
            }

            div.directorist-all-ad-after-filter {
                width: <?php echo ! empty( $all_af_width ) ? $all_af_width : '800'; ?>px;
                height: <?php echo ! empty( $all_af_height ) ? $all_af_height : '150'; ?>px;
            }

            div.swbdpam__all_ad_as_card_in_loop {
                width: <?php echo ! empty( $all_ac_width ) ? $all_ac_width : '800'; ?>px;
                height: <?php echo ! empty( $all_ac_height ) ? $all_ac_height : '150'; ?>px;
            }

            div.swbdpam__all_ad_full_row_in_loop {
                width: <?php echo ! empty( $all_fr_width ) ? $all_fr_width : '800'; ?>px;
                height: <?php echo ! empty( $all_fr_height ) ? $all_fr_height : '150'; ?>px;
            }

            div.directorist-all-ad-before-pagination {
                width: <?php echo ! empty( $all_bp_width ) ? $all_bp_width : '800'; ?>px;
                height: <?php echo ! empty( $all_bp_height ) ? $all_bp_height : '150'; ?>px;
            }

            div.directorist-all-ad-after-pagination {
                width: <?php echo ! empty( $all_ap_width ) ? $all_ap_width : '800'; ?>px;
                height: <?php echo ! empty( $all_ap_height ) ? $all_ap_height : '150'; ?>px;
            }

            div.directorist-all-ad-after-footer {
                width: <?php echo ! empty( $all_afo_width ) ? $all_afo_width : '1000'; ?>px;
                height: <?php echo ! empty( $all_afo_height ) ? $all_afo_height : '200'; ?>px;
            }
            /**********************   END All-listings Page ads size   ***********************/



            /**********************   START Single Listing Page ads size   ***********************/
            div.directorist-single-list-ad-before-header {
                width: <?php echo ! empty( $sing_bh_width ) ? $sing_bh_width : '1000'; ?>px;
                height: <?php echo ! empty( $sing_bh_height ) ? $sing_bh_height : '200'; ?>px;
            }

            div.directorist-single-list-ad-after-title {
                width: <?php echo ! empty( $sing_ati_width ) ? $sing_ati_width : '800'; ?>px;
                height: <?php echo ! empty( $sing_ati_height ) ? $sing_ati_height : '150'; ?>px;
            }

            div.swbdpam__sing_lis_ad_after_related_listing {
                width: <?php echo ! empty( $sing_arl_width ) ? $sing_arl_width : '800'; ?>px;
                height: <?php echo ! empty( $sing_arl_height ) ? $sing_arl_height : '150'; ?>px;
            }

            div.directorist-single-list-add-after-footer {
                width: <?php echo ! empty( $sing_afo_width ) ? $sing_afo_width : '1000'; ?>px;
                height: <?php echo ! empty( $sing_afo_height ) ? $sing_afo_height : '200'; ?>px;
            }
            /**********************   END Single Listing Page ads size   ***********************/


            /**********************   START All-Categories Page ads size   ***********************/
            div.directorist-all-cat-add-before-header {
                width: <?php echo ! empty( $all_cat_bh_width ) ? $all_cat_bh_width : '1000'; ?>px;
                height: <?php echo ! empty( $all_cat_bh_height ) ? $all_cat_bh_height : '200'; ?>px;
            }

            div.directorist-all-cat-ad-before-loop {
                width: <?php echo ! empty( $all_cat_blp_width ) ? $all_cat_blp_width : '800'; ?>px;
                height: <?php echo ! empty( $all_cat_blp_height ) ? $all_cat_blp_height : '150'; ?>px;
            }

            div.directorist-all-cat-ad-after-loop {
                width: <?php echo ! empty( $all_cat_alp_width ) ? $all_cat_alp_width : '800'; ?>px;
                height: <?php echo ! empty( $all_cat_alp_height ) ? $all_cat_alp_height : '150'; ?>px;
            }

            div.directorist-all-cat-ad-after-footer {
                width: <?php echo ! empty( $all_cat_afo_width ) ? $all_cat_afo_width : '1000'; ?>px;
                height: <?php echo ! empty( $all_cat_afo_height ) ? $all_cat_afo_height : '200'; ?>px;
            }
            /**********************   END All-Categories Page ads size   ***********************/


            /**********************   START Single Category Page ads size   ***********************/
            div.directorist-single-cat-add-before-header {
                width: <?php echo ! empty( $sing_cat_bh_width ) ? $sing_cat_bh_width : '1000'; ?>px;
                height: <?php echo ! empty( $sing_cat_bh_height ) ? $sing_cat_bh_height : '200'; ?>px;
            }

            div.directorist-single-cat-ad-before-filter {
                width: <?php echo ! empty( $sing_cat_bf_width ) ? $sing_cat_bf_width : '800'; ?>px;
                height: <?php echo ! empty( $sing_cat_bf_height ) ? $sing_cat_bf_height : '150'; ?>px;
            }

            div.directorist-single-cat-ad-after-filter {
                width: <?php echo ! empty( $sing_cat_af_width ) ? $sing_cat_af_width : '800'; ?>px;
                height: <?php echo ! empty( $sing_cat_af_height ) ? $sing_cat_af_height : '150'; ?>px;
            }

            div.swbdpam__sing_cat_ad_as_card_in_loop {
                width: <?php echo ! empty( $sing_cat_ac_width ) ? $sing_cat_ac_width : '800'; ?>px;
                height: <?php echo ! empty( $sing_cat_ac_height ) ? $sing_cat_ac_height : '150'; ?>px;
            }

            div.swbdpam__sing_cat_ad_full_row_in_loop {
                width: <?php echo ! empty( $sing_cat_fr_width ) ? $sing_cat_fr_width : '800'; ?>px;
                height: <?php echo ! empty( $sing_cat_fr_height ) ? $sing_cat_fr_height : '150'; ?>px;
            }

            div.directorist-single-cat-ad-after-loop {
                width: <?php echo ! empty( $sing_cat_al_width ) ? $sing_cat_al_width : '800'; ?>px;
                height: <?php echo ! empty( $sing_cat_al_height ) ? $sing_cat_al_height : '150'; ?>px;
            }

            div.directorist-single-cat-add-after-footer {
                width: <?php echo ! empty( $sing_cat_afo_width ) ? $sing_cat_afo_width : '1000'; ?>px;
                height: <?php echo ! empty( $sing_cat_afo_height ) ? $sing_cat_afo_height : '200'; ?>px;
            }
            /**********************   END Single Category Page ads size   ***********************/

            /**********************   START All-Location Page ads size   ***********************/
            div.directorist-all-loc-ad-before-header {
                width: <?php echo ! empty( $all_loc_bh_width ) ? $all_loc_bh_width : '1000'; ?>px;
                height: <?php echo ! empty( $all_loc_bh_height ) ? $all_loc_bh_height : '200'; ?>px;
            }
            div.directorist-all-loc-ad-before-loop {
                width: <?php echo ! empty( $all_loc_bsb_width ) ? $all_loc_bsb_width : '800'; ?>px;
                height: <?php echo ! empty( $all_loc_bsb_height ) ? $all_loc_bsb_height : '150'; ?>px;
            }
            div.directorist-all-loc-ad-after-loop {
                width: <?php echo ! empty( $all_loc_asb_width ) ? $all_loc_asb_width : '800'; ?>px;
                height: <?php echo ! empty( $all_loc_asb_height ) ? $all_loc_asb_height : '150'; ?>px;
            }

            div.directorist-all-loc-ad-after-footer {
                width: <?php echo ! empty( $all_loc_afo_width ) ? $all_loc_afo_width : '1000'; ?>px;
                height: <?php echo ! empty( $all_loc_afo_height ) ? $all_loc_afo_height : '200'; ?>px;
            }
            /**********************   END All-Location Page ads size   ***********************/

            /**********************   START Single Location Page ads size   ***********************/
            div.directorist-single-loc-add-before-header {
                width: <?php echo ! empty( $sing_loc_bh_width ) ? $sing_loc_bh_width : '1000'; ?>px;
                height: <?php echo ! empty( $sing_loc_bh_height ) ? $sing_loc_bh_height : '200'; ?>px;
            }

            div.directorist-single-loc-ad-before-filter {
                width: <?php echo ! empty( $sing_loc_bf_width ) ? $sing_loc_bf_width : '800'; ?>px;
                height: <?php echo ! empty( $sing_loc_bf_height ) ? $sing_loc_bf_height : '150'; ?>px;
            }

            div.directorist-single-loc-ad-after-filter {
                width: <?php echo ! empty( $sing_loc_af_width ) ? $sing_loc_af_width : '800'; ?>px;
                height: <?php echo ! empty( $sing_loc_af_height ) ? $sing_loc_af_height : '150'; ?>px;
            }

            div.swbdpam__sing_loc_ad_as_card_in_loop {
                width: <?php echo ! empty( $sing_loc_ac_width ) ? $sing_loc_ac_width : '800'; ?>px;
                height: <?php echo ! empty( $sing_loc_ac_height ) ? $sing_loc_ac_height : '150'; ?>px;
            }

            div.swbdpam__sing_loc_ad_full_row_in_loop {
                width: <?php echo ! empty( $sing_loc_fr_width ) ? $sing_loc_fr_width : '800'; ?>px;
                height: <?php echo ! empty( $sing_loc_fr_height ) ? $sing_loc_fr_height : '150'; ?>px;
            }

            div.directorist-single-loc-ad-after-loop {
                width: <?php echo ! empty( $sing_loc_al_width ) ? $sing_loc_al_width : '800'; ?>px;
                height: <?php echo ! empty( $sing_loc_al_height ) ? $sing_loc_al_height : '150'; ?>px;
            }

            div.directorist-single-loc-add-after-footer {
                width: <?php echo ! empty( $sing_loc_afo_width ) ? $sing_loc_afo_width : '1000'; ?>px;
                height: <?php echo ! empty( $sing_loc_afo_height ) ? $sing_loc_afo_height : '200'; ?>px;
            }
            /**********************   END Single Location Page ads size   ***********************/



            /**********************   START Suthor Listings Page ads size   ***********************/
            div.directorist-add-author-ad-before-header {
                width: <?php echo ! empty( $auth_lis_bh_width ) ? $auth_lis_bh_width : '1000'; ?>px;
                height: <?php echo ! empty( $auth_lis_bh_height ) ? $auth_lis_bh_height : '200'; ?>px;
            }

            div.directorist-author-ad-before-author-img {
                width: <?php echo ! empty( $auth_lis_bai_width ) ? $auth_lis_bai_width : '800'; ?>px;
                height: <?php echo ! empty( $auth_lis_bai_height ) ? $auth_lis_bai_height : '150'; ?>px;
            }

            div.directorist-author-ad-after-author-img {
                width: <?php echo ! empty( $auth_lis_aai_width ) ? $auth_lis_aai_width : '800'; ?>px;
                height: <?php echo ! empty( $auth_lis_aai_height ) ? $auth_lis_aai_height : '150'; ?>px;
            }

            div.directorist-author-ad-after-author-about {
                width: <?php echo ! empty( $auth_lis_aaa_width ) ? $auth_lis_aaa_width : '800'; ?>px;
                height: <?php echo ! empty( $auth_lis_aaa_height ) ? $auth_lis_aaa_height : '150'; ?>px;
            }

            div.directorist-author-ad-before-loop {
                width: <?php echo ! empty( $auth_lis_bl_width ) ? $auth_lis_bl_width : '800'; ?>px;
                height: <?php echo ! empty( $auth_lis_bl_height ) ? $auth_lis_bl_height : '150'; ?>px;
            }

            div.swbdpam__auth_ad_as_card_in_loop { 
                width: <?php echo ! empty( $auth_lis_ac_width ) ? $auth_lis_ac_width : '800'; ?>px; 
                height: <?php echo ! empty( $auth_lis_ac_height ) ? $auth_lis_ac_height : '150'; ?>px; 
            }

            div.swbdpam__auth_ad_full_row_in_loop { 
                width: <?php echo ! empty( $auth_lis_fr_width ) ? $auth_lis_fr_width : '800'; ?>px;
                height: <?php echo ! empty( $auth_lis_fr_height ) ? $auth_lis_fr_height : '150'; ?>px;
            }

            div.directorist-auth-ad-before-pagination {
                width: <?php echo ! empty( $auth_lis_bp_width ) ? $auth_lis_bp_width : '800'; ?>px;
                height: <?php echo ! empty( $auth_lis_bp_height ) ? $auth_lis_bp_height : '150'; ?>px;
            }

            div.directorist-add-author-ad-after-footer {
                width: <?php echo ! empty( $auth_lis_afo_width ) ? $auth_lis_afo_width : '1000'; ?>px;
                height: <?php echo ! empty( $auth_lis_afo_height ) ? $auth_lis_afo_height : '200'; ?>px;
            }
            /**********************   END Suthor Listings Page ads size   ***********************/



            /**********************   START User Dashboard Page ads size   ***********************/
            div.directorist-dashboard-ad-before-header {
                width: <?php echo ! empty( $user_dash_bh_width ) ? $user_dash_bh_width : '1000'; ?>px;
                height: <?php echo ! empty( $user_dash_bh_height ) ? $user_dash_bh_height : '200'; ?>px;
            }

            div.directorist-dash-ad-before-dashboard-menu {
                width: <?php echo ! empty( $user_dash_bdm_width ) ? $user_dash_bdm_width : '800'; ?>px;
                height: <?php echo ! empty( $user_dash_bdm_height ) ? $user_dash_bdm_height : '150'; ?>px;
            }

            div.directorist-dash-ad-before-loop {
                width: <?php echo ! empty( $user_dash_bl_width ) ? $user_dash_bl_width : '800'; ?>px;
                height: <?php echo ! empty( $user_dash_bl_height ) ? $user_dash_bl_height : '150'; ?>px;
            }

            div.swbdpam__dash_ad_as_card_in_loop {
                width: <?php echo ! empty( $user_dash_ac_width ) ? $user_dash_ac_width : '800'; ?>px;
                height: <?php echo ! empty( $user_dash_ac_height ) ? $user_dash_ac_height : '150'; ?>px;
            }

            div.directorist-dash-ad-full-row-in-loop {
                width: <?php echo ! empty( $user_dash_fr_width ) ? $user_dash_fr_width : '800'; ?>px;
                height: <?php echo ! empty( $user_dash_fr_height ) ? $user_dash_fr_height : '150'; ?>px;
            }

            div.directorist-s-home-ad-before-pagination {
                width: <?php echo ! empty( $user_dash_bp_width ) ? $user_dash_bp_width : '800'; ?>px;
                height: <?php echo ! empty( $user_dash_bp_height ) ? $user_dash_bp_height : '150'; ?>px;
            }

            div.directorist-dashboard-ad-after-footer {
                width: <?php echo ! empty( $user_dash_afo_width ) ? $user_dash_afo_width : '1000'; ?>px;
                height: <?php echo ! empty( $user_dash_afo_height ) ? $user_dash_afo_height : '200'; ?>px;
            }
            /**********************   END User Dashboard Page ads size   ***********************/



            /**********************   START Search Home Page ads size   ***********************/
            div.directorist-s-home-ad-before-header {
                width: <?php echo ! empty( $sea_hom_bh_width ) ? $sea_hom_bh_width : '1000'; ?>px;
                height: <?php echo ! empty( $sea_hom_bh_height ) ? $sea_hom_bh_height : '200'; ?>px;
            }

            div.directorist-s-home-ad-before-search-bar {
                width: <?php echo ! empty( $sea_hom_bsb_width ) ? $sea_hom_bsb_width : '800'; ?>px;
                height: <?php echo ! empty( $sea_hom_bsb_height ) ? $sea_hom_bsb_height : '150'; ?>px;
            }

            div.directorist-s-home-ad-after-search-bar {
                width: <?php echo ! empty( $sea_hom_asb_width ) ? $sea_hom_asb_width : '800'; ?>px;
                height: <?php echo ! empty( $sea_hom_asb_height ) ? $sea_hom_asb_height : '150'; ?>px;
            }

            div.directorist-s-home-ad-after-footer {
                width: <?php echo ! empty( $sea_hom_afo_width ) ? $sea_hom_afo_width : '1000'; ?>px;
                height: <?php echo ! empty( $sea_hom_afo_height ) ? $sea_hom_afo_height : '200'; ?>px;
            }
            /**********************   END Search Home Page ads size   ***********************/

            
            /**************************  START Search Result Page ads size   ****************************/
            div.directorist-s-result-ad-before-header {
                width: <?php echo ! empty( $sea_res_bh_width ) ? $sea_res_bh_width : '1000'; ?>px;
                height: <?php echo ! empty( $sea_res_bh_height ) ? $sea_res_bh_height : '200'; ?>px;
            }

            div.directorist-s-result-ad-before-filter {
                width: <?php echo ! empty( $sea_res_bf_width ) ? $sea_res_bf_width : '800'; ?>px;
                height: <?php echo ! empty( $sea_res_bf_height ) ? $sea_res_bf_height : '150'; ?>px;
            }

            div.directorist-s-result-ad-after-filter {
                width: <?php echo ! empty( $sea_res_af_width ) ? $sea_res_af_width : '800'; ?>px;
                height: <?php echo ! empty( $sea_res_af_height ) ? $sea_res_af_height : '150'; ?>px;
            }

            div.swbdpam__s_result_ad_as_card_in_loop {
                width: <?php echo ! empty( $sea_res_ac_width ) ? $sea_res_ac_width : '800'; ?>px;
                height: <?php echo ! empty( $sea_res_ac_height ) ? $sea_res_ac_height : '150'; ?>px;
            }

            div.swbdpam__s_result_ad_full_row_in_loop {
                width: <?php echo ! empty( $sea_res_fr_width ) ? $sea_res_fr_width : '800'; ?>px;
                height: <?php echo ! empty( $sea_res_fr_height ) ? $sea_res_fr_height : '150'; ?>px;
            }

            div.directorist-s-result-ad-after-loop {
                width: <?php echo ! empty( $sea_res_al_width ) ? $sea_res_al_width : '800'; ?>px;
                height: <?php echo ! empty( $sea_res_al_height ) ? $sea_res_al_height : '150'; ?>px;
            }

            div.directorist-s-result-ad-after-footer {
                width: <?php echo ! empty( $sea_res_afo_width ) ? $sea_res_afo_width : '1000'; ?>px;
                height: <?php echo ! empty( $sea_res_afo_height ) ? $sea_res_afo_height : '200'; ?>px;
            }
            /**************************  START Search Result Page ads size   ****************************/





            /**********************   START Add-listing Page image ads size   ***********************/
            .directorist-img_ad_add_listing_before-header {
                width: <?php echo ! empty( $add_bh_width ) ? $add_bh_width : '1000'; ?>px;
                height: <?php echo ! empty( $add_bh_height ) ? $add_bh_height : '200'; ?>px;
            }

            .directorist-img_ad_add_listing_before-add-new-title {
                width: <?php echo ! empty( $add_bant_width ) ? $add_bant_width : '800'; ?>px;
                height: <?php echo ! empty( $add_bant_height ) ? $add_bant_height : '150'; ?>px;
            }

            .directorist-img_ad_add_listing_after-save-preview-btn {
                width: <?php echo ! empty( $add_aspb_width ) ? $add_aspb_width : '800'; ?>px;
                height: <?php echo ! empty( $add_aspb_height ) ? $add_aspb_height : '150'; ?>px;
            }

            .directorist-img_ad_add_listing_after-footer {
                width: <?php echo ! empty( $add_afo_width ) ? $add_afo_width : '1000'; ?>px;
                height: <?php echo ! empty( $add_afo_height ) ? $add_afo_height : '200'; ?>px;
            }
            /**********************    END Add-listing Page image ads size    ***********************/


            /**********************   START All-listings Page image ads size   ***********************/
            .directorist-img_ad_all_listings_before-header {                
                width: <?php echo ! empty( $all_bh_width ) ? $all_bh_width : '1000'; ?>px;
                height: <?php echo ! empty( $all_bh_height ) ? $all_bh_height : '200'; ?>px;
            }

            .directorist-img_ad_all_listings_before-filter {
                width: <?php echo ! empty( $all_bf_width ) ? $all_bf_width : '800'; ?>px;
                height: <?php echo ! empty( $all_bf_height ) ? $all_bf_height : '150'; ?>px;
            }

            .directorist-img_ad_all_listings_after-filter {
                width: <?php echo ! empty( $all_af_width ) ? $all_af_width : '800'; ?>px;
                height: <?php echo ! empty( $all_af_height ) ? $all_af_height : '150'; ?>px;
            }

            .directorist-img_ad_all_listings_as-card-in-loop {
               width: <?php echo ! empty( $all_ac_width ) ? $all_ac_width : '350'; ?>px;
               height: <?php echo ! empty( $all_ac_height ) ? $all_ac_height : '260'; ?>px;
            }

            .directorist-img_ad_all_listings_full-row-in-loop {
               width: <?php echo ! empty( $all_fr_width ) ? $all_fr_width : '800'; ?>px;
               height: <?php echo ! empty( $all_fr_height ) ? $all_fr_height : '150'; ?>px;
            }

            .directorist-img_ad_all_listings_before-pagination {
                width: <?php echo ! empty( $all_bp_width ) ? $all_bp_width : '800'; ?>px;
                height: <?php echo ! empty( $all_bp_height ) ? $all_bp_height : '150'; ?>px;
            }

            .directorist-img_ad_all_listings_after-pagination {
                width: <?php echo ! empty( $all_ap_width ) ? $all_ap_width : '800'; ?>px;
                height: <?php echo ! empty( $all_ap_height ) ? $all_ap_height : '150'; ?>px;
            }

            .directorist-img_ad_all_listings_after-footer {
                width: <?php echo ! empty( $all_afo_width ) ? $all_afo_width : '1000'; ?>px;
                height: <?php echo ! empty( $all_afo_height ) ? $all_afo_height : '200'; ?>px;
            }
            /**********************    END All-listings Page image ads size    ***********************/


            /**********************   START Single listing Page image ads size   ***********************/
            .directorist-img_ad_single_listing_before-header {
                width: <?php echo ! empty( $sing_bh_width ) ? $sing_bh_width : '1000'; ?>px;
                height: <?php echo ! empty( $sing_bh_height ) ? $sing_bh_height : '200'; ?>px;
            }

            .directorist-img_ad_single_listing_after-title {
                width: <?php echo ! empty( $sing_ati_width ) ? $sing_ati_width : '800'; ?>px;
                height: <?php echo ! empty( $sing_ati_height ) ? $sing_ati_height : '150'; ?>px;
            }

            .directorist-img_ad_single_listing_after-related-listing {
                width: <?php echo ! empty( $sing_arl_width ) ? $sing_arl_width : '800'; ?>px;
                height: <?php echo ! empty( $sing_arl_height ) ? $sing_arl_height : '150'; ?>px;
            }

            .directorist-img_ad_single_listing_after-footer {
                width: <?php echo ! empty( $sing_afo_width ) ? $sing_afo_width : '1000'; ?>px;
                height: <?php echo ! empty( $sing_afo_height ) ? $sing_afo_height : '200'; ?>px;
            }
            /**********************    END Add-listing Page image ads size    ***********************/

            /**********************   START All-Categories Page image ads size   ***********************/
            .directorist-img_ad_all_categories_before-header {
                width: <?php echo ! empty( $all_cat_bh_width ) ? $all_cat_bh_width : '1000'; ?>px;
                height: <?php echo ! empty( $all_cat_bh_height ) ? $all_cat_bh_height : '200'; ?>px;
            }

            .directorist-img_ad_all_categories_before-loop {
                width: <?php echo ! empty( $all_cat_blp_width ) ? $all_cat_blp_width : '800'; ?>px;
                height: <?php echo ! empty( $all_cat_blp_height ) ? $all_cat_blp_height : '150'; ?>px;
            }

            .directorist-img_ad_all_categories_after-loop {
                width: <?php echo ! empty( $all_cat_alp_width ) ? $all_cat_alp_width : '800'; ?>px;
                height: <?php echo ! empty( $all_cat_alp_height ) ? $all_cat_alp_height : '150'; ?>px;
            }

            .directorist-img_ad_all_categories_after-footer {
                width: <?php echo ! empty( $all_cat_afo_width ) ? $all_cat_afo_width : '1000'; ?>px;
                height: <?php echo ! empty( $all_cat_afo_height ) ? $all_cat_afo_height : '200'; ?>px;
            }
            /**********************   END All-Categories Page image ads size   ***********************/

            /**********************   START Single Category Page image ads size   ***********************/
            .directorist-img_ad_single_category_before-header {
                width: <?php echo ! empty( $sing_cat_bh_width ) ? $sing_cat_bh_width : '1000'; ?>px;
                height: <?php echo ! empty( $sing_cat_bh_height ) ? $sing_cat_bh_height : '200'; ?>px;
            }

            .directorist-img_ad_single_category_before-filter {
                width: <?php echo ! empty( $sing_cat_bf_width ) ? $sing_cat_bf_width : '800'; ?>px;
                height: <?php echo ! empty( $sing_cat_bf_height ) ? $sing_cat_bf_height : '150'; ?>px;
            }

            .directorist-img_ad_single_category_after-filter {
                width: <?php echo ! empty( $sing_cat_af_width ) ? $sing_cat_af_width : '800'; ?>px;
                height: <?php echo ! empty( $sing_cat_af_height ) ? $sing_cat_af_height : '150'; ?>px;
            }

            .directorist-img_ad_single_category_as-card-in-loop {
                width: <?php echo ! empty( $sing_cat_ac_width ) ? $sing_cat_ac_width : '800'; ?>px;
                height: <?php echo ! empty( $sing_cat_ac_height ) ? $sing_cat_ac_height : '150'; ?>px;
            }

            .directorist-img_ad_single_category_full-row-in-loop {
                width: <?php echo ! empty( $sing_cat_fr_width ) ? $sing_cat_fr_width : '800'; ?>px;
                height: <?php echo ! empty( $sing_cat_fr_height ) ? $sing_cat_fr_height : '150'; ?>px;
            }

            .directorist-img_ad_single_category_after-loop {
                width: <?php echo ! empty( $sing_cat_al_width ) ? $sing_cat_al_width : '800'; ?>px;
                height: <?php echo ! empty( $sing_cat_al_height ) ? $sing_cat_al_height : '150'; ?>px;
            }

            .directorist-img_ad_single_category_after-footer {
                width: <?php echo ! empty( $sing_cat_afo_width ) ? $sing_cat_afo_width : '1000'; ?>px;
                height: <?php echo ! empty( $sing_cat_afo_height ) ? $sing_cat_afo_height : '200'; ?>px;
            }
            /**********************    END Single Category Page image ads size    ***********************/

            /**********************   START All-Location Page image ads size   ***********************/
            .directorist-img_ad_all_location_before-header {
                width: <?php echo ! empty( $all_loc_bh_width ) ? $all_loc_bh_width : '1000'; ?>px;
                height: <?php echo ! empty( $all_loc_bh_height ) ? $all_loc_bh_height : '200'; ?>px;
            }
            .directorist-img_ad_all_location_before-loop {
                width: <?php echo ! empty( $all_loc_blp_width ) ? $all_loc_blp_width : '800'; ?>px;
                height: <?php echo ! empty( $all_loc_blp_height ) ? $all_loc_blp_height : '150'; ?>px;
            }
            .directorist-img_ad_all_location_after-loop {
                width: <?php echo ! empty( $all_loc_alp_width ) ? $all_loc_alp_width : '800'; ?>px;
                height: <?php echo ! empty( $all_loc_alp_height ) ? $all_loc_alp_height : '150'; ?>px;
            }
            .directorist-img_ad_all_location_after-footer {
                width: <?php echo ! empty( $all_loc_afo_width ) ? $all_loc_afo_width : '1000'; ?>px;
                height: <?php echo ! empty( $all_loc_afo_height ) ? $all_loc_afo_height : '200'; ?>px;
            }
            /**********************   END All-Location Page image ads size   ***********************/

            /**********************   START Single Location Page image ads size   ***********************/
            .directorist-img_ad_single_location_before-header {
                width: <?php echo ! empty( $sing_loc_bh_width ) ? $sing_loc_bh_width : '1000'; ?>px;
                height: <?php echo ! empty( $sing_loc_bh_height ) ? $sing_loc_bh_height : '200'; ?>px;
            }

            .directorist-img_ad_single_location_before-filter {
                width: <?php echo ! empty( $sing_loc_bf_width ) ? $sing_loc_bf_width : '800'; ?>px;
                height: <?php echo ! empty( $sing_loc_bf_height ) ? $sing_loc_bf_height : '150'; ?>px;
            }

            .directorist-img_ad_single_location_after-filter {
                width: <?php echo ! empty( $sing_loc_af_width ) ? $sing_loc_af_width : '800'; ?>px;
                height: <?php echo ! empty( $sing_loc_af_height ) ? $sing_loc_af_height : '150'; ?>px;
            }

            .directorist-img_ad_single_location_as-card-in-loop {
                width: <?php echo ! empty( $sing_loc_ac_width ) ? $sing_loc_ac_width : '800'; ?>px;
                height: <?php echo ! empty( $sing_loc_ac_height ) ? $sing_loc_ac_height : '150'; ?>px;
            }

            .directorist-img_ad_single_location_full-row-in-loop {
                width: <?php echo ! empty( $sing_loc_fr_width ) ? $sing_loc_fr_width : '800'; ?>px;
                height: <?php echo ! empty( $sing_loc_fr_height ) ? $sing_loc_fr_height : '150'; ?>px;
            }

            .directorist-img_ad_single_location_after-loop {
               width: <?php echo ! empty( $sing_loc_al_width ) ? $sing_loc_al_width : '800'; ?>px;
               height: <?php echo ! empty( $sing_loc_al_height ) ? $sing_loc_al_height : '150'; ?>px;
            }

            .directorist-img_ad_single_location_after-footer {
                width: <?php echo ! empty( $sing_loc_afo_width ) ? $sing_loc_afo_width : '1000'; ?>px;
                height: <?php echo ! empty( $sing_loc_afo_height ) ? $sing_loc_afo_height : '200'; ?>px;
            }
            /**********************   END Single Location Page image ads size   ***********************/


            /**********************   START Author listings Page image ads size   ***********************/
            .directorist-img_ad_author_profile_before-header {
                width: <?php echo ! empty( $auth_lis_bh_width ) ? $auth_lis_bh_width : '1000'; ?>px;
                height: <?php echo ! empty( $auth_lis_bh_height ) ? $auth_lis_bh_height : '200'; ?>px;
            }

            .directorist-img_ad_author_profile_before-author-image {
                width: <?php echo ! empty( $auth_lis_bai_width ) ? $auth_lis_bai_width : '800'; ?>px;
                height: <?php echo ! empty( $auth_lis_bai_height ) ? $auth_lis_bai_height : '150'; ?>px;
            }

            .directorist-img_ad_author_profile_after-author-image {
                width: <?php echo ! empty( $auth_lis_aai_width ) ? $auth_lis_aai_width : '800'; ?>px;
                height: <?php echo ! empty( $auth_lis_aai_height ) ? $auth_lis_aai_height : '150'; ?>px;
            }

            .directorist-img_ad_author_profile_after-author-about {
                width: <?php echo ! empty( $auth_lis_aaa_width ) ? $auth_lis_aaa_width : '800'; ?>px;
                height: <?php echo ! empty( $auth_lis_aaa_height ) ? $auth_lis_aaa_height : '150'; ?>px;
            }

            .directorist-img_ad_author_profile_before-loop {
                width: <?php echo ! empty( $auth_lis_bl_width ) ? $auth_lis_bl_width : '800'; ?>px;
                height: <?php echo ! empty( $auth_lis_bl_height ) ? $auth_lis_bl_height : '150'; ?>px;
            }

            .directorist-img_ad_author_profile_as-card-in-loop {
                width: <?php echo ! empty( $auth_lis_ac_width ) ? $auth_lis_ac_width : '800'; ?>px; 
                height: <?php echo ! empty( $auth_lis_ac_height ) ? $auth_lis_ac_height : '150'; ?>px; 
            }

            .directorist-img_ad_author_profile_full-row-in-loop {
                width: <?php echo ! empty( $auth_lis_fr_width ) ? $auth_lis_fr_width : '800'; ?>px;
                height: <?php echo ! empty( $auth_lis_fr_height ) ? $auth_lis_fr_height : '150'; ?>px;
            }

            .directorist-img_ad_author_profile_before-pagination {
                width: <?php echo ! empty( $auth_lis_bp_width ) ? $auth_lis_bp_width : '800'; ?>px;
                height: <?php echo ! empty( $auth_lis_bp_height ) ? $auth_lis_bp_height : '150'; ?>px;
            }

            .directorist-img_ad_author_profile_after-footer {
                width: <?php echo ! empty( $auth_lis_afo_width ) ? $auth_lis_afo_width : '1000'; ?>px;
                height: <?php echo ! empty( $auth_lis_afo_height ) ? $auth_lis_afo_height : '200'; ?>px;
            }
            /**********************   END Author listings Page image ads size   ***********************/


            /**********************   START User Dashboard Page image ads size   ***********************/
            .directorist-img_ad_dashboard_before-header {
                width: <?php echo ! empty( $user_dash_bh_width ) ? $user_dash_bh_width : '1000'; ?>px;
                height: <?php echo ! empty( $user_dash_bh_height ) ? $user_dash_bh_height : '200'; ?>px;
            }

            .directorist-img_ad_dashboard_before-dashboard-menu {
                width: <?php echo ! empty( $user_dash_bdm_width ) ? $user_dash_bdm_width : '800'; ?>px;
                height: <?php echo ! empty( $user_dash_bdm_height ) ? $user_dash_bdm_height : '150'; ?>px;
            }

            .directorist-img_ad_dashboard_before-loop {
                width: <?php echo ! empty( $user_dash_bl_width ) ? $user_dash_bl_width : '800'; ?>px;
                height: <?php echo ! empty( $user_dash_bl_height ) ? $user_dash_bl_height : '150'; ?>px;
            }

            .directorist-img_ad_dashboard_as-card-in-loop {
                width: <?php echo ! empty( $user_dash_ac_width ) ? $user_dash_ac_width : '800'; ?>px;
                height: <?php echo ! empty( $user_dash_ac_height ) ? $user_dash_ac_height : '150'; ?>px;
            }

            .directorist-img_ad_dashboard_full-row-in-loop {
                width: <?php echo ! empty( $user_dash_fr_width ) ? $user_dash_fr_width : '800'; ?>px;
                height: <?php echo ! empty( $user_dash_fr_height ) ? $user_dash_fr_height : '150'; ?>px;
            }

            .directorist-img_ad_dashboard_before-pagination {
                width: <?php echo ! empty( $user_dash_bp_width ) ? $user_dash_bp_width : '800'; ?>px;            
                height: <?php echo ! empty( $user_dash_bp_height ) ? $user_dash_bp_height : '150'; ?>px;            
            }

            .directorist-img_ad_dashboard_after-footer {
                width: <?php echo ! empty( $user_dash_afo_width ) ? $user_dash_afo_width : '1000'; ?>px;
                height: <?php echo ! empty( $user_dash_afo_height ) ? $user_dash_afo_height : '200'; ?>px;
            }
            /**********************   END User Dashboard Page image ads size   ***********************/


            /**********************   START User Dashboard Page image ads size   ***********************/
            .directorist-img_ad_search_home_before-header {
                width: <?php echo ! empty( $sea_hom_bh_width ) ? $sea_hom_bh_width : '1000'; ?>px;
                height: <?php echo ! empty( $sea_hom_bh_height ) ? $sea_hom_bh_height : '200'; ?>px;
            }

            .directorist-img_ad_search_home_before-search-bar {
                width: <?php echo ! empty( $sea_hom_bsb_width ) ? $sea_hom_bsb_width : '800'; ?>px;
                height: <?php echo ! empty( $sea_hom_bsb_height ) ? $sea_hom_bsb_height : '150'; ?>px;
            }

            .directorist-img_ad_search_home_after-search-bar {
                width: <?php echo ! empty( $sea_hom_asb_width ) ? $sea_hom_asb_width : '800'; ?>px;
                height: <?php echo ! empty( $sea_hom_asb_height ) ? $sea_hom_asb_height : '150'; ?>px;
            }

            .directorist-img_ad_search_home_after-footer {
                width: <?php echo ! empty( $sea_hom_afo_width ) ? $sea_hom_afo_width : '1000'; ?>px;
                height: <?php echo ! empty( $sea_hom_afo_height ) ? $sea_hom_afo_height : '200'; ?>px;
            }
            /**********************   END User Dashboard Page image ads size   ***********************/


            /**********************   START Search Result Page image ads size   ***********************/
            .directorist-img_ad_search_result_before-header {
                width: <?php echo ! empty( $sea_res_bh_width ) ? $sea_res_bh_width : '1000'; ?>px;
                height: <?php echo ! empty( $sea_res_bh_height ) ? $sea_res_bh_height : '200'; ?>px;
            }

            .directorist-img_ad_search_result_before-filter {
                width: <?php echo ! empty( $sea_res_bf_width ) ? $sea_res_bf_width : '800'; ?>px;
                height: <?php echo ! empty( $sea_res_bf_height ) ? $sea_res_bf_height : '150'; ?>px;
            }

            .directorist-img_ad_search_result_after-filter {
                width: <?php echo ! empty( $sea_res_af_width ) ? $sea_res_af_width : '800'; ?>px;
                height: <?php echo ! empty( $sea_res_af_height ) ? $sea_res_af_height : '150'; ?>px;
            }

            .directorist-img_ad_search_result_as-card-in-loop {
                width: <?php echo ! empty( $sea_res_ac_width ) ? $sea_res_ac_width : '800'; ?>px;
                height: <?php echo ! empty( $sea_res_ac_height ) ? $sea_res_ac_height : '150'; ?>px;
            }

            .directorist-img_ad_search_result_full-row-in-loop {
                width: <?php echo ! empty( $sea_res_fr_width ) ? $sea_res_fr_width : '800'; ?>px;
                height: <?php echo ! empty( $sea_res_fr_height ) ? $sea_res_fr_height : '150'; ?>px;
            }

            .directorist-img_ad_search_result_after-loop {
                width: <?php echo ! empty( $sea_res_al_width ) ? $sea_res_al_width : '800'; ?>px;
                height: <?php echo ! empty( $sea_res_al_height ) ? $sea_res_al_height : '150'; ?>px;
            }
            
            .directorist-img_ad_search_result_after-footer {
                width: <?php echo ! empty( $sea_res_afo_width ) ? $sea_res_afo_width : '1000'; ?>px;
                height: <?php echo ! empty( $sea_res_afo_height ) ? $sea_res_afo_height : '200'; ?>px;
            }
            /**********************   END Search Result  Page image ads size   ***********************/

            <?php
            return ob_get_clean();
        }// swbdpam_dynamic_css method closer


    } // Class closer
}