<?php
/**
 * @package  Directorist - Ads Manager
 */


if( ! class_exists( 'SWBDPAMActivate' ) ){
    /**
     * Plugin active & initial loaded handler class
     */
    class SWBDPAMActivate
    {
        /**
        * Class constructor
        * Call all hooks which we wanna triger
        */
        public function register()
        {
            // Textdomain loded hook
            add_action( 'plugins_loaded', array( $this, 'load_plugin_textdomain' ) );

            // Hook remover
            add_action( 'plugins_loaded', array( $this, 'swbdpam_hook_remover' ) );
        }


        /**
         * Loaded plugin textdomain.
         */
        public function load_plugin_textdomain()
        {
            // Textdomain loded method
            load_plugin_textdomain( 'directorist-adverts-manager', false, SWBDPAM_PLUGIN_DIRNAME .'/languages' );
        }


        /**
         * Remove hooks when Ads Manager is disable
         */
        public function swbdpam_hook_remover()
        {
            // Get Ads Manager enable option
            $is_ads_manager_enable = get_directorist_option( 'swbdp_ads_manager_is_enable', 1 );
            
            // Authenticate, is Ads Manager enable or not
            if( 1 !== ( int )$is_ads_manager_enable ){
                remove_action( 'plugins_loaded', array( $this, 'load_plugin_textdomain' ) );
            }
        }

    }// End class
}