<?php
/**
 * @package  Directorist - Ads Manager
 */


if( ! class_exists( 'SWBDPAMCustomWpListTable' ) ){
    /**
     * WP List Table customizer class
     */
    class SWBDPAMCustomWpListTable
    {
        /**
         * Class constructor
         * Call all hooks which we wanna triger
         */
        public function register()
        {
            // Custom columns handler hook
            add_filter( 'manage_'. SWBDPAM_POST_TYPE.'_posts_columns',  array( $this, 'add_custom_column' ) );
            // Custom columns data handler hook
            add_action( 'manage_posts_custom_column', array( $this, 'display_custom_column_data' ) );

            // Hook remover
            add_action( 'plugins_loaded', array( $this, 'swbdpam_hook_remove' ) );
        }



        /**
         * Add new columns to the post table
         * 
         * @param Array $columns - Current columns on the list post
         * 
         * @return all columns
         */
        public function add_custom_column( $columns )
        {
            $column_name = array( 
                'swbdpam_ad_type'   => __( 'Ad Type', 'directorist-adverts-manager' ),
                'swbdpam_pages'     => __( 'Pages', 'directorist-adverts-manager' ),
                //'placements'    => __( 'Placements', 'directorist-adverts-manager' ),
                'swbdpam_expire_on' => __( 'Expire on', 'directorist-adverts-manager' )
            );

            $columns = array_slice( $columns, 0, 2, true ) + $column_name + array_slice( $columns, 2, NULL, true );

            return $columns;        
        }



        /**
         * Display the column data in added new column
         * 
         * @param  $column added column
         * 
         * @return void
         */
        public function display_custom_column_data( $column )
        {        
            global $post;

            $ad_display_pages = SWBDPAMHelperFunctions::ad_display_pages();

            switch ( $column ){
                case 'swbdpam_ad_type':
                    $ad_type = get_post_meta( $post->ID, 'swbdpam_ad_type', true );

                    if( 'image' === $ad_type ){
                        _e( 'Image', 'directorist-adverts-manager' );
                    }

                    if( 'google_adsense' === $ad_type ){
                        _e( 'Google Adsense', 'directorist-adverts-manager' );
                    }

                    if( 'facebook_pixel' === $ad_type ){
                        _e( 'Facebook Pixel', 'directorist-adverts-manager' );
                    }

                    if( 'custom_code' === $ad_type ){
                        _e( 'Custom HTML/JS', 'directorist-adverts-manager' );
                    }

                    break;
                case 'swbdpam_pages':
                    $display_pages = get_post_meta( $post->ID, 'swbdpam_pages_select', true );

                    if( is_array( $display_pages ) ){
                        foreach(  $display_pages as $page_key ){
                          echo ucwords( $ad_display_pages[$page_key] ).', ';
                        }
                    }
                    
                    break;
                case 'swbdpam_expire_on':
                    $ad_expire_day      = get_post_meta( $post->ID, 'swbdpam_ad_expire_day', true );
                    $ad_expire_hour     = get_post_meta( $post->ID, 'swbdpam_ad_expire_hour', true );
                    $mark_as_forever    = get_post_meta( $post->ID, 'swbdpam_ad_mark_as_forever', true );

                    $ad_published   = get_the_date();
                    $date           = date_create( $ad_published );

                    if( !empty( $ad_expire_day ) ){
                        date_add( $date, date_interval_create_from_date_string( $ad_expire_day .' days' ) );
                        echo date_format( $date, 'd/m/Y' );                        
                    }

                    if( !empty( $ad_expire_hour ) ){
                        date_add( $date, date_interval_create_from_date_string( $ad_expire_hour .' hours' ) );
                        echo date_format( $date, 'd/m/Y g:i A' );                        
                    }

                    if( !empty( $mark_as_forever ) && ( 'mark-as-forever' === $mark_as_forever ) ){
                        _e( 'Never Expire', 'directorist-adverts-manager' );
                    }

                    break;
            }
        }



        /**
         * Remove hooks when Ads Manager is disable
         */
        public function swbdpam_hook_remove()
        {
            // Get Ads Manager enable option
            $is_ads_manager_enable = get_directorist_option( 'swbdp_ads_manager_is_enable', 1 );

            // Authenticate, is Ads Manager enable or not
            if( 1 !== ( int )$is_ads_manager_enable ){
                remove_filter( 'manage_'. SWBDPAM_POST_TYPE.'_posts_columns',  array( $this, 'add_custom_column' ) );
                remove_action( 'manage_posts_custom_column', array( $this, 'display_custom_column_data' ) );
            }
        }


    } // Class closer
} // If statement closer