<?php
/**
 * @package  Directorist - Ads Manager
 */


if( ! class_exists( 'SWBDPAdsManagerCPT' ) ){
    /**
     * Ads Manager custom post type handler class
     */
    class SWBDPAdsManagerCPT
    {        
        public $custom_meta_field;

        /**
         * Class constructor
         * Call all hooks which we wanna triger
         */
        public function register()
        {
            // Get Custom meta box's callback functions 
            $this->custom_meta_field = new SWBDPAMAdminCallbacks();

            // Ads Manager CPT register hook
            add_action( 'init', array( $this, 'register_ads_manager_custom_post_type' ) );
            // Ads Manager custom metabox
            add_action( 'admin_menu', array( $this, 'add_ads_manager_custom_metabox'), 999 );
            // This hook change the CPT Title placeholder
            add_filter( 'enter_title_here', array( $this, 'change_ads_manager_title_placeholder') );

            // For save custom meta box data
            add_action( 'save_post', array( $this, 'swbdpam_save_cmb_ad_types_data' ) );
            add_action( 'save_post', array( $this, 'swbdpam_save_cmb_select_pages_data' ) );
            add_action( 'save_post', array( $this, 'swbdpam_save_cmb_additional_settings_data' ) );
            
            // Hook remover
            add_action( 'plugins_loaded', array( $this, 'swbdpam_hook_remove' ) );
        }


        /**
         * Ads Manager CPT register function
         * 
         * @return void
         */
        public static function register_ads_manager_custom_post_type() 
        {
            // Ads manager CPT's labeles
            $labels = array(
                'name'                  => _x( 'Ads', 'directorist-adverts-manager' ),
                'singular_name'         => _x( 'Ad', 'directorist-adverts-manager' ),
                'menu_name'             => _x( 'Ads', 'directorist-adverts-manager' ),
                'name_admin_bar'        => _x( 'Ad', 'directorist-adverts-manager' ),
                'add_new'               => __( 'Add New Ad', 'directorist-adverts-manager' ),
                'add_new_item'          => __( 'Add New Ad', 'directorist-adverts-manager' ),
                'new_item'              => __( 'New Ad', 'directorist-adverts-manager' ),
                'edit_item'             => __( 'Edit Ad', 'directorist-adverts-manager' ),
                'view_item'             => __( 'View Ad', 'directorist-adverts-manager' ),
                'all_items'             => __( 'Ads', 'directorist-adverts-manager' ),
                'search_items'          => __( 'Search Ad', 'directorist-adverts-manager' ),
                'parent_item_colon'     => __( 'Parent Ad:', 'directorist-adverts-manager' ),
                'not_found'             => __( 'No Ad found.', 'directorist-adverts-manager' ),
                'not_found_in_trash'    => __( 'No Ad found in Trash.', 'directorist-adverts-manager' ),
                'featured_image'        => _x( 'Ad Cover Image', 'directorist-adverts-manager' ),
                'set_featured_image'    => _x( 'Set cover image', 'directorist-adverts-manager' ),
                'remove_featured_image' => _x( 'Remove cover image', 'directorist-adverts-manager' ),
                'use_featured_image'    => _x( 'Use as cover image', 'directorist-adverts-manager' ),
                'insert_into_item'      => _x( 'Insert into book', 'directorist-adverts-manager' ),                
            );
        
            // Ads manager CPT's arguments
            $args = array(
                'labels'                => $labels,
                'public'                => true,
                'publicly_queryable'    => true,
                'show_ui'               => true,
                'show_in_menu'          => 'edit.php?post_type='. ATBDP_POST_TYPE,
                'query_var'             => true,
                'rewrite'               => array( 'slug' => SWBDPAM_POST_TYPE ),
                'capability_type'       => 'post',
                'has_archive'           => true,
                'hierarchical'          => false,
                'menu_icon'             => 'dashicons-search',
                'supports'              => array( 'title', 'author', 'thumbnail' ),
            );
         
            // Register ads manager CPT
            register_post_type( SWBDPAM_POST_TYPE, $args );
        }

        

        /**
         * Custom meta box for Ad manager post type
         *
         * @return void
         */
        public function add_ads_manager_custom_metabox()
        {
            // Select Ad type metabox
        	add_meta_box(
        	    'swbdpam-ad-types',                                               // Section id
                __( 'Type of Ad', 'directorist-adverts-manager' ),                  // Section name
                array( $this->custom_meta_field, 'cmb_ads_manager_ad_types_callback' ),  // Callback
                array( SWBDPAM_POST_TYPE ),                                       // Where show Section
                'normal',                                                       // For position
                'high'                                                          // For position                
            );

            // Select page & places metabox
            add_meta_box(
                'swbdpam-select-pages',                               
                __( 'Select Pages & Placement', 'directorist-adverts-manager' ),  
                array( $this->custom_meta_field, 'cmb_ads_manager_select_pages_and_placement_callback' ),     
                array( SWBDPAM_POST_TYPE ),
                'normal',
                'high'                     
            );

            // Additional settings for Ad metabox            
            add_meta_box(
                'swbdpam-additional-settings',                           
                __( 'Additional Settings', 'directorist-adverts-manager' ),
                array( $this->custom_meta_field, 'cmb_ads_manager_additional_settings_callback' ), 
                array( SWBDPAM_POST_TYPE ),
                'normal',
                'high'                     
            );
        }



        /**
         * Ad title's placeholder changer function
         * 
         * @param placeholder
         * 
         * @return placeholder
         */
        public function change_ads_manager_title_placeholder( $placeholder )
        {
            // Authenticate, is admin or not
            if( is_admin() ){
                $screen = get_current_screen();

                if( SWBDPAM_POST_TYPE == $screen->post_type ) {
                    $placeholder = __( 'Enter ad title', 'directorist-adverts-manager' );
                }
                return $placeholder;
            }
        }



        /**
         * For save, select ad type custom meta box data
         * 
         * @param post ID
         * 
         * @return void
         */
        public function swbdpam_save_cmb_ad_types_data( $post_id )
        {
            if( ! SWBDPAMHelperFunctions::is_secured( 'swbdpam_ad_types_cmb_field', 'swbdpam_ad_types_cmb_action', $post_id ) ){
                return $post_id;
            }

            $ad_type                = isset( $_POST['swbdpam_ad_type'] ) ? $_POST['swbdpam_ad_type'] : '';

            $get_image_ad_image_id  = isset( $_POST['swbdpam_image_ad_image_id'] ) ? $_POST['swbdpam_image_ad_image_id'] : '';
            $get_image_ad_image_url = isset( $_POST['swbdpam_image_ad_image_url'] ) ? $_POST['swbdpam_image_ad_image_url'] : '';
            $get_custom_code        = isset( $_POST['swbdpam_custom_code_ad'] ) ? $_POST['swbdpam_custom_code_ad'] : '';

            $get_terget_url         = isset( $_POST['swbdpam_ad_terget_url'] ) ? $_POST['swbdpam_ad_terget_url'] : '';
            $get_rel_attr           = isset( $_POST['swbdpam_rel_attr'] ) ? $_POST['swbdpam_rel_attr'] : '';
            $get_open_link_in       = isset( $_POST['swbdpam_open_link'] ) ? $_POST['swbdpam_open_link'] : '';

            update_post_meta( $post_id, 'swbdpam_ad_type', $ad_type );

            update_post_meta( $post_id, 'swbdpam_image_ad_image_id', $get_image_ad_image_id );
            update_post_meta( $post_id, 'swbdpam_image_ad_image_url', $get_image_ad_image_url );
            update_post_meta( $post_id, 'swbdpam_custom_code_ad', $get_custom_code );

            update_post_meta( $post_id, 'swbdpam_ad_terget_url', $get_terget_url );
            update_post_meta( $post_id, 'swbdpam_rel_attr', $get_rel_attr );
            update_post_meta( $post_id, 'swbdpam_open_link', $get_open_link_in );
        }



        /**
         * For save, select page & places custom meta box data
         * 
         * @param post ID
         * 
         * @return void
         */
        public function swbdpam_save_cmb_select_pages_data( $post_id )
        {
            if( ! SWBDPAMHelperFunctions::is_secured( 'swbdpam_select_pages_cmb_field', 'swbdpam_select_pages_cmb_action', $post_id ) ){
                return $post_id;
            }

            $selected_pages             = isset( $_POST['swbdpam_pages_select'] ) ? $_POST['swbdpam_pages_select'] : '';

            $selected_all_lis_plc       = isset( $_POST['swbdpam_all_listings_ad_places'] ) ? $_POST['swbdpam_all_listings_ad_places'] : '';
            $selected_sing_lis_plc      = isset( $_POST['swbdpam_single_listing_ad_places'] ) ? $_POST['swbdpam_single_listing_ad_places'] : '';
            $selected_all_cat_plc       = isset( $_POST['swbdpam_all_cat_ad_places'] ) ? $_POST['swbdpam_all_cat_ad_places'] : '';
            $selected_sing_cat_plc      = isset( $_POST['swbdpam_single_category_ad_places'] ) ? $_POST['swbdpam_single_category_ad_places'] : '';
            $selected_all_loc_plc       = isset( $_POST['swbdpam_all_loc_ad_places'] ) ? $_POST['swbdpam_all_loc_ad_places'] : '';
            $selected_sing_loc_plc      = isset( $_POST['swbdpam_single_location_ad_places'] ) ? $_POST['swbdpam_single_location_ad_places'] : '';
            $selected_add_lis_plc       = isset( $_POST['swbdpam_add_listing_ad_places'] ) ? $_POST['swbdpam_add_listing_ad_places'] : '';
            $selected_dashboard_plc     = isset( $_POST['swbdpam_dashboard_ad_places'] ) ? $_POST['swbdpam_dashboard_ad_places'] : '';
            $selected_auth_lis_plc      = isset( $_POST['swbdpam_author_listings_ad_places'] ) ? $_POST['swbdpam_author_listings_ad_places'] : '';
            $selected_search_home_plc   = isset( $_POST['swbdpam_search_home_ad_places'] ) ? $_POST['swbdpam_search_home_ad_places'] : '';
            $selected_search_result     = isset( $_POST['swbdpam_search_result_ad_places'] ) ? $_POST['swbdpam_search_result_ad_places'] : '';

            $get_bhaf_ad_width      = isset( $_POST['swbdpam_bhaf_ad_width'] ) ? $_POST['swbdpam_bhaf_ad_width'] : '';        
            $get_bhaf_ad_height     = isset( $_POST['swbdpam_bhaf_ad_height'] ) ? $_POST['swbdpam_bhaf_ad_height'] : '';

            $get_card_ad_show_after = isset( $_POST['swbdpam_card_ad_show_after_lis'] ) ? $_POST['swbdpam_card_ad_show_after_lis'] : '';
            $get_card_ad_repeat     = isset( $_POST['swbdpam_card_ad_repeat'] ) ? $_POST['swbdpam_card_ad_repeat'] : '';            
            $get_card_ad_width      = isset( $_POST['swbdpam_card_ad_width'] ) ? $_POST['swbdpam_card_ad_width'] : '';
            $get_card_ad_height     = isset( $_POST['swbdpam_card_ad_height'] ) ? $_POST['swbdpam_card_ad_height'] : '';

            $get_row_ad_show_after  = isset( $_POST['swbdpam_row_ad_show_after_row'] ) ? $_POST['swbdpam_row_ad_show_after_row'] : '';
            $get_row_ad_repeat      = isset( $_POST['swbdpam_row_ad_repeat'] ) ? $_POST['swbdpam_row_ad_repeat'] : '';            
            $get_row_ad_width       = isset( $_POST['swbdpam_row_ad_width'] ) ? $_POST['swbdpam_row_ad_width'] : '';
            $get_row_ad_height      = isset( $_POST['swbdpam_row_ad_height'] ) ? $_POST['swbdpam_row_ad_height'] : '';

            update_post_meta( $post_id, 'swbdpam_pages_select', $selected_pages );

            update_post_meta( $post_id, 'swbdpam_all_listings_ad_places', $selected_all_lis_plc );
            update_post_meta( $post_id, 'swbdpam_single_listing_ad_places', $selected_sing_lis_plc );
            update_post_meta( $post_id, 'swbdpam_all_cat_ad_places', $selected_all_cat_plc );
            update_post_meta( $post_id, 'swbdpam_single_category_ad_places', $selected_sing_cat_plc );
            update_post_meta( $post_id, 'swbdpam_all_loc_ad_places', $selected_all_loc_plc );
            update_post_meta( $post_id, 'swbdpam_single_location_ad_places', $selected_sing_loc_plc );
            update_post_meta( $post_id, 'swbdpam_add_listing_ad_places', $selected_add_lis_plc );
            update_post_meta( $post_id, 'swbdpam_dashboard_ad_places', $selected_dashboard_plc );
            update_post_meta( $post_id, 'swbdpam_author_listings_ad_places', $selected_auth_lis_plc );
            update_post_meta( $post_id, 'swbdpam_search_home_ad_places', $selected_search_home_plc );
            update_post_meta( $post_id, 'swbdpam_search_result_ad_places', $selected_search_result );

            update_post_meta( $post_id, 'swbdpam_bhaf_ad_width', $get_bhaf_ad_width );
            update_post_meta( $post_id, 'swbdpam_bhaf_ad_height', $get_bhaf_ad_height );

            update_post_meta( $post_id, 'swbdpam_card_ad_show_after_lis', $get_card_ad_show_after );
            update_post_meta( $post_id, 'swbdpam_card_ad_repeat', $get_card_ad_repeat );
            update_post_meta( $post_id, 'swbdpam_card_ad_width', $get_card_ad_width );
            update_post_meta( $post_id, 'swbdpam_card_ad_height', $get_card_ad_height );

            update_post_meta( $post_id, 'swbdpam_row_ad_show_after_row', $get_row_ad_show_after );
            update_post_meta( $post_id, 'swbdpam_row_ad_repeat', $get_row_ad_repeat );
            update_post_meta( $post_id, 'swbdpam_row_ad_width', $get_row_ad_width );
            update_post_meta( $post_id, 'swbdpam_row_ad_height', $get_row_ad_height );
        }



        /**
         * For save, Ad's additional settings custom meta box data
         * 
         * @param Post ID
         * 
         * @return void
         */
        public function swbdpam_save_cmb_additional_settings_data( $post_id )
        {
            if( ! SWBDPAMHelperFunctions::is_secured( 'swbdpam_additional_settings_cmb_field', 'swbdpam_additional_settings_cmb_action', $post_id ) ){
                return $post_id;
            }

            $get_logged_in_user = isset( $_POST['swbdpam_logged_in_user'] ) ? $_POST['swbdpam_logged_in_user'] : '';

            $get_ad_expire_day      = isset( $_POST['swbdpam_ad_expire_day'] ) ? $_POST['swbdpam_ad_expire_day'] : '';
            $get_ad_expire_hour     = isset( $_POST['swbdpam_ad_expire_hour'] ) ? $_POST['swbdpam_ad_expire_hour'] : '';
            $get_mark_as_forever    = isset( $_POST['swbdpam_ad_mark_as_forever'] ) ? $_POST['swbdpam_ad_mark_as_forever'] : '';

            $get_after_expire       = isset( $_POST['swbdpam_after_expire'] ) ? $_POST['swbdpam_after_expire'] : '';
            $get_contact_image_id   = isset( $_POST['swbdpam_contact_image_id'] ) ? $_POST['swbdpam_contact_image_id'] : '';
            $get_contact_image_url  = isset( $_POST['swbdpam_contact_image_url'] ) ? $_POST['swbdpam_contact_image_url'] : '';

            update_post_meta( $post_id, 'swbdpam_logged_in_user', $get_logged_in_user );

            update_post_meta( $post_id, 'swbdpam_ad_expire_day', $get_ad_expire_day );
            update_post_meta( $post_id, 'swbdpam_ad_expire_hour', $get_ad_expire_hour );
            update_post_meta( $post_id, 'swbdpam_ad_mark_as_forever', $get_mark_as_forever );

            update_post_meta( $post_id, 'swbdpam_after_expire', $get_after_expire );
            update_post_meta( $post_id, 'swbdpam_contact_image_id', $get_contact_image_id );
            update_post_meta( $post_id, 'swbdpam_contact_image_url', $get_contact_image_url );
        }



        /**
         * Hook remover function
         */
        public function swbdpam_hook_remove()
        {
            // Get Ads Manager enable option
            $is_ads_manager_enable = get_directorist_option( 'swbdp_ads_manager_is_enable', 1 );

            // Authenticate, is Ads Manager enable or not
            if( 1 !== (int)$is_ads_manager_enable ){
                remove_action( 'init', array( $this, 'register_ads_manager_custom_post_type' ) );
                remove_action( 'admin_menu', array( $this, 'add_ads_manager_custom_metabox'), 999 );
                remove_filter( 'enter_title_here', array( $this, 'change_ads_manager_title_placeholder') );
                
                remove_action( 'save_post', array( $this, 'swbdpam_save_cmb_ad_types_data' ) );
                remove_action( 'save_post', array( $this, 'swbdpam_save_cmb_select_pages_data' ) );
                remove_action( 'save_post', array( $this, 'swbdpam_save_cmb_additional_settings_data' ) );
            }
        }

    }// End class
    
}