<?php
/**
 * @package  Directorist - Ads Manager
 */


if( ! class_exists( 'SWBDPAMPSingleLocation' ) ){
    /**
     * Plugin active & initial loaded handler class
     */
    class SWBDPAMPSingleLocation
    {
        /**
        * Class constructor
        * Call all hooks which we wanna triger
        */
        public function register()
        {
            // Render on before header
            add_action( 'wp_head', array( $this, 'swbdpam_ap_single_loc_before_header' ) );
            // Render on before filter
            add_action( 'directorist_archive_header', array( $this, 'swbdpam_ap_single_loc_before_filter_bar' ) );
            add_action( 'directorist_before_listing_types', array( $this, 'swbdpam_ap_single_loc_before_filter_bar' ) );
            // Render on after filter
            add_action( 'atbdp_before_grid_listings_loop', array( $this, 'swbdpam_ap_single_loc_after_filter_bar' ) );
            add_action( 'directorist_before_grid_listings_loop', array( $this, 'swbdpam_ap_single_loc_after_filter_bar' ) );

            add_action( 'atbdp_before_list_listings_loop', array( $this, 'swbdpam_ap_single_loc_after_filter_bar' ) );
            add_action( 'directorist_before_list_listings_loop', array( $this, 'swbdpam_ap_single_loc_after_filter_bar' ) );
            // Render on listings loop
            add_action( 'atbdp_listings_loop', array( $this, 'swbdpam_single_loc_in_loop_ad_handler' ) );
            // Render on grid view in loop
            add_action( 'swbdpam_single_loc_as_card_in_loop', array( $this, 'swbdpam_ap_single_loc_as_card_in_loop' ) );
            // Render on list view in loop
            add_action( 'swbdpam_single_loc_full_row_in_loop', array( $this, 'swbdpam_ap_single_loc_full_row_in_loop' ) );
            // Render on after loop
            add_action( 'atbdp_before_listings_pagination', array( $this, 'swbdpam_ap_single_loc_after_loop' ) );
            add_action( 'directorist_before_listings_pagination', array( $this, 'swbdpam_ap_single_loc_after_loop' ) );
            // Render on after footer
            add_action( 'wp_footer', array( $this, 'swbdpam_ap_single_loc_after_footer' ) );

            // Hook remover
            add_action( 'plugins_loaded', array( $this, 'swbdpam_hook_remover' ) );
        }




        /**
         * This function
         */
        public function swbdpam_single_loc_in_loop_ad_handler( $i )
        {
            $as_car_ad_id   = SWBDPAMHelperFunctions::get_ad_id( 'single_location', 'swbdpam_single_location_ad_places', 'as-card-in-loop' );
            $full_row_ad_id = SWBDPAMHelperFunctions::get_ad_id( 'single_location', 'swbdpam_single_location_ad_places', 'full-row-in-loop' );

            $ad_show_aft_listing    = get_post_meta( $as_car_ad_id, 'swbdpam_card_ad_show_after_lis', true );
            $ad_show_aft_row        = get_post_meta( $full_row_ad_id, 'swbdpam_row_ad_show_after_row', true );
            $is_card_ad_repeat      = get_post_meta( $as_car_ad_id, 'swbdpam_card_ad_repeat', true );
            $is_row_ad_repeat       = get_post_meta( $full_row_ad_id, 'swbdpam_row_ad_repeat', true );
            $number_of_columns      = get_directorist_option( 'all_listing_columns' );

            $ad_show_aft_listing    = isset( $ad_show_aft_listing ) ? (int)$ad_show_aft_listing : 4;
            $ad_show_aft_row        = isset( $ad_show_aft_row ) ? (int)$ad_show_aft_row : 1;
            $ad_show_aft_lis        = $number_of_columns * $ad_show_aft_row ;
/*
            if( $ad_show_aft_listing === $i ){
                do_action( 'swbdpam_single_loc_as_card_in_loop' );
            }

            if( $ad_show_aft_row === $i ){
                do_action( 'swbdpam_single_loc_full_row_in_loop' );
            }
*/
            if( isset( $is_row_ad_repeat ) && ( 'no' == $is_row_ad_repeat ) ){
                if( ( $ad_show_aft_lis + 1 ) === $i ){
                    // Render on grid & list view in loop in full row
                    do_action( 'swbdpam_single_loc_full_row_in_loop' );
                }
            }  

            if( isset( $is_row_ad_repeat ) && ( 'yes' == $is_row_ad_repeat ) ){
                for( $lis_indx = $ad_show_aft_lis + 1; $lis_indx <= $i; $lis_indx += (int)$ad_show_aft_lis ){
                    if( $i == $lis_indx ){
                        // Render on grid view in loop in full row
                        do_action( 'swbdpam_single_loc_full_row_in_loop' );
                    }
                }        
            }            

        }



        /**
         * This function display the ad on 'Single Location' page before header
         * 
         * @return void
         */
        public function swbdpam_ap_single_loc_before_header()
        {    
            // Authenticate, Current page is 'Search Location' page or not
            $page_id                    = get_queried_object_id();
            $single_location_page_id    = get_directorist_option( 'single_location_page' );

            if( $page_id == $single_location_page_id ){
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'single_location', 'swbdpam_single_location_ad_places', 'before-header' );
                if( ! empty( $ad_id ) ){
                    ?>
                    <div class="directorist-single-loc-add-before-header">
                        <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'single_location', 'before-header' ); ?>
                    </div>
                    <?php
                }
            }

        }



        /**
         * This function display the ad on 'Search Location' page before filter bar
         * 
         * @return void
         */
        public function swbdpam_ap_single_loc_before_filter_bar()
        {
            $page_id                    = get_queried_object_id();
            $single_category_page_id    = get_directorist_option( 'single_location_page' );

            // Authenticate, Current page is 'Search Location' page or not
            if( $page_id == $single_category_page_id ){
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'single_location', 'swbdpam_single_location_ad_places', 'before-filter' );
                if( ! empty( $ad_id ) ){
                    ?>
                    <div class="directorist-single-loc-ad-before-filter">
                        <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'single_location', 'before-filter' ); ?>
                    </div>
                    <?php
                }
            }
        }



        /**
         * This function display the ad on 'Search Location' page after filter bar
         * 
         * @return void
         */
        public function swbdpam_ap_single_loc_after_filter_bar()
        {
            $page_id                    = get_queried_object_id();
            $single_category_page_id    = get_directorist_option( 'single_location_page' );

            // Authenticate, Current page is 'Search Location' page or not
            if( $page_id == $single_category_page_id ){
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'single_location', 'swbdpam_single_location_ad_places', 'after-filter' );
                if( ! empty( $ad_id ) ){
                    ?>
                    <div class="directorist-single-loc-ad-after-filter">
                        <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'single_location', 'after-filter' ); ?>
                    </div>
                    <?php
                }
            }
        }



        /**
         * This function display the ad on 'Search Location' page grid view in loop
         * 
         * @return void
         */
        public function swbdpam_ap_single_loc_as_card_in_loop( $view )
        {
            $page_id                    = get_queried_object_id();
            $single_category_page_id    = get_directorist_option( 'single_location_page' );

            $view_as    = isset( $_GET['view'] ) ? sanitize_text_field( $_GET['view'] ) : '';
            if( 'list' == $view || 'list' == $view_as ){
                return;
            }

            // Authenticate, Current page is 'Search Location' page or not
            if( $page_id == $single_category_page_id ){
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'single_location', 'swbdpam_single_location_ad_places', 'as-card-in-loop' );
                if( ! empty( $ad_id ) ){
                ?>
                <div class='atbdp_column atbdp-col-3'>
                    <div class='atbd_single_listing atbd_listing_card'>
                        <div class='atbd_single_listing_wrapper swbdpam__sing_loc_ad_as_card_in_loop'>
                            <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'single_location', 'as-card-in-loop' ); ?>
                        </div>
                    </div>
                </div>
                <?php
                }
            }
        }



        /**
         * This function display the ad on 'Search Location' page full row in loop
         * 
         * @return void
         */
        public function swbdpam_ap_single_loc_full_row_in_loop()
        {
            $page_id                    = get_queried_object_id();
            $single_category_page_id    = get_directorist_option( 'single_location_page' );

            // Authenticate, Current page is 'Search Location' page or not
            if( $page_id == $single_category_page_id ){
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'single_location', 'swbdpam_single_location_ad_places', 'full-row-in-loop' );
                if( ! empty( $ad_id ) ){
                    ?>
                    <div class="col-12 swbdpam__sing_loc_ad_full_row_in_loop">
                       <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'single_location', 'full-row-in-loop' ); ?>
                    </div>
                    <?php
                }
            }
        }
                

        /**
         * This function display the ad on 'Search Location' page after loop
         * 
         * @return void
         */
        public function swbdpam_ap_single_loc_after_loop()
        {
            $page_id                    = get_queried_object_id();
            $single_category_page_id    = get_directorist_option( 'single_location_page' );

            // Authenticate, Current page is 'Search Location' page or not
            if( $page_id == $single_category_page_id ){
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'single_location', 'swbdpam_single_location_ad_places', 'after-loop' );
                if( ! empty( $ad_id ) ){
                    ?>
                    <div class="directorist-single-loc-ad-after-loop">
                        <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'single_location', 'after-loop' ); ?>
                    </div>
                    <?php
                }
            }
        }


        
        /**
         * This function display the ad on 'Search Location' page after footer
         * 
         * @return void
         */
        public function swbdpam_ap_single_loc_after_footer()
        {
            // Authenticate, Current page is 'Search Location' page or not
            $page_id                    = get_queried_object_id();
            $single_location_page_id    = get_directorist_option( 'single_location_page' );

            if( $page_id == $single_location_page_id ){
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'single_location', 'swbdpam_single_location_ad_places', 'after-footer' );
                if( ! empty( $ad_id ) ){
                    ?>
                    <div class="directorist-single-loc-add-after-footer">
                        <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'single_location', 'after-footer' ); ?>
                    </div>
                    <?php
                }
            }
        }




        /**
         * Remove hooks when Ads Manager is disable
         */
        public function swbdpam_hook_remover()
        {
            // Get Ads Manager enable option
            $is_ads_manager_enable = get_directorist_option( 'swbdp_ads_manager_is_enable', 1 );

            // Authenticate, is Ads Manager enable or not
            if( 1 !== ( int )$is_ads_manager_enable ){
                remove_action( 'wp_head', array( $this, 'swbdpam_ap_single_loc_before_header' ) );
                remove_action( 'directorist_archive_header', array( $this, 'swbdpam_ap_single_loc_before_filter_bar' ) );
                remove_action( 'directorist_before_listing_types', array( $this, 'swbdpam_ap_single_loc_before_filter_bar' ) );
                remove_action( 'atbdp_before_grid_listings_loop', array( $this, 'swbdpam_ap_single_loc_after_filter_bar' ) );
                remove_action( 'directorist_before_grid_listings_loop', array( $this, 'swbdpam_ap_single_loc_after_filter_bar' ) );
                remove_action( 'atbdp_before_list_listings_loop', array( $this, 'swbdpam_ap_single_loc_after_filter_bar' ) );
                remove_action( 'directorist_before_list_listings_loop', array( $this, 'swbdpam_ap_single_loc_after_filter_bar' ) );
                remove_action( 'atbdp_listings_loop', array( $this, 'swbdpam_single_loc_in_loop_ad_handler' ) );
                remove_action( 'swbdpam_single_loc_as_card_in_loop', array( $this, 'swbdpam_ap_single_loc_as_card_in_loop' ) );
                remove_action( 'swbdpam_single_loc_full_row_in_loop', array( $this, 'swbdpam_ap_single_loc_full_row_in_loop' ) );
                remove_action( 'atbdp_before_listings_pagination', array( $this, 'swbdpam_ap_single_loc_after_loop' ) );
                remove_action( 'directorist_before_listings_pagination', array( $this, 'swbdpam_ap_single_loc_after_loop' ) );
                remove_action( 'wp_footer', array( $this, 'swbdpam_ap_single_loc_after_footer' ) );
            }
        }

    }// Class closer
}// If statement closer