<?php
/**
 * @package  Directorist - Ads Manager
 */



if( ! class_exists( 'SWBDPAMPSingleListing' ) ){
    /**
     * Single Listing page ads handler class
     */
    class SWBDPAMPSingleListing
    {
        /**
         * Class constructor
         * Call all hooks which we wanna triger
         */
        public function register()
        {
            // Render on before header or menu
            add_action( 'wp_head', array( $this, 'swbdpam_ap_single_lis_before_header' ) );
            // Render on listing after title
            add_action( 'atbdp_single_listing_after_title', array( $this, 'swbdpam_ap_single_lis_after_title' ) );
            add_action( 'directorist_single_listing_after_title', array( $this, 'swbdpam_ap_single_lis_after_title' ) );
            // Render on after related listing
            add_action( 'atbdp_single_listing_after_related_listing', array( $this, 'swbdpam_apsl_after_related_listing' ) );
            // Render on after footer
            add_action( 'wp_footer', array( $this, 'swbdpam_ap_single_lis_after_footer' ) );

            // Hook remover
            add_action( 'plugins_loaded', array( $this, 'swbdpam_hook_remover' ) );
        }



        /**
         * This function display the ad on 'Single Listing' page before header
         * 
         * @return void
         */
        public function swbdpam_ap_single_lis_before_header()
        {
            // Authenticate, Current page is 'Single Listings' page or not
            if( is_singular( ATBDP_POST_TYPE ) ){
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'single_listing', 'swbdpam_single_listing_ad_places', 'before-header' );
                if( ! empty( $ad_id ) ){
                    ?>
                    <div class="directorist-single-list-ad-before-header">
                        <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'single_listing', 'before-header' ); ?>
                    </div>
                    <?php
                }
            }
        }



        /**
         * This function display the ad on 'Single Listing' page after listing title
         * 
         * @return void
         */
        public function swbdpam_ap_single_lis_after_title()
        {
            // Authenticate, Current page is 'Single Listings' page or not
            if( is_singular( ATBDP_POST_TYPE ) ){
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'single_listing', 'swbdpam_single_listing_ad_places', 'after-title' );
                if( ! empty( $ad_id ) ){
                    ?>
                    <div class="directorist-single-list-ad-after-title">
                        <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'single_listing', 'after-title' ); ?>
                    </div>
                    <?php
                }
            }
        }

        

        /**
         * This function display the ad on 'Single Listing' page after related listing
         * 
         * @return void
         */
        public function swbdpam_apsl_after_related_listing()
        {
            // Authenticate, Current page is 'Single Listings' page or not
            if( is_singular( ATBDP_POST_TYPE ) ){
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'single_listing', 'swbdpam_single_listing_ad_places', 'after-related-listing' );
                if( ! empty( $ad_id ) ){
                    ?>
                    <div class="swbdpam__sing_lis_ad_after_related_listing">
                        <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'single_listing', 'after-related-listing' ); ?>
                    </div>
                    <?php
                }
            }
        }
        

        
        /**
         * This function display the ad on 'Single Listing' page after footer
         * 
         * @return void
         */
        public function swbdpam_ap_single_lis_after_footer()
        {
            // Authenticate, Current page is 'Single Listings' page or not
            if( is_singular( ATBDP_POST_TYPE ) ){
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'single_listing', 'swbdpam_single_listing_ad_places', 'after-footer' );
                if( ! empty( $ad_id ) ){
                    ?>
                    <div class="directorist-single-list-add-after-footer">
                        <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'single_listing', 'after-footer' ); ?>
                    </div>
                    <?php
                }
            }
        }



        /**
         * Remove hooks when Ads Manager is disable
         */
        public function swbdpam_hook_remover()
        {
            // Get Ads Manager enable option
            $is_ads_manager_enable = get_directorist_option( 'swbdp_ads_manager_is_enable', 1 );

            // Authenticate, is Ads Manager enable or not
            if( 1 !== ( int )$is_ads_manager_enable ){
                remove_action( 'wp_head', array( $this, 'swbdpam_ap_single_lis_before_header' ) );
                remove_action( 'atbdp_single_listing_after_title', array( $this, 'swbdpam_ap_single_lis_after_title' ) );
                remove_action( 'directorist_single_listing_after_title', array( $this, 'swbdpam_ap_single_lis_after_title' ) );
                remove_action( 'atbdp_single_listing_after_related_listing', array( $this, 'swbdpam_apsl_after_related_listing' ) );
                remove_action( 'wp_footer', array( $this, 'swbdpam_ap_single_lis_after_footer' ) );
            }
        }

    }// Class Closer
}// If statement closer