<?php
/**
 * @package  Directorist - Ads Manager
 */



if( ! class_exists( 'SWBDPAMPSearchHome' ) ){
    /**
     * Search Home page ads handler class
     */
    class SWBDPAMPSearchHome
    {
        /**
         * Class constructor
         * Call all hooks which we wanna triger
         */
        public function register()
        {
            // Render on before header
            add_action( 'wp_head', array( $this, 'swbdpam_ap_search_lis_before_header' ) );
            // Render on before search bar
            add_action( 'atbdp_search_listing_before_title', array( $this, 'swbdpam_ap_search_lis_before_search_bar' ) );
            add_action( 'directorist_search_listing_before_title', array( $this, 'swbdpam_ap_search_lis_before_search_bar' ) );
            // Render on after search bar
            add_action( 'atbdp_search_listing_after_search_bar', array( $this, 'swbdpam_ap_search_lis_after_search_bar' ) );
            add_action( 'directorist_search_listing_after_search_bar', array( $this, 'swbdpam_ap_search_lis_after_search_bar' ) );
            // Render on after footer
            add_action( 'wp_footer', array( $this, 'swbdpam_ap_search_lis_after_footer' ) );
            
            // Hook remover
            add_action( 'plugins_loaded', array( $this, 'swbdpam_hook_remover' ) );
        }
 


        /**
         * This function display the ad on 'Search Home' page before header or menu
         * 
         * @return void
         */
        public function swbdpam_ap_search_lis_before_header()
        {   
            $page_id                = get_queried_object_id();
            $search_home_page_id    = get_directorist_option( 'search_listing' );

            // Authenticate, Current page is 'Search Home' page or not
            if( $page_id == $search_home_page_id ){
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'search_home', 'swbdpam_search_home_ad_places', 'before-header' );
                if( ! empty( $ad_id ) ){
                    ?>
                    <div class="directorist-s-home-ad-before-header">
                        <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'search_home', 'before-header' ); ?>
                    </div>
                    <?php
                }
            }

        }


        /**
         * This function display the ad on 'Search Home' page before search bar
         * 
         * @return void
         */
        public function swbdpam_ap_search_lis_before_search_bar()
        {          
            $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'search_home', 'swbdpam_search_home_ad_places', 'before-search-bar' );
            if( ! empty( $ad_id ) ){
                ?>
                <div class="directorist-s-home-ad-before-search-bar">
                    <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'search_home', 'before-search-bar' ); ?>
                </div>
                <?php
            }
        }


        /**
         * This function display the ad on 'Search Home' page after search bar
         * 
         * @return void
         */
        public function swbdpam_ap_search_lis_after_search_bar()
        {
            $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'search_home', 'swbdpam_search_home_ad_places', 'after-search-bar' );
            if( ! empty( $ad_id ) ){
                ?>
                <div class="directorist-s-home-ad-after-search-bar">
                    <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'search_home', 'after-search-bar' ); ?>
                </div>
                <?php
            }
        }


        /**
         * This function display the ad on 'Search Home' page after footer
         * 
         * @return void
         */
        public function swbdpam_ap_search_lis_after_footer()
        {
            $page_id                = get_queried_object_id();
            $search_home_page_id    = get_directorist_option( 'search_listing' );

            // Authenticate, Current page is 'Search Home' page or not
            if( $page_id == $search_home_page_id ){
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'search_home', 'swbdpam_search_home_ad_places', 'after-footer' );
                if( ! empty( $ad_id ) ){
                    ?>
                    <div class="directorist-s-home-ad-after-footer">
                        <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'search_home', 'after-footer' ); ?>
                    </div>
                    <?php
                }
            }
        }



        /**
         * Remove hooks when Ads Manager is disable
         */
        public function swbdpam_hook_remover()
        {
            // Get Ads Manager enable option
            $is_ads_manager_enable = get_directorist_option( 'swbdp_ads_manager_is_enable', 1 );
            
            // Authenticate, is Ads Manager enable or not
            if( 1 !== ( int )$is_ads_manager_enable ){
                remove_action( 'wp_head', array( $this, 'swbdpam_ap_search_lis_before_header' ) );
                remove_action( 'atbdp_search_listing_before_title', array( $this, 'swbdpam_ap_search_lis_before_search_bar' ) );
                remove_action( 'directorist_search_listing_before_title', array( $this, 'swbdpam_ap_search_lis_before_search_bar' ) );
                remove_action( 'atbdp_search_listing_after_search_bar', array( $this, 'swbdpam_ap_search_lis_after_search_bar' ) );
                remove_action( 'directorist_search_listing_after_search_bar', array( $this, 'swbdpam_ap_search_lis_after_search_bar' ) );
                remove_action( 'wp_footer', array( $this, 'swbdpam_ap_search_lis_after_footer' ) );
            }
        }


    }// Class closer
}// If statement closer