<?php
/**
 * @package  Directorist - Ads Manager
 */


if( ! class_exists( 'SWBDPAMPDashboard' ) ){
    /**
     * User Dashboard page ads handler class
     */
    class SWBDPAMPDashboard
    {
        /**
        * Class constructor
        * Call all hooks which we wanna triger
        */
        public function register()
        {   
            // Render on before header
            add_action( 'wp_head', array( $this, 'swbdpam_ap_user_dash_before_header' ) );
            // Render on before dashboard menu bar
            add_action( 'directorist_dashboard_before_container', array( $this, 'swbdpam_ap_user_dash_before_dashboard_menu_bar' ) );
            // Render on before loop
            add_action( 'directorist_dashboard_tab_contents', array( $this, 'swbdpam_ap_user_dash_before_loop' ) );
            // Render in User Dashboard listings loop
            add_action( 'atbdp_dashboard_listings_loop', array( $this, 'swbdpam_dashboard_in_loop_ad_handler' ) );
            // Render on grid view in loop
            add_action( 'atbdp_dashboard_as_card_in_loop', array( $this, 'swbdpam_ap_user_dash_as_card_in_loop' ) );
            // Render on full row in loop
            add_action( 'directorist_dashboard_after_loop', array( $this, 'swbdpam_ap_user_dash_full_row_in_loop' ) );
            // Render on before pagination
            add_action( 'atbdp_dashboard_after_loop', array( $this, 'swbdpam_ap_user_dash_after_loop' ) );
            // Render on after footer
            add_action( 'wp_footer', array( $this, 'swbdpam_apd_after_footer' ) );

            // Hook remover
            add_action( 'plugins_loaded', array( $this, 'swbdpam_hook_remover' ) );
        }
 


        /**
         * This function place the hooks in loop 
         * 
         * @return void
         */
        public function swbdpam_dashboard_in_loop_ad_handler( $i )
        {
            $as_car_ad_id   = SWBDPAMHelperFunctions::get_ad_id( 'dashboard', 'swbdpam_dashboard_ad_places', 'as-card-in-loop' );
            $full_row_ad_id = SWBDPAMHelperFunctions::get_ad_id( 'dashboard', 'swbdpam_dashboard_ad_places', 'full-row-in-loop' );

            $ad_show_aft_listing    = get_post_meta( $as_car_ad_id, 'swbdpam_card_ad_show_after_lis', true );
            $ad_show_aft_row        = get_post_meta( $full_row_ad_id, 'swbdpam_row_ad_show_after_row', true );
            $is_card_ad_repeat      = get_post_meta( $as_car_ad_id, 'swbdpam_card_ad_repeat', true );
            $is_row_ad_repeat       = get_post_meta( $full_row_ad_id, 'swbdpam_row_ad_repeat', true );
            $number_of_columns      = get_directorist_option( 'all_listing_columns' );

            $ad_show_aft_listing    = isset( $ad_show_aft_listing ) ? (int)$ad_show_aft_listing : 4;
            $ad_show_aft_row        = isset( $ad_show_aft_row ) ? (int)$ad_show_aft_row : 1;
            $ad_show_aft_lis        = $number_of_columns * $ad_show_aft_row ;

/*            // 
            if( $ad_show_aft_listing == $i ){
                // Render on grid view in loop
                do_action( 'atbdp_dashboard_as_card_in_loop' );
            }

            // 
            if( $ad_show_aft_row == $i ){
                // Render on grid view in loop
                do_action( 'directorist_dashboard_after_loop' );
            }
*/
            if( isset( $is_row_ad_repeat ) && ( 'no' == $is_row_ad_repeat ) ){
                if( ( $ad_show_aft_lis + 1 ) === $i ){
                    // Render on grid & list view in loop in full row
                    do_action( 'directorist_dashboard_after_loop' );
                }
            }  

            if( isset( $is_row_ad_repeat ) && ( 'yes' == $is_row_ad_repeat ) ){
                for( $lis_indx = $ad_show_aft_lis + 1; $lis_indx <= $i; $lis_indx += (int)$ad_show_aft_lis ){
                    if( $i == $lis_indx ){
                        // Render on grid view in loop in full row
                        do_action( 'directorist_dashboard_after_loop' );
                    }
                }        
            }            

        }



        /**
         * This function display the ad on 'User Dashboard' page before header or menu
         * 
         * @return void
         */
        public function swbdpam_ap_user_dash_before_header()
        {   
            $page_id            = get_queried_object_id();
            $dashboard_page_id  = get_directorist_option( 'user_dashboard' ); 

            // Authenticate, Current page is 'User Deshboard' page or not
            if( $page_id == $dashboard_page_id ){
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'dashboard', 'swbdpam_dashboard_ad_places', 'before-header' );
                if( ! empty( $ad_id ) ){
                    ?>
                    <div class="directorist-dashboard-ad-before-header">
                        <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'dashboard', 'before-header' ); ?>
                    </div>
                    <?php
                }
            }

        }



        /**
         * This function display the ad on 'User Dashboard' page before dashboard menu bar
         * 
         * @return void
         */
        public function swbdpam_ap_user_dash_before_dashboard_menu_bar()
        {
            $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'dashboard', 'swbdpam_dashboard_ad_places', 'before-dashboard-menu' );
            if( ! empty( $ad_id ) ){
                ?>
                <div class="directorist-dash-ad-before-dashboard-menu">
                    <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'dashboard', 'before-dashboard-menu' ); ?>
                </div>
                <?php
            }
        }


        
        /**
         * This function display the ad on 'User Dashboard' page before loop
         * 
         * @return void
         */
        public function swbdpam_ap_user_dash_before_loop()
        {
            $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'dashboard', 'swbdpam_dashboard_ad_places', 'before-loop' );
            if( ! empty( $ad_id ) ){
                ?>
                <div class="directorist-dash-ad-before-loop">
                    <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'dashboard', 'before-loop' ); ?>
                </div>
                <?php
            }
        }


        /**
         * This function display the ad on 'User Dashboard' page grid view in loop
         * 
         * @return void
         */
        public function swbdpam_ap_user_dash_as_card_in_loop()
        {		
            $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'dashboard', 'swbdpam_dashboard_ad_places', 'as-card-in-loop' );
            if( ! empty( $ad_id ) ){
            ?>
            <div class='atbdp_column atbdp-col-3'>
                <div class='atbd_single_listing atbd_listing_card'>
                    <div class='atbd_single_listing_wrapper swbdpam__dash_ad_as_card_in_loop'>
                        <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'dashboard', 'as-card-in-loop' ); ?>
                    </div>
                </div>
            </div>
            <?php
            }
        }



        /**
         * This function display the ad on 'User Dashboard' page full row in loop
         * 
         * @return void
         */
        public function swbdpam_ap_user_dash_full_row_in_loop()
        {
            $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'dashboard', 'swbdpam_dashboard_ad_places', 'full-row-in-loop' );
            if( ! empty( $ad_id ) ){
                ?>
                <div class="col-12 directorist-dash-ad-full-row-in-loop">
                   <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'dashboard', 'full-row-in-loop' ); ?>
                </div>
                <?php
            }
        }
                


        /**
         * This function display the ad on 'User Dashboard' page before pagination
         * 
         * @return void
         */
        public function swbdpam_ap_user_dash_after_loop()
        {
            $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'dashboard', 'swbdpam_dashboard_ad_places', 'before-pagination' );
            if( ! empty( $ad_id ) ){
                ?>
                <div class="col-12">
                    <div class="directorist-s-home-ad-before-pagination">
                        <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'dashboard', 'before-pagination' ); ?>
                    </div>
                </div>
                <?php
            }
        }



        /**
         * This function display the ad on 'User Dashboard' page after footer
         * 
         * @return void
         */
        public function swbdpam_apd_after_footer()
        {
            $page_id            = get_queried_object_id();
            $dashboard_page_id  = get_directorist_option( 'user_dashboard' );

            // Authenticate, Current page is 'User Deshboard' page or not
            if( $page_id == $dashboard_page_id ){
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'dashboard', 'swbdpam_dashboard_ad_places', 'after-footer' );
                if( ! empty( $ad_id ) ){
                    ?>
                    <div class="directorist-dashboard-ad-after-footer">
                        <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'dashboard', 'after-footer' ); ?>
                    </div>
                    <?php
                }
            }
        }



        /**
         * Remove hooks when Ads Manager is disable
         */
        public function swbdpam_hook_remover()
        {
            // Get Ads Manager enable option
            $is_ads_manager_enable = get_directorist_option( 'swbdp_ads_manager_is_enable', 1 );

            // Authenticate, is Ads Manager enable or not
            if( 1 !== ( int )$is_ads_manager_enable ){
                remove_action( 'wp_head', array( $this, 'swbdpam_ap_user_dash_before_header' ) );
                remove_action( 'directorist_dashboard_before_container', array( $this, 'swbdpam_ap_user_dash_before_dashboard_menu_bar' ) );
                remove_action( 'directorist_dashboard_tab_contents', array( $this, 'swbdpam_ap_user_dash_before_loop' ) );
                remove_action( 'atbdp_dashboard_listings_loop', array( $this, 'swbdpam_dashboard_in_loop_ad_handler' ) );
                remove_action( 'atbdp_dashboard_as_card_in_loop', array( $this, 'swbdpam_ap_user_dash_as_card_in_loop' ) );
                remove_action( 'directorist_dashboard_after_loop', array( $this, 'swbdpam_ap_user_dash_full_row_in_loop' ) );
                remove_action( 'atbdp_dashboard_after_loop', array( $this, 'swbdpam_ap_user_dash_after_loop' ) );
                remove_action( 'wp_footer', array( $this, 'swbdpam_apd_after_footer' ) );
            }
        }


    }// Class closer
}// If statement closer