<?php
/**
 * @package  Directorist - Ads Manager
 */


if( ! class_exists( 'SWBDPAMPAuthorListing' ) ){
    /**
     * Aauthor Profile page ads handler class 
     */
    class SWBDPAMPAuthorListing 
    { 
        /** 
        * Class constructor 
        * Call all hooks which we wanna triger 
        */ 
        public function register() 
        { 
            // Render on header
            add_action( 'wp_head', array( $this, 'swbdpam_ap_auth_lis_before_header' ) );
            // Render on before author bar 
            add_action( 'atbdp_before_author_profile_section', array( $this, 'swbdpam_ap_auth_lis_before_author_bar' ) );
            add_action( 'directorist_before_author_profile_section', array( $this, 'swbdpam_ap_auth_lis_before_author_bar' ) );
            // Render on after author bar
            add_action( 'atbdp_before_author_about_section', array( $this, 'swbdpam_ap_auth_lis_before_author_about' ) );
            add_action( 'directorist_before_author_about_section', array( $this, 'swbdpam_ap_auth_lis_before_author_about' ) );
            // Render on after about
            add_action( 'atbdp_author_listing_after_about_section', array( $this, 'swbdpam_ap_auth_lis_after_about' ) );
            add_action( 'directorist_author_listing_after_about_section', array( $this, 'swbdpam_ap_auth_lis_after_about' ) );
            // Render on before loop
            add_action( 'atbdp_author_listings_before_loop', array( $this, 'swbdpam_ap_auth_lis_before_loop' ) );
            add_action( 'directorist_author_listings_before_loop', array( $this, 'swbdpam_ap_auth_lis_before_loop' ) );
            // Render in listings loop
            add_action( 'atbdp_listings_loop', array( $this, 'swbdpam_author_listings_in_loop_ad_handler' ) );
            // Render on grid view in loop
            add_action( 'atbdp_author_listing_as_card_in_loop', array( $this, 'swbdpam_ap_auth_lis_as_card_in_loop' ) );
            // Render on grid view in loop full row
            add_action( 'atbdp_author_listing_full_row_in_loop', array( $this, 'swbdpam_ap_auth_lis_full_row_in_loop' ) );
            // Render on before pagination
            add_action( 'atbdp_author_listings_before_pagination', array( $this, 'swbdpam_ap_auth_lis_before_pagination' ) );
            // Render on after footer
            add_action( 'wp_footer', array( $this, 'swbdpam_ap_auth_lis_after_footer' ) );
            
            // Hook remover
            add_action( 'plugins_loaded', array( $this, 'swbdpam_hook_remover' ) );
        }

  

        /**
         * This function place the hooks in loop 
         * 
         * @return void
         */
        public function swbdpam_author_listings_in_loop_ad_handler( $i )
        {
            $as_car_ad_id   = SWBDPAMHelperFunctions::get_ad_id( 'author_profile', 'swbdpam_author_listings_ad_places', 'as-card-in-loop' );
            $full_row_ad_id = SWBDPAMHelperFunctions::get_ad_id( 'author_profile', 'swbdpam_author_listings_ad_places', 'full-row-in-loop' );

            $ad_show_aft_listing    = get_post_meta( $as_car_ad_id, 'swbdpam_card_ad_show_after_lis', true );
            $ad_show_aft_row        = get_post_meta( $full_row_ad_id, 'swbdpam_row_ad_show_after_row', true );
            $is_card_ad_repeat      = get_post_meta( $as_car_ad_id, 'swbdpam_card_ad_repeat', true );
            $is_row_ad_repeat       = get_post_meta( $full_row_ad_id, 'swbdpam_row_ad_repeat', true );
            $number_of_columns      = get_directorist_option( 'all_listing_columns' );

            $ad_show_aft_listing = isset( $ad_show_aft_listing ) ? (int)$ad_show_aft_listing : 4;
            $ad_show_aft_row    = isset( $ad_show_aft_row ) ? (int)$ad_show_aft_row : 1;

            // 
            if( $ad_show_aft_listing == $i ){
                // Render on grid view in loop
                do_action( 'atbdp_author_listing_as_card_in_loop' );
            }

            // 
            if( $ad_show_aft_row == $i ){
                // Render on grid view in loop
                do_action( 'atbdp_author_listing_full_row_in_loop' );
            }
        }



        /**
         * This function display the ad on 'Aauthor Profile' page before header or menu
         * 
         * @return void
         */
        public function swbdpam_ap_auth_lis_before_header()
        {   
            $page_id                = get_queried_object_id();
            $author_profile_page_id = get_directorist_option( 'author_profile_page' );

            // Authenticate, Current page is 'Aauthor Profile' page or not
            if( $page_id == $author_profile_page_id ){
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'author_profile', 'swbdpam_author_listings_ad_places', 'before-header' );
                if( ! empty( $ad_id ) ){
                    ?>
                    <div class="directorist-add-author-ad-before-header">
                        <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'author_profile', 'before-header' ); ?>
                    </div>
                    <?php
                }
            }
            
        }



        /**
         * This function display the ad on 'Aauthor Profile' page before author bar
         * 
         * @return void
         */
        public function swbdpam_ap_auth_lis_before_author_bar()
        {
            $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'author_profile', 'swbdpam_author_listings_ad_places', 'before-author-image' );
            if( ! empty( $ad_id ) ){
                ?>
                <div class="directorist-author-ad-before-author-img">
                    <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'author_profile', 'before-author-image' ); ?>
                </div>
                <?php
            }
        }



        /**
         * This function display the ad on 'Aauthor Profile' page after author bar
         * 
         * @return void
         */
        public function swbdpam_ap_auth_lis_before_author_about()
        {
            $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'author_profile', 'swbdpam_author_listings_ad_places', 'after-author-image' );
            if( ! empty( $ad_id ) ){
                ?>
                <div class="directorist-author-ad-after-author-img">
                    <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'author_profile', 'after-author-image' ); ?>
                </div>
                <?php
            }
        }



        /**
         * This function display the ad on 'Aauthor Profile' page after about
         * 
         * @return void
         */
        public function swbdpam_ap_auth_lis_after_about()
        {
            $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'author_profile', 'swbdpam_author_listings_ad_places', 'after-author-about' );
            if( ! empty( $ad_id ) ){
                ?>
                <div class="directorist-author-ad-after-author-about">
                    <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'author_profile', 'after-author-about' ); ?>
                </div>
                <?php
            }

        }



        /**
         * This function display the ad on 'Aauthor Profile' page before loop
         * 
         * @return void
         */
        public function swbdpam_ap_auth_lis_before_loop()
        {
            $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'author_profile', 'swbdpam_author_listings_ad_places', 'before-loop' );
            if( ! empty( $ad_id ) ){
                ?>
                <div class="directorist-author-ad-before-loop">
                    <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'author_profile', 'before-loop' ); ?>
                </div>
                <?php
            }
        }



        /**
         * This function display the ad on 'Aauthor Profile' page grid view in loop
         * 
         * @return void
         */
        public function swbdpam_ap_auth_lis_as_card_in_loop()
        {
            $page_id                = get_queried_object_id();
            $author_profile_page_id = get_directorist_option( 'author_profile_page' );

            // Authenticate, Current page is 'Aauthor Profile' page or not
            if( $page_id == $author_profile_page_id ){
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'author_profile', 'swbdpam_author_listings_ad_places', 'as-card-in-loop' );
                if( ! empty( $ad_id ) ){   
                ?>            
                <div class='atbdp_column atbdp-col-3'>
                    <div class='atbd_single_listing atbd_listing_card'>
                        <div class='atbd_single_listing_wrapper swbdpam__auth_ad_as_card_in_loop'>     
                            <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'author_profile', 'as-card-in-loop' ); ?>
                        </div>
                    </div>
                </div>
                <?php
                }
            }
        }
                


        /**
         * This function display the ad on 'Aauthor Profile' page full row in loop
         * 
         * @return void
         */
        public function swbdpam_ap_auth_lis_full_row_in_loop()
        {
            $page_id                = get_queried_object_id();
            $author_profile_page_id = get_directorist_option( 'author_profile_page' );

            // Authenticate, Current page is 'Aauthor Profile' page or not
            if( $page_id == $author_profile_page_id ){
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'author_profile', 'swbdpam_author_listings_ad_places', 'full-row-in-loop' );          
                if( ! empty( $ad_id ) ){
                    ?>
                    <div class="col-12 swbdpam__auth_ad_full_row_in_loop">
                       <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'author_profile', 'full-row-in-loop' ); ?>
                    </div>
                    <?php
                }
            }
        }



        /**
         * This function display the ad on 'Aauthor Profile' page before pagination
         * 
         * @return void
         */
        public function swbdpam_ap_auth_lis_before_pagination()
        {
            $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'author_profile', 'swbdpam_author_listings_ad_places', 'before-pagination' );
            if( ! empty( $ad_id ) ){
                ?>
                <div class="directorist-auth-ad-before-pagination">
                    <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'author_profile', 'before-pagination' ); ?>
                </div>
                <?php
            }
        }



        /**
         * This function display the ad on 'Aauthor Profile' page after footer
         * 
         * @return void
         */
        public function swbdpam_ap_auth_lis_after_footer()
        {
            // Authenticate, Current page is 'Aauthor Profile' page or not
            $page_id                = get_queried_object_id();
            $author_profile_page_id = get_directorist_option( 'author_profile_page' );

            if( $page_id == $author_profile_page_id ){
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'author_profile', 'swbdpam_author_listings_ad_places', 'after-footer' );
                if( ! empty( $ad_id ) ){
                    ?>
                    <div class="directorist-add-author-ad-after-footer">
                        <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id , 'author_profile', 'after-footer'); ?>
                    </div>
                    <?php
                }
            }
        }



        /**
         * Remove hooks when Ads Manager is disable
         */
        public function swbdpam_hook_remover()
        {
            // Get Ads Manager enable option
            $is_ads_manager_enable = get_directorist_option( 'swbdp_ads_manager_is_enable', 1 );

            // Authenticate, is Ads Manager enable or not
            if( 1 !== ( int )$is_ads_manager_enable ){
                remove_action( 'wp_head', array( $this, 'swbdpam_ap_auth_lis_before_header' ) ); 
                remove_action( 'atbdp_before_author_profile_section', array( $this, 'swbdpam_ap_auth_lis_before_author_bar' ) );
                remove_action( 'directorist_before_author_profile_section', array( $this, 'swbdpam_ap_auth_lis_before_author_bar' ) );
                remove_action( 'atbdp_before_author_about_section', array( $this, 'swbdpam_ap_auth_lis_before_author_about' ) );
                remove_action( 'directorist_before_author_about_section', array( $this, 'swbdpam_ap_auth_lis_before_author_about' ) );
                remove_action( 'atbdp_author_listing_after_about_section', array( $this, 'swbdpam_ap_auth_lis_after_about' ) );
                remove_action( 'directorist_author_listing_after_about_section', array( $this, 'swbdpam_ap_auth_lis_after_about' ) );
                remove_action( 'atbdp_author_listings_before_loop', array( $this, 'swbdpam_ap_auth_lis_before_loop' ) );
                remove_action( 'directorist_author_listings_before_loop', array( $this, 'swbdpam_ap_auth_lis_before_loop' ) );
                remove_action( 'atbdp_listings_loop', array( $this, 'swbdpam_author_listings_in_loop_ad_handler' ) );
                remove_action( 'atbdp_author_listing_as_card_in_loop', array( $this, 'swbdpam_ap_auth_lis_as_card_in_loop' ) );
                remove_action( 'atbdp_author_listing_full_row_in_loop', array( $this, 'swbdpam_ap_auth_lis_full_row_in_loop' ) );
                remove_action( 'atbdp_author_listings_before_pagination', array( $this, 'swbdpam_ap_auth_lis_before_pagination' ) );
                remove_action( 'wp_footer', array( $this, 'swbdpam_ap_auth_lis_after_footer' ) );
            }
        }


    }// Close closer
}// If statement closer