<?php
/**
 * @package  Directorist - Ads Manager
 */


if( ! class_exists( 'SWBDPAMPAllLocations' ) ){
    /**
     * 'All-Locations' page ads handler class
     */
    class SWBDPAMPAllLocations
    {
        /**
         * Class constructor
         * Call all hooks which we wanna triger
         */
        public function register()
        {
            // Render on header
            add_action( 'wp_head', array( $this, 'swbdpam_ap_all_loc_before_header' ) );
            // Render on before add new title
            add_action( 'atbdp_before_all_locations_loop', array( $this, 'swbdpam_ap_all_loc_before_loop' ) );
            // Render on after save preview button
            add_action( 'atbdp_after_all_locations_loop', array( $this, 'swbdpam_ap_all_loc_after_loop' ) );
            // Render on footer
            add_action( 'wp_footer', array( $this, 'swbdpam_ap_all_loc_after_footer' ) );

            // Hook remover
            add_action( 'plugins_loaded', array( $this, 'swbdpam_hook_remover' ) );
        }
 

        
        /**
         * This function display the ad on 'All-Locations' page before header or menu
         * 
         * @return void
         */
        public function swbdpam_ap_all_loc_before_header()
        {
            $page_id            = get_queried_object_id();
            $all_loc_page_id    = get_directorist_option( 'all_locations_page' );

            // Authenticate, Current page is 'All-Locations' page or not
            if( $page_id == $all_loc_page_id ){
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'all_location', 'swbdpam_all_loc_ad_places', 'before-header' );
                if( ! empty( $ad_id ) ){
                    ?>
                    <div class="directorist-all-loc-ad-before-header">
                        <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'all_location', 'before-header' ); ?>
                    </div>
                    <?php
                }
            }
        }


        /**
         * This function display the ad on 'All-Locations' page before add new title
         * 
         * @return void
         */
        public function swbdpam_ap_all_loc_before_loop()
        {           
            $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'all_location', 'swbdpam_all_loc_ad_places', 'before-loop' ); 
            if( ! empty( $ad_id ) ){
                ?>
                <div class="directorist-all-loc-ad-before-loop">
                    <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'all_location', 'before-loop' ); ?>
                </div>
                <?php
            }
        }

        

        /**
        * This function display the ad on 'All-Locations' page after save preview btn
        * 
        * @return void
        */
        public function swbdpam_ap_all_loc_after_loop()
        {
            $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'all_location', 'swbdpam_all_loc_ad_places', 'after-loop' );
            if( ! empty( $ad_id ) ){
                ?>
                <div class="directorist-all-loc-ad-after-loop">
                    <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'all_location', 'after-loop' ); ?>
                </div>
                <?php
            }
        }



        /**
         * This function display the ad on 'All-Locations' page after footer
         * 
         * @return void
         */
        public function swbdpam_ap_all_loc_after_footer()
        {
            $page_id            = get_queried_object_id();
            $all_loc_page_id    = get_directorist_option( 'all_locations_page' );

            // Authenticate, Current page is 'All-Locations' page or not
            if( $page_id == $all_loc_page_id ){
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'all_location', 'swbdpam_all_loc_ad_places', 'after-footer' );
                if( ! empty( $ad_id ) ){
                    ?>
                    <div class="directorist-all-loc-ad-after-footer">
                        <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'all_location', 'after-footer' ); ?>
                    </div>
                    <?php
                }
            }
        }



        
        /**
         * Remove hooks when Ads Manager is disable
         */
        public function swbdpam_hook_remover()
        {
            // Get Ads Manager enable option
            $is_ads_manager_enable = get_directorist_option( 'swbdp_ads_manager_is_enable', 1 );

            // Authenticate, is Ads Manager enable or not
            if( 1 !== ( int )$is_ads_manager_enable ){
                remove_action( 'wp_head', array( $this, 'swbdpam_ap_all_loc_before_header' ) );
                remove_action( 'atbdp_before_all_locations_loop', array( $this, 'swbdpam_ap_all_loc_before_loop' ) );
                remove_action( 'atbdp_after_all_locations_loop', array( $this, 'swbdpam_ap_all_loc_after_loop' ) );
                remove_action( 'wp_footer', array( $this, 'swbdpam_ap_all_loc_after_footer' ) );
            }
        }


    } // Class Closer
} // If statement Closer