<?php
/**
 * @package  Directorist - Ads Manager
 */


if( ! class_exists( 'SWBDPAMPAllListings' ) ){
    /**
    * All-listing page ads handler class
    */
    class SWBDPAMPAllListings
    {
        /**
         * Class constructor
         * Call all hooks which we wanna triger
         */
        public function register()
        {   
            // Render on header
            add_action( 'wp_head', array( $this, 'swbdpam_ap_all_lis_before_header' ) );
            // Render on before filter
            add_action( 'directorist_archive_header', array( $this, 'swbdpam_ap_all_lis_before_filter_bar' ) );
            add_action( 'directorist_before_listing_types', array( $this, 'swbdpam_ap_all_lis_before_filter_bar' ) );

            //add_filter( 'atbdp_all_listings_query_arguments', array( $this, 'control_listings_per_page' ) );
            
            // Render on after filter
            add_action( 'atbdp_before_grid_listings_loop', array( $this, 'swbdpam_ap_all_lis_after_filter_bar' ) );
            add_action( 'directorist_before_grid_listings_loop', array( $this, 'swbdpam_ap_all_lis_after_filter_bar' ) );

            add_action( 'atbdp_before_list_listings_loop', array( $this, 'swbdpam_ap_all_lis_after_filter_bar' ) );
            add_action( 'directorist_before_list_listings_loop', array( $this, 'swbdpam_ap_all_lis_after_filter_bar' ) );

            // Render in all listing loop
            add_action( 'atbdp_listings_loop', array( $this, 'swbdpam_all_lis_in_loop_ad_handler' ) );
            // Render on grid view in loop
            add_action( 'swbdpam_all_listing_as_card_in_loop', array( $this, 'swbdpam_ap_all_lis_as_card_in_loop' ) );
            // Render on before pagination
            add_action( 'atbdp_before_listings_pagination', array( $this, 'swbdpam_ap_all_lis_before_pagination' ) );
            add_action( 'directorist_before_listings_pagination', array( $this, 'swbdpam_ap_all_lis_before_pagination' ) );
            // Render on after pagination
            add_action( 'atbdp_after_grid_listings_loop', array( $this, 'swbdpam_ap_all_lis_after_pagination' ) );
            add_action( 'directorist_after_grid_listings_loop', array( $this, 'swbdpam_ap_all_lis_after_pagination' ) );
            add_action( 'directorist_after_list_listings_loop', array( $this, 'swbdpam_ap_all_lis_after_pagination' ) );
            // Render on footer
            add_action( 'wp_footer', array( $this, 'swbdpam_ap_all_lis_after_footer' ) );

            // Hook remover
            add_action( 'plugins_loaded', array( $this, 'swbdpam_hook_remover' ) );
        }


 
        public function swbdpam_all_lis_in_loop_ad_handler( $i )
        {
            $as_car_ad_id   = SWBDPAMHelperFunctions::get_ad_id( 'all_listings', 'swbdpam_all_listings_ad_places', 'as-card-in-loop' );
            $full_row_ad_id = SWBDPAMHelperFunctions::get_ad_id( 'all_listings', 'swbdpam_all_listings_ad_places', 'full-row-in-loop' );

            $ad_show_aft_listing    = get_post_meta( $as_car_ad_id, 'swbdpam_card_ad_show_after_lis', true );
            $ad_show_aft_row        = get_post_meta( $full_row_ad_id, 'swbdpam_row_ad_show_after_row', true );
            $is_card_ad_repeat      = get_post_meta( $as_car_ad_id, 'swbdpam_card_ad_repeat', true );
            $is_row_ad_repeat       = get_post_meta( $full_row_ad_id, 'swbdpam_row_ad_repeat', true );

            $number_of_columns      = get_directorist_option( 'all_listing_columns' );
            

            $ad_show_aft_listing    = isset( $ad_show_aft_listing ) ? (int)$ad_show_aft_listing : 0;
            $ad_show_aft_row        = isset( $ad_show_aft_row ) ? (int)$ad_show_aft_row : 1;
            $ad_show_aft_lis        = $number_of_columns * $ad_show_aft_row ;

/*
            //if( isset( $is_card_ad_repeat ) && ( 'no' == $is_card_ad_repeat ) ){
            //if( $ad_show_aft_listing < $ad_show_aft_lis ){
                if( ( $ad_show_aft_listing + 1 ) === $i ){
                    // Render on grid & list view in loop in full row
                    do_action( 'swbdpam_all_listing_as_card_in_loop' );              
                }
            //}
*/                        

            if( isset( $is_row_ad_repeat ) && ( 'no' == $is_row_ad_repeat ) ){
                if( ( $ad_show_aft_lis + 1 ) === $i ){
                    // Render on grid & list view in loop in full row
                    do_action( 'swbdpam_all_listing_full_row_in_loop' );
                }
            }  
            
            if( isset( $is_row_ad_repeat ) && ( 'yes' == $is_row_ad_repeat ) ){
                for( $lis_indx = $ad_show_aft_lis + 1; $lis_indx <= $i; $lis_indx += (int)$ad_show_aft_lis ){
                    if( $i == $lis_indx ){
                        // Render on grid view in loop in full row
                        do_action( 'swbdpam_all_listing_full_row_in_loop' );
                    }
                }        
            }            
        }
/*
        public function control_listings_per_page( $args )
        {
            $num_of_lis_in_page     = get_directorist_option( 'all_listing_page_items' );
            $args['posts_per_page'] = (int)$num_of_lis_in_page - 1;
            return $args;
        }
*/

        /**
         * This function display the ad on 'All-listing' page before header or menu
         * 
         * @return void
         */
        public function swbdpam_ap_all_lis_before_header()
        {   
            $page_id                = get_queried_object_id();
            $all_listing_page_id    = get_directorist_option( 'all_listing_page' );            
            $all_listing            = ( $page_id == $all_listing_page_id ) ? true : false;

            // Authenticate, Current page is 'All-Listings' page or not
            if( apply_filters( 'directorist_all_listing_header_ad', $all_listing ) ){
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'all_listings', 'swbdpam_all_listings_ad_places', 'before-header' );
                if( ! empty( $ad_id ) ){
                    ?>
                    <div class="directorist-all-ad-before-header">
                        <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'all_listings', 'before-header' ); ?>
                    </div>
                    <?php
                }
            }            
        }


        /**
         * This function display the ad on All-listing page before filter
         * 
         * @return void
         */
        public function swbdpam_ap_all_lis_before_filter_bar( )
        {   
            $page_id                = get_queried_object_id();
            $all_listing_page_id    = get_directorist_option( 'all_listing_page' );
            
            // Authenticate, Current page is 'All-Listings' page or not
            if( $page_id == $all_listing_page_id ){
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'all_listings', 'swbdpam_all_listings_ad_places', 'before-filter' );
                if( ! empty( $ad_id ) ){
                    ?>
                    <div class="directorist-all-ad-before-filter">
                        <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'all_listings', 'before-filter' ); ?>
                    </div>
                    <?php
                }                    
            }
        }


        /**
         * This function display the ad on All-listing page after filter
         * 
         * @return void
         */
        public function swbdpam_ap_all_lis_after_filter_bar()
        {
            $page_id                = get_queried_object_id();
            $all_listing_page_id    = get_directorist_option( 'all_listing_page' );

            // Authenticate, Current page is 'All-Listings' page or not
            if( $page_id == $all_listing_page_id ){
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'all_listings', 'swbdpam_all_listings_ad_places', 'after-filter' );
                if( ! empty( $ad_id ) ){
                    ?>
                    <div class="directorist-all-ad-after-filter">
                        <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'all_listings', 'after-filter' ); ?>
                    </div>
                    <?php
                }                    
            }
        }



        /**
         * This function display the ad on All-listing page grid view in loop
         * 
         * @return void
         */
        public function swbdpam_ap_all_lis_as_card_in_loop( $view  )
        {	
            $page_id                = get_queried_object_id();
            $all_listing_page_id    = get_directorist_option( 'all_listing_page' );

            //$default_view   = get_directorist_option( 'default_listing_view' );
            $view_as    = isset( $_GET['view'] ) ? sanitize_text_field( $_GET['view'] ) : '';
            if( 'list' == $view || 'list' == $view_as ){
                return;
            }
            
            // Authenticate, Current page is 'All-Listings' page or not
            if( $page_id == $all_listing_page_id ) {
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'all_listings', 'swbdpam_all_listings_ad_places', 'as-card-in-loop' );
                if( ! empty( $ad_id ) ){
                ?>
                <div class='atbdp_column atbdp-col-3'>
                    <div class='atbd_single_listing atbd_listing_card'>
                        <div class='atbd_single_listing_wrapper swbdpam__all_ad_as_card_in_loop'>
                            <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'all_listings', 'as-card-in-loop' ); ?>
                        </div>
                    </div>
                </div>
                <?php
                }
            }
        }
                
        /**
         * This function display the ad on All-listing page before pagination
         * 
         * @return void
         */
        public function swbdpam_ap_all_lis_before_pagination()
        {
            $page_id                = get_queried_object_id();
            $all_listing_page_id    = get_directorist_option( 'all_listing_page' );

            // Authenticate, Current page is 'All-Listings' page or not
            if( $page_id == $all_listing_page_id ){
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'all_listings', 'swbdpam_all_listings_ad_places', 'before-pagination' );       
                if( ! empty( $ad_id ) ){
                    ?>
                    <div class="directorist-all-ad-before-pagination">
                        <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'all_listings', 'before-pagination' ); ?>
                    </div>
                    <?php
                }                    
            }
        }




        /**
         * This function display the ad on All-listing page after pagination
         * 
         * @return void
         */
        public function swbdpam_ap_all_lis_after_pagination()
        {
            $page_id                = get_queried_object_id();
            $all_listing_page_id    = get_directorist_option( 'all_listing_page' );

            // Authenticate, Current page is 'All-Listings' page or not
            if( $page_id == $all_listing_page_id ){
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'all_listings', 'swbdpam_all_listings_ad_places', 'after-pagination' );          
                if( ! empty( $ad_id ) ){
                    ?>
                    <div class="directorist-all-ad-after-pagination">
                        <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'all_listings', 'after-pagination' ); ?>
                    </div>
                    <?php
                }                    
            }
        }
        



        /**
         * This function display the ad on All-listing page after footer
         * 
         * @return void
         */
        public function swbdpam_ap_all_lis_after_footer()
        {
            // Authenticate, Current page is 'All-Listings' page or not
            $page_id                = get_queried_object_id();
            $all_listing_page_id    = get_directorist_option( 'all_listing_page' );
            $all_listing            = ( $page_id == $all_listing_page_id ) ? true : false;

            // Authenticate, Current page is 'All-Listings' page or not
            if( apply_filters( 'directorist_all_listing_footer_ad', $all_listing ) ){
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'all_listings', 'swbdpam_all_listings_ad_places', 'after-footer' );
                if( ! empty( $ad_id ) ){
                    ?>
                    <div class="directorist-all-ad-after-footer">
                        <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'all_listings', 'after-footer' ); ?>
                    </div>
                    <?php
                }
            }
        }



        /**
         * Remove hooks when Ads Manager is disable
         */
        public function swbdpam_hook_remover()
        {
            // Get Ads Manager enable option
            $is_ads_manager_enable = get_directorist_option( 'swbdp_ads_manager_is_enable', 1 );

            // Authenticate, is Ads Manager enable or not
            if( 1 !== ( int )$is_ads_manager_enable ){
                remove_action( 'wp_head', array( $this, 'swbdpam_ap_all_lis_before_header' ) );
                remove_action( 'directorist_archive_header', array( $this, 'swbdpam_ap_all_lis_before_filter_bar' ) );
                remove_action( 'directorist_before_listing_types', array( $this, 'swbdpam_ap_all_lis_before_filter_bar' ) );
                remove_action( 'atbdp_before_grid_listings_loop', array( $this, 'swbdpam_ap_all_lis_after_filter_bar' ) );
                remove_action( 'directorist_before_grid_listings_loop', array( $this, 'swbdpam_ap_all_lis_after_filter_bar' ) );
                remove_action( 'atbdp_before_list_listings_loop', array( $this, 'swbdpam_ap_all_lis_after_filter_bar' ) );
                remove_action( 'directorist_before_list_listings_loop', array( $this, 'swbdpam_ap_all_lis_after_filter_bar' ) );
                remove_action( 'atbdp_listings_loop', array( $this, 'swbdpam_all_lis_in_loop_ad_handler' ) );
                remove_action( 'swbdpam_all_listing_as_card_in_loop', array( $this, 'swbdpam_ap_all_lis_as_card_in_loop' ) );
                remove_action( 'atbdp_before_listings_pagination', array( $this, 'swbdpam_ap_all_lis_before_pagination' ) );
                remove_action( 'directorist_before_listings_pagination', array( $this, 'swbdpam_ap_all_lis_before_pagination' ) );
                remove_action( 'atbdp_after_grid_listings_loop', array( $this, 'swbdpam_ap_all_lis_after_pagination' ) );
                remove_action( 'directorist_after_grid_listings_loop', array( $this, 'swbdpam_ap_all_lis_after_pagination' ) );
                remove_action( 'directorist_after_list_listings_loop', array( $this, 'swbdpam_ap_all_lis_after_pagination' ) );
                remove_action( 'wp_footer', array( $this, 'swbdpam_ap_all_lis_after_footer' ) );
            }
        }


    }// Class closer
}