<?php
/**
 * @package  Directorist - Ads Manager
 */


if( ! class_exists( 'SWBDPAMPAllCategories' ) ){
    /**
     * All-Categories' page ads handler class
     */
    class SWBDPAMPAllCategories
    {
        /**
         * Class constructor
         * Call all hooks which we wanna triger
         */
        public function register()
        {
            // Render on header
            add_action( 'wp_head', array( $this, 'swbdpam_ap_all_cat_before_header' ) );
            // Render on before loop
            add_action( 'atbdp_before_all_categories_loop', array( $this, 'swbdpam_ap_all_cat_before_loop' ) );
            // Render on after loop
            add_action( 'atbdp_after_all_categories_loop', array( $this, 'swbdpam_ap_all_cat_after_loop' ) );
            // Render on footer
            add_action( 'wp_footer', array( $this, 'swbdpam_ap_all_cat_after_footer' ) );

            // Hook remover
            add_action( 'plugins_loaded', array( $this, 'swbdpam_hook_remover' ) );
        }
 

        
        /**
         * This function display the ad on 'All-Categories' page before header or menu
         * 
         * @return void
         */
        public function swbdpam_ap_all_cat_before_header()
        {
            $page_id            = get_queried_object_id();
            $all_cat_page_id    = get_directorist_option( 'all_categories_page' );

            // Authenticate, Current page is 'All-Categories' page or not
            if( $page_id == $all_cat_page_id ){
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'all_categories', 'swbdpam_all_cat_ad_places', 'before-header' );
                if( ! empty( $ad_id ) ){
                    ?>
                    <div class="directorist-all-cat-add-before-header">
                        <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'all_categories', 'before-header' ); ?>
                    </div>
                    <?php
                }
            }
        }


        /**
         * This function display the ad on 'All-Categories' page before add new title
         * 
         * @return void
         */
        public function swbdpam_ap_all_cat_before_loop()
        {           
            $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'all_categories', 'swbdpam_all_cat_ad_places', 'before-loop' ); 
            if( ! empty( $ad_id ) ){
                ?>
                <div class="directorist-all-cat-ad-before-loop">
                    <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'all_categories', 'before-loop' ); ?>
                </div>
                <?php
            }
        }

        

        /**
        * This function display the ad on 'All-Categories' page after save preview btn
        * 
        * @return void
        */
        public function swbdpam_ap_all_cat_after_loop()
        {
            $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'all_categories', 'swbdpam_all_cat_ad_places', 'after-loop' );
            if( ! empty( $ad_id ) ){
                ?>
                <div class="directorist-all-cat-ad-after-loop">
                    <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'all_categories', 'after-loop' ); ?>
                </div>
                <?php
            }
        }



        /**
         * This function display the ad on 'All-Categories' page after footer
         * 
         * @return void
         */
        public function swbdpam_ap_all_cat_after_footer()
        {
            $page_id            = get_queried_object_id();
            $all_cat_page_id    = get_directorist_option( 'all_categories_page' );

            // Authenticate, Current page is 'All-Categories' page or not
            if( $page_id == $all_cat_page_id ){
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'all_categories', 'swbdpam_all_cat_ad_places', 'after-footer' );
                if( ! empty( $ad_id ) ){
                    ?>
                    <div class="directorist-all-cat-ad-after-footer">
                        <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'all_categories', 'after-footer' ); ?>
                    </div>
                    <?php
                }
            }
        }



        
        /**
         * Remove hooks when Ads Manager is disable
         */
        public function swbdpam_hook_remover()
        {
            // Get Ads Manager enable option
            $is_ads_manager_enable = get_directorist_option( 'swbdp_ads_manager_is_enable', 1 );

            // Authenticate, is Ads Manager enable or not
            if( 1 !== ( int )$is_ads_manager_enable ){
                remove_action( 'wp_head', array( $this, 'swbdpam_ap_all_cat_before_header' ) );
                remove_action( 'atbdp_before_all_categories_loop', array( $this, 'swbdpam_ap_all_cat_before_loop' ) );
                remove_action( 'atbdp_after_all_categories_loop', array( $this, 'swbdpam_ap_all_cat_after_loop' ) );
                remove_action( 'wp_footer', array( $this, 'swbdpam_ap_all_cat_after_footer' ) );
            }
        }


    } // Class Closer
} // If statement Closer