<?php
/**
 * @package  Directorist - Ads Manager
 */


if( ! class_exists( 'SWBDPAMPAddListing' ) ){
    /**
     * Add-Listing' page ads handler class
     */
    class SWBDPAMPAddListing
    {
        /**
         * Class constructor
         * Call all hooks which we wanna triger
         */
        public function register()
        {
            // Render on header
            add_action( 'wp_head', array( $this, 'swbdpam_ap_add_lis_before_header' ) );
            // Render on before add new title
            add_action( 'atbdb_before_add_listing_from_frontend', array( $this, 'swbdpam_ap_add_lis_before_add_new_title' ) );
            add_action( 'directorist_before_add_listing_from_frontend', array( $this, 'swbdpam_ap_add_lis_before_add_new_title' ) );
            // Render on after save preview button
            add_action( 'atbdp_after_submit_listing_frontend', array( $this, 'swbdpam_ap_add_lis_after_save_preview_btn' ) );
            add_action( 'directorist_after_submit_listing_frontend', array( $this, 'swbdpam_ap_add_lis_after_save_preview_btn' ) );
            // Render on footer
            add_action( 'wp_footer', array( $this, 'swbdpam_ap_add_lis_after_footer' ) );

            // Hook remover
            add_action( 'plugins_loaded', array( $this, 'swbdpam_hook_remover' ) );
        }
 

        
        /**
         * This function display the ad on 'Add-Listing' page before header or menu
         * 
         * @return void
         */
        public function swbdpam_ap_add_lis_before_header()
        {
            $page_id                = get_queried_object_id();
            $add_listing_page_id    = get_directorist_option( 'add_listing_page' );

            // Authenticate, Current page is 'Add-Listing' page or not
            if( $page_id == $add_listing_page_id ){
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'add_listing', 'swbdpam_add_listing_ad_places', 'before-header' );
                if( ! empty( $ad_id ) ){
                    ?>
                    <div class="directorist-add-ad-before-header">
                        <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'add_listing', 'before-header' ); ?>
                    </div>
                    <?php
                }
            }
        }


        /**
         * This function display the ad on 'Add-Listing' page before add new title
         * 
         * @return void
         */
        public function swbdpam_ap_add_lis_before_add_new_title()
        {           
            $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'add_listing', 'swbdpam_add_listing_ad_places', 'before-add-new-title' ); 
            if( ! empty( $ad_id ) ){
                ?>
                <div class="directorist-add-ad-before-add-new-title">
                    <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'add_listing', 'before-add-new-title' ); ?>
                </div>
                <?php
            }
        }

        

        /**
        * This function display the ad on 'Add-Listing' page after save preview btn
        * 
        * @return void
        */
        public function swbdpam_ap_add_lis_after_save_preview_btn()
        {
            $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'add_listing', 'swbdpam_add_listing_ad_places', 'after-save-preview-btn' );
            if( ! empty( $ad_id ) ){
                ?>
                <div class="directorist-add-ad-after-save-preview-btn">
                    <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'add_listing', 'after-save-preview-btn' ); ?>
                </div>
                <?php
            }
        }



        /**
         * This function display the ad on 'Add-Listing' page after footer
         * 
         * @return void
         */
        public function swbdpam_ap_add_lis_after_footer()
        {
            $page_id                = get_queried_object_id();
            $add_listing_page_id    = get_directorist_option( 'add_listing_page' );

            // Authenticate, Current page is 'Add-Listing' page or not
            if( $page_id == $add_listing_page_id ){
                $ad_id = SWBDPAMHelperFunctions::get_ad_id( 'add_listing', 'swbdpam_add_listing_ad_places', 'after-footer' );
                if( ! empty( $ad_id ) ){
                    ?>
                    <div class="directorist-add-ad-after-footer">
                        <?php echo SWBDPAMHelperFunctions::display_ad( $ad_id, 'add_listing', 'after-footer' ); ?>
                    </div>
                    <?php
                }
            }
        }



        
        /**
         * Remove hooks when Ads Manager is disable
         */
        public function swbdpam_hook_remover()
        {
            // Get Ads Manager enable option
            $is_ads_manager_enable = get_directorist_option( 'swbdp_ads_manager_is_enable', 1 );

            // Authenticate, is Ads Manager enable or not
            if( 1 !== ( int )$is_ads_manager_enable ){
                remove_action( 'wp_head', array( $this, 'swbdpam_ap_add_lis_before_header' ) );
                remove_action( 'atbdb_before_add_listing_from_frontend', array( $this, 'swbdpam_ap_add_lis_before_add_new_title' ) );
                remove_action( 'directorist_before_add_listing_from_frontend', array( $this, 'swbdpam_ap_add_lis_before_add_new_title' ) );
                remove_action( 'atbdp_after_submit_listing_frontend', array( $this, 'swbdpam_ap_add_lis_after_save_preview_btn' ) );
                remove_action( 'directorist_after_submit_listing_frontend', array( $this, 'swbdpam_ap_add_lis_after_save_preview_btn' ) );
                remove_action( 'wp_footer', array( $this, 'swbdpam_ap_add_lis_after_footer' ) );
            }
        }


    } // Class Closer
} // If statement Closer