<?php
/**
 * Search listing element class.
 * 
 * @author wpWax
 */
namespace wpWax\Directorist\Oxygen;

defined( 'ABSPATH' ) || die();

use Directorist\Helper;

class SearchListing extends Element {

	protected $shouldProcessParams = true;

	public function name() {
		return esc_html__( 'Search Listing', 'directorist-oxygen-integration' );
	}

	public function slug() {
		return 'directorist-search-listing';
	}

	public function controls() {
		/**
		 * General settings section
		 */
		$general = $this->addControlSection( 'general', __( 'General', 'directorist-oxygen-integration' ), 'assets/icon.png', $this );

		if ( Helper::multi_directory_enabled() ) {
			$general->addCustomControl( Control::get_types( $this,  array( 
				'slug' => 'drst_directory_type'
			) ), 'drst_directory_type' );

			$general->addCustomControl( Control::get_types( $this,  array( 
				'slug'        => 'drst_default_directory_type',
				'name'        => __( 'Select default type', 'directorist-oxygen-integration' ),
				'placeholder' => __( 'Select type', 'directorist-oxygen-integration' ),
				'multiple'    => false
			) ), 'drst_default_directory_type' );
		}

		$general->addOptionControl(
			array(
				'type'    => 'buttons-list',
				'name'    => __( 'Show Title & Subtitle?', 'directorist-oxygen-integration' ),
				'slug'    => 'drst_show_title_subtitle',
				'default' => 'yes'
			)
		)->setValue( array( 'yes', 'no' ) );

		$general->addOptionControl(
			array(
				'type'      => 'textfield',
				'name'      => __( 'Search Form Title', 'directorist-oxygen-integration' ),
				'slug'      => 'drst_search_bar_title',
				'default'   => __( 'Search here', 'directorist-oxygen-integration' ),
				'condition' => 'drst_show_title_subtitle=yes',
			)
		);

		$general->addOptionControl(
			array(
				'type'      => 'textfield',
				'name'      => __( 'Search Form Subtitle', 'directorist-oxygen-integration' ),
				'slug'      => 'drst_search_bar_sub_title',
				'default'   => __( 'Find the best match of your interest', 'directorist-oxygen-integration' ),
				'condition' => 'drst_show_title_subtitle=yes',
			)
		);

		$general->addOptionControl(
			array(
				'type'    => 'buttons-list',
				'name'    => __( 'Show More Filters Button?', 'directorist-oxygen-integration' ),
				'slug'    => 'drst_more_filters_button',
				'default' => 'yes'
			)
		)->setValue( array( 'yes', 'no' ) );

		$general->addOptionControl(
			array(
				'type'      => 'textfield',
				'name'      => __( 'More Filters Button Label', 'directorist-oxygen-integration' ),
				'slug'      => 'drst_more_filters_text',
				'default'   => __( 'More Filters', 'directorist-oxygen-integration' ),
				'condition' => 'drst_more_filters_button=yes'
			)
		);

		$general->addOptionControl(
			array(
				'type'    => 'buttons-list',
				'name'    => __( 'Show Apply Filters Button?', 'directorist-oxygen-integration' ),
				'slug'    => 'drst_apply_filters_button',
				'default' => 'yes',
				'condition' => 'drst_more_filters_button=yes',
			)
		)->setValue( array( 'yes', 'no' ) );

		$general->addOptionControl(
			array(
				'type'      => 'textfield',
				'name'      => __( 'Apply Filters Text', 'directorist-oxygen-integration' ),
				'slug'      => 'drst_apply_filters_text',
				'default'   => __( 'Apply Filters', 'directorist-oxygen-integration' ),
				'condition' => 'drst_more_filters_button=yes&&drst_apply_filters_button=yes'
			)
		);

		$general->addOptionControl(
			array(
				'type'    => 'buttons-list',
				'name'    => __( 'Show Reset Filters Button?', 'directorist-oxygen-integration' ),
				'slug'    => 'drst_reset_filters_button',
				'default' => 'yes',
				'condition' => 'drst_more_filters_button=yes',
			)
		)->setValue( array( 'yes', 'no' ) );

		$general->addOptionControl(
			array(
				'type'      => 'textfield',
				'name'      => __( 'Reset Filters Text', 'directorist-oxygen-integration' ),
				'slug'      => 'drst_reset_filters_text',
				'default'   => __( 'Reset Filters', 'directorist-oxygen-integration' ),
				'condition' => 'drst_more_filters_button=yes&&drst_reset_filters_button=yes'
			)
		);

		$general->addOptionControl(
			array(
				'type'    => 'dropdown',
				'name'    => __( 'More Filter By', 'directorist-oxygen-integration' ),
				'slug'    => 'drst_more_filters_display',
				'default' => 'overlapping',
				'value' => array(
					'overlapping' => __( 'Overlapping', 'directorist-oxygen-integration' ),
					'sliding'     => __( 'Sliding', 'directorist-oxygen-integration' ),
					'always_open' => __( 'Always Open', 'directorist-oxygen-integration' ),
				)
			)
		);

		$general->addOptionControl(
			array(
				'type'    => 'buttons-list',
				'name'    => __( 'Logged In User Only?', 'directorist-oxygen-integration' ),
				'slug'    => 'drst_logged_in_user_only',
				'default' => 'no'
			)
		)->setValue( array( 'yes', 'no' ) );
	}

	protected function remapShortcodeParams( array $params = array() ) {
		foreach ( [ 'directory_type' ] as $comma_separable_field ) {
			if ( empty( $params[ $comma_separable_field ] ) ) {
				continue;
			}

			$params[ $comma_separable_field ] = implode( ',', $params[ $comma_separable_field ] );
			unset( $comma_separable_field );
		}

		return $params;
	}
}

new SearchListing();
