<?php
/**
 * Category element class.
 * 
 * @author wpWax
 */
namespace wpWax\Directorist\Oxygen;

defined( 'ABSPATH' ) || die();

class Category extends Element {

	protected $shouldProcessParams = true;

	public function name() {
		return esc_html__( 'Single Category', 'directorist-oxygen-integration' );
	}

	public function slug() {
		return 'directorist-category';
	}

	public function controls() {
		/**
		 * General settings section
		 */
		$general = $this->addControlSection( 'general', __( 'General', 'directorist-oxygen-integration' ), 'assets/icon.png', $this );

		$general->addOptionControl(
			array(
				'type'  => 'dropdown',
				'name'  => __( 'View', 'directorist-oxygen-integration' ),
				'slug'  => 'drst_view',
				'default' => 'grid',
				'value' => array(
					'grid' => __( 'Grid', 'directorist-oxygen-integration' ),
					'list' => __( 'List', 'directorist-oxygen-integration' ),
					'map'  => __( 'Map', 'directorist-oxygen-integration' ),
				)
			)
		);

		$general->addOptionControl(
			array(
				'type'  => 'dropdown',
				'name'  => __( 'Columns', 'directorist-oxygen-integration' ),
				'slug'  => 'drst_columns',
				'default' => '3',
				'value' => array(
					'1' => __( '1 Column', 'directorist-oxygen-integration' ),
					'2' => __( '2 Columns', 'directorist-oxygen-integration' ),
					'3' => __( '3 Columns', 'directorist-oxygen-integration' ),
					'4' => __( '4 Columns', 'directorist-oxygen-integration' ),
					'6' => __( '6 Columns', 'directorist-oxygen-integration' ),
				),
				'condition' => 'drst_view=grid'
			)
		);

		$general->addOptionControl(
			array(
				'type'    => 'textfield',
				'name'    => __( 'Number Of Listing', 'directorist-oxygen-integration' ),
				'slug'    => 'drst_listings_per_page',
				'default' => 6
			)
		);

		$general->addOptionControl(
			array(
				'type'    => 'dropdown',
				'name'    => __( 'Order By', 'directorist-oxygen-integration' ),
				'slug'    => 'drst_orderby',
				'default' => 'date',
				'value' => array(
					'title' => __( 'Title', 'directorist-oxygen-integration' ),
					'date'  => __( 'Date', 'directorist-oxygen-integration' ),
					'rand'  => __( 'Random', 'directorist-oxygen-integration' ),
					'price' => __( 'Price', 'directorist-oxygen-integration' ),
				)
			)
		);

		$general->addOptionControl(
			array(
				'type'    => 'buttons-list',
				'name'    => __( 'Order', 'directorist-oxygen-integration' ),
				'slug'    => 'drst_order',
				'default' => 'desc',
			)
		)->setValue( array( 'asc', 'desc' ) );

		$general->addOptionControl(
			array(
				'type'    => 'buttons-list',
				'name'    => __( 'Show Pagination?', 'directorist-oxygen-integration' ),
				'slug'    => 'drst_show_pagination',
				'default' => 'no'
			)
		)->setValue( array( 'yes', 'no' ) );

		$general->addOptionControl(
			array(
				'type'    => 'buttons-list',
				'name'    => __( 'Show Header?', 'directorist-oxygen-integration' ),
				'slug'    => 'drst_header',
				'default' => 'no'
			)
		)->setValue( array( 'yes', 'no' ) );

		$general->addOptionControl(
			array(
				'type'      => 'textfield',
				'name'      => __( 'Header Title', 'directorist-oxygen-integration' ),
				'slug'      => 'drst_header_title',
				'condition' => 'drst_header=yes'
			)
		);

		$general->addOptionControl(
			array(
				'type'    => 'buttons-list',
				'name'    => __( 'Logged In User Only?', 'directorist-oxygen-integration' ),
				'slug'    => 'drst_logged_in_user_only',
				'default' => 'no'
			)
		)->setValue( array( 'yes', 'no' ) );

		$general->addOptionControl(
			array(
				'type'      => 'textfield',
				'name'      => __( 'Map Height', 'directorist-oxygen-integration' ),
				'slug'      => 'drst_map_height',
				'default'   => 500,
				'condition' => 'drst_view=map'
			)
		);

		$general->addOptionControl(
			array(
				'type'      => 'textfield',
				'name'      => __( 'Map Zoom Level', 'directorist-oxygen-integration' ),
				'slug'      => 'drst_map_zoom_level',
				'condition' => 'drst_view=map'
			)
		);
	}
}

new Category();
