<?php
/**
 * Author profile element class.
 * 
 * @author wpWax
 */
namespace wpWax\Directorist\Oxygen;

defined( 'ABSPATH' ) || die();

class AuthorProfile extends Element {

	protected $shouldProcessParams = true;

	public function name() {
		return esc_html__( 'Author Profile', 'directorist-oxygen-integration' );
	}

	public function slug() {
		return 'directorist-author-profile';
	}

	public function controls() {
		/**
		 * General settings section
		 */
		$general = $this->addControlSection( 'general', __( 'General', 'directorist-oxygen-integration' ), 'assets/icon.png', $this );

		$general->addOptionControl(
			array(
				'type'    => 'buttons-list',
				'name'    => __( 'Logged In User Only?', 'directorist-oxygen-integration' ),
				'slug'    => 'drst_logged_in_user_only',
				'default' => 'no'
			)
		)->setValue( array( 'yes', 'no' ) );
	}
}

new AuthorProfile();
