<?php
/**
 * All listing element class.
 * 
 * @author wpWax
 */
namespace wpWax\Directorist\Oxygen;

defined( 'ABSPATH' ) || die();

use Directorist\Helper;

class AllListing extends Element {

	protected $shouldProcessParams = true;

	public function name() {
		return esc_html__( 'All Listing', 'directorist-oxygen-integration' );
	}

	public function slug() {
		return 'directorist-all-listing';
	}

	public function controls() {
		/**
		 * General settings section
		 */
		$general = $this->addControlSection( 'general', __( 'General', 'directorist-oxygen-integration' ), 'assets/icon.png', $this );

		if ( Helper::multi_directory_enabled() ) {
			$general->addCustomControl( Control::get_types( $this,  array( 
				'slug' => 'drst_directory_type'
			) ), 'drst_directory_type' );

			$general->addCustomControl( Control::get_types( $this,  array( 
				'slug'        => 'drst_default_directory_type',
				'name'        => __( 'Select default type', 'directorist-oxygen-integration' ),
				'placeholder' => __( 'Select type', 'directorist-oxygen-integration' ),
				'multiple'    => false
			) ), 'drst_default_directory_type' );
		}

		$general->addOptionControl(
			array(
				'type'  => 'dropdown',
				'name'  => __( 'View', 'directorist-oxygen-integration' ),
				'slug'  => 'drst_view',
				'default' => 'grid',
				'value' => array(
					'grid' => __( 'Grid', 'directorist-oxygen-integration' ),
					'list' => __( 'List', 'directorist-oxygen-integration' ),
					'map'  => __( 'Map', 'directorist-oxygen-integration' ),
				)
			)
		);

		$general->addOptionControl(
			array(
				'type'  => 'dropdown',
				'name'  => __( 'Columns', 'directorist-oxygen-integration' ),
				'slug'  => 'drst_columns',
				'default' => '3',
				'value' => array(
					'1' => __( '1 Column', 'directorist-oxygen-integration' ),
					'2' => __( '2 Columns', 'directorist-oxygen-integration' ),
					'3' => __( '3 Columns', 'directorist-oxygen-integration' ),
					'4' => __( '4 Columns', 'directorist-oxygen-integration' ),
					'6' => __( '6 Columns', 'directorist-oxygen-integration' ),
				),
				'condition' => 'drst_view=grid'
			)
		);

		$general->addOptionControl(
			array(
				'type'    => 'buttons-list',
				'name'    => __( 'Show Pagination?', 'directorist-oxygen-integration' ),
				'slug'    => 'drst_show_pagination',
				'default' => 'no'
			)
		)->setValue( array( 'yes', 'no' ) );

		$general->addOptionControl(
			array(
				'type'    => 'buttons-list',
				'name'    => __( 'Show Featured Only?', 'directorist-oxygen-integration' ),
				'slug'    => 'drst_featured_only',
				'default' => 'no'
			)
		)->setValue( array( 'yes', 'no' ) );

		$general->addOptionControl(
			array(
				'type'    => 'buttons-list',
				'name'    => __( 'Show Header?', 'directorist-oxygen-integration' ),
				'slug'    => 'drst_header',
				'default' => 'yes'
			)
		)->setValue( array( 'yes', 'no' ) );

		$general->addOptionControl(
			array(
				'type'      => 'textfield',
				'name'      => __( 'Header Title', 'directorist-oxygen-integration' ),
				'default'   => __( 'Listings Found', 'directorist-oxygen-integration' ),
				'slug'      => 'drst_header_title',
				'condition' => 'drst_header=yes'
			)
		);

		$general->addOptionControl(
			array(
				'type'    => 'buttons-list',
				'name'    => __( 'Show Popular Only?', 'directorist-oxygen-integration' ),
				'slug'    => 'drst_popular_only',
				'default' => 'no'
			)
		)->setValue( array( 'yes', 'no' ) );

		$general->addOptionControl(
			array(
				'type'    => 'buttons-list',
				'name'    => __( 'Show Filter Button?', 'directorist-oxygen-integration' ),
				'slug'    => 'drst_advanced_filter',
				'default' => 'no'
			)
		)->setValue( array( 'yes', 'no' ) );

		$general->addOptionControl(
			array(
				'type'    => 'buttons-list',
				'name'    => __( 'Show Preview Image?', 'directorist-oxygen-integration' ),
				'slug'    => 'drst_display_preview_image',
				'default' => 'yes'
			)
		)->setValue( array( 'yes', 'no' ) );

		$general->addOptionControl(
			array(
				'type'    => 'buttons-list',
				'name'    => __( 'Enable Before After Hook?', 'directorist-oxygen-integration' ),
				'slug'    => 'drst_action_before_after_loop',
				'default' => 'no'
			)
		)->setValue( array( 'yes', 'no' ) );

		$general->addOptionControl(
			array(
				'type'    => 'buttons-list',
				'name'    => __( 'Logged In User Only?', 'directorist-oxygen-integration' ),
				'slug'    => 'drst_logged_in_user_only',
				'default' => 'no'
			)
		)->setValue( array( 'yes', 'no' ) );

		$general->addOptionControl(
			array(
				'type'      => 'textfield',
				'name'      => __( 'Map Height', 'directorist-oxygen-integration' ),
				'slug'      => 'drst_map_height',
				'default'   => 500,
				'condition' => 'drst_view=map'
			)
		);

		$general->addOptionControl(
			array(
				'type'      => 'textfield',
				'name'      => __( 'Map Zoom Level', 'directorist-oxygen-integration' ),
				'slug'      => 'drst_map_zoom_level',
				'condition' => 'drst_view=map'
			)
		);

		/**
		 * Query section
		 */
		$query = $this->addControlSection( 'query', __( 'Query', 'directorist-oxygen-integration' ), 'assets/icon.png', $this );
		
		$query->addOptionControl(
			array(
				'type'    => 'textfield',
				'name'    => __( 'Number Of Listing', 'directorist-oxygen-integration' ),
				'slug'    => 'drst_listings_per_page',
				'default' => 6
			)
		);

		$query->addOptionControl(
			array(
				'type'    => 'dropdown',
				'name'    => __( 'Order By', 'directorist-oxygen-integration' ),
				'slug'    => 'drst_orderby',
				'default' => 'date',
				'value' => array(
					'title' => __( 'Title', 'directorist-oxygen-integration' ),
					'date'  => __( 'Date', 'directorist-oxygen-integration' ),
					'rand'  => __( 'Random', 'directorist-oxygen-integration' ),
					'price' => __( 'Price', 'directorist-oxygen-integration' ),
				)
			)
		);
		
		$query->addOptionControl(
			array(
				'type'    => 'buttons-list',
				'name'    => __( 'Order', 'directorist-oxygen-integration' ),
				'slug'    => 'drst_order',
				'default' => 'desc',
			)
		)->setValue( array( 'asc', 'desc' ) );

		$query->addCustomControl( Control::get_listings( 'drst_ids', $this ), 'drst_ids' );

		$query->addCustomControl( Control::get_categories( 'drst_category', $this ), 'drst_category' );

		$query->addCustomControl( Control::get_tags( 'drst_tag', $this ), 'drst_tag' );

		$query->addCustomControl( Control::get_locations( 'drst_location', $this ), 'drst_location' );
	}

	protected function remapShortcodeParams( array $params = array() ) {
		foreach ( [ 'category', 'tag', 'location', 'ids', 'directory_type' ] as $comma_separable_field ) {
			if ( empty( $params[ $comma_separable_field ] ) ) {
				continue;
			}

			$params[ $comma_separable_field ] = implode( ',', $params[ $comma_separable_field ] );
			unset( $comma_separable_field );
		}

		return $params;
	}
}

new AllListing();
