<?php
/**
 * All categories element class.
 * 
 * @author wpWax
 */
namespace wpWax\Directorist\Oxygen;

defined( 'ABSPATH' ) || die();

use Directorist\Helper;

class AllCategories extends Element {

	protected $shouldProcessParams = true;

	public function name() {
		return esc_html__( 'All Categories', 'directorist-oxygen-integration' );
	}

	public function slug() {
		return 'directorist-all-categories';
	}

	public function controls() {
		/**
		 * General settings section
		 */
		$general = $this->addControlSection( 'general', __( 'General', 'directorist-oxygen-integration' ), 'assets/icon.png', $this );

		if ( Helper::multi_directory_enabled() ) {
			$general->addCustomControl( Control::get_types( $this,  array( 
				'slug' => 'drst_directory_type'
			) ), 'drst_directory_type' );

			$general->addCustomControl( Control::get_types( $this,  array( 
				'slug'        => 'drst_default_directory_type',
				'name'        => __( 'Select default type', 'directorist-oxygen-integration' ),
				'placeholder' => __( 'Select type', 'directorist-oxygen-integration' ),
				'multiple'    => false
			) ), 'drst_default_directory_type' );
		}

		$general->addOptionControl(
			array(
				'type'  => 'dropdown',
				'name'  => __( 'View', 'directorist-oxygen-integration' ),
				'slug'  => 'drst_view',
				'default' => 'grid',
				'value' => array(
					'grid' => __( 'Grid', 'directorist-oxygen-integration' ),
					'list' => __( 'List', 'directorist-oxygen-integration' ),
				)
			)
		);

		$general->addOptionControl(
			array(
				'type'  => 'dropdown',
				'name'  => __( 'Columns', 'directorist-oxygen-integration' ),
				'slug'  => 'drst_columns',
				'default' => '3',
				'value' => array(
					'1' => __( '1 Column', 'directorist-oxygen-integration' ),
					'2' => __( '2 Columns', 'directorist-oxygen-integration' ),
					'3' => __( '3 Columns', 'directorist-oxygen-integration' ),
					'4' => __( '4 Columns', 'directorist-oxygen-integration' ),
					'6' => __( '6 Columns', 'directorist-oxygen-integration' ),
				),
				'condition' => 'drst_view=grid'
			)
		);

		$general->addOptionControl(
			array(
				'type'    => 'textfield',
				'name'    => __( 'Number Of Category', 'directorist-oxygen-integration' ),
				'slug'    => 'drst_cat_per_page',
				'default' => 6
			)
		);

		$general->addOptionControl(
			array(
				'type'    => 'dropdown',
				'name'    => __( 'Order By', 'directorist-oxygen-integration' ),
				'slug'    => 'drst_orderby',
				'default' => 'name',
				'value' => array(
					'id'    => __( 'ID', 'directorist-oxygen-integration' ),
					'count' => __( 'Count', 'directorist-oxygen-integration' ),
					'name'  => __( 'Name', 'directorist-oxygen-integration' ),
					'slug'  => __( 'Categories', 'directorist-oxygen-integration' ),
				)
			)
		);

		$general->addOptionControl(
			array(
				'type'    => 'buttons-list',
				'name'    => __( 'Order', 'directorist-oxygen-integration' ),
				'slug'    => 'drst_order',
				'default' => 'desc',
			)
		)->setValue( array( 'asc', 'desc' ) );

		$general->addCustomControl( Control::get_categories( 'drst_slug', $this ), 'drst_slug' );

		$general->addOptionControl(
			array(
				'type'    => 'buttons-list',
				'name'    => __( 'Logged In User Only?', 'directorist-oxygen-integration' ),
				'slug'    => 'drst_logged_in_user_only',
				'default' => 'no'
			)
		)->setValue( array( 'yes', 'no' ) );
	}

	protected function remapShortcodeParams( array $params = array() ) {
		foreach ( [ 'slug', 'directory_type' ] as $comma_separable_field ) {
			if ( empty( $params[ $comma_separable_field ] ) ) {
				continue;
			}

			$params[ $comma_separable_field ] = implode( ',', $params[ $comma_separable_field ] );
			unset( $comma_separable_field );
		}

		return $params;
	}
}

new AllCategories();
