<?php
/**
 * Add listing element class.
 * 
 * @author wpWax
 */
namespace wpWax\Directorist\Oxygen;

defined( 'ABSPATH' ) || die();

use Directorist\Helper;

class AddListing extends Element {

	public function name() {
		return esc_html__( 'Add Listing', 'directorist-oxygen-integration' );
	}

	public function slug() {
		return 'directorist-add-listing';
	}

	public function controls() {
		/**
		 * Layout section
		 */
		$general = $this->addControlSection( 'general', __( 'General', 'directorist-oxygen-integration' ), 'assets/icon.png', $this );

		if ( Helper::multi_directory_enabled() ) {
			$general->addCustomControl( Control::get_types( $this,  array( 
				'slug' => 'drst_directory_type'
			) ), 'drst_directory_type' );
		}
	}

	protected function remapShortcodeParams( array $params = array() ) {
		foreach ( [ 'directory_type' ] as $comma_separable_field ) {
			if ( empty( $params[ $comma_separable_field ] ) ) {
				continue;
			}

			$params[ $comma_separable_field ] = implode( ',', $params[ $comma_separable_field ] );
			unset( $comma_separable_field );
		}

		return $params;
	}
}

new AddListing();
