<?php
/**
 * Plugin Name: Directorist - Oxygen Integration
 * Plugin URI: https://directorist.com/product/directorist-oxygen-integration
 * Description: This is an add-on for Directorist Plugin. Oxygen builder support for Directorist.
 * Version: 1.1.0
 * Author: wpWax
 * Author URI: https://directorist.com/
 * License: GPLv2 or later
 * Text Domain: directorist-oxygen-integration
 * Domain Path: /languages
 */

/**
 * Directorist oxygen extension.
 * 
 * @package wpWax\Directorist\Oxygen
 */
namespace wpWax\Directorist\Oxygen;

defined( 'ABSPATH' ) || die();

use CT_Toolbar;

/**
 * Initialize extension.
 *
 * @return void
 */
function extension_init() {
	if ( ! directorist_is_plugin_active( 'directorist/directorist-base.php' ) || ! class_exists( '\OxyEl' ) ) {
		return;
	}

	// Register +Add Directorist section
	add_action( 'oxygen_add_plus_sections',  __NAMESPACE__ . '\register_section' );

	// Register +Add Directorist subsections
	// oxygen_add_plus_{$id}_section_content
	add_action( 'oxygen_add_plus_directorist_category_section_content', __NAMESPACE__ . '\register_subsection' );

	add_action( 'ct_before_builder', __NAMESPACE__ . '\add_control_style' );

	load_controls();
	
	load_elements();

	add_filter( 'directorist_css_scripts', __NAMESPACE__ . '\remove_shortcode_restrictions_from_directorist_script' );

	// Remove directorist default single template hook.
	if ( class_exists( '\Directorist\Directorist_Template_Hooks', false ) ) {
		$template_hooks = \Directorist\Directorist_Template_Hooks::instance();
		remove_action( 'template_include', [ $template_hooks, 'single_template_path' ], 999 );
	}

	add_filter( 'template_include', static function( $template ) {
		if ( ! is_singular( ATBDP_POST_TYPE ) ) {
			return $template;
		}

		$page_id = get_custom_single_listing_page_id_by_listing_id( get_queried_object_id() );
		if ( ! $page_id ) {
			return $template;
		}

		$oxygen_template = CT_FW_PATH . '/oxygen-main-template.php';
		if ( ! is_readable( $oxygen_template ) ) {
			return $template;
		}

		global $dirctorist_oxygen_custom_single_id;
		$dirctorist_oxygen_custom_single_id = $page_id;

		return $oxygen_template;
	} );

	add_action( 'wp_head', static function() {
		global $dirctorist_oxygen_custom_single_id;
		if ( empty( $dirctorist_oxygen_custom_single_id ) ) {
			return;
		}

		global $post;
		$post = get_post( $dirctorist_oxygen_custom_single_id );
	}, -1 );

	add_action( 'wp_footer', static function() {
		global $dirctorist_oxygen_custom_single_id;
		if ( empty( $dirctorist_oxygen_custom_single_id ) ) {
			return;
		}

		global $post;
		$post = get_post( get_queried_object_id() );
	}, -1 );
}
add_action( 'init', __NAMESPACE__ . '\extension_init', 20 );

/**
 * Include controls file.
 *
 * @return void
 */
function load_controls() {
	// Base element
	include_once __DIR__ . '/class-control.php';
}

/**
 * Include elements file.
 *
 * @return void
 */
function load_elements() {
	// Base element
	include_once __DIR__ . '/class-element.php';

	// elements without controls
	include_once __DIR__ . '/elements/add-listing.php';
	include_once __DIR__ . '/elements/checkout.php';
	include_once __DIR__ . '/elements/custom-registration.php';
	include_once __DIR__ . '/elements/payment-receipt.php';
	include_once __DIR__ . '/elements/transaction-failure.php';
	include_once __DIR__ . '/elements/user-dashboard.php';
	include_once __DIR__ . '/elements/user-login.php';
	include_once __DIR__ . '/elements/single-details.php';

	// elements with controls
	include_once __DIR__ . '/elements/all-listing.php';
	include_once __DIR__ . '/elements/category.php';
	include_once __DIR__ . '/elements/location.php';
	include_once __DIR__ . '/elements/tag.php';
	include_once __DIR__ . '/elements/all-categories.php';
	include_once __DIR__ . '/elements/all-locations.php';
	include_once __DIR__ . '/elements/author-profile.php';
	include_once __DIR__ . '/elements/search-listing.php';
	include_once __DIR__ . '/elements/search-result.php';
}

/**
 * Register directorist section tab.
 *
 * @return void
 */
function register_section() {
	CT_Toolbar::oxygen_add_plus_accordion_section( 'directorist_category', __( 'Directorist', 'directorist-oxygen-integration' ) );
}

/**
 * Register directorist elemnents section hook.
 *
 * @return void
 */
function register_subsection() {
	/**
	 * Oxygen is creating this hook dynamically
	 * 
	 * button place value is being used to create this hook.
	 * eg. directorist::elements -> oxygen_add_plus_directorist_elements
	 * 
	 * @see \OxygenElementHelper /component-framework/api/oxygen.element-helper.class.php
	 */
	do_action( 'oxygen_add_plus_directorist_elements' );
}

function add_control_style() {
	?>
	<style>
		.select2-container--default .select2-search--dropdown .select2-search__field {
			background: transparent;
			border: none;
			outline: 0;
			box-shadow: none;
			-webkit-appearance: textfield;
		}
	</style>
	<?php
}

/**
 * Removes shortcode restrictions from Directorist script 
 * 
 * @param array
 * @return array
 */
function remove_shortcode_restrictions_from_directorist_script( $scripts ) {

	foreach ( $scripts as $script_key => $scripts_args ) {
		if ( ! isset( $scripts_args['shortcode'] ) ) continue;

		unset( $scripts[ $script_key ]['shortcode'] );
	}

	return $scripts;
}

if ( ! function_exists( 'directorist_is_plugin_active' ) ) {
    function directorist_is_plugin_active( $plugin ) {
        return in_array( $plugin, (array) get_option( 'active_plugins', array() ), true ) || directorist_is_plugin_active_for_network( $plugin );
    }
}

if ( ! function_exists( 'directorist_is_plugin_active_for_network' ) ) {
    function directorist_is_plugin_active_for_network( $plugin ) {
        if ( ! is_multisite() ) {
            return false;
        }
                
        $plugins = get_site_option( 'active_sitewide_plugins' );
        if ( isset( $plugins[ $plugin ] ) ) {
                return true;
        }

        return false;
    }
}

function get_custom_single_listing_page_id_by_listing_id( $listing_id = null ) {
	$args = array(
		'taxonomy'   => ATBDP_TYPE,
		'object_ids' => (int) $listing_id,
		'fields'     => 'ids',
		'meta_query' => array(
			'page_enabled' => array(
				'key'     => 'enable_single_listing_page',
				'compare' => '=',
				'value'   => 1,
			),
		),
	);

	$directory_types = get_terms( $args );
	if ( empty( $directory_types ) || is_wp_error( $directory_types ) ) {
		return 0;
	}

	$directory_type_id = current( $directory_types );
	$custom_single_page_id = (int) get_term_meta( $directory_type_id, 'single_listing_page', true );

	if ( empty( $custom_single_page_id ) ) {
		return 0;
	}

	return $custom_single_page_id;
}
