<?php
/**
 * Directorist oxygen control.
 * 
 * @package wpWax\Directorist\Oxygen
 */
namespace wpWax\Directorist\Oxygen;

defined( 'ABSPATH' ) || die();

class Control {
	
	public static function get_listings( $controlId, Element $element ) {
		$args = array(
			'name'        => __( 'Listing Items', 'directorist-oxygen-integration' ),
			'slug'        => $controlId,
			'placeholder' => __( 'Select items ...', 'directorist-oxygen-integration' ),
		);

		$posts = get_posts( array(
			'post_type'      => ATBDP_POST_TYPE,
			'post_status'    => 'publish',
			'posts_per_page' => -1
		) );

		if ( ! empty( $posts ) ) {
			$args['value'] = wp_list_pluck( $posts, 'post_title', 'ID' );
		}

		return self::get_custom_select2_html( $element, $args );
	}

	public static function get_locations( $controlId, Element $element ) {
		$args = array(
			'name'        => __( 'Locations', 'directorist-oxygen-integration' ),
			'slug'        => $controlId,
			'placeholder' => __( 'Select locations ...', 'directorist-oxygen-integration' ),
		);

		$terms = get_terms( array(
			'taxonomy'   => ATBDP_LOCATION,
			'hide_empty' => false,
		) );

		if ( ! is_wp_error( $terms ) && is_array( $terms ) ) {
			$args['value'] = wp_list_pluck( $terms, 'name', 'slug' );
		}

		return self::get_custom_select2_html( $element, $args );
	}

	public static function get_tags( $controlId, Element $element ) {
		$args = array(
			'name'        => __( 'Tags', 'directorist-oxygen-integration' ),
			'slug'        => $controlId,
			'placeholder' => __( 'Select tags ...', 'directorist-oxygen-integration' ),
		);

		$terms = get_terms( array(
			'taxonomy'   => ATBDP_TAGS,
			'hide_empty' => false,
		) );

		if ( ! is_wp_error( $terms ) && is_array( $terms ) ) {
			$args['value'] = wp_list_pluck( $terms, 'name', 'slug' );
		}

		return self::get_custom_select2_html( $element, $args );
	}

	public static function get_categories( $controlId, Element $element ) {
		$args = array(
			'name'        => __( 'Categories', 'directorist-oxygen-integration' ),
			'slug'        => $controlId,
			'placeholder' => __( 'Select categories ...', 'directorist-oxygen-integration' ),
		);

		$terms = get_terms( array(
			'taxonomy'   => ATBDP_CATEGORY,
			'hide_empty' => false,
		) );

		if ( ! is_wp_error( $terms ) && is_array( $terms ) ) {
			$args['value'] = wp_list_pluck( $terms, 'name', 'slug' );
		}

		return self::get_custom_select2_html( $element, $args );
	}

	public static function get_types( Element $element, $args ) {
		$args = wp_parse_args( $args, array(
			'name'        => __( 'Directory Types', 'directorist-oxygen-integration' ),
			'placeholder' => __( 'Select types ...', 'directorist-oxygen-integration' ),
		) );

		$terms = get_terms( array(
			'taxonomy'   => ATBDP_TYPE,
			'hide_empty' => false,
		) );

		if ( ! is_wp_error( $terms ) && is_array( $terms ) ) {
			$args['value'] = wp_list_pluck( $terms, 'name', 'slug' );
		}

		return self::get_custom_select2_html( $element, $args );
	}

	public static function get_custom_select2_html( Element $element, $args = array() ) {
		$args = wp_parse_args( $args, array(
			'name'        => 'Control Label',
			'slug'        => \uniqid( 'control_slug' ),
			'value'       => array(),
			'placeholder' => __( 'Set custom placeholder text ...', 'directorist-oxygen-integration' ),
			'multiple'    => true,
		) );

		$controlId  = \uniqid( 'oxygen_control_' . $args['slug'] );
		$objectName = $element->getSlug();

		ob_start();
		?>
		<div class="oxygen-control-row" style="margin-bottom: 0">
			<div class="oxygen-control-wrapper" style="margin-bottom: 0">
				<label class="oxygen-control-label"><?php echo esc_html( $args['name'] ); ?></label>
				<div class="oxygen-control">
					<select
						data-allow-clear="true"
						id="<?php echo esc_attr( $controlId ); ?>"
						name="<?php echo esc_attr( $controlId ); ?><?php echo $args['multiple'] ? '[]' : ''; ?>"
						<?php echo $args['multiple'] ? 'multiple="multiple"' : ''; ?>
						ng-init="initSelect2( '<?php echo esc_attr( $controlId ); ?>', '<?php echo esc_attr( $args['placeholder'] ); ?>' )"
						ng-model="iframeScope.component.options[ iframeScope.component.active.id ]['model']['<?php echo esc_attr( $args['slug'] ); ?>']"
						ng-change="iframeScope.setOption( iframeScope.component.active.id, '<?php echo esc_attr( $objectName ); ?>', '<?php echo esc_attr( $args['slug'] ); ?>' )">
						<?php foreach ( $args['value'] as $key => $value ) : ?>
							<option value="<?php echo esc_attr( $key ); ?>"><?php echo esc_html( $value ); ?></option>
						<?php endforeach; ?>
					</select>
				</div>
			</div>
		</div>
		<?php
		return ob_get_clean();
	}
}
