<?php
/**
 * Button X
 *
 * This file is used to register buttons support in navigation menu.
 *
 * @package Buttons X
 * @since 1.7.8
 */

// Make sure we don't expose any info if called directly
if ( !defined( 'ABSPATH' ) )
	exit;

if( !class_exists( 'BtnsxMenu' ) ) {
	class BtnsxMenu {

		private static $instance;

		/**
		 * Initiator
		 * @since 0.1
		 */
		public static function init() {
			return self::$instance;
		}

		/**
		 * Constructor
		 * @since 0.1
		 */
		public function __construct() {
			// filter the menu item output on frontend
			add_filter( 'walker_nav_menu_start_el', array( $this, 'start_el' ), 10, 2 );
		}

		/**
		 * Modifies the menu item display on frontend
		 * 
		 * @param string $item_output The original html.
		 * @param object $item  The menu item being displayed.
		 * @return object
		 */
		public function start_el( $item_output, $item ) {
			// if single button
			if( $item->object == 'buttons-x' ){
				$item_output = do_shortcode( '[btnsx id="'.$item->object_id.'"]' );
			}
			// if dual button
			if( $item->object == 'buttons-x-dual' ){
				$item_output = do_shortcode( '[btnsx_dual id="'.$item->object_id.'"]' );
			}
			// if social button
			if( $item->object == 'buttons-x-social' ){
				$item_output = do_shortcode( '[btnsx_social id="'.$item->object_id.'"]' );
			}
			// if social counter button
			if( $item->object == 'buttons-x-cs' ){
				$item_output = do_shortcode( '[btnsx_social_counter id="'.$item->object_id.'"]' );
			}
			return $item_output;
		}

		
	} // Menu Class
}

/**
 *  Kicking this off
 */

$btn_options = new BtnsxMenu();
$btn_options->init();