<?php
/**
 * Button X External Plugins
 *
 * This file is used to register support for external plugins.
 *
 * @package Buttons X
 * @since 1.8.1
 */

// Make sure we don't expose any info if called directly
if ( !defined( 'ABSPATH' ) ){
	exit;
}

if( !class_exists( 'BtnsxExternalPlugins' ) ) {
	class BtnsxExternalPlugins {

		private static $instance;

		/**
		 * Initiator
		 * @since 1.8.1
		 */
		public static function init() {
			return self::$instance;
		}

		/**
		 * Constructor
		 * @since 1.8.1
		 */
		public function __construct() {
			// Popup Maker Support
				add_action( 'plugins_loaded', array( $this, 'btnsx_popup_maker' ) );
			// WP Video Lightbox Support
				add_action( 'plugins_loaded', array( $this, 'btnsx_wp_video_lightbox' ) );
			// PopupPress Support
				add_action( 'plugins_loaded', array( $this, 'btnsx_popuppress' ) );
			// Ninja Popups Support
				add_action( 'plugins_loaded', array( $this, 'btnsx_ninja_popup' ) );
			// Layered Popups Support
				add_action( 'plugins_loaded', array( $this, 'btnsx_layered_popup' ) );
			// Optin Monster Support
				add_action( 'plugins_loaded', array( $this, 'btnsx_optin_monster' ) );
		}

		// Popup Maker Support
			public function btnsx_popup_maker() {
				if( class_exists('Popup_Maker') ){
					add_filter( 'btnsx_link_options_filter', array($this, 'btnsx_popup_maker_option'), 10, 1 );
					add_filter( 'btnsx_link_tab_fields_filter', array($this, 'btnsx_popup_maker_link_tab_field' ) );
					add_filter( 'btnsx_shortcode_attributes', array($this, 'btnsx_popup_maker_shortcode_attributes' ) );
					add_filter( 'btnsx_save_data_filter', array( $this, 'btnsx_popup_maker_data' ) );
					add_filter( 'btnsx_output_button_before_filter', array( $this, 'btnsx_popup_maker_before_button' ), 10, 3 );
					add_filter( 'btnsx_output_button_after_filter', array( $this, 'btnsx_popup_maker_after_button' ), 10, 3 );
				}
			}
			public function btnsx_popup_maker_option( $options ) {
				$options['popup_maker'] = __( 'Popup Maker', 'btnsx' );
				return $options;
			}
			public function btnsx_popup_maker_link_tab_field( array $options ) {
				$meta = new Btnsx();
				global $post;
				$options[] = array(
					'type'			=>	'cpt',
					'cpt'			=>	'popup',
					'id'			=>	'btnsx_opt_link_popup_maker',
					'name'			=>	'btnsx_opt_link_popup_maker',
					'placeholder'	=>	__( 'Choose Popup', 'btnsx' ),
					'label'			=>	__( 'Popup Maker.', 'btnsx' ),
					'tooltip'		=>	__( 'Select a popup. These are the popup\'s created under Popup Maker -> All Popups.', 'btnsx' ),
					'value'			=>	$meta->meta_values( $post->ID, array( 'field' => 'btnsx_link_popup_maker' ) )
				);
				return $options;
			}
			public function btnsx_popup_maker_shortcode_attributes( array $atts ) {
				$atts[] = array(
					'link_popup_maker'			=>	''
				);
				return $atts;
			}
			public function btnsx_popup_maker_data( array $data ) {
				$data['btnsx_link_popup_maker'] = sanitize_text_field( isset( $_POST['btnsx_opt_link_popup_maker'] ) ? $_POST['btnsx_opt_link_popup_maker'] : '' );
				return $data;
			}
			public function btnsx_popup_maker_before_button( array $data, $options, $atts ) {
				$meta = get_post_meta( $atts['id'], 'btnsx', true );
				if( $meta['btnsx_link_type'] == 'popup_maker' ){
					$data[] = array( '[popup_trigger id="'.$meta['btnsx_link_popup_maker'].'"]' );
				}
				return $data;
			}
			public function btnsx_popup_maker_after_button( array $data, $options, $atts ) {
				$meta = get_post_meta( $atts['id'], 'btnsx', true );
				if( $meta['btnsx_link_type'] == 'popup_maker' ){
					$data[] = array( '[/popup_trigger]' );
				}
				return $data;
			}

		// WP Video Lightbox Support
			public function btnsx_wp_video_lightbox() {
				if( class_exists('WP_Video_Lightbox') ){
					add_filter( 'btnsx_link_options_filter', array($this, 'btnsx_wp_video_lightbox_option'), 10, 1 );
					add_filter( 'btnsx_link_tab_fields_filter', array($this, 'btnsx_wp_video_lightbox_link_tab_field' ) );
					add_filter( 'btnsx_shortcode_attributes', array($this, 'btnsx_wp_video_lightbox_shortcode_attributes' ) );
					add_filter( 'btnsx_save_data_filter', array( $this, 'btnsx_wp_video_lightbox_data' ) );
					add_filter( 'btnsx_output_button_link', array( $this, 'btnsx_wp_video_lightbox_output_link' ), 10, 2 );
					add_filter( 'btnsx_output_button_link_relationship', array( $this, 'btnsx_wp_video_lightbox_output_link_relationship' ), 10, 2 );
				}
			}
			public function btnsx_wp_video_lightbox_option( $options ) {
				$options['wp_video_lightbox'] = __( 'WP Video Lightbox', 'btnsx' );
				return $options;
			}
			public function btnsx_wp_video_lightbox_link_tab_field( array $options ) {
				$meta = new Btnsx();
				global $post;
				$options[] = array(
					'type'			=>	'select',
					'id'			=>	'btnsx_opt_link_wpvl_type',
					'name'			=>	'btnsx_opt_link_wpvl_type',
					'placeholder'	=>	__( 'Choose Video Type', 'btnsx' ),
					'label'			=>	__( 'WP Video Lightbox - Type', 'btnsx' ),
					'tooltip'		=>	__( 'Select video type.', 'btnsx' ),
					'options'		=>	array(
						'vimeo'			=> __( 'Vimeo', 'btnsx' ),
						'youtube'		=> __( 'Youtube', 'btnsx' )
					),
					'value'			=>	$meta->meta_values( $post->ID, array( 'field' => 'btnsx_link_wpvl_type' ) )
				);
				$options[] = array(
					'type'			=>	'text',
					'id'			=>	'btnsx_opt_link_wpvl_id',
					'name'			=>	'btnsx_opt_link_wpvl_id',
					'placeholder'	=>	' ',
					'label'			=>	__( 'WP Video Lightbox - Video ID', 'btnsx' ),
					'tooltip'		=>	__( 'Add video ID. <br><br><u>Vimeo Video ID</u>: If your Vimeo video url is "https://vimeo.com/151048570" then video id is <strong>151048570</strong>.<br><br><strong>Youtube Video ID</strong>: If your Yotube video url is "https://www.youtube.com/watch?v=vqiABPHh1sA" or "https://youtu.be/vqiABPHh1sA" then video id is <strong>vqiABPHh1sA</strong>.', 'btnsx' ),
					'value'			=>	$meta->meta_values( $post->ID, array( 'field' => 'btnsx_link_wpvl_id' ) )
				);
				$options[] = array(
					'type'			=>	'text',
					'id'			=>	'btnsx_opt_link_wpvl_width',
					'name'			=>	'btnsx_opt_link_wpvl_width',
					'placeholder'	=>	' ',
					'label'			=>	__( 'WP Video Lightbox - Video Width', 'btnsx' ),
					'tooltip'		=>	__( 'Add video width (in pixels). Eg: 640. If left empty default width set in WP Video Lightbox settings will be used.', 'btnsx' ),
					'value'			=>	$meta->meta_values( $post->ID, array( 'field' => 'btnsx_link_wpvl_width' ) )
				);
				$options[] = array(
					'type'			=>	'text',
					'id'			=>	'btnsx_opt_link_wpvl_height',
					'name'			=>	'btnsx_opt_link_wpvl_height',
					'placeholder'	=>	' ',
					'label'			=>	__( 'WP Video Lightbox - Video Height', 'btnsx' ),
					'tooltip'		=>	__( 'Add video height (in pixels). Eg: 480. If left empty default height set in WP Video Lightbox settings will be used.', 'btnsx' ),
					'value'			=>	$meta->meta_values( $post->ID, array( 'field' => 'btnsx_link_wpvl_height' ) )
				);
				return $options;
			}
			public function btnsx_wp_video_lightbox_shortcode_attributes( array $atts ) {
				$atts[] = array(
					'link_wpvl_type'					=>	'',
					'link_wpvl_id'						=>	'',
					'link_wpvl_width'					=>	'',
					'link_wpvl_height'					=>	'',
				);
				return $atts;
			}
			public function btnsx_wp_video_lightbox_data( array $data ) {
				$data['btnsx_link_wpvl_type'] = sanitize_text_field( isset( $_POST['btnsx_opt_link_wpvl_type'] ) ? $_POST['btnsx_opt_link_wpvl_type'] : '' );
				$data['btnsx_link_wpvl_id'] = sanitize_text_field( isset( $_POST['btnsx_opt_link_wpvl_id'] ) ? $_POST['btnsx_opt_link_wpvl_id'] : '' );
				$data['btnsx_link_wpvl_width'] = sanitize_text_field( isset( $_POST['btnsx_opt_link_wpvl_width'] ) ? $_POST['btnsx_opt_link_wpvl_width'] : '' );
				$data['btnsx_link_wpvl_height'] = sanitize_text_field( isset( $_POST['btnsx_opt_link_wpvl_height'] ) ? $_POST['btnsx_opt_link_wpvl_height'] : '' );
				return $data;
			}
			public function btnsx_wp_video_lightbox_output_link( $link, $atts ) {
				$meta = get_post_meta( $atts['id'], 'btnsx', true );
				if( $meta['btnsx_link_type'] == 'wp_video_lightbox' ){
					// if ( is_plugin_active( 'wp-video-lightbox/wp-video-lightbox.php' ) ) {
	   				$wpvl = get_option('wpvl_prettyphoto_options');
		   			if( $meta['btnsx_link_wpvl_width'] == '' && $wpvl->default_width != '' ){
		   				$meta['btnsx_link_wpvl_width'] = $wpvl->default_width;
		   			}
		   			if( $meta['btnsx_link_wpvl_height'] == '' && $wpvl->default_height != '' ){
		   				$meta['btnsx_link_wpvl_height'] = $wpvl->default_height;
		   			}
		   			// }
		   			if( $meta['btnsx_link_wpvl_type'] == 'vimeo' ){
		   				$link = 'https://vimeo.com/'.$meta['btnsx_link_wpvl_id'].'?width='.$meta['btnsx_link_wpvl_width'].'&amp;height='.$meta['btnsx_link_wpvl_height'];
		   			} elseif( $meta['btnsx_link_wpvl_type'] == 'youtube' ){
		   				$link = 'https://www.youtube.com/watch?v='.$meta['btnsx_link_wpvl_id'].'&amp;width='.$meta['btnsx_link_wpvl_width'].'&amp;height='.$meta['btnsx_link_wpvl_height'];
		   			} else {
		   				$link = 'javascript:void(0)';
		   			}
				}
				return $link;
			}
			public function btnsx_wp_video_lightbox_output_link_relationship( $link_relationship, $atts ) {
				$meta = get_post_meta( $atts['id'], 'btnsx', true );
				// var_dump($meta);
				if( $meta['btnsx_link_type'] == 'wp_video_lightbox' ){
					$link_relationship = ' rel="wp-video-lightbox"';
				}
				return $link_relationship;
			}
		
		// PopupPress Support
			public function btnsx_popuppress() {
				if( defined('PPS_PLUGIN_NAME') && PPS_PLUGIN_NAME === 'PopupPress' ){
					add_filter( 'btnsx_link_options_filter', array($this, 'btnsx_popuppress_option'), 10, 1 );
					add_filter( 'btnsx_link_tab_fields_filter', array($this, 'btnsx_popuppress_link_tab_field' ) );
					add_filter( 'btnsx_shortcode_attributes', array($this, 'btnsx_popuppress_shortcode_attributes' ) );
					add_filter( 'btnsx_save_data_filter', array( $this, 'btnsx_popuppress_data' ) );
					add_filter( 'btnsx_output_button_class_filter', array($this, 'btnsx_popuppress_class'), 10, 3 );
				}
			}
			public function btnsx_popuppress_option( $options ) {
				$options['popuppress'] = __( 'PopupPress', 'btnsx' );
				return $options;
			}
			public function btnsx_popuppress_link_tab_field( array $options ) {
				$meta = new Btnsx();
				global $post;
				$options[] = array(
					'type'			=>	'cpt',
					'cpt'			=>	'popuppress',
					'id'			=>	'btnsx_opt_link_popuppress',
					'name'			=>	'btnsx_opt_link_popuppress',
					'placeholder'	=>	__( 'Choose Popup', 'btnsx' ),
					'label'			=>	__( 'PopupPress Popup.', 'btnsx' ),
					'tooltip'		=>	__( 'Select a popup. These are the popup\'s listed under PopupPress -> PopupPress.', 'btnsx' ),
					'value'			=>	$meta->meta_values( $post->ID, array( 'field' => 'btnsx_link_popuppress' ) )
				);
				return $options;
			}
			public function btnsx_popuppress_shortcode_attributes( array $atts ) {
				$atts[] = array(
					'link_popuppress'	=>	''
				);
				return $atts;
			}
			public function btnsx_popuppress_data( array $data ) {
				$data['btnsx_link_popuppress'] = sanitize_text_field( isset( $_POST['btnsx_opt_link_popuppress'] ) ? $_POST['btnsx_opt_link_popuppress'] : '' );
				return $data;
			}
			public function btnsx_popuppress_class( array $classes, $options, $atts ) {
				$meta = get_post_meta( $atts['id'], 'btnsx', true );
				if( $meta['btnsx_link_type'] == 'popuppress' ){
					$class = 'pps-button-popup-' . $meta['btnsx_link_popuppress'];
					$classes[] = array( $class );
				}
				return $classes;
			}

		// Ninja Popup Support
			public function btnsx_ninja_popup() {
				if( defined('SNP_OPTIONS') && SNP_OPTIONS === 'snp' ){
					add_filter( 'btnsx_link_options_filter', array($this, 'btnsx_ninja_popup_option'), 10, 1 );
					add_filter( 'btnsx_link_tab_fields_filter', array($this, 'btnsx_ninja_popup_link_tab_field' ) );
					add_filter( 'btnsx_shortcode_attributes', array($this, 'btnsx_ninja_popup_shortcode_attributes' ) );
					add_filter( 'btnsx_save_data_filter', array( $this, 'btnsx_ninja_popup_data' ) );
					add_filter( 'btnsx_output_button_link', array( $this, 'btnsx_ninja_popup_output_link' ), 10, 2 );
					add_filter( 'btnsx_output_button_link_relationship', array( $this, 'btnsx_ninja_popup_output_link_relationship' ), 10, 2 );
				}
			}
			public function btnsx_ninja_popup_option( $options ) {
				$options['ninja_popup'] = __( 'Ninja Popup', 'btnsx' );
				return $options;
			}
			public function btnsx_ninja_popup_link_tab_field( array $options ) {
				$meta = new Btnsx();
				global $post;
				$options[] = array(
					'type'			=>	'cpt',
					'cpt'			=>	'snp_popups',
					'id'			=>	'btnsx_opt_link_ninja_popup',
					'name'			=>	'btnsx_opt_link_ninja_popup',
					'placeholder'	=>	__( 'Select a popup', 'btnsx' ),
					'label'			=>	__( 'Ninja Popup.', 'btnsx' ),
					'tooltip'		=>	__( 'Select a popup. These are the popup\'s listed under Ninja Popups -> Popups.', 'btnsx' ),
					'value'			=>	$meta->meta_values( $post->ID, array( 'field' => 'btnsx_link_ninja_popup' ) )
				);
				return $options;
			}
			public function btnsx_ninja_popup_shortcode_attributes( array $atts ) {
				$atts[] = array(
					'link_ninja_popup'	=>	''
				);
				return $atts;
			}
			public function btnsx_ninja_popup_data( array $data ) {
				$data['btnsx_link_ninja_popup'] = sanitize_text_field( isset( $_POST['btnsx_opt_link_ninja_popup'] ) ? $_POST['btnsx_opt_link_ninja_popup'] : '' );
				return $data;
			}
			public function btnsx_ninja_popup_output_link( $link, $atts ) {
				$meta = get_post_meta( $atts['id'], 'btnsx', true );
				if( isset($meta['btnsx_link_type']) && $meta['btnsx_link_type'] == 'ninja_popup' ){
					if( isset($meta['btnsx_link_ninja_popup']) ){
						$link = '#ninja-popup-'.$meta['btnsx_link_ninja_popup'];
					}
				}
				return $link;
			}
			public function btnsx_ninja_popup_output_link_relationship( $link_relationship, $atts ) {
				$meta = get_post_meta( $atts['id'], 'btnsx', true );
				// var_dump($meta);
				if( $meta['btnsx_link_type'] == 'ninja_popup' ){
					$link_relationship = ' rel="'.$meta['btnsx_link_ninja_popup'].'"';
				}
				return $link_relationship;
			}

		// Layered Popups Support
			public function btnsx_layered_popup() {
				if( class_exists('ulp_class') ){
					add_filter( 'btnsx_link_options_filter', array($this, 'btnsx_layered_popup_option'), 10, 1 );
					add_filter( 'btnsx_link_tab_fields_filter', array($this, 'btnsx_layered_popup_link_tab_field' ) );
					add_filter( 'btnsx_shortcode_attributes', array($this, 'btnsx_layered_popup_shortcode_attributes' ) );
					add_filter( 'btnsx_save_data_filter', array( $this, 'btnsx_layered_popup_data' ) );
					add_filter( 'btnsx_output_button_link', array( $this, 'btnsx_layered_popup_output_link' ), 10, 2 );
				}
			}
			public function btnsx_layered_popup_option( $options ) {
				$options['layered_popup'] = __( 'Layered Popup', 'btnsx' );
				return $options;
			}
			public function btnsx_layered_popup_link_tab_field( array $options ) {
				$meta = new Btnsx();
				global $post;
				global $wpdb;
				$results = $wpdb->get_results( 'SELECT id, str_id, title FROM '.$wpdb->prefix.'ulp_popups ORDER BY id DESC', ARRAY_A );
				$opts = array();
				foreach ($results as $key => $value) {
					$opts[$value['str_id']] = $value['title'];
				}
				$options[] = array(
					'type'			=>	'select',
					'id'			=>	'btnsx_opt_link_layered_popup',
					'name'			=>	'btnsx_opt_link_layered_popup',
					'placeholder'	=>	__( 'Select a popup', 'btnsx' ),
					'label'			=>	__( 'Layered Popup.', 'btnsx' ),
					'tooltip'		=>	__( 'Select a popup. These are the popup\'s listed under Layered Popups -> Popups.', 'btnsx' ),
					'options'		=>	$opts,
					'value'			=>	$meta->meta_values( $post->ID, array( 'field' => 'btnsx_link_layered_popup' ) )
				);
				return $options;
			}
			public function btnsx_layered_popup_shortcode_attributes( array $atts ) {
				$atts[] = array(
					'link_layered_popup'	=>	''
				);
				return $atts;
			}
			public function btnsx_layered_popup_data( array $data ) {
				$data['btnsx_link_layered_popup'] = sanitize_text_field( isset( $_POST['btnsx_opt_link_layered_popup'] ) ? $_POST['btnsx_opt_link_layered_popup'] : '' );
				return $data;
			}
			public function btnsx_layered_popup_output_link( $link, $atts ) {
				$meta = get_post_meta( $atts['id'], 'btnsx', true );
				if( $meta['btnsx_link_type'] == 'layered_popup' ){
					$link = '#ulp-'.$meta['btnsx_link_layered_popup'];
				}
				return $link;
			}
		
		// Optin Monster Support
			public function btnsx_optin_monster() {
				if( function_exists( 'optin_monster' ) ){
					add_filter( 'btnsx_link_options_filter', array($this, 'btnsx_optin_monster_option'), 10, 1 );
					add_filter( 'btnsx_link_tab_fields_filter', array($this, 'btnsx_optin_monster_link_tab_field' ) );
					add_filter( 'btnsx_shortcode_attributes', array($this, 'btnsx_optin_monster_shortcode_attributes' ) );
					add_filter( 'btnsx_save_data_filter', array( $this, 'btnsx_optin_monster_data' ) );
					add_filter( 'btnsx_output_button_class_filter', array( $this, 'btnsx_optin_monster_class' ), 10, 3 );
					add_filter( 'btnsx_output_button_attributes_filter', array( $this, 'btnsx_optin_monster_attributes' ), 10, 3 );
				}
			}
			public function btnsx_optin_monster_option( $options ) {
				$options['optin_monster'] = __( 'Optin Monster', 'btnsx' );
				return $options;
			}
			public function btnsx_optin_monster_link_tab_field( array $options ) {
				$meta = new Btnsx();
				global $post;
				$options[] = array(
					'type'			=>	'text',
					'id'			=>	'btnsx_opt_link_optin_moster_slug',
					'name'			=>	'btnsx_opt_link_optin_moster_slug',
					'placeholder'	=>	' ',
					'label'			=>	__( 'Unique Optin Slug', 'btnsx' ),
					'tooltip'		=>	__( 'Add unique optin slug.', 'btnsx' ),
					'value'			=>	$meta->meta_values( $post->ID, array( 'field' => 'btnsx_link_optin_moster_slug' ) )
				);
				return $options;
			}
			public function btnsx_optin_monster_shortcode_attributes( array $atts ) {
				$atts[] = array(
					'link_optin_moster_slug'			=>	''
				);
				return $atts;
			}
			public function btnsx_optin_monster_data( array $data ) {
				$data['btnsx_link_optin_moster_slug'] = sanitize_text_field( isset( $_POST['btnsx_opt_link_optin_moster_slug'] ) ? $_POST['btnsx_opt_link_optin_moster_slug'] : '' );
				return $data;
			}
			public function btnsx_optin_monster_class( array $classes, $options, $atts ) {
				$meta = get_post_meta( $atts['id'], 'btnsx', true );
				if( $meta['btnsx_link_type'] == 'optin_monster' ){
					$classes[] = array( ' manual-optin-trigger' );
				}
				return $classes;
			}
			public function btnsx_optin_monster_attributes( array $data, $options, $atts ) {
				$meta = get_post_meta( $atts['id'], 'btnsx', true );
				if( $meta['btnsx_link_type'] == 'optin_monster' ){
					$data[] = array( 'data-optin-slug="' . $meta['btnsx_link_optin_moster_slug'] . '"' );
				}
				return $data;
			}

	} // External Plugins Class
}

/**
 *  Kicking this off
 */

$btn_options = new BtnsxExternalPlugins();
$btn_options->init();