<?php
/**
 * Buttons X Form Elements
 *
 * This file is used to output form elements.
 *
 * @package Buttons X
 * @since 0.1
 */

// Make sure we don't expose any info if called directly
if ( !defined( 'ABSPATH' ) )
	exit;

if( !class_exists( 'BtnsxFormElements' ) ) {
	
	class BtnsxFormElements {

		private static $instance;

		/**
		 * Initiator
		 * @since 0.1
		 */

		public static function init(){
			return self::$instance;
		}

		public function get_post_types( $unset ) {
			$post_types = get_post_types( array( 'public' => true ), 'names' );
			$output = array();
			foreach ( $post_types as $type ) {
				$output[$type] = ucfirst($type);
			}
			foreach ( $unset as $u ) {
				if( isset($output[$u]) ) {
					unset($output[$u]);
				}
			}
			return $output;
		}

		/**
		 * CPT as select options html
		 * @since  1.8.0
		 * @param  string/array    $type
		 * @param  string/array    $selected
		 * @return string
		 */
		public function cpt_html( $type, $selected ) {
			$options = array();

			$args = array(
				'post_type' => $type,
				'post_status' => 'publish',
				'posts_per_page' => -1
			);
			$query = new WP_Query( $args );
			// The Loop
			if ( $query->have_posts() ) {
				while ( $query->have_posts() ) {
					$query->the_post();
					$options[ get_the_ID() ] = get_the_title();
				}
			} else {
				// no posts found
			}
			/* Restore original Post Data */
			wp_reset_postdata();

			$output = '';
			foreach ( $options as $k => $l ) {
				if( is_array( $selected ) ) {
					if( in_array( $k, $selected ) ) {
						$output .= '<option value="' . $k . '" selected>' . $l . '</option>';
					} else {
						$output .= '<option value="' . $k . '">' . $l . '</option>';
					}
				} else {
					if( $k == $selected ){
						$output .= '<option value="' . $k . '" selected>' . $l . '</option>';
					} else {
						$output .= '<option value="' . $k . '">' . $l . '</option>';
					}
				}
			}

			return $output;
		}

		/**
		 * CPT as select options
		 * @since  0.1
		 * @param  string/array    $type
		 * @param  string/array    $selected
		 * @return string
		 */
		public function cpt( $type, $selected ) {
			$options = array();

			$args = array(
				'post_type' => $type,
				'post_status' => 'publish',
				'posts_per_page' => -1
			);
			$query = new WP_Query( $args );
			// The Loop
			if ( $query->have_posts() ) {
				while ( $query->have_posts() ) {
					$query->the_post();
					$options[ get_the_ID() ] = get_the_title();
				}
			} else {
				// no posts found
				$options[ '' ] = __( 'No posts found', 'btnsx' );
			}
			/* Restore original Post Data */
			wp_reset_postdata();

			// $output = '';
			// foreach ( $options as $k => $l ) {
			// 	if( is_array( $selected ) ) {
			// 		if( in_array( $k, $selected ) ) {
			// 			$output .= '<option value="' . $k . '" selected>' . $l . '</option>';
			// 		} else {
			// 			$output .= '<option value="' . $k . '">' . $l . '</option>';
			// 		}
			// 	} else {
			// 		if( $k == $selected ){
			// 			$output .= '<option value="' . $k . '" selected>' . $l . '</option>';
			// 		} else {
			// 			$output .= '<option value="' . $k . '">' . $l . '</option>';
			// 		}
			// 	}
			// }
			$output = array();
			foreach ( $options as $k => $l ) {
				$output[$k] = ucfirst($l);
			}

			return $output;
		}

		/**
		 * Post/Page/CPT's as select options
		 * @since  0.1
		 * @param  string    $selected
		 * @return string
		 */
		public function posts( $selected ) {
			$post_types = get_post_types( array( 'public' => true ) );
			$options = array();
			foreach ( $post_types as $key => $type ) {
				if( !in_array( $type, array( 'buttons-x', 'buttons-x-social', 'buttons-x-dual', 'buttons-x-cs' ) ) ) {
					$args = array( 'post_type' => $type, 'posts_per_page' => -1, 'post_status' => 'publish', 'post_parent' => null ); 
					$posts = get_posts( $args );
					if ( $posts ) {
						foreach ( $posts as $post ) {
							$options[ ucfirst( $type ) ][ $post->ID ] = $post->post_title;
						}
						wp_reset_postdata();
					}
				}
			}

			$output = '';
	
			foreach ( $options as $option => $label ) {
				$output .= '<optgroup label="' . $option . '">';
				foreach ( $label as $k => $l ) {
					if( is_array( $selected ) ) {
						if( in_array( $k, $selected ) ) {
							$output .= '<option value="' . $k . '" selected>' . $l . '</option>';
						} else {
							$output .= '<option value="' . $k . '">' . $l . '</option>';
						}
					} else {
						if( $k == $selected ){
							$output .= '<option value="' . $k . '" selected>' . $l . '</option>';
						} else {
							$output .= '<option value="' . $k . '">' . $l . '</option>';
						}
					}
				}
				$output .= '</optgroup>';
			}

			return $output;
		}

		/**
		 * Post/Page/CPT links as select options
		 * @since  0.1
		 * @param  string    $selected
		 * @return string
		 */
		public function post_links( $selected ) {
			$post_types = get_post_types( array( 'public' => true ) );
			$options = array();
			foreach ( $post_types as $key => $type ) {
				if( !in_array( $type, array( 'buttons-x', 'buttons-x-social', 'buttons-x-dual', 'buttons-x-cs' ) ) ) {
					$args = array(
						'post_type' => $type,
						'post_status' => 'publish',
						'posts_per_page' => -1
					);
					$query = new WP_Query( $args );
					// The Loop
					if ( $query->have_posts() ) {
						while ( $query->have_posts() ) {
							$query->the_post();
							$options[ ucfirst( $type ) ][ get_permalink() ] = get_the_title();
						}
					} else {
						// no posts found
					}
					/* Restore original Post Data */
					wp_reset_postdata();
				}
			}

			$output = '';
	
			foreach ( $options as $option => $label ) {
				$output .= '<optgroup label="' . $option . '">';
				foreach ( $label as $k => $l ) {
					if( $k == $selected ){
						$output .= '<option value="' . $k . '" selected>' . $l . '</option>';
					}else{
						$output .= '<option value="' . $k . '">' . $l . '</option>';
					}
				}
				$output .= '</optgroup>';
			}

			return $output;
		}

		/**
		 * Font Awesome Icons as select options
		 * @since  0.1
		 * @return string
		 */
		public function icon_options( $selected ){
			$icons = array( 
				__( 'FONT AWESOME ICONS', 'btnsx' ) => array(
					__( 'Web Application Icons', 'btnsx' )	=>	array( ' ', 'fa fa-adjust', 'fa fa-american-sign-language-interpreting', 'fa fa-anchor', 'fa fa-archive', 'fa fa-area-chart', 'fa fa-arrows', 'fa fa-arrows-h', 'fa fa-arrows-v', 'fa fa-asl-interpreting', 'fa fa-assistive-listening-systems', 'fa fa-asterisk', 'fa fa-at', 'fa fa-audio-description', 'fa fa-automobile', 'fa fa-balance-scale', 'fa fa-ban', 'fa fa-bank', 'fa fa-bar-chart', 'fa fa-bar-chart-o', 'fa fa-barcode', 'fa fa-bars', 'fa fa-battery-0', 'fa fa-battery-1', 'fa fa-battery-2', 'fa fa-battery-3', 'fa fa-battery-4', 'fa fa-battery-empty', 'fa fa-battery-full', 'fa fa-battery-half', 'fa fa-battery-quarter', 'fa fa-battery-three-quarters', 'fa fa-bed', 'fa fa-beer', 'fa fa-bell', 'fa fa-bell-o', 'fa fa-bell-slash', 'fa fa-bell-slash-o', 'fa fa-bicycle', 'fa fa-binoculars', 'fa fa-birthday-cake', 'fa fa-blind', 'fa fa-bluetooth', 'fa fa-bluetooth-b', 'fa fa-bolt', 'fa fa-bomb', 'fa fa-book', 'fa fa-bookmark', 'fa fa-bookmark-o', 'fa fa-braille', 'fa fa-briefcase', 'fa fa-bug', 'fa fa-building', 'fa fa-building-o', 'fa fa-bullhorn', 'fa fa-bullseye', 'fa fa-bus', 'fa fa-cab', 'fa fa-calculator', 'fa fa-calendar', 'fa fa-calendar-check-o', 'fa fa-calendar-minus-o', 'fa fa-calendar-o', 'fa fa-calendar-plus-o', 'fa fa-calendar-times-o', 'fa fa-camera', 'fa fa-camera-retro', 'fa fa-car', 'fa fa-caret-square-o-down', 'fa fa-caret-square-o-left', 'fa fa-caret-square-o-right', 'fa fa-caret-square-o-up', 'fa fa-cart-arrow-down', 'fa fa-cart-plus', 'fa fa-cc', 'fa fa-certificate', 'fa fa-check', 'fa fa-check-circle', 'fa fa-check-circle-o', 'fa fa-check-square', 'fa fa-check-square-o', 'fa fa-child', 'fa fa-circle', 'fa fa-circle-o', 'fa fa-circle-o-notch', 'fa fa-circle-thin', 'fa fa-clock-o', 'fa fa-clone', 'fa fa-close', 'fa fa-cloud', 'fa fa-cloud-download', 'fa fa-cloud-upload', 'fa fa-code', 'fa fa-code-fork', 'fa fa-coffee', 'fa fa-cog', 'fa fa-cogs', 'fa fa-comment', 'fa fa-comment-o', 'fa fa-commenting', 'fa fa-commenting-o', 'fa fa-comments', 'fa fa-comments-o', 'fa fa-compass', 'fa fa-copyright', 'fa fa-creative-commons', 'fa fa-credit-card', 'fa fa-credit-card-alt', 'fa fa-crop', 'fa fa-crosshairs', 'fa fa-cube', 'fa fa-cubes', 'fa fa-cutlery', 'fa fa-dashboard', 'fa fa-database', 'fa fa-deaf', 'fa fa-deafness', 'fa fa-desktop', 'fa fa-diamond', 'fa fa-dot-circle-o', 'fa fa-download', 'fa fa-edit', 'fa fa-ellipsis-h', 'fa fa-ellipsis-v', 'fa fa-envelope', 'fa fa-envelope-o', 'fa fa-envelope-square', 'fa fa-eraser', 'fa fa-exchange', 'fa fa-exclamation', 'fa fa-exclamation-circle', 'fa fa-exclamation-triangle', 'fa fa-external-link', 'fa fa-external-link-square', 'fa fa-eye', 'fa fa-eye-slash', 'fa fa-eyedropper', 'fa fa-fax', 'fa fa-feed', 'fa fa-female', 'fa fa-fighter-jet', 'fa fa-file-archive-o', 'fa fa-file-audio-o', 'fa fa-file-code-o', 'fa fa-file-excel-o', 'fa fa-file-image-o', 'fa fa-file-movie-o', 'fa fa-file-pdf-o', 'fa fa-file-photo-o', 'fa fa-file-picture-o', 'fa fa-file-powerpoint-o', 'fa fa-file-sound-o', 'fa fa-file-video-o', 'fa fa-file-word-o', 'fa fa-file-zip-o', 'fa fa-film', 'fa fa-filter', 'fa fa-fire', 'fa fa-fire-extinguisher', 'fa fa-flag', 'fa fa-flag-checkered', 'fa fa-flag-o', 'fa fa-flash', 'fa fa-flask', 'fa fa-folder', 'fa fa-folder-o', 'fa fa-folder-open', 'fa fa-folder-open-o', 'fa fa-frown-o', 'fa fa-futbol-o', 'fa fa-gamepad', 'fa fa-gavel', 'fa fa-gear', 'fa fa-gears', 'fa fa-gift', 'fa fa-glass', 'fa fa-globe', 'fa fa-graduation-cap', 'fa fa-group', 'fa fa-hand-grab-o', 'fa fa-hand-lizard-o', 'fa fa-hand-paper-o', 'fa fa-hand-peace-o', 'fa fa-hand-pointer-o', 'fa fa-hand-rock-o', 'fa fa-hand-scissors-o', 'fa fa-hand-spock-o', 'fa fa-hand-stop-o', 'fa fa-hard-of-hearing', 'fa fa-hashtag', 'fa fa-hdd-o', 'fa fa-headphones', 'fa fa-heart', 'fa fa-heart-o', 'fa fa-heartbeat', 'fa fa-history', 'fa fa-home', 'fa fa-hotel', 'fa fa-hourglass', 'fa fa-hourglass-1', 'fa fa-hourglass-2', 'fa fa-hourglass-3', 'fa fa-hourglass-end', 'fa fa-hourglass-half', 'fa fa-hourglass-o', 'fa fa-hourglass-start', 'fa fa-i-cursor', 'fa fa-image', 'fa fa-inbox', 'fa fa-industry', 'fa fa-info', 'fa fa-info-circle', 'fa fa-institution', 'fa fa-key', 'fa fa-keyboard-o', 'fa fa-language', 'fa fa-laptop', 'fa fa-leaf', 'fa fa-legal', 'fa fa-lemon-o', 'fa fa-level-down', 'fa fa-level-up', 'fa fa-life-bouy', 'fa fa-life-buoy', 'fa fa-life-ring', 'fa fa-life-saver', 'fa fa-lightbulb-o', 'fa fa-line-chart', 'fa fa-location-arrow', 'fa fa-lock', 'fa fa-low-vision', 'fa fa-magic', 'fa fa-magnet', 'fa fa-mail-forward', 'fa fa-mail-reply', 'fa fa-mail-reply-all', 'fa fa-male', 'fa fa-map', 'fa fa-map-marker', 'fa fa-map-o', 'fa fa-map-pin', 'fa fa-map-signs', 'fa fa-meh-o', 'fa fa-microphone', 'fa fa-microphone-slash', 'fa fa-minus', 'fa fa-minus-circle', 'fa fa-minus-square', 'fa fa-minus-square-o', 'fa fa-mobile', 'fa fa-mobile-phone', 'fa fa-money', 'fa fa-moon-o', 'fa fa-mortar-board', 'fa fa-motorcycle', 'fa fa-mouse-pointer', 'fa fa-music', 'fa fa-navicon', 'fa fa-newspaper-o', 'fa fa-object-group', 'fa fa-object-ungroup', 'fa fa-paint-brush', 'fa fa-paper-plane', 'fa fa-paper-plane-o', 'fa fa-paw', 'fa fa-pencil', 'fa fa-pencil-square', 'fa fa-pencil-square-o', 'fa fa-percent', 'fa fa-phone', 'fa fa-phone-square', 'fa fa-photo', 'fa fa-picture-o', 'fa fa-pie-chart', 'fa fa-plane', 'fa fa-plug', 'fa fa-plus', 'fa fa-plus-circle', 'fa fa-plus-square', 'fa fa-plus-square-o', 'fa fa-power-off', 'fa fa-print', 'fa fa-puzzle-piece', 'fa fa-qrcode', 'fa fa-question', 'fa fa-question-circle', 'fa fa-question-circle-o', 'fa fa-quote-left', 'fa fa-quote-right', 'fa fa-random', 'fa fa-recycle', 'fa fa-refresh', 'fa fa-registered', 'fa fa-remove', 'fa fa-reorder', 'fa fa-reply', 'fa fa-reply-all', 'fa fa-retweet', 'fa fa-road', 'fa fa-rocket', 'fa fa-rss', 'fa fa-rss-square', 'fa fa-search', 'fa fa-search-minus', 'fa fa-search-plus', 'fa fa-send', 'fa fa-send-o', 'fa fa-server', 'fa fa-share', 'fa fa-share-alt', 'fa fa-share-alt-square', 'fa fa-share-square', 'fa fa-share-square-o', 'fa fa-shield', 'fa fa-ship', 'fa fa-shopping-bag', 'fa fa-shopping-basket', 'fa fa-shopping-cart', 'fa fa-sign-in', 'fa fa-sign-language', 'fa fa-sign-out', 'fa fa-signal', 'fa fa-signing', 'fa fa-sitemap', 'fa fa-sliders', 'fa fa-smile-o', 'fa fa-soccer-ball-o', 'fa fa-sort', 'fa fa-sort-alpha-asc', 'fa fa-sort-alpha-desc', 'fa fa-sort-amount-asc', 'fa fa-sort-amount-desc', 'fa fa-sort-asc', 'fa fa-sort-desc', 'fa fa-sort-down', 'fa fa-sort-numeric-asc', 'fa fa-sort-numeric-desc', 'fa fa-sort-up', 'fa fa-space-shuttle', 'fa fa-spinner', 'fa fa-spoon', 'fa fa-square', 'fa fa-square-o', 'fa fa-star', 'fa fa-star-half', 'fa fa-star-half-empty', 'fa fa-star-half-full', 'fa fa-star-half-o', 'fa fa-star-o', 'fa fa-sticky-note', 'fa fa-sticky-note-o', 'fa fa-street-view', 'fa fa-suitcase', 'fa fa-sun-o', 'fa fa-support', 'fa fa-tablet', 'fa fa-tachometer', 'fa fa-tag', 'fa fa-tags', 'fa fa-tasks', 'fa fa-taxi', 'fa fa-television', 'fa fa-terminal', 'fa fa-thumb-tack', 'fa fa-thumbs-down', 'fa fa-thumbs-o-down', 'fa fa-thumbs-o-up', 'fa fa-thumbs-up', 'fa fa-ticket', 'fa fa-times', 'fa fa-times-circle', 'fa fa-times-circle-o', 'fa fa-tint', 'fa fa-toggle-down', 'fa fa-toggle-left', 'fa fa-toggle-off', 'fa fa-toggle-on', 'fa fa-toggle-right', 'fa fa-toggle-up', 'fa fa-trademark', 'fa fa-trash', 'fa fa-trash-o', 'fa fa-tree', 'fa fa-trophy', 'fa fa-truck', 'fa fa-tty', 'fa fa-tv', 'fa fa-umbrella', 'fa fa-universal-access', 'fa fa-university', 'fa fa-unlock', 'fa fa-unlock-alt', 'fa fa-unsorted', 'fa fa-upload', 'fa fa-user', 'fa fa-user-plus', 'fa fa-user-secret', 'fa fa-user-times', 'fa fa-users', 'fa fa-video-camera', 'fa fa-volume-control-phone', 'fa fa-volume-down', 'fa fa-volume-off', 'fa fa-volume-up', 'fa fa-warning', 'fa fa-wheelchair', 'fa fa-wheelchair-alt', 'fa fa-wifi', 'fa fa-wrench'
					),
	        		__( 'Hand Icons', 'btnsx' )	=>	array( 'fa fa-hand-grab-o', 'fa fa-hand-lizard-o', 'fa fa-hand-o-down', 'fa fa-hand-o-left', 'fa fa-hand-o-right', 'fa fa-hand-o-up', 'fa fa-hand-paper-o', 'fa fa-hand-peace-o', 'fa fa-hand-pointer-o', 'fa fa-hand-rock-o', 'fa fa-hand-scissors-o', 'fa fa-hand-spock-o', 'fa fa-hand-stop-o', 'fa fa-thumbs-down', 'fa fa-thumbs-o-down', 'fa fa-thumbs-o-up', 'fa fa-thumbs-up'
	        		),
	        		__( 'Transportation Icons', 'btnsx' )	=>	array( 'fa fa-ambulance', 'fa fa-automobile', 'fa fa-bicycle', 'fa fa-bus', 'fa fa-cab', 'fa fa-car', 'fa fa-fighter-jet', 'fa fa-motorcycle', 'fa fa-plane', 'fa fa-rocket', 'fa fa-ship', 'fa fa-space-shuttle', 'fa fa-subway', 'fa fa-taxi', 'fa fa-train', 'fa fa-truck', 'fa fa-wheelchair'
	        		),
	        		__( 'Gender Icons', 'btnsx' )	=>	array( 'fa fa-genderless', 'fa fa-intersex', 'fa fa-mars', 'fa fa-mars-double', 'fa fa-mars-stroke', 'fa fa-mars-stroke-h', 'fa fa-mars-stroke-v', 'fa fa-mercury', 'fa fa-neuter', 'fa fa-transgender', 'fa fa-transgender-alt', 'fa fa-venus', 'fa fa-venus-double', 'fa fa-venus-mars'
	        		),
	        		__( 'File Type Icons', 'btnsx' )	=>	array( 'fa fa-file', 'fa fa-file-archive-o', 'fa fa-file-audio-o', 'fa fa-file-code-o', 'fa fa-file-excel-o', 'fa fa-file-image-o', 'fa fa-file-movie-o', 'fa fa-file-o', 'fa fa-file-pdf-o', 'fa fa-file-photo-o', 'fa fa-file-picture-o', 'fa fa-file-powerpoint-o', 'fa fa-file-sound-o', 'fa fa-file-text', 'fa fa-file-text-o', 'fa fa-file-video-o', 'fa fa-file-word-o', 'fa fa-file-zip-o'
	        		),
	        		__( 'Spinner Icons', 'btnsx' )	=>	array( 'fa fa-circle-o-notch', 'fa fa-cog', 'fa fa-gear', 'fa fa-refresh', 'fa fa-spinner'
	        		),
	        		__( 'Form Control Icons', 'btnsx' )	=>	array( 'fa fa-check-square', 'fa fa-check-square-o', 'fa fa-circle', 'fa fa-circle-o', 'fa fa-dot-circle-o', 'fa fa-minus-square', 'fa fa-minus-square-o', 'fa fa-plus-square', 'fa fa-plus-square-o', 'fa fa-square', 'fa fa-square-o'
	        		),
	        		__( 'Payment Icons', 'btnsx' )	=>	array( 'fa fa-cc-amex', 'fa fa-cc-diners-club', 'fa fa-cc-discover', 'fa fa-cc-jcb', 'fa fa-cc-mastercard', 'fa fa-cc-paypal', 'fa fa-cc-stripe', 'fa fa-cc-visa', 'fa fa-credit-card', 'fa fa-credit-card-alt', 'fa fa-google-wallet', 'fa fa-paypal'
	        		),
	        		__( 'Chart Icons', 'btnsx' )	=>	array( 'fa fa-area-chart', 'fa fa-bar-chart', 'fa fa-bar-chart-o', 'fa fa-line-chart', 'fa fa-pie-chart'
	        		),
	        		__( 'Currency Icons', 'btnsx' )	=>	array( 'fa fa-bitcoin', 'fa fa-btc', 'fa fa-cny', 'fa fa-dollar', 'fa fa-eur', 'fa fa-euro', 'fa fa-gbp', 'fa fa-gg', 'fa fa-gg-circle', 'fa fa-ils', 'fa fa-inr', 'fa fa-jpy', 'fa fa-krw', 'fa fa-money', 'fa fa-rmb', 'fa fa-rouble', 'fa fa-rub', 'fa fa-ruble', 'fa fa-rupee', 'fa fa-shekel', 'fa fa-sheqel', 'fa fa-try', 'fa fa-turkish-lira', 'fa fa-usd', 'fa fa-won', 'fa fa-yen'
	        		),
	        		__( 'Text Editor Icons', 'btnsx' )	=>	array( 'fa fa-align-center', 'fa fa-align-justify', 'fa fa-align-left', 'fa fa-align-right', 'fa fa-bold', 'fa fa-chain', 'fa fa-chain-broken', 'fa fa-clipboard', 'fa fa-columns', 'fa fa-copy', 'fa fa-cut', 'fa fa-dedent', 'fa fa-eraser', 'fa fa-file', 'fa fa-file-o', 'fa fa-file-text', 'fa fa-file-text-o', 'fa fa-files-o', 'fa fa-floppy-o', 'fa fa-font', 'fa fa-header', 'fa fa-indent', 'fa fa-italic', 'fa fa-link', 'fa fa-list', 'fa fa-list-alt', 'fa fa-list-ol', 'fa fa-list-ul', 'fa fa-outdent', 'fa fa-paperclip', 'fa fa-paragraph', 'fa fa-paste', 'fa fa-repeat', 'fa fa-rotate-left', 'fa fa-rotate-right', 'fa fa-save', 'fa fa-scissors', 'fa fa-strikethrough', 'fa fa-subscript', 'fa fa-superscript', 'fa fa-table', 'fa fa-text-height', 'fa fa-text-width', 'fa fa-th', 'fa fa-th-large', 'fa fa-th-list', 'fa fa-underline', 'fa fa-undo', 'fa fa-unlink'
	        		),
	        		__( 'Directional Icons', 'btnsx' )	=>	array( 'fa fa-angle-double-down', 'fa fa-angle-double-left', 'fa fa-angle-double-right', 'fa fa-angle-double-up', 'fa fa-angle-down', 'fa fa-angle-left', 'fa fa-angle-right', 'fa fa-angle-up', 'fa fa-arrow-circle-down', 'fa fa-arrow-circle-left', 'fa fa-arrow-circle-o-down', 'fa fa-arrow-circle-o-left', 'fa fa-arrow-circle-o-right', 'fa fa-arrow-circle-o-up', 'fa fa-arrow-circle-right', 'fa fa-arrow-circle-up', 'fa fa-arrow-down', 'fa fa-arrow-left', 'fa fa-arrow-right', 'fa fa-arrow-up', 'fa fa-arrows', 'fa fa-arrows-alt', 'fa fa-arrows-h', 'fa fa-arrows-v', 'fa fa-caret-down', 'fa fa-caret-left', 'fa fa-caret-right', 'fa fa-caret-square-o-down', 'fa fa-caret-square-o-left', 'fa fa-caret-square-o-right', 'fa fa-caret-square-o-up', 'fa fa-caret-up', 'fa fa-chevron-circle-down', 'fa fa-chevron-circle-left', 'fa fa-chevron-circle-right', 'fa fa-chevron-circle-up', 'fa fa-chevron-down', 'fa fa-chevron-left', 'fa fa-chevron-right', 'fa fa-chevron-up', 'fa fa-exchange', 'fa fa-hand-o-down', 'fa fa-hand-o-left', 'fa fa-hand-o-right', 'fa fa-hand-o-up', 'fa fa-long-arrow-down', 'fa fa-long-arrow-left', 'fa fa-long-arrow-right', 'fa fa-long-arrow-up', 'fa fa-toggle-down', 'fa fa-toggle-left', 'fa fa-toggle-right', 'fa fa-toggle-up'
	        		),
	        		__( 'Video Player Icons', 'btnsx' )	=>	array( 'fa fa-arrows-alt', 'fa fa-backward', 'fa fa-compress', 'fa fa-eject', 'fa fa-expand', 'fa fa-fast-backward', 'fa fa-fast-forward', 'fa fa-forward', 'fa fa-pause', 'fa fa-pause-circle', 'fa fa-pause-circle-o', 'fa fa-play', 'fa fa-play-circle', 'fa fa-play-circle-o', 'fa fa-random', 'fa fa-step-backward', 'fa fa-step-forward', 'fa fa-stop', 'fa fa-stop-circle', 'fa fa-stop-circle-o', 'fa fa-youtube-play'
	        		),
	        		__( 'Brand Icons', 'btnsx' )	=>	array( 'fa fa-500px', 'fa fa-adn', 'fa fa-amazon', 'fa fa-android', 'fa fa-angellist', 'fa fa-apple', 'fa fa-behance', 'fa fa-behance-square', 'fa fa-bitbucket', 'fa fa-bitbucket-square', 'fa fa-bitcoin', 'fa fa-black-tie', 'fa fa-bluetooth', 'fa fa-bluetooth-b', 'fa fa-btc', 'fa fa-buysellads', 'fa fa-cc-amex', 'fa fa-cc-diners-club', 'fa fa-cc-discover', 'fa fa-cc-jcb', 'fa fa-cc-mastercard', 'fa fa-cc-paypal', 'fa fa-cc-stripe', 'fa fa-cc-visa', 'fa fa-chrome', 'fa fa-codepen', 'fa fa-codiepie', 'fa fa-connectdevelop', 'fa fa-contao', 'fa fa-css3', 'fa fa-dashcube', 'fa fa-delicious', 'fa fa-deviantart', 'fa fa-digg', 'fa fa-dribbble', 'fa fa-dropbox', 'fa fa-drupal', 'fa fa-edge', 'fa fa-empire', 'fa fa-envira', 'fa fa-expeditedssl', 'fa fa-facebook', 'fa fa-facebook-f', 'fa fa-facebook-official', 'fa fa-facebook-square', 'fa fa-firefox', 'fa fa-flickr', 'fa fa-fonticons', 'fa fa-fort-awesome', 'fa fa-forumbee', 'fa fa-foursquare', 'fa fa-ge', 'fa fa-get-pocket', 'fa fa-gg', 'fa fa-gg-circle', 'fa fa-git', 'fa fa-git-square', 'fa fa-github', 'fa fa-github-alt', 'fa fa-github-square', 'fa fa-gitlab', 'fa fa-gittip', 'fa fa-glide', 'fa fa-glide-g', 'fa fa-google', 'fa fa-google-plus', 'fa fa-google-plus-square', 'fa fa-google-wallet', 'fa fa-gratipay', 'fa fa-hacker-news', 'fa fa-houzz', 'fa fa-html5', 'fa fa-instagram', 'fa fa-internet-explorer', 'fa fa-ioxhost', 'fa fa-joomla', 'fa fa-jsfiddle', 'fa fa-lastfm', 'fa fa-lastfm-square', 'fa fa-leanpub', 'fa fa-linkedin', 'fa fa-linkedin-square', 'fa fa-linux', 'fa fa-maxcdn', 'fa fa-meanpath', 'fa fa-medium', 'fa fa-mixcloud', 'fa fa-modx', 'fa fa-odnoklassniki', 'fa fa-odnoklassniki-square', 'fa fa-opencart', 'fa fa-openid', 'fa fa-opera', 'fa fa-optin-monster', 'fa fa-pagelines', 'fa fa-paypal', 'fa fa-pied-piper', 'fa fa-pied-piper-alt', 'fa fa-pinterest', 'fa fa-pinterest-p', 'fa fa-pinterest-square', 'fa fa-product-hunt', 'fa fa-qq', 'fa fa-ra', 'fa fa-rebel', 'fa fa-reddit', 'fa fa-reddit-alien', 'fa fa-reddit-square', 'fa fa-renren', 'fa fa-safari', 'fa fa-scribd', 'fa fa-sellsy', 'fa fa-share-alt', 'fa fa-share-alt-square', 'fa fa-shirtsinbulk', 'fa fa-simplybuilt', 'fa fa-skyatlas', 'fa fa-skype', 'fa fa-slack', 'fa fa-slideshare', 'fa fa-snapchat', 'fa fa-snapchat-ghost', 'fa fa-snapchat-square', 'fa fa-soundcloud', 'fa fa-spotify', 'fa fa-stack-exchange', 'fa fa-stack-overflow', 'fa fa-steam', 'fa fa-steam-square', 'fa fa-stumbleupon', 'fa fa-stumbleupon-circle', 'fa fa-tencent-weibo', 'fa fa-trello', 'fa fa-tripadvisor', 'fa fa-tumblr', 'fa fa-tumblr-square', 'fa fa-twitch', 'fa fa-twitter', 'fa fa-twitter-square', 'fa fa-usb', 'fa fa-viacoin', 'fa fa-viadeo', 'fa fa-viadeo-square', 'fa fa-vimeo', 'fa fa-vimeo-square', 'fa fa-vine', 'fa fa-vk', 'fa fa-wechat', 'fa fa-weibo', 'fa fa-weixin', 'fa fa-whatsapp', 'fa fa-wikipedia-w', 'fa fa-windows', 'fa fa-wordpress', 'fa fa-wpbeginner', 'fa fa-wpforms', 'fa fa-xing', 'fa fa-xing-square', 'fa fa-y-combinator', 'fa fa-y-combinator-square', 'fa fa-yahoo', 'fa fa-yc', 'fa fa-yc-square', 'fa fa-yelp', 'fa fa-youtube', 'fa fa-youtube-play', 'fa fa-youtube-square'
	        		),
	        		__( 'Medical Icons', 'btnsx' )	=> array( 'fa fa-ambulance', 'fa fa-h-square', 'fa fa-heart', 'fa fa-heart-o', 'fa fa-heartbeat', 'fa fa-hospital-o', 'fa fa-medkit', 'fa fa-plus-square', 'fa fa-stethoscope', 'fa fa-user-md', 'fa fa-wheelchair'
	    			)
	    		)
			);
			
			$output = '';
			
			foreach ( $icons as $icon => $label ) {
				$output .= '<optgroup label="' . esc_attr( $icon ) . '">';
				foreach ( $label as $key => $label ) {
					$output .= '<optgroup label="' . esc_attr( $key ) . '">';
					foreach ( $label as $l ) {
						if( $l == $selected ){
							$output .= '<option value="' . esc_attr( $l ) . '" selected>' . sanitize_text_field( $l ) . '</option>';
						}else{
							$output .= '<option value="' . esc_attr( $l ) . '">' . sanitize_text_field( $l ) . '</option>';
						}
					}
				}
			}

			return $output;
		}

		/**
		 * Animate.css as select options
		 * @since  0.1
		 * @param  string    $selected
		 * @return string
		 */
		public function icon_animation_options( $selected ){
			$animations = array(
				__( 'Attention Seekers', 'btnsx' ) => array(
					'bounce' => __('Bounce', 'btnsx'),
					'flash' => __('Flash', 'btnsx'),
					'pulse' => __('Pulse', 'btnsx'),
					'shake' => __('Shake', 'btnsx'),
					'tada' => __('Tada', 'btnsx'),
					'swing' => __('Swing', 'btnsx'),
					'wobble' => __('Wobble', 'btnsx')
					),
				__( 'Bouncing Entrances', 'btnsx' ) => array(
					'bounceIn' => __('BounceIn', 'btnsx'),
					'bounceInDown' => __('BounceInDown', 'btnsx'),
					'bounceInLeft' => __('BounceInLeft', 'btnsx'),
					'bounceInRight' => __('BounceInRight', 'btnsx'),
					'bounceInUp' => __('BounceInUp', 'btnsx')
					),
				__( 'Bouncing Exits', 'btnsx' ) => array(
					'bounceOut' => __('BounceOut', 'btnsx'),
					'bounceOutDown' => __('BounceOutDown', 'btnsx'),
					'bounceOutLeft' => __('BounceOutLeft', 'btnsx'),
					'bounceOutRight' => __('BounceOutRight', 'btnsx'),
					'bounceOutUp' => __('BounceOutUp', 'btnsx')
					),
				__( 'Fading Entrances', 'btnsx' ) => array(
					'fadeIn' => __('FadeIn', 'btnsx'),
					'fadeInDown' => __('FadeInDown', 'btnsx'),
					'fadeInDownBig' => __('FadeInDownBig', 'btnsx'),
					'fadeInLeft' => __('FadeInLeft', 'btnsx'),
					'fadeInLeftBig' => __('FadeInLeftBig', 'btnsx'),
					'fadeInRight' => __('FadeInRight', 'btnsx'),
					'fadeInRightBig' => __('FadeInRightBig', 'btnsx'),
					'fadeInUp' => __('FadeInUp', 'btnsx'),
					'fadeInUpBig' => __('FadeInUpBig', 'btnsx'),
					),
				__( 'Fading Exits', 'btnsx' ) => array(
					'fadeOut' => __('FadeOut', 'btnsx'),
					'fadeOutDown' => __('FadeOutDown', 'btnsx'),
					'fadeOutDownBig' => __('FadeOutDownBig', 'btnsx'),
					'fadeOutLeft' => __('FadeOutLeft', 'btnsx'),
					'fadeOutLeftBig' => __('FadeOutLeftBig', 'btnsx'),
					'fadeOutRight' => __('FadeOutRight', 'btnsx'),
					'fadeOutRightBig' => __('FadeOutRightBig', 'btnsx'),
					'fadeOutUp' => __('FadeOutUp', 'btnsx'),
					'fadeOutUpBig' => __('FadeOutUpBig', 'btnsx'),
					),
				__( 'Flippers', 'btnsx' ) => array(
					'flip' => __('Flip', 'btnsx'),
					'flipInX' => __('FlipInX', 'btnsx'),
					'flipInY' => __('FlipInY', 'btnsx'),
					'flipOutX' => __('FlipOutX', 'btnsx'),
					'flipOutY' => __('FlipOutY', 'btnsx')
					),
				__( 'Lightspeed', 'btnsx' ) => array(
					'lightSpeedIn' => __('LightSpeedIn', 'btnsx'),
					'lightSpeedOut' => __('LightSpeedOut', 'btnsx')
					),
				__( 'Rotating Entrances', 'btnsx' ) => array(
					'rotateIn' => __('RotateIn', 'btnsx'),
					'rotateInDownLeft' => __('RotateInDownLeft', 'btnsx'),
					'rotateInDownRight' => __('RotateInDownRight', 'btnsx'),
					'rotateInUpLeft' => __('RotateInUpLeft', 'btnsx'),
					'rotateInUpRight' => __('RotateInUpRight', 'btnsx')
					),
				__( 'Rotating Exits', 'btnsx' ) => array(
					'rotateOut' => __('RotateOut', 'btnsx'),
					'rotateOutDownLeft' => __('RotateOutDownLeft', 'btnsx'),
					'rotateOutDownRight' => __('RotateOutDownRight', 'btnsx'),
					'rotateOutUpLeft' => __('RotateOutUpLeft', 'btnsx'),
					'rotateOutUpRight' => __('RotateOutUpRight', 'btnsx')
					),
				__( 'Specials', 'btnsx' ) => array(
					'hinge' => __('hinge', 'btnsx'),
					'rollIn' => __('rollIn', 'btnsx'),
					'rollOut' => __('rollOut', 'btnsx')
					),
				__( 'Zoom Entrances', 'btnsx' ) => array(
					'zoomIn' => __('ZoomIn', 'btnsx'),
					'zoomInDown' => __('ZoomInDown', 'btnsx'),
					'zoomInLeft' => __('ZoomInLeft', 'btnsx'),
					'zoomInRight' => __('ZoomInRight', 'btnsx'),
					'zoomInUp' => __('ZoomInUp', 'btnsx'),
					),
				__( 'Zoom Exits', 'btnsx' ) => array(
					'zoomOut' => __('ZoomOut', 'btnsx'),
					'zoomOutDown' => __('ZoomOutDown', 'btnsx'),
					'zoomOutLeft' => __('ZoomOutLeft', 'btnsx'),
					'zoomOutRight' => __('ZoomOutRight', 'btnsx'),
					'zoomOutUp' => __('ZoomOutUp', 'btnsx')
					)
			);
			$output = '';
			
			foreach ( $animations as $option => $label ) {
				$output .= '<optgroup label="' . $option . '">';
				foreach ( $label as $k => $l ) {
					if( $k == $selected ){
						$output .= '<option value="' . $k . '" selected>' . $l . '</option>';
					}else{
						$output .= '<option value="' . $k . '">' . $l . '</option>';
					}
				}
			}

			return $output;
		}

		/**
		 * Hover.css as select options
		 * @since  0.1
		 * @param  string    $selected
		 * @return string
		 */
		public function animation_options( $selected ){
			$animations = array(
				__( 'HOVER.CSS', 'btnsx' ) => array(
					__( '2D Transitions', 'btnsx' ) => array(
						'hvr-bob' => __('Bob', 'btnsx'),
						'hvr-bounce-in' => __('Bounce In', 'btnsx'),
						'hvr-bounce-out' => __('Bounce Out', 'btnsx'),
						'hvr-buzz' => __('Buzz', 'btnsx'),
						'hvr-buzz-out' => __('Buzz Out', 'btnsx'),
						'hvr-float' => __('Float', 'btnsx'),
						'hvr-grow-rotate' => __('Grow Rotate', 'btnsx'),
						'hvr-hang' => __('Hang', 'btnsx'),
						'hvr-pop' => __('Pop', 'btnsx'),
						'hvr-pulse' => __('Pulse', 'btnsx'),
						'hvr-pulse-grow' => __('Pulse Grow', 'btnsx'),
						'hvr-pulse-shrink' => __('Pulse Shrink', 'btnsx'),
						'hvr-push' => __('Push', 'btnsx'),
						'hvr-rotate' => __('Rotate', 'btnsx'),
						'hvr-shrink' => __('Shrink', 'btnsx'),
						'hvr-sink' => __('Sink', 'btnsx'),
						'hvr-skew' => __('Skew', 'btnsx'),
						'hvr-skew-backward' => __('Skew Backward', 'btnsx'),
						'hvr-skew-forward' => __('Skew Forward', 'btnsx'),
						'hvr-wobble-bottom' => __('Wobble Bottom', 'btnsx'),
						'hvr-wobble-horizontal' => __('Wobble Horizontal', 'btnsx'),
						'hvr-wobble-skew' => __('Wobble Skew', 'btnsx'),
						'hvr-wobble-to-bottom-right' => __('Wobble To Bottom Right', 'btnsx'),
						'hvr-wobble-to-top-right' => __('Wobble To Top Right', 'btnsx'),
						'hvr-wobble-top' => __('Wobble Top', 'btnsx'),
						'hvr-wobble-vertical' => __('Wobble Vertical', 'btnsx'),
						'hvr-grow' => __('Grow', 'btnsx')
					),
					__( 'Background Transitions', 'btnsx' ) => array(
						// 'hvr-back-pulse' => __('Back Pulse', 'btnsx'),
						'hvr-bounce-to-bottom' => __('Bounce To Bottom', 'btnsx'),
						'hvr-bounce-to-left' => __('Bounce To Left', 'btnsx'),
						'hvr-bounce-to-right' => __('Bounce To Right', 'btnsx'),
						'hvr-bounce-to-top' => __('Bounce To Top', 'btnsx'),
						// 'hvr-fade' => __('Fade', 'btnsx'),
						'hvr-radial-in' => __('Radial In', 'btnsx'),
						'hvr-radial-out' => __('Radial Out', 'btnsx'),
						'hvr-rectangle-in' => __('Rectangle In', 'btnsx'),
						'hvr-rectangle-out' => __('Rectangle Out', 'btnsx'),
						'hvr-shutter-in-horizontal' => __('Shutter In Horizontal', 'btnsx'),
						'hvr-shutter-in-vertical' => __('Shutter In Vertical', 'btnsx'),
						'hvr-shutter-out-horizontal' => __('Shutter Out Horizontal', 'btnsx'),
						'hvr-shutter-out-vertical' => __('Shutter Out Vertical', 'btnsx'),
						'hvr-sweep-to-bottom' => __('Sweep To Bottom', 'btnsx'),
						'hvr-sweep-to-left' => __('Sweep To Left', 'btnsx'),
						'hvr-sweep-to-right' => __('Sweep To Right', 'btnsx'),
						'hvr-sweep-to-top' => __('Sweep To Top', 'btnsx')
					),
					// __( 'Icons', 'btnsx' ) => array(
					// 	'hvr-icon-back' => __('Icon Back', 'btnsx'),
					// 	'hvr-icon-bob' => __('Icon Bob', 'btnsx'),
					// 	'hvr-icon-bounce' => __('Icon Bounce', 'btnsx'),
					// 	'hvr-icon-buzz' => __('Icon Buzz', 'btnsx'),
					// 	'hvr-icon-buzz-out' => __('Icon Buzz Out', 'btnsx'),
					// 	'hvr-icon-down' => __('Icon Down', 'btnsx'),
					// 	'hvr-icon-drop' => __('Icon Drop', 'btnsx'),
					// 	'hvr-icon-fade' => __('Icon Fade', 'btnsx'),
					// 	'hvr-icon-float' => __('Icon Fade', 'btnsx'),
					// 	'hvr-icon-float-away' => __('Icon Float Away', 'btnsx'),
					// 	'hvr-icon-forward' => __('Icon Forward', 'btnsx'),
					// 	'hvr-icon-grow' => __('Icon Grow', 'btnsx'),
					// 	'hvr-icon-grow-rotate' => __('Icon Grow Rotate', 'btnsx'),
					// 	'hvr-icon-hang' => __('Icon Hang', 'btnsx'),
					// 	'hvr-icon-pop' => __('Icon Pop', 'btnsx'),
					// 	'hvr-icon-pulse' => __('Icon Pulse', 'btnsx'),
					// 	'hvr-icon-pulse-grow' => __('Icon Pulse Grow', 'btnsx'),
					// 	'hvr-icon-pulse-shrink' => __('Icon Pulse Shrink', 'btnsx'),
					// 	'hvr-icon-push' => __('Icon Push', 'btnsx'),
					// 	'hvr-icon-rotate' => __('Icon Rotate', 'btnsx'),
					// 	'hvr-icon-shrink' => __('Icon Shrink', 'btnsx'),
					// 	'hvr-icon-sink' => __('Icon Sink', 'btnsx'),
					// 	'hvr-icon-sink-away' => __('Icon Sink Away', 'btnsx'),
					// 	'hvr-icon-spin' => __('Icon Spin', 'btnsx'),
					// 	'hvr-icon-up' => __('Icon Up', 'btnsx'),
					// 	'hvr-icon-wobble-horizontal' => __('Icon Wobble Horizontal', 'btnsx'),
					// 	'hvr-icon-wobble-vertical' => __('Icon Wobble Vertical', 'btnsx')
					// ),
					__( 'Border Transitions', 'btnsx' ) => array(
						// 'hvr-border-fade' => __('Border Fade', 'btnsx'),
						// 'hvr-hollow' => __('Hollow', 'btnsx'),
						// 'hvr-outline-in' => __('Outline In', 'btnsx'),
						// 'hvr-outline-out' => __('Outline Out', 'btnsx'),
						'hvr-overline-from-center' => __('Overline From Center', 'btnsx'),
						'hvr-overline-from-left' => __('Overline From Left', 'btnsx'),
						'hvr-overline-from-right' => __('Overline From Right', 'btnsx'),
						'hvr-overline-reveal' => __('Overline Reveal', 'btnsx'),
						// 'hvr-reveal' => __('Reveal', 'btnsx'),
						// 'hvr-ripple-in' => __('Ripple In', 'btnsx'),
						// 'hvr-ripple-out' => __('Ripple Out', 'btnsx'),
						// 'hvr-round-corners' => __('Round Corners', 'btnsx'),
						'hvr-trim' => __('Trim', 'btnsx'),
						'hvr-underline-from-center' => __('Underline From Center', 'btnsx'),
						'hvr-underline-from-left' => __('Underline From Left', 'btnsx'),
						'hvr-underline-from-right' => __('Underline From Right', 'btnsx'),
						'hvr-underline-reveal' => __('Underline Reveal', 'btnsx')
					),
					// __( 'Shadow and Glow Transitions', 'btnsx' ) => array(
						// 'hvr-box-shadow-inset' => __('Box Shadow Inset', 'btnsx'),
						// 'hvr-box-shadow-outset' => __('Box Shadow Outset', 'btnsx'),
						// 'hvr-float-shadow' => __('Float Shadow', 'btnsx'),
						// 'hvr-glow' => __('Glow', 'btnsx'),
						// 'hvr-grow-shadow' => __('Grow Shadow', 'btnsx'),
						// 'hvr-shadow' => __('Shadow', 'btnsx'),
						// 'hvr-shadow-radial' => __('Shadow Radial', 'btnsx')
					// ),
					// __( 'Speech Bubbles', 'btnsx' ) => array(
					// 	'hvr-bubble-bottom' => __('Bubble Bottom', 'btnsx'),
					// 	'hvr-bubble-float-bottom' => __('Bubble Float Bottom', 'btnsx'),
					// 	'hvr-bubble-float-left' => __('Bubble Float Left', 'btnsx'),
					// 	'hvr-bubble-float-right' => __('Bubble Float Right', 'btnsx'),
					// 	'hvr-bubble-float-top' => __('Bubble Float Top', 'btnsx'),
					// 	'hvr-bubble-left' => __('Bubble Left', 'btnsx'),
					// 	'hvr-bubble-right' => __('Bubble Right', 'btnsx'),
					// 	'hvr-bubble-top' => __('Bubble Top', 'btnsx'),
					// ),
					__( 'Curls', 'btnsx' ) => array(
						'hvr-curl-bottom-left' => __('Curl Bottom Left', 'btnsx'),
						'hvr-curl-bottom-right' => __('Curl Bottom Right', 'btnsx'),
						'hvr-curl-top-left' => __('Curl Top Left', 'btnsx'),
						'hvr-curl-top-right' => __('Curl Top Right', 'btnsx'),
					)
				)
			);
			$output = '';
			
			foreach ( $animations as $icon => $label ) {
				$output .= '<optgroup label="' . $icon . '">';
				foreach ( $label as $key => $label ) {
					$output .= '<optgroup label="' . $key . '">';
					foreach ( $label as $k => $l ) {
						if( $k == $selected ){
							$output .= '<option value="' . $k . '" selected>' . $l . '</option>';
						}else{
							$output .= '<option value="' . $k . '">' . $l . '</option>';
						}
					}
				}
			}

			return $output;
		}

		/**
		 * Google WebFonts as select options
		 * @since  0.1
		 * @param  string    $selected
		 * @return string
		 */
		public function google_webfonts( $selected ){
			$fonts = json_decode( 
        		file_get_contents( BTNSX__PLUGIN_DIR . 'assets/webfonts.json' ) 
			); // 'https://www.googleapis.com/webfonts/v1/webfonts?key=' . BTNSX__WEBFONTS_API_KEY
			$output = array();
			foreach ($fonts->items as $key => $value) {
				$output[$value->family] = $value->family;
			}
			return $output;
		}

		/**
		 * EDD product id's as select options
		 * @since  0.1
		 * @param  string    $selected
		 * @return string
		 */
		public function edd_product_ids( $selected ){
			$output = '';
			$args = array(
                'post_type' => 'download',
                'post_status' => 'publish',
                'posts_per_page' => -1
            );

            $the_query = new WP_Query( $args );

            // The Loop
            if ( $the_query->have_posts() ) {
            	$output .= '<optgroup label="' . __( 'Available Downloads' , 'btnsx' ) . '">';
            	// var_dump(get_the_id());
                while ( $the_query->have_posts() ) {
                    $the_query->the_post();
                    if ( isset( $selected ) && $selected == get_the_id() ) {
                        $output .= '<option value="' . get_the_id() . '" selected="selected">' . get_the_title() . '</option>';
                    }else{
                        $output .= '<option value="' . get_the_id() . '">' . get_the_title() . '</option>';
                    }
                }
                $output .= '</optgroup>';
            } else {
                // no downloads found
                $output .= '<option value="">'.__( 'No result found.', 'btnsx' ).'</option>';
            }

            return $output;

            /* Restore original Post Data */
            wp_reset_postdata();
		}

		/**
		 * Woocommerce product id's as select options
		 * @since  0.1
		 * @param  string    $selected
		 * @return string
		 */
		public function woocommerce_product_ids( $selected ){
			$output = '';
			$args = array(
                'post_type' => 'product',
                'post_status' => 'publish',
                'posts_per_page' => -1
            );

            $the_query = new WP_Query( $args );

            // The Loop
            if ( $the_query->have_posts() ) {
            	$output .= '<optgroup label="' . __( 'Available Products' , 'btnsx' ) . '">';
            	// var_dump(get_the_id());
                while ( $the_query->have_posts() ) {
                    $the_query->the_post();
                    if ( isset( $selected ) && $selected == get_the_id() ) {
                        $output .= '<option value="' . get_the_id() . '" selected="selected">' . get_the_title() . '</option>';
                    }else{
                        $output .= '<option value="' . get_the_id() . '">' . get_the_title() . '</option>';
                    }
                }
                $output .= '</optgroup>';
            } else {
                // no downloads found
                $output .= '<option value="">'.__( 'No result found.', 'btnsx' ).'</option>';
            }

            return $output;

            /* Restore original Post Data */
            wp_reset_postdata();
		}

		/**
		 * Function to output tooltip
		 * @since  0.1
		 * @param  array     $args
		 * @return string
		 */
		public function tooltip( $args = array() ) {

			$defaults = array(
				'class' => 'btnsx-tooltip', 
				'position' => 'right', 
				'delay' => '50', 
				'text' => 'I am tooltip'
			);

			$args = wp_parse_args( $args, $defaults );

			return '<span class="fa-stack fa-lg ' . sanitize_html_class( $args['class'] ) . '" data-position="' . esc_attr( $args['position'] ) . '" data-delay="' . esc_attr( $args['delay'] ) . '" data-tooltip="' . esc_attr( $args['text'] ) . '"><i class="fa fa-circle-thin fa-stack-2x"></i><i class="fa fa-question fa-stack-1x"></i></span>';
		}

		/**
		 * Generate input HTML
		 * @since  0.1
		 * @param  array     $args 	existing options array
		 * @return array 	all standard DOM input options
		 */
		public function input( $args = array() ) {

			$defaults = array(
				'type'				=>	'text',
				'cpt'				=>	'post',
				'size'				=>	'12',
				'id'				=>	NULL,
				'name'				=>	NULL,
				'class'				=>	NULL,
				'multiselect'		=>	NULL,
				'title'				=>	NULL,
				'placeholder'		=>	NULL,
				'label'				=>	NULL,
				'tooltip'			=>	NULL,
				'min'				=>	0,
				'max'				=>	100,
				'on_text'			=>	__( 'On', 'btnsx' ),
				'off_text'			=>	__( 'Off', 'btnsx' ),
				'step'				=>	1,
				'value'				=>	NULL,
				'options'			=>	array(),
				'copy'				=>	NULL,
				'copy_text'			=>	NULL,
				'copy_ids'			=>	array()
			);

			// Merge arguments together 
			$input = wp_parse_args( $args, $defaults );
			$no_esc_key = array( 'cpt', 'options', 'tooltip', 'value', 'multiselect', 'copy_ids', 'copy_text', 'copy_ids' );

			// Validate the data - All input values are validated here with few exceptions, exceptions are validated on occurence
			foreach ( $input as $k => $v ) {
				if( !in_array( $k, $no_esc_key ) ) {
					$input[$k] = esc_attr( $v );
				}
			}

			// Create input attributes
			$input_props = array();
			$input_props['id'] = ( $input['id'] != NULL ) ? 'id="' . $input['id'] . '"' : NULL;
			$input_props['name'] = ( $input['name'] != NULL ) ? 'name="' . $input['name'] . '"' : NULL;
			$input_props['placeholder'] = ( $input['placeholder'] != NULL ) ? 'placeholder="' . $input['placeholder'] . '"' : NULL;
			$input_props['class'] = ( $input['class'] != NULL ) ? 'class="' . $input['class'] . '"' : NULL;
			$input_props['value'] = ( $input['value'] != NULL && !is_array( $input['value'] ) ) ? 'value="' . esc_attr( $input['value'] ) . '"' : NULL;

			// declare allowed html tags for tooltip
			$tooltip_allowed_html = array(
				'span' => array(
					'class' => array(),
					'data-position' => array(),
					'data-delay' => array(),
					'data-tooltip' => array()
				),
				'i'	=>	array(
					'class' => array()
				)
			);
			// declare allowed html tags for select options
			$select_allowed_html = array(
				'optgroup' => array(
					'label' => array()
				),
				'option' =>	array(
					'value' => array(),
					'selected' => array()
				)
			);

			switch ( $input['type'] ) {

				case 'text': ?>
					<div class="col m<?php echo $input['size']; ?>">
						<div class="input-field col s12">
							<input type="text" <?php echo implode( ' ', $input_props ); ?>>
							<?php if( $input['label'] != NULL ){ ?>
								<label for="<?php echo $input['id']; ?>"><?php echo $input['label']; ?>
									<?php } if( $input['tooltip'] != NULL ) {
										echo wp_kses( $this->tooltip( array( 'text' => $input['tooltip'] ) ), $tooltip_allowed_html );
									}
									?>
								</label>
						</div>
					</div>
					<?php break;

				case 'number': ?>
					<div class="col m<?php echo $input['size']; ?>">
						<div class="input-field col s12">
							<input type="number" <?php echo implode( ' ', $input_props ); ?>>
							<label for="<?php echo $input['id']; ?>"><?php echo $input['label']; ?>
								<?php if( $input['tooltip'] != NULL ) {
									echo wp_kses( $this->tooltip( array( 'text' => $input['tooltip'] ) ), $tooltip_allowed_html );
								}
								?>
							</label>
						</div>
					</div>
					<?php break;

				case 'range': 

					$input_props['range_id'] = ( $input['id'] != NULL ) ? 'id="' . $input['id'] . '_range"' : NULL;
					$input_props['range_name'] = ( $input['name'] != NULL ) ? 'name="range_' . $input['name'] . '"' : NULL;
					$input_props['min'] = ( $input['min'] != NULL ) ? 'min="' . $input['min'] . '"' : 0;
					$input_props['max'] = ( $input['max'] != NULL ) ? 'max="' . $input['max'] . '"' : 100;
					$input_props['step'] = ( $input['step'] != NULL ) ? 'step="' . $input['step'] . '"' : 1;

					?>
					<div class="col m12">
						<div class="row">
							<div class="col m4 btnsx-no-padding">
								<div class="input-field col s12">
									<input type="text" <?php echo implode( ' ', $input_props ); ?>>
									<label for="<?php echo $input['id']; ?>"><?php echo $input['label']; ?>
										<?php if( $input['tooltip'] != NULL ) {
											echo wp_kses( $this->tooltip( array( 'text' => $input['tooltip'] ) ), $tooltip_allowed_html );
										}
										?>
									</label>
								</div>
							</div>
							<div class="col m8 btnsx-no-padding">
								<p class="range-field">
									<input type="range" <?php echo $input_props['class'] . $input_props['range_id'] . ' ' . $input_props['range_name'] . ' ' . $input_props['min'] . ' ' . $input_props['max'] . ' ' . $input_props['step']; ?>/>
								</p>
							</div>
						</div>
					</div>
					<?php break;

				case 'select': 

					$input_props['select_placeholder'] = ( $input['placeholder'] != NULL ) ? $input['placeholder'] : 'placeholder="' . __('Choose your option','btnsx') . '"';
					$input_props['placeholder'] = NULL;
					$input_props['class'] = ( $input['class'] != NULL ) ? 'class="' . $input['class'] . '"' : 'class="btnsx-select"';

					$input['value'] = maybe_unserialize( $input['value'] );
					$multi_select = ( isset( $input['multiselect'] ) && $input['multiselect'] === true ) ? ' multiple="multiple"' : '';

					?>
					<div class="col m12">
						<div class="col s12">
							<label for="<?php echo $input['id']; ?>"><?php echo $input['label']; ?>
								<?php if( $input['tooltip'] != NULL ) {
									echo wp_kses( $this->tooltip( array( 'text' => $input['tooltip'] ) ), $tooltip_allowed_html );
								}
								?>
							</label>
							<?php 
								if( $input['copy'] == true ){
									$highlight = isset( $input['copy_ids']['highlight'] ) ? $input['copy_ids']['highlight'] : '';
									$old_select = isset( $input['copy_ids']['old_select'] ) ? $input['copy_ids']['old_select'] : '';
									$new_select = isset( $input['copy_ids']['new_select'] ) ? $input['copy_ids']['new_select'] : '';
									$normal_text = isset( $input['copy_text'] ) && $input['copy_text'] === 'normal' ? __( 'Copy to normal', 'btnsx' ) : '';
									$hover_text = isset( $input['copy_text'] ) && $input['copy_text'] === 'hover' ? __( 'Copy to hover', 'btnsx' ) : '';
									echo '<button id="' . $input['id'] . '_copy_btn" class="btnsx-copy-field" data-highlight="' . $highlight . '" data-old-select="' . $old_select . '" data-new-select="' . $new_select . '">' . $normal_text . $hover_text . '</button>';
								}	
							?>
						</div>
						<div class="input-field col s12" style="margin-top: 0.5rem;">
							<select <?php echo implode( ' ', $input_props ) . $multi_select; ?> style="width: 100%">
								<?php if( $input['placeholder'] != NULL ) { ?>
										<option value="-1" disabled selected><?php echo $input_props['select_placeholder']; ?></option>
								<?php }
									// var_dump($input['options']);
									foreach ( $input['options'] as $key => $label ) {
										if( is_array( $input['value'] ) ) {
											if( in_array( $key, $input['value'] ) ) {
												echo '<option id="' . $input['id'] . '-option-' . esc_attr( $key ) . '"  value="' . esc_attr( $key ) . '" selected>' . sanitize_text_field( $label ) . '</option>';
											} else {
												echo '<option id="' . $input['id'] . '-option-' . esc_attr( $key ) . '"  value="' . esc_attr( $key ) . '">' . sanitize_text_field( $label ) . '</option>';
											}
										} else {
											if( $input['value'] != NULL && $input['value'] == $key ){
												echo '<option id="' . $input['id'] . '-option-' . esc_attr( $key ) . '"  value="' . esc_attr( $key ) . '" selected>' . (string) $label . '</option>';
											} else {
												echo '<option id="' . $input['id'] . '-option-' . esc_attr( $key ) . '"  value="' . esc_attr( $key ) . '">' . (string) $label . '</option>';
											}
										}
									}
								?>
							</select>
						</div>
					</div>
					<?php break;

				case 'icon': 

					$input_props['select_placeholder'] = ( $input['placeholder'] != NULL ) ? $input['placeholder'] : __( 'Choose your option', 'btnsx' );
					$input_props['placeholder'] = NULL;
					$input_props['class'] = ( $input['class'] != NULL ) ? 'class="btnsx-select ' . $input['class'] . '"' : 'class="btnsx-select"';

					?>
					<div class="col m12">
						<div class="col s12">
							<label for="<?php echo $input['id']; ?>"><?php echo $input['label']; ?>
								<?php if( $input['tooltip'] != NULL ) {
									echo wp_kses( $this->tooltip( array( 'text' => $input['tooltip'] ) ), $tooltip_allowed_html );
								}
								?>
							</label>
						</div>
						<div class="input-field col s12" style="margin-top: 0.5rem;">
							<select <?php echo implode( ' ', $input_props ); ?> style="width: 100%">
								<?php if( $input['placeholder'] != NULL ) { ?>
									<option value="" disabled selected><?php echo $input_props['select_placeholder']; ?></option>
								<?php } 
									echo wp_kses( $this->icon_options( $input['value'] ), $select_allowed_html );
								?>
							</select>
						</div>
					</div>
					<?php break;

				case 'radio': ?>
					<div class="col m<?php echo $input['size']; ?>" style="margin-bottom:20px;">
						<div class="col s12">
							<label for=""><?php echo $input['label']; ?>
								<?php if( $input['tooltip'] != NULL ) {
									echo wp_kses( $this->tooltip( array( 'text' => $input['tooltip'] ) ), $tooltip_allowed_html );
								}
								?>
							</label>
							<?php
								unset( $input_props['id'] );
								$checkbox_value = isset( $input['value'] ) ? 'value="' . esc_attr( $input['value'] ) . '"' : '';
								foreach ( $input['options'] as $id => $value ) {
									$checkbox_checked = isset( $input['value'] ) && $input['value'] == $value ? 'checked="checked"' : '';
									echo '<p>';
									echo '<input type="radio" id="' .  esc_attr( $id ) . '" value="' .  esc_attr( $value ) . '" ' . implode( ' ', $input_props ) . $checkbox_checked .'/>';
									echo '<label for="' .  esc_attr( $id ) . '">' . ucfirst( $value ) . '</label>';
									echo '</p>';
								}
							?>
						</div>
					</div>
					<?php break;

				case 'cpt': 

					echo $this->input(
						array(
						    'type'			=>	'select',
						    'id'			=>	$input['id'],
						    'name'			=>	$input['name'],
						    'placeholder'	=>	$input['placeholder'],
						    'label'			=>	$input['label'],
						    'tooltip'		=>	$input['tooltip'],
						    'multiselect'	=>	$input['multiselect'],
						    'options'		=>	$this->cpt( $input['cpt'], $input['value'] ),
						    'value'			=> $input['value']
						)
					);

					break;

				case 'posts': 

					$post_options = array();
					$post_options[] = $this->posts( $input['value'] );

					echo $this->input(
						array(
						    'type'			=>	'select',
						    'id'			=>	$input['id'],
						    'name'			=>	$input['name'],
						    'placeholder'	=>	$input['placeholder'],
						    'label'			=>	$input['label'],
						    'tooltip'		=>	$input['tooltip'],
						    'multiselect'	=>	$input['multiselect'],
						    'options'		=>	$post_options
						)
					);

					break;

				case 'postlinks': 

					$post_options = array();
					$post_options[] = $this->post_links( $input['value'] );

					echo $this->input(
						array(
						    'type'			=>	'select',
						    'id'			=>	$input['id'],
						    'name'			=>	$input['name'],
						    'placeholder'	=>	$input['placeholder'],
						    'label'			=>	$input['label'],
						    'tooltip'		=>	$input['tooltip'],
						    'multiselect'	=>	$input['multiselect'],
						    'options'		=>	$post_options
						)
					);

					break;

				case 'menu':

					$menus = get_terms('nav_menu'); $options = array();
					foreach( $menus as $menu ){
						$options[ $menu->name ] = $menu->name;
					}

					echo $this->input(
						array(
							'type'			=>	'select',
							'id'			=>	$input['id'],
							'name'			=>	$input['name'],
							'placeholder'	=>	$input['placeholder'],
							'label'			=>	$input['label'],
							'tooltip'		=>	$input['tooltip'],
							'options'		=>	$options,
							'value'			=>	$input['value']
						)
					);

					break;

				case 'checkbox': 
					$checkbox_value = isset( $input['value'] ) ? 'value="' . esc_attr( $input['value'] ) . '"' : '';
					$checkbox_checked = isset( $input['value'] ) && $input['value'] == '1' ? 'checked="checked"' : '';
					?>
					<div id="<?php echo $input['id'].'_container'; ?>" class="col m<?php echo $input['size']; ?>">
						<div class="col s12">
							<p class="btnsx-checkbox-container">
								<input type="checkbox" <?php echo implode( ' ', $input_props ) . $checkbox_value . $checkbox_checked; ?>/>
								<label for="<?php echo $input['id']; ?>"><?php echo $input['label']; ?>
									<?php if( $input['tooltip'] != NULL ) {
										echo wp_kses( $this->tooltip( array( 'text' => $input['tooltip'] ) ), $tooltip_allowed_html );
									}
									?>
								</label>
							</p>
						</div>
					</div>
					<?php break;

				case 'switch': 
					$checkbox_value = isset( $input['value'] ) ? 'value="' . esc_attr( $input['value'] ) . '"' : '';
					$checkbox_checked = isset( $input['value'] ) && $input['value'] == '1' ? 'checked="checked"' : '';
					?>
					<div class="col m<?php echo $input['size']; ?>">
						<div class="col s12" style="margin-bottom:20px;">
							<label for="<?php echo $input['id']; ?>"><?php echo $input['label']; ?>
								<?php if( $input['tooltip'] != NULL ) {
									echo wp_kses( $this->tooltip( array( 'text' => $input['tooltip'] ) ), $tooltip_allowed_html );
								}
								?>
							</label>
							<p>
								<!-- Switch -->
								<div class="switch">
								    <label>
								    	<?php echo $input['off_text']; ?>
										<input type="checkbox" <?php echo implode( ' ', $input_props ) . $checkbox_value . $checkbox_checked; ?>/>
										<span class="lever"></span>
										<?php echo $input['on_text']; ?>
									</label>
								</div>
							</p>
						</div>
					</div>
					<?php break;
				
				case 'trbl': 

					$trbl_fields = array(
						'all'		=>	__( 'All Sides', 'btnsx' ),
						'top'		=>	__( 'Top', 'btnsx' ),
						'bottom'	=>	__( 'Bottom', 'btnsx' ),
						'left'		=>	__( 'Left', 'btnsx' ),
						'right'		=>	__( 'Right', 'btnsx' )
					);

					foreach ( $trbl_fields as $key => $label ) { ?>
						<div class="col3">
							<?php
							echo $this->input( 
								array(
									'type'			=>	'range',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['id'] . '_' . $key,
	    							'placeholder'	=>	' ',
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : ''
								)
							);
							?>
						</div>
					<?php } break;

				case 'editor': 
					unset( $input_props['value'] );
					?>
					<div class="col m12">
							
					</div>
					<div class="col m12">
						<div class="input-field col s12">
							<label for="<?php echo $input['id']; ?>"><?php echo $input['label']; ?>
								<?php if( $input['tooltip'] != NULL ) {
									echo wp_kses( $this->tooltip( array( 'text' => $input['tooltip'] ) ), $tooltip_allowed_html );
								}
								?>
							</label>
							<textarea class="btnsx-css-editor" data-btnsx-editor="css" <?php echo implode( ' ', $input_props ); ?>><?php echo esc_textarea( $input['value'] ); ?></textarea>

						</div>
					</div>
					<?php break;

				case 'editor-js': 
					unset( $input_props['value'] );
					?>
					<div class="col m12">
							
					</div>
					<div class="col m12">
						<div class="input-field col s12">
							<label for="<?php echo $input['id']; ?>"><?php echo $input['label']; ?>
								<?php if( $input['tooltip'] != NULL ) {
									echo wp_kses( $this->tooltip( array( 'text' => $input['tooltip'] ) ), $tooltip_allowed_html );
								}
								?>
							</label>
							<textarea class="btnsx-js-editor" data-btnsx-editor="javascript" <?php echo implode( ' ', $input_props ); ?>><?php echo esc_textarea( $input['value'] ); ?></textarea>

						</div>
					</div>
					<?php break;

				case 'tinymce': ?>
					<div class="col m12">
							<?php 

								$btnsx_editor_content = '';

								wp_editor( $btnsx_editor_content, 'btnsx_opt_text', array(
								    'wpautop'       => true,
								    'media_buttons' => false,
								    'textarea_name' => 'btnsx_opt_text',
								    'textarea_rows' => 10,
								    'teeny'         => true
								) );

							?>
					</div>
					<?php break;

				case 'color': ?>
					<div class="col m12">
						<label class="btnsx-color-label" name="" for="<?php echo $input['id']; ?>"><?php echo $input['label']; ?>
							<?php if( $input['tooltip'] != NULL ) {
								echo wp_kses( $this->tooltip( array( 'text' => $input['tooltip'] ) ), $tooltip_allowed_html );
							}
							?>
						</label>
						<?php 
							if( $input['copy'] == true ){
								$highlight = isset( $input['copy_ids']['highlight'] ) ? $input['copy_ids']['highlight'] : '';
								$old_input = isset( $input['copy_ids']['old_input'] ) ? $input['copy_ids']['old_input'] : '';
								$new_input = isset( $input['copy_ids']['new_input'] ) ? $input['copy_ids']['new_input'] : '';
								$old_color = isset( $input['copy_ids']['old_color'] ) ? $input['copy_ids']['old_color'] : '';
								$new_color = isset( $input['copy_ids']['new_color'] ) ? $input['copy_ids']['new_color'] : '';
								$normal_text = isset( $input['copy_text'] ) && $input['copy_text'] === 'normal' ? __( 'Copy to normal', 'btnsx' ) : '';
								$hover_text = isset( $input['copy_text'] ) && $input['copy_text'] === 'hover' ? __( 'Copy to hover', 'btnsx' ) : '';
								echo '<button id="' . $input['id'] . '_copy_btn" class="btnsx-copy-field" data-highlight="' . $highlight . '" data-old-input="' . $old_input . '" data-new-input="' . $new_input . '" data-old-color="' . $old_color . '" data-new-color="' . $new_color . '" data-old-select data-new-select>' . $normal_text . $hover_text . '</button>';
							}	
						?>
					</div>
					<?php
						echo $this->input( 
							array(
    							'type'			=>	'text',
    							'id'			=>	$input['id'],
    							'name'			=>	$input['name'],
    							'placeholder'	=>	' ',
    							'class'			=>	'btnsx-text btnsx-color',
    							'value'			=>	( isset( $input['value'] ) ? $input['value'] : NULL )
    						)
						);

					break;

				case 'font': 
					$font_fields = array(
						'size'		=>	__( 'Font Size', 'btnsx' ),
						'family'	=>	__( 'Font Family', 'btnsx' ),
						'weight'	=>	__( 'Font Weight', 'btnsx' ),
						'style'		=>	__( 'Font Style', 'btnsx' )
					);

					foreach ( $font_fields as $key => $label ) {
						if( $key == 'size' ){

							echo $this->input( 
								array(
	    							'type'			=>	'range',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key,
	    							'placeholder'	=>	' ',
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);

						} elseif( $key == 'style' ) {

							echo $this->input(
								array(
	    							'type'			=>	'select',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key,
	    							'placeholder'	=>	__( 'Choose font style', 'btnsx' ),
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'options'		=>	array(
	    								'normal'		=> __( 'Normal', 'btnsx' ),
	    								'italic'		=> __( 'Italic', 'btnsx' ),
	    								'oblique'		=> __( 'Oblique', 'btnsx' ),
	    								'inherit'		=> __( 'Inherit', 'btnsx' )
	    							),
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);

						} elseif( $key == 'weight' ) {

							echo $this->input(
								array(
	    							'type'			=>	'select',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key,
	    							'placeholder'	=>	__( 'Choose font weight', 'btnsx' ),
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'options'		=>	array(
	    								'normal'		=> __( 'Normal', 'btnsx' ),
	    								'bold'			=> __( 'Bold', 'btnsx' ),
	    								'bolder'		=> __( 'Bolder', 'btnsx' ),
	    								'lighter'		=> __( 'Lighter', 'btnsx' ),
	    								'100'			=> __( '100', 'buttons-x' ),
	    								'100italic'		=> __( '100 Italic', 'buttons-x' ),
	    								'200'			=> __( '200', 'buttons-x' ),
	    								'200italic'		=> __( '200 Italic', 'buttons-x' ),
	    								'300'			=> __( '300', 'buttons-x' ),
	    								'300italic'		=> __( '300 Italic', 'buttons-x' ),
	    								'400'			=> __( '400', 'buttons-x' ),
	    								'400italic'		=> __( '400 Italic', 'buttons-x' ),
	    								'500'			=> __( '500', 'buttons-x' ),
	    								'500italic'		=> __( '500 Italic', 'buttons-x' ),
	    								'600'			=> __( '600', 'buttons-x' ),
	    								'600italic'		=> __( '600 Italic', 'buttons-x' ),
	    								'700'			=> __( '700', 'buttons-x' ),
	    								'700italic'		=> __( '700 Italic', 'buttons-x' ),
	    								'800'			=> __( '800', 'buttons-x' ),
	    								'800italic'		=> __( '800 Italic', 'buttons-x' ),
	    								'900'			=> __( '900', 'buttons-x' ),
	    								'900italic'		=> __( '900 Italic', 'buttons-x' ),
	    								'inherit'		=> __( 'Inherit', 'btnsx' )
	    							),
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);

						} elseif( $key == 'family' ) {

							echo $this->input(
								array(
	    							'type'			=>	'select',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key,
	    							'placeholder'	=>	__( 'Choose font family', 'btnsx' ),
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'options'		=>	$this->google_webfonts( $input['value'][$key] ),
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);

						}
					}

					break;

				case 'color-states': 

					$color_fields = array(
						'normal' =>	__( 'Normal', 'btnsx' ),
						'hover'	=>	__( 'Hover', 'btnsx' )
					);

					$i = 0;
					foreach ( $color_fields as $key => $label ) { 
						if( !is_array($input['value']) ){
							$input['value'] = NULL;
						}
						if( !is_array($input['copy_ids']) ){
							$input['copy_ids'] = NULL;
						}
						if( !is_array($input['copy_text']) ){
							$input['copy_ids'] = NULL;
						}
						echo $this->input( 
							array(
    							'type'			=>	'color',
    							'id'			=>	$input['id'] . '_' . $key,
    							'name'			=>	$input['name'] . '_' . $key,
    							'placeholder'	=>	' ',
    							'label'			=>	$label,
    							'tooltip'		=>	$input['tooltip'][$key],
    							'class'			=>	'btnsx-color',
    							'value'			=>	$input['value'][$key],
    							'copy'			=>	$input['copy'],
    							'copy_text'		=>	$input['copy_text'][$key],
    							'copy_ids'		=>	$input['copy_ids'][$key]
    						)
						);
						$i++;
					}

					break;

				case 'gradient': 

					$gradient_fields = array(
						'location'	=>	__( 'Location', 'btnsx' ),
						'color'		=>	__( 'Color', 'btnsx' )
					);

					$i = 0;
					foreach ( $gradient_fields as $key => $label ) { 
						if( !is_array( $input['value'] ) ){
							$input['value'] = NULL;
						}
						if( $key === 'color' ) {
							echo $this->input( 
								array(
	    							'type'			=>	'color',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key . '[]',
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'placeholder'	=>	' ',
	    							'value'			=>	$input['value'][$key]
	    						)
							);
						}
						if( $key === 'location' ) {
							echo $this->input( 
								array(
	    							'type'			=>	'range',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key . '[]',
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'placeholder'	=>	' ',
	    							'class'			=>	'btnsx-text',
	    							'value'			=>	$input['value'][$key]
	    						)
							);
						}
						$i++;
					}

					break;

				case 'box-shadow': 

					$shadow_fields = array(
						'horizontal'	=>	__( 'Horizontal', 'btnsx' ),
						'vertical'		=>	__( 'Vertical', 'btnsx' ),
						'blur'			=>	__( 'Blur', 'btnsx' ),
						'spread'		=>	__( 'Spread', 'btnsx' ),
						'position'		=>	__( 'Position', 'btnsx' ),
						'color'			=>	__( 'Color', 'btnsx' )
					);

					foreach ( $shadow_fields as $key => $label ) { 
						if( $key == 'color' ) { 
							echo $this->input( 
								array(
	    							'type'			=>	'color',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key . '[]',
	    							'placeholder'	=>	' ',
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'class'			=>	'btnsx-text btnsx-color',
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);
						} elseif( $key == 'horizontal' || $key == 'vertical' || $key == 'blur' || $key == 'spread' ) {
							echo $this->input( 
								array(
	    							'type'			=>	'range',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key . '[]',
	    							'placeholder'	=>	' ',
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'class'			=>	'btnsx-text',
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);
						} elseif( $key == 'position' ) {
							echo $this->input( 
								array(
	    							'type'			=>	'select',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key . '[]',
	    							'placeholder'	=>	' ',
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'class'			=>	'btnsx-select',
	    							'options'		=>	array(
	    								' '		=> __( 'Outset', 'btnsx' ),
	    								'inset'			=> __( 'Inset', 'btnsx' )
    								),
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);
						}
					}

					break;

				case 'text-shadow': 

					$shadow_fields = array(
						'horizontal'	=>	__( 'Horizontal', 'btnsx' ),
						'vertical'		=>	__( 'Vertical', 'btnsx' ),
						'blur'			=>	__( 'Blur', 'btnsx' ),
						'color'			=>	__( 'Color', 'btnsx' )
					);

					foreach ( $shadow_fields as $key => $label ) { 
						if( $key == 'color' ) {
							echo $this->input( 
								array(
	    							'type'			=>	'color',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key,
	    							'placeholder'	=>	' ',
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'class'			=>	'btnsx-color',
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);
						} elseif( $key == 'horizontal' || $key == 'vertical' || $key == 'blur' ) {
							echo $this->input( 
								array(
	    							'type'			=>	'range',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key,
	    							'placeholder'	=>	' ',
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);
						}
					}

					break;

				case 'radius': 

					$radius_fields = array(
						'all'			=>	__( 'All Sides', 'btnsx' ),
						'top_left'		=>	__( 'Top Left', 'btnsx' ),
						'top_right'		=>	__( 'Top Right', 'btnsx' ),
						'bottom_left'	=>	__( 'Bottom Left', 'btnsx' ),
						'bottom_right'	=>	__( 'Bottom Right', 'btnsx' )
					);

					foreach ( $radius_fields as $key => $label ) {
						echo $this->input( 
							array(
    							'type'			=>	'range',
    							'id'			=>	$input['id'] . '_' . $key,
    							'name'			=>	$input['name'] . '_' . $key,
    							'placeholder'	=>	' ',
    							'label'			=>	$label,
    							'tooltip'		=>	isset( $input['tooltip'][$key] ) ? $input['tooltip'][$key] : NULL,
    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
    						)
						);
					}

					break;

				case 'divider': 

					$divider_fields = array(
						'size'		=>	__( 'Size', 'btnsx' ),
						'position'	=>	__( 'Position', 'btnsx' ),
						'color'		=>	__( 'Color', 'btnsx' )
					);

					foreach ( $divider_fields as $key => $label ) { 
						if( $key == 'color' ) { 
							echo $this->input( 
								array(
	    							'type'			=>	'color',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key,
	    							'placeholder'	=>	' ',
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'class'			=>	'btnsx-color',
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);
						} elseif( $key == 'size' ) {
							echo $this->input( 
								array(
	    							'type'			=>	'range',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key,
	    							'placeholder'	=>	' ',
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);
						} elseif( $key == 'position' ) {
							echo $this->input( 
								array(
	    							'type'			=>	'range',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key,
	    							'placeholder'	=>	' ',
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);
						}
					}

					break;

				case 'file': 

					$file_props['id'] = ( $input['id'] != NULL ) ? 'id="' . $input['id'] . '_upload"' : NULL;
					
					?>
					<div class="col m12">
						<div class="col s12">
							<label class="btnsx-upload-label" for="<?php echo $input['id']; ?>"><?php echo $input['label']; ?>
								<?php if( $input['tooltip'] != NULL ) {
									echo wp_kses( $this->tooltip( array( 'text' => $input['tooltip'] ) ), $tooltip_allowed_html );
								}
								?>
							</label>
							<?php 
								if( $input['copy'] == true ){
									$highlight = isset( $input['copy_ids']['highlight'] ) ? $input['copy_ids']['highlight'] : '';
									$old_input = isset( $input['copy_ids']['old_input'] ) ? $input['copy_ids']['old_input'] : '';
									$new_input = isset( $input['copy_ids']['new_input'] ) ? $input['copy_ids']['new_input'] : '';
									$normal_text = isset( $input['copy_text'] ) && $input['copy_text'] === 'normal' ? __( 'Copy to normal', 'btnsx' ) : '';
									$hover_text = isset( $input['copy_text'] ) && $input['copy_text'] === 'hover' ? __( 'Copy to hover', 'btnsx' ) : '';
									echo '<button id="' . $input['id'] . '_copy_btn" class="btnsx-copy-field" data-highlight="' . $highlight . '" data-old-input="' . $old_input . '" data-new-input="' . $new_input . '" data-old-color="" data-new-color="" data-old-select data-new-select>' . $normal_text . $hover_text . '</button>';
								}	
							?>
						</div>
					</div>
					<div class="col m12">
						<div class="col s12">
							<div class="file-field input-field">
						    	<input class="file-path btnsx-input-upload validate" type="text" <?php echo implode( ' ', $input_props ); ?>/>
						    	<div class="btn">
						    		<span><?php _e( 'UPLOAD', 'btnsx' ); ?></span>
						    		<input <?php echo $file_props['id']; ?> class="btnsx-btn-upload" type="file"/>
						    	</div>
						    </div>
						</div>
					</div>

					<?php

					break;

				case 'animation': 

					$animation_options = array();
					$animation_options[] = $this->animation_options( $input['value'] );

					echo $this->input(
						array(
						    'type'			=>	'select',
						    'id'			=>	$input['id'],
						    'name'			=>	$input['name'],
						    'placeholder'	=>	$input['placeholder'],
						    'label'			=>	$input['label'],
						    'tooltip'		=>	$input['tooltip'],
						    'options'		=>	$animation_options
						)
					);

					break;

				case 'icon-animation': 

					$animation_options = array();
					$animation_options[] = $this->icon_animation_options( $input['value'] );

					echo $this->input(
						array(
						    'type'			=>	'select',
						    'id'			=>	$input['id'],
						    'name'			=>	$input['name'],
						    'placeholder'	=>	$input['placeholder'],
						    'label'			=>	$input['label'],
						    'tooltip'		=>	$input['tooltip'],
						    'options'		=>	$animation_options
						)
					);

					break;

				case 'edd': 

					$input_props['select_placeholder'] = ( $input['placeholder'] != NULL ) ? $input['placeholder'] : __('Choose your option');
					$input_props['placeholder'] = NULL;
					$input_props['class'] = ( $input['class'] != NULL ) ? 'class="btnsx-select ' . $input['class'] . '"' : 'class="btnsx-select"';

					?>
					<div class="col m12">
						<div class="col s12">
							<label for="<?php echo $input['id']; ?>"><?php echo $input['label']; ?>
								<?php if( $input['tooltip'] != NULL ) {
									echo wp_kses( $this->tooltip( array( 'text' => $input['tooltip'] ) ), $tooltip_allowed_html);
								}
								?>
							</label>
						</div>
						<div class="input-field col s12" style="margin-top: 0.5rem;">
							<select <?php echo implode( ' ', $input_props ); ?> style="width: 100%">
								<?php if( $input['placeholder'] != NULL ) { ?>
									<option value="" disabled selected><?php echo $input_props['select_placeholder']; ?></option>
								<?php } 
									echo wp_kses( $this->edd_product_ids( $input['value'] ), $select_allowed_html );
								?>
							</select>
						</div>
					</div>
					<?php break;

				case 'woocommerce': 

					$input_props['select_placeholder'] = ( $input['placeholder'] != NULL ) ? $input['placeholder'] : __('Choose your option');
					$input_props['placeholder'] = NULL;
					$input_props['class'] = ( $input['class'] != NULL ) ? 'class="btnsx-select ' . $input['class'] . '"' : 'class="btnsx-select"';
					// Check whether WooCommerce is active
					if( class_exists('WooCommerce') ) :
					?>
					<div class="col m12">
						<div class="col s12">
							<label for="<?php echo $input['id']; ?>"><?php echo $input['label']; ?>
								<?php if( $input['tooltip'] != NULL ) {
									echo wp_kses( $this->tooltip( array( 'text' => $input['tooltip'] ) ), $tooltip_allowed_html );
								}
								?>
							</label>
						</div>
						<div class="input-field col s12" style="margin-top: 0.5rem;">
							<select <?php echo implode( ' ', $input_props ); ?> style="width: 100%">
								<?php if( $input['placeholder'] != NULL ) { ?>
									<option value="" disabled selected><?php echo $input_props['select_placeholder']; ?></option>
								<?php } 
									echo wp_kses( $this->woocommerce_product_ids( $input['value'] ), $select_allowed_html );
								?>
							</select>
						</div>
					</div>
					<?php 
					endif;
					break;

				case 'html': ?>

					<div class="col m<?php echo $input['size']; ?>">
						<?php echo wp_kses_post( $input['value'] ); ?>
					</div>

					<?php break;

				case 'button': ?>

					<div class="col m<?php echo $input['size']; ?>">
						<div class="col m<?php echo $input['size']; ?>">
							<?php echo wp_kses_post( $input['value'] ); ?>
							<button <?php echo implode( ' ', $input_props ); ?>><?php echo $input['label']; ?></button>
						</div>
					</div>

					<?php break;

				case 'border': 

					$border_fields = array(
						'size'		=>	__( 'Size', 'btnsx' ),
						'style'		=>	__( 'Style', 'btnsx' ),
						'color'		=>	__( 'Color', 'btnsx' )
					);

					foreach ( $border_fields as $key => $label ) { 
						if( $key == 'color' ) { 
							echo $this->input( 
								array(
	    							'type'			=>	'color',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key,
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'placeholder'	=>	' ',
	    							'class'			=>	'btnsx-color',
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);
						} elseif( $key == 'size' ) {
							echo $this->input( 
								array(
	    							'type'			=>	'range',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key,
	    							'placeholder'	=>	' ',
	    							'label'			=>	$label,
	    							'tooltip'		=>	$input['tooltip'][$key],
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);
						} elseif( $key == 'style' ) {
							echo $this->input( 
								array(
									'type'			=>	'select',
								    'id'			=>	$input['id'] . '_' . $key,
								    'name'			=>	$input['name'] . '_' . $key,
								    'placeholder'	=>	' ',
								    'label'			=>	$label,
								    'tooltip'		=>	$input['tooltip'][$key],
								    'options'		=>	array(
								    	'none'		=> __( 'None', 'btnsx' ),
								    	'hidden'	=> __( 'Hidden', 'btnsx' ),
								    	'dotted'	=> __( 'Dotted', 'btnsx' ),
								    	'dashed'	=> __( 'Dashed', 'btnsx' ),
								    	'solid'		=> __( 'Solid', 'btnsx' ),
								    	'double'	=> __( 'Double', 'btnsx' ),
								    	'groove'	=> __( 'Groove', 'btnsx' ),
								    	'ridge'		=> __( 'Ridge', 'btnsx' ),
								    	'inset'		=> __( 'Inset', 'btnsx' ),
								    	'outset'	=> __( 'Outset', 'btnsx' ),
								    	'inherit'	=> __( 'Inherit', 'btnsx' ),
								    ),
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);
						}
					}

					$border_sides = array(
						'top'		=>	__( 'Top', 'btnsx' ),
						'bottom'	=>	__( 'Bottom', 'btnsx' ),
						'left'		=>	__( 'Left', 'btnsx' ),
						'right'		=>	__( 'Right', 'btnsx' )
					);

					?>
					
					<div class="row">
						<div class="col m12">
							<label style="float:left;padding-left:0.75rem;margin-top:1.2rem;"><?php _e('Sides','btnsx'); ?></label>
						</div>
					<?php 
						foreach ( $border_sides as $key => $label ) {
							echo $this->input( 
								array(
									'type'			=>	'checkbox',
									'size'			=>	3,
									'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key,
	    							'label'			=>	$label,
	    							'tooltip'		=>	isset( $input['tooltip'][$key] ) ? $input['tooltip'][$key] : NULL,
									'class'			=>	'btnsx-checkbox',
									'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : 1
								)
							);
						}
					?>

					</div>

					<?php break;

				case 'background-image': 

					$bg_image_fields = array(
						'image'		=>	__( 'Background Image', 'btnsx' ),
						// 'repeat'	=>	__( 'Background Repeat', 'btnsx' ),
						'position'	=>	__( 'Background Position', 'btnsx' )
					);

					foreach ( $bg_image_fields as $key => $label ) { 
						if( $key == 'image' ) { 
							echo $this->input( 
								array(
	    							'type'			=>	'file',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key,
	    							'label'			=>	$label,
	    							'tooltip'		=>	isset( $input['tooltip'][$key] ) ? $input['tooltip'][$key] : NULL,
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);
						} elseif( $key == 'repeat' ) {
							echo $this->input( 
								array(
	    							'type'			=>	'select',
	    							'id'			=>	$input['id'] . '_' . $key,
	    							'name'			=>	$input['name'] . '_' . $key,
	    							'placeholder'	=>	' ',
	    							'label'			=>	$label,
	    							'tooltip'		=>	isset( $input['tooltip'][$key] ) ? $input['tooltip'][$key] : NULL,
	    							'options'		=>	array(
	    								'repeat'	=>	__( 'Repeat', 'btnsx' ),
	    								'repeat-x'	=>	__( 'Repeat X', 'btnsx' ),
	    								'repeat-y'	=>	__( 'Repeat Y', 'btnsx' ),
	    								'no-repeat'	=>	__( 'No Repeat', 'btnsx' )
	    							),
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);
						} elseif( $key == 'position' ) {
							echo $this->input( 
								array(
									'type'			=>	'select',
								    'id'			=>	$input['id'] . '_' . $key,
								    'name'			=>	$input['name'] . '_' . $key,
								    'placeholder'	=>	' ',
								    'label'			=>	$label,
								    'tooltip'		=>	isset( $input['tooltip'][$key] ) ? $input['tooltip'][$key] : NULL,
								    'options'		=>	array(
								    	'left top'		=> __( 'Left Top', 'btnsx' ),
								    	'left center'	=> __( 'Left Center', 'btnsx' ),
								    	'left bottom'	=> __( 'Left Bottom', 'btnsx' ),
								    	'right top'		=> __( 'Right Top', 'btnsx' ),
								    	'right center'	=> __( 'Right Center', 'btnsx' ),
								    	'right bottom'	=> __( 'Right Bottom', 'btnsx' ),
								    	'center top'	=> __( 'Center Top', 'btnsx' ),
								    	'center center'	=> __( 'Center Center', 'btnsx' ),
								    	'center bottom'	=> __( 'Center Bottom', 'btnsx' ),
								    	'initial'		=> __( 'Initial', 'btnsx' ),
								    ),
	    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
	    						)
							);
						}
					}

					break;

				case 'width-height':

					$wh_fields = array(
						'width'		=>	__( 'Width', 'btnsx' ),
						'height'	=>	__( 'Height', 'btnsx' )
					);

					echo '<div class="row">';

					foreach ( $wh_fields as $key => $label ) { 
						echo '<div class="col s6">';
						echo $this->input( 
							array(
    							'type'			=>	'range',
    							'id'			=>	$input['id'] . '_' . $key,
    							'name'			=>	$input['name'] . '_' . $key,
    							'placeholder'	=>	' ',
    							'label'			=>	$label,
    							'tooltip'		=>	isset( $input['tooltip'][$key] ) ? $input['tooltip'][$key] : NULL,
    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : NULL
    						)
						);
						echo '</div>';
					}

					echo '</div>';

					break;

				case 'padding':

					$padding_fields = array(
						'all'		=>	__( 'Padding All Sides', 'btnsx' ),
						'top'		=>	__( 'Padding Top', 'btnsx' ),
						'bottom'	=>	__( 'Padding Bottom', 'btnsx' ),
						'left'		=>	__( 'Padding Left', 'btnsx' ),
						'right'		=>	__( 'Padding Right', 'btnsx' )
					);

					foreach ( $padding_fields as $key => $label ) {
						echo $this->input( 
							array(
								'type'			=>	'range',
    							'id'			=>	$input['id'] . '_' . $key,
    							'name'			=>	$input['id'] . '_' . $key,
    							'placeholder'	=>	' ',
    							'label'			=>	$label,
    							'tooltip'		=>	$input['tooltip'][$key],
    							'value'			=>	isset( $input['value'][$key] ) ? $input['value'][$key] : ''
							)
						);
					}

					break;

				default: ?>
					<input type="hidden" <?php echo implode( ' ', $input_props ); ?>>
					<?php break;
			
			}
		}

	} // Form Elements Class

}