<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$content_css = $heading_css ='';

extract( shortcode_atts( array(
	'style' => 'style-1',
	'image_option' => 'default',
	'image_crop' => 'rectangle',
	'alignment' => '',
	'content_padding' => '',
	'content_background' => '#f7f7f7',
	'excerpt_lenght' => '23',
	'link_text' => 'Read more',
	'items'		=> '3',
	'gap'		=> '30',
	'auto_scroll' => 'false',
	'cat_slug' => '',
    'show_bullets' => '',
    'bullet_color' => '',
    'show_arrows' => '',
    'arrow_color' => '',
    'arrow_position' => 'center',
    'arrow_between' => '50',
    'bullet_between' => '50',
    'arrow_offset' => 'center',
    'arrow_offset_v' => '0',
    'arrow_offset_s' => '50',
    'column'        => '3c',
    'column2'       => '2c',
    'column3'       => '1c',
	'heading_font_family' => 'Default',
	'heading_font_weight' => 'Default',
	'heading_color' => '',
	'heading_font_size' => '',
	'heading_line_height' => '',
	'heading_top_margin' => '',
	'heading_bottom_margin' => ''
), $atts ) );

$gap = intval( $gap );
$items = intval( $items );
$column = intval( $column );
$column2 = intval( $column2 );
$column3 = intval( $column3 );

$heading_line_height = intval( $heading_line_height );
$heading_font_size = intval( $heading_font_size );
$heading_top_margin = intval( $heading_top_margin );
$heading_bottom_margin = intval( $heading_bottom_margin );

if ( empty( $items ) ) return;

$cls = $style .' '. $alignment;

if ( $show_arrows ) {
    $cls .= ' has-arrows' .' arrow-'. $arrow_color;

    if ( $arrow_position == 'center' ) {
        $cls .= ' arrow-'. $arrow_position .' offset'. $arrow_offset .' offset-v'. $arrow_offset_v;
    } else {
        $cls .= ' arrow-'. $arrow_position .' arrow'. $arrow_offset_s;
    }
}

if ( $show_bullets )
    $cls .= ' has-bullets bullet-'. $bullet_color .' bullet'. $bullet_between; 

if ( $content_padding ) $content_css .= 'padding:'. $content_padding .';';
if ( $content_background ) $content_css .= 'background-color:'. $content_background .';';

if ( $heading_font_weight != 'Default' ) $heading_css .= 'font-weight:'. $heading_font_weight .';';
if ( $heading_color ) $heading_css .= 'color:'. $heading_color .';';
if ( $heading_font_size ) $heading_css .= 'font-size:'. $heading_font_size .'px;';
if ( $heading_line_height ) $heading_css .= 'line-height:'. $heading_line_height .'px;';
if ( $heading_top_margin ) $heading_css .= 'margin-top:'. $heading_top_margin .'px;';
if ( $heading_bottom_margin ) $heading_css .= 'margin-bottom:'. $heading_bottom_margin .'px;';
if ( $heading_font_family != 'Default' ) {
	edukul_enqueue_google_font( $heading_font_family );
	$heading_css .= 'font-family:'. $heading_font_family .';';
}

$query_args = array(
    'post_type' => 'post',
    'posts_per_page' => $items
);

if ( ! empty( $cat_slug ) )
	$query_args['category_name'] = $cat_slug;

$query = new WP_Query( $query_args );
if ( ! $query->have_posts() ) { return; }
ob_start(); ?>

<div class="edukul-news <?php echo esc_attr( $cls ); ?>" data-auto="<?php echo esc_attr( $auto_scroll ); ?>" data-column="<?php echo esc_attr( $column ); ?>" data-column2="<?php echo esc_attr( $column2 ); ?>" data-column3="<?php echo esc_attr( $column3 ); ?>" data-gap="<?php echo esc_html( $gap ); ?>">
<?php if ( $query->have_posts() ) : ?>
	<?php wp_enqueue_script( 'edukul-owlcarousel' ); ?>

	<div class="owl-carousel owl-theme">
    <?php while ( $query->have_posts() ) : $query->the_post(); ?>

		<div class="news-item clearfix">
			<div class="inner">
				<div class="thumb-wrap">
					<?php
					$thumb_html = $img_size = $title_html = $meta_html = '';

					if ( $image_option == 'default' ) {
						if ( has_post_thumbnail() ) {
							if ( $image_crop == 'full' ) $img_size = 'full';
							if ( $image_crop == 'square' ) $img_size = 'edukul-square';
							if ( $image_crop == 'rectangle' ) $img_size = 'edukul-rectangle';
							if ( $image_crop == 'rectangle2' ) $img_size = 'edukul-rectangle2';
							if ( $image_crop == 'rectangle3' ) $img_size = 'edukul-rectangle3';
							if ( $image_crop == 'rectangle4' ) $img_size = 'edukul-rectangle4';

							echo $thumb_html = get_the_post_thumbnail( get_the_ID(), $img_size );
						}
					} else {
						$size = 'edukul-'. edukul_metabox('custom_thumbnail_crop');
						$image = edukul_metabox( 'custom_thumbnail', array( 'size' => $size ) );

						if ( $image ) echo $thumb_html = '<img src="'. $image['url'] .'" alt="Image" />';
					}
					?>

				</div><!-- /.thumb-wrap -->

                <div class="text-wrap" style="<?php echo esc_attr( $content_css ); ?>">
					<?php
					printf( '<div class="post-meta"><span class="post-by-author item"><a href="%s" title="%s">%s</a></span> <span class="post-date item"><span class="entry-date">%s</span></span></div>',
						esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
						esc_attr( sprintf( esc_html__( 'View all posts by %s', 'edukul' ), get_the_author() ) ),
						get_the_author(),
						get_the_date()
					);

					echo '<h3 class="title" style="'. esc_attr( $heading_css ) .'"><a href="'. esc_url( get_the_permalink() ) .'">'. get_the_title() .'</a></h3>';

					if ( !empty( $excerpt_lenght ) )
					echo '<p class="excerpt">'. wp_trim_words( get_the_content(), $excerpt_lenght, '&hellip;' ) .'</p>';

					echo '<a class="link" href="'. esc_url( get_permalink() ) .'"><span>'. esc_html( $link_text ) .'</span></a>';
					?>
                </div><!-- /.text-wrap -->
	        </div>
	    </div><!-- /.news-item -->
	    
	<?php endwhile; ?>
	</div><!-- /.owl-carousel -->

<?php endif; ?>

<?php wp_reset_postdata(); ?>
</div><!-- /.edukul-news -->
<?php
$return = ob_get_clean();
echo $return;