<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$cls = $inner_css = $filter_css = $filter_wrap_css  = $filter_data = '';

extract( shortcode_atts( array(
	'margin' => '',
	'image_crop' => 'rectangle',
	'items'			=> '8',
	'cat_slug'	=> '',
	'exclude_cat_slug' => '',
	'pagination' => 'false',
	'gapv'			=> '30',
	'gaph'			=> '30',
	'show_filter'	=> 'true',
	'filter_by_default' => '',
	'filter_cat_slug' => '',
	'filter_button_all' => 'All',
	'bottom_filter' => '',
	'filter_align' => 'style-1',
	'column'		=> '4c',
	'column2'		=> '3c',
	'column3'		=> '2c',
	'column4'		=> '1c'
), $atts ) );

$gapv = intval( $gapv );
$gaph = intval( $gaph );
$items = intval( $items );
$column = intval( $column );
$column2 = intval( $column2 );
$column3 = intval( $column3 );
$column4 = intval( $column4 );
$bottom_filter = intval( $bottom_filter );

if ( empty( $items ) ) return;

if ( empty( $gapv ) ) $gapv = 0;
if ( empty( $gaph ) ) $gaph = 0;

if ( $margin ) $inner_css .= 'margin:'. $margin .';';
if ( $bottom_filter ) $filter_wrap_css = 'margin-bottom:'. $bottom_filter . 'px;';

if ( ! empty( $filter_cat_slug ) && $filter_by_default  )
	$filter_data = strtolower( $filter_cat_slug );

if ( get_query_var('paged') ) {
   $paged = get_query_var('paged');
} elseif ( get_query_var('page') ) {
   $paged = get_query_var('page');
} else {
   $paged = 1;
}

$query_args = array(
    'post_type' => 'gallery',
    'posts_per_page' => $items,
    'paged'     => $paged
);

if ( ! empty( $cat_slug ) ) {
	$query_args['tax_query'] = array(
		array(
			'taxonomy' => 'gallery_category',
			'field'    => 'slug',
			'terms'    => $cat_slug
		),
	);
}

if ( ! empty( $exclude_cat_slug ) ) {
	$query_args['tax_query'] = array(
	    array(
	        'taxonomy' => 'gallery_category',
	        'field' => 'slug',
	        'terms' => $exclude_cat_slug,
	        'operator' => 'NOT IN',
	    ),
	);
}

$query = new WP_Query( $query_args );
if ( ! $query->have_posts() ) { echo "Gallery item not found!"; return; }
ob_start(); ?>

<div class="edukul-gallery-grid" data-layout="grid" data-column="<?php echo esc_attr( $column ); ?>" data-column2="<?php echo esc_attr( $column2 ); ?>" data-column3="<?php echo esc_attr( $column3 ); ?>" data-column4="<?php echo esc_attr( $column4 ); ?>" data-gaph="<?php echo esc_attr( $gaph ); ?>" data-gapv="<?php echo esc_attr( $gapv ); ?>" data-filter="<?php echo esc_attr( $filter_data ); ?>">
<div style="<?php echo esc_attr( $inner_css ); ?>">

	<?php if ( $query->have_posts() ) :
	    if ( $show_filter == 'true' ) {
	        echo '<div id="gallery-filter" style="'. $filter_wrap_css .'" class="cbp-l-filters-alignCenter clearfix '. $filter_align .'"><div class="inner">';
        	if ( ! empty( $filter_button_all ) )
        		echo '<div data-filter="*" class="cbp-filter-item button-all" style="'. $filter_css .'"><span>'. esc_html( $filter_button_all ) .'</span><div class="cbp-filter-counter"></div></div>';

				if ( $cat_slug ) {

					$term = strtolower( str_replace( ' ', '-', $cat_slug ) );
					$term = get_term_by( 'slug', $cat_slug, 'gallery_category' ); 
					if ( $term ) $terms = get_term_children( $term->term_id, 'gallery_category' );

					foreach( $terms as $term ) {
						$t = get_term_by( 'id', $term, 'gallery_category' );
						echo '<div data-filter=".'. esc_attr( $t->slug ) .'" class="cbp-filter-item" title="'. esc_attr( $t->name ) .'" style="'. $filter_css .'"><span>'. $t->name . '</span><div class="cbp-filter-counter"></div></div>';
					}
				} else {

					$terms = get_terms('gallery_category');
				    foreach ( $terms as $term ) {
				        echo '<div data-filter=".'. esc_attr( $term->slug ) .'" class="cbp-filter-item" title="'. esc_attr( $term->name ) .'" style="'. $filter_css .'"><span>'. $term->name . '</span><div class="cbp-filter-counter"></div></div>';
				    }
				}
	        echo '</div></div>';
	    } ?>

		<div id="galleries" class="cbp">
		    <?php while ( $query->have_posts() ) : $query->the_post();
				wp_enqueue_script( 'edukul-cubeportfolio' ); wp_enqueue_script( 'edukul-magnificpopup' );
				
			    global $post;
				$term_list = '';
			    $terms = get_the_terms( $post->ID, 'gallery_category' );

			    if ( $terms ) {
			        foreach ( $terms as $term ) {
			            $term_list .= $term->slug .' ';
			        }
			    } ?>

	            <div class="cbp-item <?php echo esc_attr( $term_list ); ?>">
					<div class="gallery-box">

							<?php
							$img_size = $title = $link = '';

							if ( has_post_thumbnail() ) {
								if ( $image_crop == 'full' ) $img_size = 'full';
								if ( $image_crop == 'square2' ) $img_size = 'edukul-square2';
								if ( $image_crop == 'rectangle' ) $img_size = 'edukul-rectangle';
							}

			            	$icon_html = sprintf('<div class="icon"><a href="%1$s" class="zoom popup-image"><span class="core-icon-search"></span></a></div>',
			            	edukul_get_image( array( 'size' => 'full', 'format' => 'src' ) ),
			            	esc_url( get_the_permalink() )
			            	);

			            	$title = edukul_metabox( 'title' ) ? edukul_metabox( 'title' ) : get_the_title();
			            	$title_html = sprintf('<h4 class="title"><a href="%1$s" title="%2$s">%2$s</a></h4>', esc_url( get_the_permalink() ), esc_attr( $title ) );

			            	$link = '<div class="link"><a class="edukul-links link-style-5 accent" href="'. esc_url( get_the_permalink() ) .'"><span class="text">'. esc_html__( 'LEARN MORE', 'edukul' ) .'</span></a></div>';

			            	echo '<div class="thumb">'. get_the_post_thumbnail( get_the_ID(), $img_size ) .'<div class="text-wrap">'. $icon_html. $title_html . $link .'</div></div>';
							?>

					</div><!-- /.gallery-box -->
	            </div><!-- /.cbp-item -->
			<?php endwhile; ?>
		</div><!-- /#portfolio -->

		<?php if ( 'true' == $pagination ) {
			echo '<div class="gallery-nav">';
			edukul_pagination($query);
			echo '</div>';
		}
		?>
	<?php endif; ?>

	<?php wp_reset_postdata(); ?>

</div>
</div><!-- /.edukul-gallery -->

<?php
$return = ob_get_clean();
echo $return;