<?php
// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$cls = $icon = $icon_html = $icon_css = $data = '';

extract( shortcode_atts( array(
	'style' => 'style-1',
	'content_bg' => 'gray',
	'course_type' => 'most_recent',
	'items' => '4',
	'gap'			=> '30',
	'auto_scroll' => 'false',
    'show_bullets' => '',
    'bullet_color' => '',
    'show_arrows' => '',
    'arrow_color' => '',
    'arrow_position' => 'center',
    'arrow_between' => '50',
    'bullet_between' => '50',
    'arrow_offset' => 'center',
    'arrow_offset_v' => '0',
    'arrow_offset_s' => '50',
    'column'        => '3c',
    'column2'       => '2c',
    'column3'       => '1c'
), $atts ) );

$loop = edukul_educator_get_courses( $course_type, $items );

$gap = intval( $gap );
$items = intval( $items );
$column = intval( $column );
$column2 = intval( $column2 );
$column3 = intval( $column3 );

if ( empty( $items ) ) return;

$cls = $style .' '. $content_bg;

if ( $show_arrows ) {
	$cls .= ' has-arrows' .' arrow-'. $arrow_color;
	if ( $arrow_position == 'center' ) {
	    $cls .= ' arrow-'. $arrow_position .' offset'. $arrow_offset .' offset-v'. $arrow_offset_v;
	} else {
	    $cls .= ' arrow-'. $arrow_position .' arrow'. $arrow_offset_s;
	}
}

if ( $show_bullets )
    $cls .= ' has-bullets bullet-'. $bullet_color .' bullet'. $bullet_between; 

?>

<div class="edukul-courses <?php echo esc_attr( $cls ); ?>" data-auto="<?php echo esc_attr( $auto_scroll ); ?>" data-column="<?php echo esc_attr( $column ); ?>" data-column2="<?php echo esc_attr( $column2 ); ?>" data-column3="<?php echo esc_attr( $column3 ); ?>" data-gap="<?php echo esc_html( $gap ); ?>">

<?php if ( $loop->have_posts() ) : ?>
	<?php wp_enqueue_script( 'edukul-owlcarousel' ); ?>
	<div class="owl-carousel owl-theme">
		<?php while ( $loop->have_posts() ) : $loop->the_post(); ?>
			<?php Edr_View::template_part( 'content', 'course' ); ?>
		<?php endwhile; ?>
		<?php wp_reset_postdata(); ?>
	</div>
<?php endif; ?>
</div><!-- /.edukul-courses -->